T.ns('Sport.Controller').Surveys = (function  () {

	var
		Base = T.ns('Sport.Controller').Base,
    View = T.ns('Sport.View').Surveys,
    KEY = 'Sport_pl_surveys',
		self = new Base(),
    allowVoting = true,
    _surveys = -1;

  var saveAllSurveys = function () {
    lscache.set(KEY, getAllSurveys());
  };

  var loadAllSurveys = function () {
    return lscache.get(KEY);
  };

  var saveSurvey = function (xx, val) {
    var
      data = getAllSurveys();

    data["xx:" + xx] = val;
    saveAllSurveys();
  };

  var deleteReminder = function (xx) {
    delete getAllSurveys()['xx:' + xx];
    saveAllSurveys();
  };

  var getAllSurveys = function () {

    if (_surveys === -1)
      _surveys = loadAllSurveys() || {};

    return _surveys;

  };

  var getSurvey = function (xx) {
    return getAllSurveys()['xx:' + xx] || null;
  };

  var vote = function (xx, pos) {
    self.getData(_appConfig.addr.data + _appConfig.urls.surveyVote.replace('%XX%', xx).replace('%POS%', pos), function (d) {
      if (d) {
        var container = document.querySelector('.sport-survey');
        if (container) {
          container.className += ' voted';
          container.innerHTML = View.getVoted(d, true);
          saveSurvey(xx, "true");
        }
      }
      allowVoting = true;
    }, function () {
      allowVoting = true;
    });
  };

  var onClickListener = function (e) {
    if (allowVoting) {
      var data = this.getAttribute('data-xxp').split('.'),
          xx = data[0],
          pos = data[1];

      allowVoting = false;
      vote(xx, pos);
    }
  };

  self.get = function (survey) {
    if (getSurvey(survey.x)) {
      return View.getVoted(survey);
    } else {
      setTimeout(function () {
        var elements = document.querySelectorAll('.sport-survey .option'),
          i = 0, length = elements.length;

          for ( ; i < length; i++) {
            elements[i].addEventListener('click', onClickListener);
          }

      }, 1000);
      return View.getNonVoted(survey);
    }
  };

	return self;

})();
