var
	jsonpIdx = 0,
	loadJSONP = (function(){
	  return function(url, onSuccess, onError, jsonpCallback, context) {
	  	var noTimeout = true,
	  		onComplete = function(data){
		    	if (noTimeout) {
		    		clearTimeout(timeoutID);
		      		onSuccess.call((context || window), data);
			      	document.getElementsByTagName('head')[0].removeChild(script);
			      	script = null;
			      	delete window[name];
				} else if (typeof onError === 'function') {
					onError.call((context || window));
				}
		    },
	  		timeoutID = setTimeout(function(){
		  		noTimeout = false;
		  		onComplete();
		  	}, 5000),
		  	name = jsonpCallback + jsonpIdx++,
	    	script = document.createElement('script');

	    // INIT
	    if (url.match(/\?/)) url += "&callback="+name;
	    else url += "?callback="+name;

	    // Create script
	    script.type = 'text/javascript';
	    script.src = url;

	    // Setup handler
	    window[name] = onComplete;

	    // Load JSON
	    document.getElementsByTagName('head')[0].appendChild(script);
	  };
	})(),
	_config = {
		"appConfig" : "http://config.app.gazeta.pl/config?sport",
		"testHost" : null
	},
	_categories = [
      {
        "id": "all",
        "name": "Wszystkie",
        "sub": null,
        "gfx": null
      },
      {
        "id": "pilka",
        "name": "Piłka nożna",
        "sub": null,
        "gfx": null
      },
      {
        "id": "moto",
        "name": "Moto",
        "sub": [
          "Żużel",
          "Formuła 1",
          "F1",
          "Kubica",
          "Robert Kubica",
          "Rajdy"
        ],
        "gfx": null
      },
      {
        "id": "tenis",
        "name": "Tenis",
        "sub": null,
        "gfx": null
      },
      {
        "id": "siatkowka",
        "name": "Siatkówka",
        "sub": null,
        "gfx": null
      },
      {
        "id": "koszykowka",
        "name": "Koszykówka",
        "sub": null,
        "gfx": null
      },
      {
        "id": "reczna",
        "name": "Piłka ręczna",
        "sub": null,
        "gfx": null
      },
      {
        "id": "hokej",
        "name": "Hokej",
        "sub": [
          "Hokej na lodzie",
          "Hokej na trawie"
        ],
        "gfx": null
      },
      {
        "id": "boks",
        "name": "Boks",
        "sub": null,
        "gfx": null
      },
      {
        "id": "inne",
        "name": "Inne",
        "sub": null,
        "gfx": null
      }
    ],
	_appConfig = {
    "host": "http://sportpllive.app.gazeta.pl",
    "port": 80,
    "addr": {
      "data": "http://sportpllive.app.gazeta.pl:80",
      "ws": "http://sportpllive.app.gazeta.pl:1100"
    },
    "urls": {
      "start": "/start/%FILTER%",
      "resume": "/resume/%FILTER%/%TIMESTAMP%",
      "LiveStream": "/index/%XX%",
      "LiveStreamPaged": "/index/%FILTER%/%PAGE%",
      "toLiveStream": "/live/all",
      "Top20": "/index/top20",
      "Events": "/events/%XX%",
      "Event": "/event/%SID%/%XX%/%LIMIT%",
      "EventByHeader": "/event/%XX%",
      "Calendar": "/calendar/%XX%",
      "Article": "/article/%SID%.%XX%",
      "gameHead": "/gameHead/%XX%",
      "survey": "/survey/%XX%",
      "surveyVote": "/survey/%XX%/%POS%",
      "Config": "/config?%TIMESTAMP%"
    }
  };

if (navigator.mozApps) {

  loadJSONP = (function(){
    return function (url, onSuccess, onError, jsonpCallback, context) {
      var xhr = new XMLHttpRequest({mozSystem: true}),
          noTimeout = true,
          onComplete = function(data){
            clearTimeout(timeoutID);
            if (noTimeout && data) {
              onSuccess.call((context || window), data);
            } else if (typeof onError === 'function') {
              onError.call((context || window));
            }
          },
          timeoutID = setTimeout(function(){
            noTimeout = false;
            onComplete();
          }, 5000);

      xhr.open("GET", url, true);
      xhr.onreadystatechange = function () {
          if (xhr.status === 200 && xhr.readyState === 4) {
              var d = null;
              try {
                d = JSON.parse(xhr.response);
              } catch (e) {
                d = null;
              }
              onComplete(d);
          }
      }

      xhr.onerror = function () {
        clearTimeout(timeoutID);
        if (typeof onError === 'function') {
          onError.call((context || window));
        }
      };
      xhr.send();
    }
   })();

    navigator.mozSetMessageHandler('alarm', function (d) {
      var app =null,
          notification = null;

      navigator.mozApps.getSelf().onsuccess = function(evt) {
        app = evt.target.result;
      }
      notification = navigator.mozNotification.createNotification(
        'Rozpoczyna się relacja',
        d.data.name
      );
      notification.onclick = function () {
        app.launch();
        T.ns('Sport.Controller.Relation').getRelationByHxx(d.data.hxx);
      };
       notification.show();
    });

    navigator.mozSetMessageHandler('activity', function (activityRequest) {
      var option = activityRequest.source;
      if (option.name == 'pl.sport.live') {
        T.ns('Sport.Controller.Relation').getRelationByHxx(option.data.hxx);
      }
    });
} else {
    console.log("Open Web Apps not supported");
}

(function(){

	FastClick.attach(document.body);

	var getLocalConfig = function (callback) {
				callback();
	};

	var getAppConfig = function (callback) {
		loadJSONP(_config.appConfig + '&' + (new Date()*1), function (cfg) {
			try {
				_appConfig = cfg.source || _appConfig;
				_categories = cfg.settings && cfg.settings.categories || _categories;
			} catch(e) {
				console.log(e);
				_appConfig = null;
			}

			if (_appConfig) {
				if (_config.testHost) {
					_appConfig.addr.data = _config.testHost;
					_appConfig.addr.ws = _config.testHost;
				}

				callback();
			} else {
				callback();
			}

		}, callback, "sportJsonp", this);
	};
	getLocalConfig(function () {
		getAppConfig(function () {
			if (window.location.href.indexOf("#panel") === -1) {
				window.location.href = window.location.href + '#panel1';
			} else {
				window.location.href = window.location.href.split("#")[0] + '#panel1';
			}
			T.ns('Sport.Controller.Index').start();
			T.ns('Sport.Controller.Socket').listen();
			T.ns('Sport.Controller.Categories').renderCategories();
		});
	});

})();
