T.ns('Sport.View').Article = (function  () {
	var
		Base = T.ns('Sport.View').Base,
		Head = T.ns('Sport.View').Headers,
		self = new Base();

	self._container = '#article';
	self._$container = document.querySelector(self._container);

	self.render = function (content) {

		var
			html = [],
			surv = null,
			article = content && content[0] || null,
			photo = article && article.p && article.p[0] || null;

		self._$container.scrollTop = 0;

		if (article.rf) {
			article.rf.forEach(function (rel) {
				if (rel.t === 'gameHead') {
					html.push(Head.get(rel.l[0], self._container));
				} else if (rel.t === 'survey') {
					surv = T.ns('Sport.Controller.Surveys').get(rel.l[0]);
				}
			});
		}
		html.push('<div class="art-title"><h1>' + article.t + '</h1></div>');

		if (photo) {
			html.push('<div class="photo"><img src="' + photo.u + '" /></div>');
			if (photo.a || photo.d) {

				html.push('<div class="photo_desc">');
				if (photo.a) {
					html.push('<p class="author">' + photo.a + '</p>');
				}
				if (photo.d) {
					html.push('<p class="desc">' + photo.d + '</p>');
				}
				html.push('</div>');
			}
		}
		if (article.l) {
			html.push('<p class="lead">' + article.l + '</p>');
		}
		if (article.c) {
			html.push('<div class="content">' + article.c.replace(/<iframe(?:[\s\S]*?)<\/iframe>/gim, '') + '</div>');
		}
		if (surv) {
			html.push(surv);
		}
		if (article.b) {
			html.push('<div class="footer" style="background-image:url(' + article.b + ');">' + article.a + '</div>');
		} else {
			html.push('<div class="footer">' + article.a + '</div>');
		}

		self._$container.innerHTML = html.join('');
		Base.shareUrl = article.u;
		// ga('send', {
		//   'hitType': 'event',
		//   'eventCategory': 'article',
		//   'eventAction': 'open',
		//   'eventLabel': article.t
		// });

	};

	self.show = function () {
		self._$container.className = self._$container.className + ' show';
	};

	self.hide = function () {
		self._$container.className = self._$container.className.replace(/ show/gi,'');
		self._$container.innerHTML = '<progress></progress>';
	};

	return self;

})();
