T.ns('Sport.View').Base = (function  () {
	var
		self = function(){
			this._className = '';
			this._container = '#container';
			this._$container = document.querySelector(self._container);
			this._addMethod = 'replace';
			this.shareUrl = null;
		};

	var noteClass = function (cl) {
		switch (cl) {
			case 'change':
				return '<br><img src="images/RelationIcons/change_player.png" />'
			break;
			case 'goal':
				return '<br><img src="images/RelationIcons/goal.png" />'
			break;
			case 'korespondencja':
			case 'correspondent':
				return '<br><img src="images/RelationIcons/korespondencja.png" />'
			break;
			case 'twitter':
				return '<br><img src="images/RelationIcons/twitter.png" />'
			break;
			case 'yellowCard':
				return '<br><img src="images/RelationIcons/yellow_card.png" />'
			break;
			case 'redCard':
				return '<br><img src="images/RelationIcons/red_card.png" />'
			break;
			case 'quote':
				return '<br><img src="images/RelationIcons/quote.png" />'
			break;
			case 'facebook':
				return '<br><img src="images/RelationIcons/facebook.png" />'
			break;
			case 'goldMedal':
				return '<br><img src="images/RelationIcons/gold_medal.png" />'
			break;
			case 'silverMedal':
				return '<br><img src="images/RelationIcons/silver_medal.png" />'
			break;
			case 'bronzeMedal':
				return '<br><img src="images/RelationIcons/bronze_medal.png" />'
			break;
			case 'extraTime':
				return '<br><img src="images/RelationIcons/extra_time.png" />'
			break;
			default:
				return '';
		}
	};

	var parseDate = function (ts) {

		var
			date = new Date(ts),
			now = new Date(),
			dayNow = now.getDate(),
			day = date.getDate(),
			time = date.getHours() + ':' + ('00' + date.getMinutes()).slice(-2);

		switch (day) {
			case dayNow:
				return time;
				break;
			case dayNow-1:
				return 'Wczoraj ' + time;
				break;
			case dayNow-2:
				return 'Przedwczoraj ' + time;
				break;
			default:
				return day + '.' + ('00' + (date.getMonth() + 1)).slice(-2) + ' ' + time;
				break;
		}

		return day + ' ' + hour + ':' + mins;

	};

	var importantLook = function (el) {

		var
			html = [],
			contentType = el.s === 13 || el.s === 14 ? 'relation' : 'article';

		html.push('<li class="important news top20 ' + contentType + '" data-ts="' + el.d + '" data-xx="' + el.sid + '.' + el.x + '">');
			html.push('<div class="img-tn"><img src="' + el.li + '" /></div>');
			html.push('<div class="news-content">' + el.t + '</div>');
		html.push('</li>');

		return html.join('');
	};

	var urgentLook = function (el) {

		var
			html = [],
			contentType = el.s === 13 || el.s === 14 ? 'relation' : 'article';

		html.push('<li class="urgent news top20 ' + contentType + '" data-ts="' + el.d + '" data-xx="' + el.sid + '.' + el.x + '">');
			html.push('<div class="header">PILNE</div>');
			html.push('<div class="img-tn"><img src="' + el.li + '" /></div>');
			html.push('<div class="news-content">' + el.t + '</div>');
		html.push('</li>');

		return html.join('');
	};

	var mourningLook = function (el) {

		var
			html = [],
			contentType = el.s === 13 || el.s === 14 ? 'relation' : 'article';

		html.push('<li class="mourning news top20 ' + contentType + '" data-ts="' + el.d + '" data-xx="' + el.sid + '.' + el.x + '">');
			html.push('<div class="img-tn"><img src="' + el.li + '" /></div>');
			html.push('<div class="news-content">' + el.t + '</div>');
		html.push('</li>');

		return html.join('');
	};

	var noteLook = function (el) {

		var
			html = [];

		html.push('<li class="note news relation" data-ts="' + el.d + '" data-xx="' + el.sid + '.' + el.x + '">');
			html.push('<div class="header">' + el.t + '</div>');
			html.push('<div class="table">');
				html.push('<div class="table-cell details">');

					if (el.i)
						html.push('<div class="urgentText">Pilne!</div>');

					if (el.e)
						html.push('<div class="extra">' + noteClass(el.e) + '</div>');

				html.push('</div>');
				html.push('<div class="table-cell news-content">' + el.b + '</div>');
			html.push('</div>');
		html.push('</li>');

		return html.join('');
	};

	var defaultLook = function (el) {

		var
			html = [];

		html.push('<li class="default news article" data-ts="' + el.d + '" data-xx="' + el.sid + '.' + el.x + '">');
			html.push('<div class="table-cell img-tn" style="background-image: url(' + el.li + ');"></div>');
			html.push('<div class="table-cell news-content">');
				html.push('<div class="note-title">' + el.t + '</div>');
				html.push('<div class="footer">' + el.c + '<span class="time">' + parseDate(el.d) + '</span></div>');
			html.push('</div>');
		html.push('</li>');

		return html.join('');
	};
	self.prototype.render = function (elements, refresh) {
		var
			html = [],
			tpl = '',
			wrapper = document.createElement('ul'),
			i = 0, length = elements.length,
			el = null;

		wrapper.className = 'news-box';

		for ( ; i < length; i++) {
			el = elements[i];

			switch (el.s) {
				case 0:
					tpl = defaultLook(el);
					break;
				case 10:
				case 13:
					tpl = urgentLook(el);
					break;
				case 11:
					tpl = mourningLook(el);
					break;
				case 12:
				case 14:
					tpl = importantLook(el);
					break;
				case 20:
					tpl = noteLook(el);
					break;
				default:
					tpl = defaultLook(el);
			}

			html.push(tpl);

		}

		wrapper.innerHTML = html.join('');
		if (refresh) {
			this._$container.innerHTML = '';
		}
		switch (this._addMethod) {
			case 'prepend':
				if (this._$container.firstChild) {
					this._$container.insertBefore(wrapper, this._$container.firstChild);
				} else {
					this._$container.appendChild(wrapper);
				}
				break;
			default:
				this._$container.appendChild(wrapper);
		}
		setTimeout(function () {
			var elements = wrapper.querySelectorAll('.news.article'),
				i = 0,
				length = elements.length;

			for ( i = 0, length = elements.length; i < length; i++ ) {
				elements[i].addEventListener('click', function (){
					T.ns('Sport.Controller.Article').getArticle(this.getAttribute('data-xx'));
				});
			}
			elements = wrapper.querySelectorAll('.news.relation');
			i = 0;
			length = elements.length;
			for ( i = 0, length = elements.length; i < length; i++ ) {
				elements[i].addEventListener('click', function (){
					T.ns('Sport.Controller.Relation').getRelation(this.getAttribute('data-xx'));
				});
			}
		}, 100);
	};

	return self;

})();
