T.ns('Sport.View').Calendar = (function  () {
	var
		Base = T.ns('Sport.View').Base,
		self = new Base();

	self._container = '#calendar';
	self._$container = document.querySelector(self._container);
	self._nearestEvent = null;

	var parseDate = function (ts) {

		var
			date = new Date(ts),
			now = new Date(),
			dayNow = now.getDate(),
			day = date.getDate(),
			time = date.getHours() + ':' + ('00' + date.getMinutes()).slice(-2);

		switch (day) {
			case dayNow:
				return 'Dziś';
				break;
			case dayNow+1:
				return 'Jutro';
				break;
			case dayNow+2:
				return 'Pojutrze';
				break;
			default:
				return day + '.' + ('00' + (date.getMonth() + 1)).slice(-2) + '.' + date.getFullYear();
				break;
		}

		return day + '.' + ('00' + (date.getMonth() + 1)).slice(-2) + '.' + date.getFullYear();
	};

	var parseMatchDate = function (ts) {

		var
			date = new Date(ts),
			now = new Date(),
			dayNow = now.getDate(),
			day = date.getDate(),
			time = date.getHours() + ':' + ('00' + date.getMinutes()).slice(-2);

		switch (day) {
			case dayNow:
				return 'Dziś<br/>' + time;
				break;
			case dayNow+1:
				return 'Jutro<br/>' + time;
				break;
			case dayNow+2:
				return 'Pojutrze<br/>' + time;
				break;
			default:
				return day + '.' + ('00' + (date.getMonth() + 1)).slice(-2) + '.' + date.getFullYear() + '<br/>' + time;
				break;
		}

		return day + '.' + ('00' + (date.getMonth() + 1)).slice(-2) + '.' + date.getFullYear() + '<br/>' + time;
	};

	var headerLook = function (el) {

		var
			title = '',
			i = 0, length = el.h && el.h.length || null,
			extraClass = T.ns('Sport.Controller.Calendar').getReminderId(el.x) ? ' added' : '',
			html = [];

		html.push('<div class="event header" data-xx="' + el.x + '">');
			html.push('<div class="table details">');
				html.push('<div class="table-cell teams-side">');

				if (length) {
					for ( ; i < length; i++ ) {
						title += el.h[i].n + (length - 1 !== i ? ' - ' : '');
						html.push('<div class="team">' + el.h[i].n + '</div>');
					}
				} else {
					title = el.t;
					html.push('<div class="team">' + el.t + '</div>');
				}

				html.push('</div>');
				html.push('<div class="table-cell part add' + extraClass + '" data-xx="' + el.x + '" data-name="' + title + '" data-ts="' + el.d + '">' + parseMatchDate(el.d) + '</div>');
			html.push('</div>');
		html.push('</div>');

		return html.join('');

	};

	self.render = function (days) {

		var
			i = 0, length = days.length,
			j = 0, length2 = 0,
			day = null,
			discipline = null,
			event = null,
			match = null,
			tpl = null,
			wrapper = document.createElement('div'),
			tmpDaysCounter = 0,
			tmpEventsCounter = 0,
			dNow = Date.now(),
			html = [];

		wrapper.className = 'calendar-box';
		for ( ; i < length; i++ ) {
			tmpDaysCounter = 0;
			day = days[i];
			if (day.disciplines && day.disciplines.length) {
				html.push('<div class="day">' + parseDate(day.date) + '</div>');

				for (j = 0, length2 = day.disciplines.length; j < length2; j++) {
					discipline = day.disciplines[j];
					if (T.ns('Sport.Controller.Categories').checkFilter(discipline.name)) {
						for (k = 0, length3 = discipline.events.length; k < length3; k++) {
							tmpEventsCounter = 0;
							event = discipline.events[k];
							if (event.matches && event.matches.length) {
								++tmpDaysCounter;
								html.push('<div class="path">' + event.name + '</div>');
								for (l = 0, length4 = event.matches.length; l < length4; l++) {
									match = event.matches[l];
									if (match.d > dNow) {
										++tmpEventsCounter;
										if (!self._nearestEvent || self._nearestEvent > match.d) {
											self._nearestEvent = match.d;
										}
										html.push(headerLook(match));
									}
								}
								if (tmpEventsCounter === 0) {
									html.pop();
									--tmpDaysCounter;
								}
							}
						}
					}

				}

				if (tmpDaysCounter === 0) {
					html.pop();
				}
			}

		}
		if (html.length === 0) {
			html.push('<div class="noEvents">Brak aktualnych wydarzeń w tej kategorii.</div>');
		}
		wrapper.innerHTML = html.join('');
		self._$container.innerHTML = '';
		self._$container.appendChild(wrapper);

		setTimeout(function () {

			var
				elements = wrapper.querySelectorAll('.add');

			for ( var i = 0, length = elements.length; i < length; i++ ) {
				elements[i].addEventListener('click', function (){
					if (this.className.indexOf('added') > -1) {
						if (window.confirm('Anulować przypomnienie o relacji ' + this.getAttribute('data-name') + '?')) {
  							T.ns('Sport.Controller.Calendar').removeReminder(this.getAttribute('data-xx'));
  						}
					} else {
						if (window.confirm('Dodać przypomnienie o starcie ' + this.getAttribute('data-name') + '?')) {
  							T.ns('Sport.Controller.Calendar').setReminder(this.getAttribute('data-ts'), this.getAttribute('data-name'), this.getAttribute('data-xx'));
						}
					}
				});
			}
		}, 100);
	};

	return self;

})();
