T.ns('Sport.View').Events = (function  () {
	var
		Base = T.ns('Sport.View').Base,
		self = new Base(),
		activeCounter = 0;

	self._$badge = document.querySelector('#panel2 .sport-badge');
	self._container = '#events';
	self._$container = document.querySelector(self._container);


	var parseDate = function (ts) {
		if (ts === Infinity)
			return 'Trwające';

		var
			date = new Date(ts),
			now = new Date(),
			dayNow = now.getDate(),
			day = date.getDate(),
			time = date.getHours() + ':' + ('00' + date.getMinutes()).slice(-2);

		switch (day) {
			case dayNow:
				return 'Dziś';
				break;
			case dayNow-1:
				return 'Wczoraj';
				break;
			case dayNow-2:
				return 'Przedwczoraj';
				break;
			default:
				return day + '.' + ('00' + (date.getMonth() + 1)).slice(-2) + '.' + date.getFullYear();
				break;
		}

		return day + '.' + ('00' + (date.getMonth() + 1)).slice(-2) + '.' + date.getFullYear();
	};

	var sortByName = function (array, key) {

		return array.sort(function (a, b) {

			if ( a[key] < b[key] ) {

				return -1;

			} else {

				return 1;

			}

		});

	};

	var sortAll = function (data) {

		var i = 0,
			j = 0,
			k = 0,
			days = {},
			disciplines = [];

		data = T.sortByKey(data, 'date', 'desc');

		for ( i = 0; i < data.length; i++ ) {

			data[i].disciplines = T.sortByKey(sortByName(data[i].disciplines, 'name'), 'd', 'desc');
			days = data[i];

			for ( j = 0; j < days.disciplines.length; j++) {

				days.disciplines[j].events = T.sortByKey(sortByName(days.disciplines[j].events, 'name'), 'd', 'desc');
				disciplines = days.disciplines[j];

				for ( k = 0; k < disciplines.events.length; k++ ) {

					disciplines.events[k].matches = T.sortByKey(sortByName(disciplines.events[k].matches, 'u'), 'd', 'desc');

				}

			}

		}

		return data;

	};

	var sortByDay = function (events) {

		var
			sorted = [],
			i = 0,
			j = 0,
			e = {},
			sport = '',
			disciplines = [],
			date = '',
			idxDate = null,
			idxSport = null,
			idxPath = null,
			path = null;

		j = events && events.length;

		if ( j ) {

			for ( ; i < j; i++ ) {

				e = events[i];

				if (T.ns('Sport.Controller.Categories').checkFilter(e.c)) {

					date = e.r ? Infinity : T.getDayFromTs(e.d);
					idxDate = T.inJSONArrayByKey(sorted, 'date', date);
					sport = e.c;

					if ( idxDate === -1 ) {

						sorted[sorted.length] = {
							date: date,
							disciplines: []
						};
						idxDate = sorted.length - 1;

					}

					disciplines = sorted[idxDate].disciplines;
					idxSport = T.inJSONArrayByKey(disciplines, 'name', sport);

					if ( idxSport === -1 ) {

						disciplines[disciplines.length] = {
							name: sport,
							d: 10000000000000,
							events: []
						}
						idxSport = disciplines.length - 1;

					}

					path = (e.p && (e.p.length > 1 ? (e.p.slice(0, e.p.length - 1).join(', ') + ': ' + e.p[e.p.length - 1]) : e.p[0])) || 'Sport';

					idxPath = T.inJSONArrayByKey(disciplines[idxSport].events, 'name', path);

					if ( idxPath === -1 ) {

						disciplines[idxSport].events[disciplines[idxSport].events.length] = {
							name: path,
							d: 10000000000000,
							matches: []
						}
						idxPath = disciplines[idxSport].events.length - 1;

					}

					disciplines[idxSport].events[idxPath].matches.push(e);

					if ( e.d < disciplines[idxSport].events[idxPath].d ) {

						disciplines[idxSport].events[idxPath].d = e.d;

					}

					if ( e.d < disciplines[idxSport].d ) {

						disciplines[idxSport].d = e.d;

					}

					sorted[idxDate].disciplines = disciplines;

				}

			}

		}

		return sortAll(sorted);
	};

	var headerLook = function (el) {

		var
			i = 0, length = el.h.r.length,
			html = [];

		html.push('<div class="event header" data-xx="' + el.x + '" data-sxx="' + (el.s + '.' + el.x) + '" data-hxx="' + el.hXx + '">');
			html.push('<div class="table details">');
				if (el.r) {
					activeCounter += 1;
					html.push('<div class="table-cell part"><div class="isRunning"></div>' + (el.h.d && el.h.d.p && el.h.d.p[el.h.d.p.length-1] || 'Trwa') + '</div>');
				}
				html.push('<div class="table-cell teams-side">');

				for ( ; i < length; i++ ) {

					html.push('<div class="team">' + el.h.r[i].p + '<span class="score">' + el.h.r[i].ps + '</span></div>');

				}

				html.push('</div>');
			html.push('</div>');
		html.push('</div>');

		return html.join('');

	};

	var noHeaderLook = function (el) {
		var
			html = [];

		html.push('<div class="event noHeader" data-xx="' + el.x + '" data-sxx="' + (el.s + '.' + el.x) + '">');
			html.push('<div class="table details">');
				if (el.r) {
					activeCounter += 1;
					html.push('<div class="table-cell part"><div class="isRunning"></div>Trwa</div>');
				}
				html.push('<div class="table-cell teams-side title">' + el.t + '</div>');
			html.push('</div>');
		html.push('</div>');

		return html.join('');

	};

	self.render = function (events, refresh) {

		activeCounter = 0;

		var
			days = sortByDay(events),
			i = 0, length = days.length,
			day = null,
			discipline = null,
			event = null,
			match = null,
			tpl = null,
			wrapper = document.createElement('div'),
			html = [];


		wrapper.className = 'events-box';

		for ( ; i < length; i++ ) {

			day = days[i];
			html.push('<div class="day">' + parseDate(day.date) + '</div>');

			for (j = 0, length2 = day.disciplines.length; j < length2; j++) {
				discipline = day.disciplines[j];
				for (k = 0, length3 = discipline.events.length; k < length3; k++) {
					event = discipline.events[k];
					html.push('<div class="path">' + event.name + '</div>');
					for (l = 0, length4 = event.matches.length; l < length4; l++) {
						match = event.matches[l];
						if ( match.h && match.h.r && match.h.r.length === 2) {
							tpl = headerLook(match);
						} else {
							tpl = noHeaderLook(match);
						}
						html.push(tpl);
					}
				}

			}

		}

		if (html.length === 0) {
			html.push('<div class="noEvents">Brak aktualnych wyników w tej kategorii.</div>');
		}

		wrapper.innerHTML = html.join('');

		if (refresh) {
			self._$container.innerHTML = '';
		}
		if (self._$container.firstChild) {
			self._$container.insertBefore(wrapper, self._$container.firstChild);
		} else {
			self._$container.appendChild(wrapper);
		}
		if (activeCounter) {
			self._$badge.innerHTML = activeCounter;
			self._$badge.style.visibility = 'visible';
		} else {
			self._$badge.style.visibility = 'hidden';
		}
		setTimeout(function () {
			var elements = wrapper.querySelectorAll('.event');
			for ( var i = 0, length = elements.length; i < length; i++ ) {
				elements[i].addEventListener('click', function (){
					T.ns('Sport.Controller.Relation').getRelation(this.getAttribute('data-sxx'));
				});
			}
		}, 100);
	};

	return self;

})();
