T.ns('Sport.View').Headers = (function  () {
	var
		self = {};

	self.get = function (el, container) {
		var
			head = el.h && el.h.d || el.d,
			results = el.h && el.h.r || el.r;
		if (el.ts && el.ts > Date.now()) {
			return getCalendarHead(el, results, container);
		} else if (el.t === 'GG_DRUZYNOWE' || results && results.length === 2) {
			return getTeamHead(el, head, results, container);
		} else if (results && results.length > 2) {
			return getIndividualHead(el, head, results, container);
		}
	};

	var getTeamHead = function (el, head, results, container) {
		var
			i = 0,
			length = results && results.length || 0,
			isArticle = container.indexOf('article') > -1,
			whoWin = -1,
			html = [];

		html.push('<div class="game-head-app-wrapper">');
			html.push('<div class="game-head-app" data-xx="' + el.x + '" data-sxx="' + (el.s + '.' + el.x) + '" data-hxx="' + el.hXx + '">');
				if (el.h && el.h.n) {
					html.push('<div class="path">' + (el.h && el.h.n || el.p) + '</div>');
				}
				html.push('<div class="table details">');

					if (el.a || (head && (head.gs > 0 && head.gs < 9))) {
						html.push('<div class="table-cell part"><div class="isRunning"></div>' + (head.p && head.p[head.p.length-1] || 'Trwa') + '</div>');
					}
					html.push('<div class="table-cell teams-side">');

					if (results[0].ps > results[1].ps) {
						whoWin = 0;
					} else if (results[0].ps < results[1].ps) {
						whoWin = 1;
					}
					for (i = 0 ; i < length; i++ ) {

						html.push('<div class="team">');
						if (i === whoWin) {
							html.push('<b>' + results[i].p + '</b>');
						} else {
							html.push(results[i].p);
						}
						html.push('<span class="score">' + results[i].ps + '</span></div>');

					}

					html.push('</div>');
				html.push('</div>');
			html.push('</div>');
			if (head.hd || head.p && head.p.length) {
				html.push('<div class="game-head-app-match-details' + (!isArticle && (!el.e || el.e.length === 0) ? ' showed' : '') + '">');
					html.push('<div class="teams-details">');
					if (head.p && head.p.length) {
						html.push('<h3>Przebieg meczu:</h3>');
						for (i = 0 ; i < head.p.length; i++ ) {
							if (i !== 0) {
								html.push('<br/>');
							}
							html.push('<b>' + head.p[i] + '</b>: ' + head.hss[i] + ' : ' + head.ass[i]);
						}
					}
					if (head.hd && results) {
						html.push('<h3>' + results[0].p + '</h3>' + head.hd);
						html.push('<h3>' + results[1].p + '</h3>' + head.ad);
					}
					html.push('</div>');
					html.push('<div class="show-details">Rozwiń</div>');
					html.push('<div class="hide-details">Zwiń</div>');
				html.push('</div>');
			html.push('</div>');

		}

		setTimeout(function () {
				var
					$matchDetails = document.querySelector(container + ' .game-head-app-match-details'),
					$gameHead = null;

				if ($matchDetails){
					$matchDetails.querySelector('.show-details').addEventListener('click', function (){
						$matchDetails.className = 'game-head-app-match-details showed';
					});
					$matchDetails.querySelector('.hide-details').addEventListener('click', function (){
						$matchDetails.className = 'game-head-app-match-details';
					});
				}
				if (isArticle && el.s !== 0) {
					$gameHead = document.querySelector(container + ' .game-head-app');
					$gameHead.addEventListener('click', function (){
						T.ns('Sport.Controller.Relation').getRelation($gameHead.getAttribute('data-sxx'));
					});
				}
		}, 1000);
		return html.join('');

	};

	var getIndividualHead = function (el, head, results, container) {
		var
			i = 0,
			length = results && results.length || 0,
			isArticle = container.indexOf('article') > -1,
			html = [];

		html.push('<div class="game-head-app-wrapper">');
			html.push('<div class="game-head-app" data-xx="' + el.x + '" data-sxx="' + (el.s + '.' + el.x) + '" data-hxx="' + el.hXx + '">');
				if (el.h && el.h.n) {
					html.push('<div class="path">' + (el.h && el.h.n || el.p) + '</div>');
				}
				html.push('<div class="table details">');

					if (el.a || (head && (head.gs > 0 && head.gs < 9))) {
						html.push('<div class="table-cell part"><div class="isRunning"></div>' + (head.p && head.p[head.p.length-1] || 'Trwa') + '</div>');
					}
					html.push('<div class="table-cell teams-side">');

					if (length > 3) {
						length = 3;
					}

					for (i = 0 ; i < length; i++ ) {

						html.push('<div class="team"><span class="lp">' + results[i].lp + '</span>');
						if (i === 0) {
							html.push('<b>' + results[i].p + '</b>');
						} else {
							html.push(results[i].p);
						}
						html.push('<span class="score">' + results[i].ps + '</span></div>');

					}

					html.push('</div>');
				html.push('</div>');
			html.push('</div>');
			if ((length = results && results.length || 0) > 3 ) {
				html.push('<div class="game-head-app-match-details' + (!isArticle && (!el.e || el.e.length === 0) ? ' showed' : '') + '">');
					html.push('<div class="players-details">');
					for (i = 3 ; i < length; i++ ) {
						html.push('<div class="team"><span class="lp">' + results[i].lp + '</span>' + results[i].p + '<span class="score">' + results[i].ps + '</span></div>');
					}
					html.push('</div>');
					html.push('<div class="show-details">Rozwiń</div>');
					html.push('<div class="hide-details">Zwiń</div>');
				html.push('</div>');
			html.push('</div>');
		}

		setTimeout(function () {
				var
					$matchDetails = document.querySelector(container + ' .game-head-app-match-details'),
					$gameHead = null;

				if ($matchDetails){
					$matchDetails.querySelector('.show-details').addEventListener('click', function (){
						$matchDetails.className = 'game-head-app-match-details showed';
					});
					$matchDetails.querySelector('.hide-details').addEventListener('click', function (){
						$matchDetails.className = 'game-head-app-match-details';
					});
				}
				if (isArticle && el.s !== 0) {
					$gameHead = document.querySelector(container + ' .game-head-app');
					$gameHead.addEventListener('click', function (){
						T.ns('Sport.Controller.Relation').getRelation($gameHead.getAttribute('data-sxx'));
					});
				}
		}, 1000);
		return html.join('');

	};

	var getCalendarHead = function (el, results, container) {
		var
			i = 0, length = results && results.length || null,
			html = [],
			extraClass = T.ns('Sport.Controller.Calendar').getReminderId(el.x) ? ' added' : '',
			title = '';

		html.push('<div class="game-head-app calendar" data-xx="' + el.x + '">');
			html.push('<div class="table details">');
				html.push('<div class="table-cell teams-side">');

				if (length) {
					for ( ; i < length; i++ ) {

						title += results[i].p;
						html.push('<div class="team">' + results[i].p + '</div>');

					}
				} else {
					title = el.n;
					html.push('<div class="team">' + el.n + '</div>');
				}

				html.push('</div>');
				html.push('<div class="table-cell part add' + extraClass + '" data-xx="' + el.x + '" data-name="' + title + '" data-ts="' + el.ts + '">' + parseMatchDate(el.ts) + '</div>');
			html.push('</div>');
		html.push('</div>');

		setTimeout(function () {

			var
				$add = document.querySelector(container + ' .game-head-app .add');

			$add.addEventListener('click', function () {
				if ($add.className.indexOf('added') > -1) {
					if (window.confirm('Anulować przypomnienie o relacji ' + $add.getAttribute('data-name') + '?')) {
							T.ns('Sport.Controller.Calendar').removeReminder($add.getAttribute('data-xx'));
						}
				} else {
					if (window.confirm('Dodać przypomnienie o starcie ' + $add.getAttribute('data-name') + '?')) {
							T.ns('Sport.Controller.Calendar').setReminder($add.getAttribute('data-ts'), $add.getAttribute('data-name'), $add.getAttribute('data-xx'));
					}
				}
			});

		}, 100);

		return html.join('');
	};

	var parseMatchDate = function (ts) {

		var
			date = new Date(ts),
			now = new Date(),
			dayNow = now.getDate(),
			day = date.getDate(),
			time = date.getHours() + ':' + ('00' + date.getMinutes()).slice(-2);

		switch (day) {
			case dayNow:
				return 'Dziś<br/>' + time;
				break;
			case dayNow+1:
				return 'Jutro<br/>' + time;
				break;
			case dayNow+2:
				return 'Pojutrze<br/>' + time;
				break;
			default:
				return day + '.' + ('00' + (date.getMonth() + 1)).slice(-2) + '.' + date.getFullYear() + '<br/>' + time;
				break;
		}

		return day + '.' + ('00' + (date.getMonth() + 1)).slice(-2) + '.' + date.getFullYear() + '<br/>' + time;
	};

	return self;

})();
