T.ns('Sport.View').Relation = (function  () {
	var
		Base = T.ns('Sport.View').Base,
		Head = T.ns('Sport.View').Headers,
		self = new Base();

	self._container = '#relation';
	self._$container = document.querySelector(self._container);

	var parseDate = function (ts) {

		var
			date = new Date(ts),
			time = date.getHours() + ':' + ('00' + date.getMinutes()).slice(-2);

		return time;

	};

	var noteClass = function (cl) {
		switch (cl) {
			case 'change':
				return '<br><img src="images/RelationIcons/change_player.png" />'
			break;
			case 'goal':
				return '<br><img src="images/RelationIcons/goal.png" />'
			break;
			case 'korespondencja':
			case 'correspondent':
				return '<br><img src="images/RelationIcons/korespondencja.png" />'
			break;
			case 'twitter':
				return '<br><img src="images/RelationIcons/twitter.png" />'
			break;
			case 'yellowCard':
				return '<br><img src="images/RelationIcons/yellow_card.png" />'
			break;
			case 'redCard':
				return '<br><img src="images/RelationIcons/red_card.png" />'
			break;
			case 'quote':
				return '<br><img src="images/RelationIcons/quote.png" />'
			break;
			case 'facebook':
				return '<br><img src="images/RelationIcons/facebook.png" />'
			break;
			case 'goldMedal':
				return '<br><img src="images/RelationIcons/gold_medal.png" />'
			break;
			case 'silverMedal':
				return '<br><img src="images/RelationIcons/silver_medal.png" />'
			break;
			case 'bronzeMedal':
				return '<br><img src="images/RelationIcons/bronze_medal.png" />'
			break;
			case 'extraTime':
				return '<br><img src="images/RelationIcons/extra_time.png" />'
			break;
			default:
				return '';
		}
	};

	var noteTime = function (e) {

		if (e.m) {
			if (e.a) {
				return e.m + '. min. + ' + e.a;
			} else {
				return e.m + '. min.';
			}
		} else if (e.t) {
			return e.t;
		} else if (e.d) {
			return parseDate(e.d);
		}

		return parseDate(Date.now());
	};

	self.getNotes = function (notes) {
		var i = 0,
			length = notes.length,
			html = [],
			e = null;

		for ( ; i < length; i++) {
			e = notes[i];
			html.push('<li class="note' + (e.i ? ' urgent' : '') + '">');
				html.push('<div class="time">' + (e.i ? '<span class="urgentText">PILNE</span><br/>' : '') + noteTime(e) + noteClass(e.e) +  '</div>');
				html.push('<div class="body">' + (e.b ? e.b.replace(/<iframe(?:[\s\S]*?)<\/iframe>/gim, '') : "") + '</div>');
			html.push('</li>');
		}
		return html.join('');
	};

	self.render = function (relation) {
		var
			html = [];

		self._$container.scrollTop = 0;
		if (relation.h) {
			html.push(Head.get(relation, self._container));
		} else {
			if (relation.p) {
				html.push('<div class="path">' + relation.p + '</div>');
			}

			html.push('<div class="table noHeader">');

			if (relation.a) {
				html.push('<div class="table-cell part"><div class="isRunning"></div>Trwa</div>');
			}

				html.push('<div class="table-cell rel-title">' + relation.t + '</div>');

			html.push('</div>');
		}

		if (relation.e && relation.e.length) {
			if (relation.a) {
				relation.e = T.sortByKey(relation.e, "n", 'desc');
			} else {
				relation.e = T.sortByKey(relation.e, "n");
			}

			html.push('<ul>');
				html.push(self.getNotes(relation.e));
			html.push('</ul>');
		}

		self._$container.innerHTML = html.join('');
		Base.shareUrl = relation.u;
		// ga('send', {
		//   'hitType': 'event',
		//   'eventCategory': 'article',
		//   'eventAction': 'open',
		//   'eventLabel': relation.t
		// });
	};

	self.show = function () {
		self._$container.className += ' show';
	};

	self.hide = function () {
		self._$container.className = self._$container.className.replace(/ show/gi,'');
		self._$container.innerHTML = '<progress></progress>';
	};

	return self;

})();
