T.ns('Sport.View').Surveys = (function  () {
	var
		Base = T.ns('Sport.View').Base,
		self = new Base();

	var getPercent = function (n) {
		return Math.round(100*n) + '%';
	};

	var twoOptions = function (options, xx) {

		var html = [];

		html.push('<div class="table">');
			html.push('<div class="table-cell">' + options[0] + '<br/><div class="option two" data-xxp="' + xx + '.0">Głosuj</div></div>');
			html.push('<div class="table-cell"></div>');
			html.push('<div class="table-cell">' + options[1] + '<br/><div class="option two" data-xxp="' + xx + '.1">Głosuj</div></div>');
		html.push('</div>');
		return html.join('');
	};

	var multipleOptions = function (options, xx) {

		var html = [];

		options.forEach(function (o, idx) {
			html.push('<div class="option multi" data-xxp="' + xx + '.' + idx + '"><div class="question">' + o + '</div></div>');
		});

		return html.join('');
	};

	var twoOptionsVoted = function (options, results) {

		var html = [];

		html.push('<div class="table">');
			html.push('<div class="table-cell">' + options[0] + '<br/><span class="votes">(' + results.a[0] + ')</span></div>');
			html.push('<div class="table-cell"><canvas id="myChart" width="100" height="100"></canvas></div>');
			html.push('<div class="table-cell">' + options[1] + '<br/><span class="votes">(' + results.a[1] + ')</span></div>');
		html.push('</div>');
		html.push('<div class="overall">Liczba oddanych głosów: ' + results.n + '</div>');
		setTimeout(function () {
			var ctx = document.getElementById("myChart").getContext("2d");
			
			new Chart(ctx).Doughnut([
				{
					value : results.a[1],
					color : "#043b62"
				},
				{
					value: results.a[0],
					color:"#3c94d2"
				}
			], {segmentShowStroke: false});
		}, 2000);
		return html.join('');
	};

	var multipleOptionsVoted = function (options, results) {

		var html = [],
			percent = 0;

		options.forEach(function (o, idx) {
			percent = getPercent(results.p[idx]);
			html.push('<div class="option multi">');
			 	html.push('<div class="question">' + o + '</div>');
			 	html.push('<div class="result" style="background-size: ' + percent + ' 100%;">');
			 		html.push(percent + ' <span class="votes">(' + results.a[idx] + ')</span>');
			 	html.push('</div>');
			html.push('</div>');
		});

		return html.join('');
	};

	self.getNonVoted = function (survey) {

		var html = [];

		html.push('<div class="sport-survey">');
			html.push('<h3>' + survey.q + '</h3>');
			if (survey.a.length === 2) {
				html.push(twoOptions(survey.a, survey.x));
			} else {
				html.push(multipleOptions(survey.a, survey.x));
			}
		html.push('</div>');

		return html.join('');
	};
	self.getVoted = function (survey, noContainer) {

		var html = [];

		if (!noContainer) {
			html.push('<div class="sport-survey voted">');
		}
			html.push('<h3>' + survey.q + '</h3>');
			if (survey.a.length === 2) {
				html.push(twoOptionsVoted(survey.a, survey.r));
			} else {
				html.push(multipleOptionsVoted(survey.a, survey.r));
			}
		
		if (!noContainer) {
			html.push('</div>');
		}

		return html.join('');
	};

	return self;

})();
