// Hide and Seek Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     draggable (Boolean): If true the view will follow the cursor position between the touch start and touch end.
//     alpha (Number): Amount of transparency amount ranging from 0 (completely transparent) to 0.5 to 1 (completely opaque). 
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     ignoreTransparentPixels (Boolean): If true the hotspot will register only if the pixel's alpha component under touch position is greater than 0.
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Hide and Seek Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after all the hidden items are found.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a target item is touched.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     items: A random item is selected at the start of each round to be the correct item.
//         Available States:
//             HIDDEN: Initial state of the label.
//             DRAG: Displayed when the item is being dragged.
//             FOUND: Displayed after the item is found.
//         Properties:
//             mask: Optional view coupled with an item.
//                 Properties:
//                     wiggleOnTouch (Boolean): A touch will cause the mask's item to vibrate.
//                     foundOnTouch (Boolean): A touch will cause the mask' item to be found.
//                     touchDisabled (Boolean): Touch events on the mask will be ignored.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -89
		}
	},
	gameIcon: "mozilla_thumb_256x256_SpotTheAnimals.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "start-hideSeek-animals.jpg",
	audioEnabled: true,
	audioFilename: "audio-hideSeek-animals.mp3",
	audio: { //all audio including intro, payoff, and music
		states: [
			{
				name: "intro",
				startTime: 0,
				duration: 2.6
			}, {
				name: "payoff",
				startTime: 4,
				duration: 3
			},
			{
				name: "music", 
				startTime: 9,
				duration: 21.4,
				loop: true
			}
		]
	},
	rounds: [
		{ //Round 1
			background: {
				filename: "background-jungle-pond.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden", //the item appearing in its hidden state, can be partial image
									filename: "turtle.png", //make a rectangle marquee in Photoshop to get the bounding rectangle of the object and export as transparent png
									x: 833, //x,y coordinates of objects can be found by opening the object in Photoshop, add on a layer mask to show the bounding rectangle, take the ruler tool and measure from top to bottom. Take this number and subtract 100 px. The x,y coordinates will then be placed here.
									y: 402
								},{
									type: "Drag", //item appearing in draggable state, should be full image even if hidden was partial
									filename: "turtle.png",
									x: 833,
									y: 402,
									draggable: true
								},{
									type: "Found", //found animation
									filename: "turtle-found.png",
									x: 808,
									y: 340,
									numFrames: 20
								}
							],
							mask: { //export the mask item covering above state and add 10px to each side of the image to allow for wiggle
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "turtle-mask.png",
										x: 823, //original x,y coordinates - does not include the added 10px
										y: 392
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "toucan.png",
									x: 800,
									y: 170
								},{
									type: "Drag",
									filename: "toucan.png",
									x: 800,
									y: 170,
									draggable: true
								},{
									type: "Found",
									filename: "toucan-found.png",
									x: 790,
									y: 130,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "toucan-mask.png",
										x: 790,
										y: 160
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "grover-frog.png",
									x: -17,
									y: 219
								},{
									type: "Drag",
									filename: "grover-frog.png",
									x: -17,
									y: 219,
									draggable: true
								},{
									type: "Found",
									filename: "grover-frog-found.png",
									x: -52,
									y: 110,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "grover-frog-mask.png",
										x: -27,
										y: 209
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "zebra-1.png",
									x: 199,
									y: 239
								},{
									type: "Drag",
									filename: "zebra-1.png",
									x: 199,
									y: 239,
									draggable: true
								},{
									type: "Found",
									filename: "zebra-1-found.png",
									x: 170,
									y: 185,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "zebra-1-mask.png",
										x: 189,
										y: 229
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Elephant.png",
									x: 428,
									y: 176
								}, {
									type: "Drag",
									filename: "Elephant.png",
									x: 428,
									y: 176,
									draggable: true
								}, {
									type: "Found",
									filename: "elephant_found.png",
									x: 415,
									y: 153,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Elephant-mask.png",
										x: 418,
										y: 166
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Tiger.png",
									x: 50,
									y: 472
								}, {
									type: "Drag",
									filename: "Tiger.png",
									x: 50,
									y: 472,
									draggable: true
								}, {
									type: "Found",
									filename: "tiger_found.png",
									x: 22,
									y: 452,
									numFrames: 9
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Tiger-mask.png",
										x: 22,
										y: 462
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "macaw.png",
									x: 170,
									y: 96
								}, {
									type: "Drag",
									filename: "macaw.png",
									x: 170,
									y: 96,
									draggable: true
								}, {
									type: "Found",
									filename: "macaw-found.png",
									x: 152,
									y: 76,
									numFrames: 16
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "macaw-mask-1.png",
										x: 160,
										y: 86
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Hippo.png",
									x: 493,
									y: 499
								}, {
									type: "Drag",
									filename: "Hippo.png",
									x: 493,
									y: 499,
									draggable: true
								}, {
									type: "Found",
									filename: "hippo_found.png",
									x: 495,
									y: 456,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Hippo-mask.png",
										x: 493,
										y: 499,
									}
								]
							}
						}					
					]
				}
			]
		}, { //Round 2
			background: {
				filename: "background-night-scene.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Bat.png",
									x: 470,
									y: 218
								},{
									type: "Drag",
									filename: "Bat.png",
									x: 470,
									y: 218,
									draggable: true
								},{
									type: "Found",
									filename: "bat_found.png",
									x: 470,
									y: 150,
									numFrames: 16
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Bat-mask.png",
										x: 460,
										y: 208
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Frog.png",
									x: 277,
									y: 359
								},{
									type: "Drag",
									filename: "Frog.png",
									x: 277,
									y: 359,
									draggable: true
								},{
									type: "Found",
									filename: "frog_green_found.png",
									x: 255,
									y: 145,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Frog-mask.png",
										x: 267,
										y: 349
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Giraffe.png",
									x: 752,
									y: 312
								},{
									type: "Drag",
									filename: "Giraffe.png",
									x: 752,
									y: 312,
									draggable: true
								},{
									type: "Found",
									filename: "giraffe2_found.png",
									x: 600,
									y: 260,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Giraffe-mask.png",
										x: 742,
										y: 302
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Grover-butterfly.png",
									x: 333,
									y: 443
								},{
									type: "Drag",
									filename: "Grover-butterfly.png",
									x: 333,
									y: 443,
									draggable: true
								},{
									type: "Found",
									filename: "Grover-butterfly_found.png",
									x: 300,
									y: 390,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Grover-butterfly-mask.png",
										x: 323,
										y: 433
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Leopard.png",
									x: 107,
									y: 85
								},{
									type: "Drag",
									filename: "Leopard.png",
									x: 107,
									y: 85,
									draggable: true
								},{
									type: "Found",
									filename: "jaguar_found.png",
									x: 103,
									y: 65,
									numFrames: 10
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Leopard-mask.png",
										x: 97,
										y: 75
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Monkey.png",
									x: 755,
									y: 141
								},{
									type: "Drag",
									filename: "Monkey.png",
									x: 755,
									y: 141,
									draggable: true
								},{
									type: "Found",
									filename: "monkey_found.png",
									x: 742,
									y: 31,
									numFrames: 11
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Monkey-mask.png",
										x: 745,
										y: 131
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "macaw.png",
									x: 551,
									y: 350
								},{
									type: "Drag",
									filename: "macaw.png",
									x: 551,
									y: 350,
									draggable: true
								},{
									type: "Found",
									filename: "macaw-found.png",
									x: 533,
									y: 331,
									numFrames: 16
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "macaw-mask-2.png",
										x: 541,
										y: 340
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Zebra-2.png",
									x: 49,
									y: 437
								},{
									type: "Drag",
									filename: "Zebra-2.png",
									x: 49,
									y: 437,
									draggable: true
								},{
									type: "Found",
									filename: "zebra-2-found.png",
									x: 29,
									y: 357,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Zebra-2-mask.png",
										x: 39,
										y: 427
									}
								]
							}
						}		
					]
				}
			]
		}, { //Round 3
			background: {
				filename: "background-river-scene.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Alligator.png",
									x: -105,
									y: 340
								},{
									type: "Drag",
									filename: "Alligator.png",
									x: -105,
									y: 340,
									draggable: true
								},{
									type: "Found",
									filename: "crocodile_found.png",
									x: -120,
									y: 260,
									numFrames: 16
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Alligator-mask.png",
										x: -115,
										y: 330
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Armadillo.png",
									x: 771,
									y: 500
								},{
									type: "Drag",
									filename: "Armadillo.png",
									x: 771,
									y: 500,
									draggable: true
								},{
									type: "Found",
									filename: "armadillo_found.png",
									x: 720,
									y: 405,
									numFrames: 20
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Armadillo-mask.png",
										x: 761,
										y: 490
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Butterfly.png",
									x: 151,
									y: 134
								},{
									type: "Drag",
									filename: "Butterfly.png",
									x: 151,
									y: 134,
									draggable: true
								},{
									type: "Found",
									filename: "butterfly_found.png",
									x: 141,
									y: 121,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Butterfly-mask.png",
										x: 141,
										y: 124
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Grover-with-monkey.png",
									x: 405,
									y: 457
								},{
									type: "Drag",
									filename: "Grover-with-monkey.png",
									x: 405,
									y: 457,
									draggable: true
								},{
									type: "Found",
									filename: "Grover-monkey_found.png",
									x: 383,
									y: 368,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Grover-with-monkey-mask.png",
										x: 395,
										y: 447
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Hippo.png",
									x: -25,
									y: 484
								},{
									type: "Drag",
									filename: "Hippo.png",
									x: -25,
									y: 484,
									draggable: true
								},{
									type: "Found",
									filename: "hippo_found.png",
									x: 0,
									y: 430,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Hippo-mask-2.png",
										x: -35,
										y: 474
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "parrot.png",
									x: 585,
									y: 106
								},{
									type: "Drag",
									filename: "parrot.png",
									x: 585,
									y: 106,
									draggable: true
								},{
									type: "Found",
									filename: "parrot-found.png",
									x: 515,
									y: 66,
									numFrames: 11
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "parrot-mask.png",
										x: 575,
										y: 96
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Red-Frog.png",
									x: 423,
									y: 348
								},{
									type: "Drag",
									filename: "Red-Frog.png",
									x: 423,
									y: 348,
									draggable: true
								},{
									type: "Found",
									filename: "frog_red_found.png",
									x: 413,
									y: 148,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Red-Frog-mask.png",
										x: 413,
										y: 338
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Snake.png",
									x: 297,
									y: 231
								},{
									type: "Drag",
									filename: "Snake.png",
									x: 297,
									y: 231,
									draggable: true
								},{
									type: "Found",
									filename: "snake_found.png",
									x: 287,
									y: 211,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Snake-mask.png",
										x: 287,
										y: 221
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Tiger.png",
									x: 722,
									y: 166
								},{
									type: "Drag",
									filename: "Tiger.png",
									x: 722,
									y: 166,
									draggable: true
								},{
									type: "Found",
									filename: "tiger_found.png",
									x: 690,
									y: 153,
									numFrames: 9
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Tiger-mask-2.png",
										x: 712,
										y: 156
									}
								]
							}
						}		
					]
				}
			]
		}, { //Round 4
			background: {
				filename: "background-rainforest-scene.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Bat.png",
									x: 318,
									y: 93
								},{
									type: "Drag",
									filename: "Bat.png",
									x: 318,
									y: 93,
									draggable: true
								},{
									type: "Found",
									filename: "bat_found.png",
									x: 314,
									y: 23,
									numFrames: 16
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Bat-mask-2.png",
										x: 308,
										y: 83
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Butterfly.png",
									x: 766,
									y: 518
								},{
									type: "Drag",
									filename: "Butterfly.png",
									x: 766,
									y: 518,
									draggable: true
								},{
									type: "Found",
									filename: "butterfly_found.png",
									x: 746,
									y: 500,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Butterfly-mask-2.png",
										x: 756,
										y: 508
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Elephant.png",
									x: 439,
									y: 215
								},{
									type: "Drag",
									filename: "Elephant.png",
									x: 439,
									y: 215,
									draggable: true
								},{
									type: "Found",
									filename: "elephant_found.png",
									x: 425,
									y: 190,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Elephant-mask-2.png",
										x: 429,
										y: 205
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Giraffe-2.png",
									x: -11,
									y: 98
								},{
									type: "Drag",
									filename: "Giraffe-2.png",
									x: -11,
									y: 88,
									draggable: true
								},{
									type: "Found",
									filename: "giraffe_found.png",
									x: -11,
									y: 88,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Giraffe-mask-2.png",
										x: -21,
										y: 78
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Grover-with-Toucan.png",
									x: 818,
									y: 239
								},{
									type: "Drag",
									filename: "Grover-with-Toucan.png",
									x: 818,
									y: 239,
									draggable: true
								},{
									type: "Found",
									filename: "Grover-toucan_found.png",
									x: 765,
									y: 198,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Grover-with-Toucan-mask.png",
										x: 808,
										y: 229
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Lemur.png",
									x: 261,
									y: 488
								},{
									type: "Drag",
									filename: "Lemur.png",
									x: 261,
									y: 488,
									draggable: true
								},{
									type: "Found",
									filename: "lemure_found.png",
									x: 240,
									y: 385,
									numFrames: 10
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Lemur-mask.png",
										x: 251,
										y: 478
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "parrot.png",
									x: 295,
									y: 206
								},{
									type: "Drag",
									filename: "parrot.png",
									x: 295,
									y: 206,
									draggable: true
								},{
									type: "Found",
									filename: "parrot-found.png",
									x: 235,
									y: 146,
									numFrames: 11
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "parrot-mask-2.png",
										x: 285,
										y: 196
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Snake.png",
									x: 609,
									y: 114
								},{
									type: "Drag",
									filename: "Snake.png",
									x: 609,
									y: 114,
									draggable: true
								},{
									type: "Found",
									filename: "snake_found.png",
									x: 590,
									y: 100,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Snake-mask-2.png",
										x: 599,
										y: 104
									}
								]
							}
						}
					]
				}
			]
		}, { //Round 5
			background: {
				filename: "background-waterfall.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Butterfly.png",
									x: 799,
									y: 170
								},{
									type: "Drag",
									filename: "Butterfly.png",
									x: 799,
									y: 170,
									draggable: true
								},{
									type: "Found",
									filename: "butterfly_found.png",
									x: 779,
									y: 154,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Butterfly-mask-3.png",
										x: 789,
										y: 160
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Red-Frog.png",
									x: 382,
									y: 460
								},{
									type: "Drag",
									filename: "Red-Frog.png",
									x: 382,
									y: 460,
									draggable: true
								},{
									type: "Found",
									filename: "frog_red_found.png",
									x: 363,
									y: 247,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Frog-mask-2.png",
										x: 372,
										y: 450
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Grover-with-iguana.png",
									x: 19,
									y: 222
								},{
									type: "Drag",
									filename: "Grover-with-iguana.png",
									x: 19,
									y: 222,
									draggable: true
								},{
									type: "Found",
									filename: "Grover-iguana_found.png",
									x: 0,
									y: 193,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Grover-with-iguana-mask.png",
										x: 9,
										y: 212
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Monkey.png",
									x: 83,
									y: 83
								},{
									type: "Drag",
									filename: "Monkey.png",
									x: 83,
									y: 83,
									draggable: true
								},{
									type: "Found",
									filename: "monkey_found.png",
									x: 70,
									y: -15,
									numFrames: 11
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Monkey-mask-2.png",
										x: 73,
										y: 53
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "macaw.png",
									x: 296,
									y: 140
								},{
									type: "Drag",
									filename: "macaw.png",
									x: 296,
									y: 140,
									draggable: true
								},{
									type: "Found",
									filename: "macaw-found.png",
									x: 277,
									y: 120,
									numFrames: 16
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "macaw-mask-3.png",
										x: 286,
										y: 130
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Snake.png",
									x: 722,
									y: 453
								},{
									type: "Drag",
									filename: "Snake.png",
									x: 722,
									y: 453,
									draggable: true
								},{
									type: "Found",
									filename: "snake_found.png",
									x: 718,
									y: 433,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Snake-mask-4.png",
										x: 712,
										y: 443
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "toucan.png",
									x: 603,
									y: 116
								},{
									type: "Drag",
									filename: "toucan.png",
									x: 603,
									y: 116,
									draggable: true
								},{
									type: "Found",
									filename: "toucan-found.png",
									x: 603,
									y: 80,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Toucan-mask-2.png",
										x: 593,
										y: 106
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Zebra.png",
									x: 501,
									y: 243
								},{
									type: "Drag",
									filename: "Zebra.png",
									x: 501,
									y: 243,
									draggable: true
								},{
									type: "Found",
									filename: "zebra-3-found.png",
									x: 501,
									y: 213,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Zebra-mask-3.png",
										x: 491,
										y: 233
									}
								]
							}
						}			
					]
				}
			]
		}
	]
};