// Hide and Seek Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     draggable (Boolean): If true the view will follow the cursor position between the touch start and touch end.
//     alpha (Number): Amount of transparency amount ranging from 0 (completely transparent) to 0.5 to 1 (completely opaque). 
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     ignoreTransparentPixels (Boolean): If true the hotspot will register only if the pixel's alpha component under touch position is greater than 0.
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Hide and Seek Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after all the hidden items are found.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a target item is touched.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     items: A random item is selected at the start of each round to be the correct item.
//         Available States:
//             HIDDEN: Initial state of the label.
//             DRAG: Displayed when the item is being dragged.
//             FOUND: Displayed after the item is found.
//         Properties:
//             mask: Optional view coupled with an item.
//                 Properties:
//                     wiggleOnTouch (Boolean): A touch will cause the mask's item to vibrate.
//                     foundOnTouch (Boolean): A touch will cause the mask' item to be found.
//                     touchDisabled (Boolean): Touch events on the mask will be ignored.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -89
		}
	},
	gameIcon: "mozilla_thumb_256x256_SpotTheNumbers.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "HTML_startscreen_spotthenumbersedited.jpg",
	audioEnabled: true,
	audioFilename: "audio-hideSeek-numbers.mp3",
	audio: { //all audio including intro, payoff, and music
		states: [
			{
				name: "intro",
				startTime: 0,
				duration: 2.7
			}, {
				name: "payoff",
				startTime: 4,
				duration: 3.7
			},
			{
				name: "music", 
				startTime: 9,
				duration: 21.4,
				loop: true
			}
		]
	},
	rounds: [
		{ //Round 1
			background: {
				filename: "Background-Blue-Sky.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden", //the item appearing in its hidden state, can be partial image
									filename: "1-hidden---blue-sky.png", //make a rectangle marquee in Photoshop to get the bounding rectangle of the object and export as transparent png
									x: 77, //x,y coordinates of objects can be found by opening the object in Photoshop, add on a layer mask to show the bounding rectangle, take the ruler tool and measure from top to bottom. Take this number and subtract 100 px. The x,y coordinates will then be placed here.
									y: 190,
									hotspots: [
										{ x: -30, y: -10, width: 88, height: 130 }
									]
								},{
									type: "Drag", //item appearing in draggable state, should be full image even if hidden was partial
									filename: "1-hidden---blue-sky.png",
									x: 77,
									y: 190,
									draggable: true
								},{
									type: "Found", //found animation
									filename: "one1_found.png",
									x: 28,
									y: 112,
									numFrames: 15
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "2-hidden---blue-sky.png",
									x: 576,
									y: 153
								},{
									type: "Drag",
									filename: "2-hidden---blue-sky.png",
									x: 576,
									y: 153,
									draggable: true
								},{
									type: "Found",
									filename: "two1_found.png",
									x: 550,
									y: 100,
									numFrames: 14
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "3-hidden---blue-sky.png",
									x: 895,
									y: 296
								},{
									type: "Drag",
									filename: "3-hidden---blue-sky.png",
									x: 895,
									y: 296,
									draggable: true
								},{
									type: "Found",
									filename: "three1_found.png",
									x: 869,
									y: 246,
									numFrames: 13
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "4-hidden---blue-sky.png",
									x: 217,
									y: 111
								},{
									type: "Drag",
									filename: "4-hidden---blue-sky.png",
									x: 217,
									y: 111,
									draggable: true
								},{
									type: "Found",
									filename: "four_found.png",
									x: 190,
									y: 32,
									numFrames: 12
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "5-and-abby---blue-sky.png",
									x: 346,
									y: 400
								},{
									type: "Drag",
									filename: "5-and-abby---blue-sky.png",
									x: 346,
									y: 400,
									draggable: true
								},{
									type: "Found",
									filename: "Abby1_5_found.png",
									x: 310,
									y: 265,
									numFrames: 18
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "5-and-Abby-mask.png",
										x: 336,
										y: 390
									}
								]
							}
						}	
					]
				}
			]
		}, { //Round 2
			background: {
				filename: "Background-Partly-Cloudy-Sky.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "6-hidden.png",
									x: 56,
									y: 127
								},{
									type: "Drag",
									filename: "6-hidden.png",
									x: 56,
									y: 127,
									draggable: true
								},{
									type: "Found",
									filename: "six_found.png",
									x: 31,
									y: 53,
									numFrames: 12
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "7-hidden.png",
									x: 60,
									y: 415
								},{
									type: "Drag",
									filename: "7-hidden.png",
									x: 60,
									y: 415,
									draggable: true
								},{
									type: "Found",
									filename: "seven1_found.png",
									x: 32,
									y: 360,
									numFrames: 15
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "8-hidden.png",
									x: 297,
									y: 458
								},{
									type: "Drag",
									filename: "8-hidden.png",
									x: 297,
									y: 458,
									draggable: true
								},{
									type: "Found",
									filename: "eight_found.png",
									x: 255,
									y: 348,
									numFrames: 14
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "9-and-abby-hidden.png",
									x: 642,
									y: 354
								},{
									type: "Drag",
									filename: "9-and-abby-hidden.png",
									x: 642,
									y: 354,
									draggable: true
								},{
									type: "Found",
									filename: "Abby2_9_found.png",
									x: 590,
									y: 215,
									numFrames: 18
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "9-and-Abby-mask.png",
										x: 632,
										y: 344
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "10-hidden.png",
									x: 844,
									y: 198
								},{
									type: "Drag",
									filename: "10-hidden.png",
									x: 844,
									y: 198,
									draggable: true
								},{
									type: "Found",
									filename: "ten_found.png",
									x: 815,
									y: 97,
									numFrames: 15
								}
							]
						}
					]
				}
			]
		}, { //Round 3
			background: {
				filename: "Background-Stormy-Sky.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "1-hidden.png",
									x: 69,
									y: 140,
									hotspots: [
										{ x: -30, y: -10, width: 88, height: 130 }
									]
								},{
									type: "Drag",
									filename: "1-hidden.png",
									x: 69,
									y: 140,
									draggable: true
								},{
									type: "Found",
									filename: "one2_found.png",
									x: 19,
									y: 65,
									numFrames: 15
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "2-hidden.png",
									x: 58,
									y: 411
								},{
									type: "Drag",
									filename: "2-hidden.png",
									x: 58,
									y: 411,
									draggable: true
								},{
									type: "Found",
									filename: "two2_found.png",
									x: 32,
									y: 360,
									numFrames: 14
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "3-hidden.png",
									x: 893,
									y: 211
								},{
									type: "Drag",
									filename: "3-hidden.png",
									x: 893,
									y: 211,
									draggable: true
								},{
									type: "Found",
									filename: "three2_found.png",
									x: 870,
									y: 170,
									numFrames: 13
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "4-and-Abby-hidden.png",
									x: 393,
									y: 203
								},{
									type: "Drag",
									filename: "4-and-Abby-hidden.png",
									x: 393,
									y: 203,
									draggable: true
								},{
									type: "Found",
									filename: "Abby3_4_found.png",
									x: 350,
									y: 80,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "4-and-Abby-mask.png",
										x: 383,
										y: 193
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "5-hidden.png",
									x: 300,
									y: 448
								},{
									type: "Drag",
									filename: "5-hidden.png",
									x: 300,
									y: 448,
									draggable: true
								},{
									type: "Found",
									filename: "five2_found.png",
									x: 274,
									y: 368,
									numFrames: 17
								}
							]
						}	
					]
				}
			]
		}, { //Round 4
			background: {
				filename: "Background-Rainbow-Sky.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "6-hidden.png",
									x: 93,
									y: 424
								},{
									type: "Drag",
									filename: "6-hidden.png",
									x: 93,
									y: 424,
									draggable: true
								},{
									type: "Found",
									filename: "six_found.png",
									x: 68,
									y: 349,
									numFrames: 12
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "7-hidden.png",
									x: 218,
									y: 186
								},{
									type: "Drag",
									filename: "7-hidden.png",
									x: 218,
									y: 186,
									draggable: true
								},{
									type: "Found",
									filename: "seven2_found.png",
									x: 190,
									y: 132,
									numFrames: 15
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "8-and-Abby-hidden.png",
									x: 334,
									y: 290
								},{
									type: "Drag",
									filename: "8-and-Abby-hidden.png",
									x: 334,
									y: 290,
									draggable: true
								},{
									type: "Found",
									filename: "Abby4_8_found.png",
									x: 310,
									y: 155,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "8-and-Abby-mask.png",
										x: 328,
										y: 298
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "9-hidden.png",
									x: 464,
									y: 96
								},{
									type: "Drag",
									filename: "9-hidden.png",
									x: 464,
									y: 96,
									draggable: true
								},{
									type: "Found",
									filename: "nine_found.png",
									x: 437,
									y: 45,
									numFrames: 14
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "10-hidden.png",
									x: 780,
									y: 471
								},{
									type: "Drag",
									filename: "10-hidden.png",
									x: 780,
									y: 471,
									draggable: true
								},{
									type: "Found",
									filename: "ten_found.png",
									x: 751,
									y: 371,
									numFrames: 15
								}
							]
						}
					]
				}
			]
		}, { //Round 5
			background: {
				filename: "Background-night.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "1-hidden.png",
									x: 558,
									y: 287,
									hotspots: [
										{ x: -30, y: -10, width: 88, height: 130 }
									]
								},{
									type: "Drag",
									filename: "1-hidden.png",
									x: 558,
									y: 287,
									draggable: true
								},{
									type: "Found",
									filename: "one2_found.png",
									x: 509,
									y: 208,
									numFrames: 15
								}
							]
						}, {
							states: [
								{
									type: "Hidden",
									filename: "2-and-Abby-hidden.png",
									x: -4,
									y: 131
								},{
									type: "Drag",
									filename: "2-and-Abby-hidden.png",
									x: -4,
									y: 131,
									draggable: true
								},{
									type: "Found",
									filename: "Abby5_2_found.png",
									x: -34,
									y: -20,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "2-and-Abby-Cloud-mask.png",
										x: -13,
										y: 121
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "3-hidden.png",
									x: 815,
									y: 400
								},{
									type: "Drag",
									filename: "3-hidden.png",
									x: 815,
									y: 400,
									draggable: true
								},{
									type: "Found",
									filename: "three1_found.png",
									x: 788,
									y: 350,
									numFrames: 13
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "4-hidden.png",
									x: 92,
									y: 485
								},{
									type: "Drag",
									filename: "4-hidden.png",
									x: 92,
									y: 485,
									draggable: true
								},{
									type: "Found",
									filename: "four_found.png",
									x: 64,
									y: 405,
									numFrames: 12
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "5-hidden.png",
									x: 284,
									y: 377
								},{
									type: "Drag",
									filename: "5-hidden.png",
									x: 284,
									y: 377,
									draggable: true
								},{
									type: "Found",
									filename: "five3_found.png",
									x: 258,
									y: 298,
									numFrames: 17
								}
							]
						}		
					]
				}
			]
		}
	]
};