function Rectangle(a,b,c){this.corner=a,this.width=b,this.height=c}function Vector2d(a,b){this.x=a,this.y=b}function Blob(a){this.position=a.position,this.radius=a.radius||0,this.speed=a.speed||new Vector2d(0,0),this.rotationRate=500*Math.random()+200,this.isPlayer=a.isPlayer||!1,this.rotation=this.isPlayer?0:a.rotation||4*(Math.random()-.5)*Math.PI,this._name="Blob #"+this.constructor.counter++}function GameLoop(a){this.world=a.world,this.tick=Common.bind(this,this.tick),this._lastUpdateTime=null,this._rafId=null}function Particle(a){this.position=new Vector2d(0,0),this.speed=a.speed,this.color=a.color,this.lifetime=a.lifetime||1e3,this.size=a.size||2,this.age=0,this._lastPosition=this.position}function ParticleEmitter(a){this.position=a.position,this.direction=a.direction,this.lifetime=a.lifetime,this.mirrored="undefined"==typeof a.mirrored?!0:a.mirrored,this.count=a.count||16,this.clipping=a.clipping||new Rectangle(new Vector2d(0,0),window.innerWidth,window.innerHeight),this.particles=[],this.speedScale=250}function World(a){this.viewport=a.viewport,this.extents=a.extents,this.canvas=a.canvas,this.ctx=this.canvas.getContext("2d"),this.blobs=[],this.particleEmitters=[],this.backgroundEl=a.backgroundEl,this.timeMultiplier=1;var b=this;this.constructor.boundFunctions.forEach(function(a){b[a]=Common.bind(b,b[a])}),this.canvas.addEventListener("mousedown",this.handleMouseDown)}!function(){function a(a,c){var d=function(){};d.prototype=a.prototype,c.prototype=new d,c.uber=a.prototype,c.uberConstructor=c.prototype.uberConstructor=a,c.prototype.super=function(){this.uberConstructor.apply(this,arguments)},c.prototype.constructor=c,b(c,a)}function b(a){for(var b=1;b<arguments.length;b++){var c=arguments[b];for(var d in c)c.hasOwnProperty(d)&&(a[d]=c[d])}}function c(a,b){return function(){b.apply(a,arguments)}}this.Common={inherit:a,extend:b,bind:c}}(),function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(b){var c=(new Date).getTime(),d=Math.max(0,16-(c-a)),e=window.setTimeout(function(){b(c+d)},d);return a=c+d,e}),window.cancelAnimationFrame||(window.cancelAnimationFrame=function(a){clearTimeout(a)})}(),window.EventEmitter={on:function(a,b){this._ensureEvent(a),this._events[a].push(b)},off:function(a,b){this._events&&this._events[a]&&(this._events[a]=this._events[a].filter(function(a){return a!==b}))},emit:function(a){var b=Array.prototype.slice.call(arguments,1);this._ensureEvent(a),this._events[a].forEach(function(a){a.apply(this,b)})},_ensureEvent:function(a){this._events||(this._events={}),this._events[a]||(this._events[a]=[])}},Object.defineProperty(Rectangle.prototype,"otherCorner",{get:function(){return new Vector2d(this.corner.x+this.width,this.corner.y+this.height)},set:function(a){var b=a.sub(this.corner);b.x<0&&(this.corner.x=a.x),b.y<0&&(this.corner.y=a.y),this.width=Math.abs(b.x),this.height=Math.abs(b.y)},enumerable:!0}),Object.defineProperty(Rectangle.prototype,"center",{get:function(){return new Vector2d(this.corner.x+this.width/2,this.corner.y+this.height/2)},set:function(a){this.corner.x=a.x-this.width/2,this.corner.y=a.y-this.height/2},enumerable:!0}),Rectangle.prototype.hitTest=function(a){},Rectangle.prototype.intersects=function(a){var b=this,c=a;return Math.max(b.corner.x,c.corner.x)<=Math.min(b.otherCorner.x,c.otherCorner.y)&&Math.max(b.corner.y,c.corner.y)<=Math.min(b.otherCorner.y,c.otherCorner.y)?!0:!1},Rectangle.prototype.intersect=function(a){return this.intersects(a)?new Rectangle(new Vector2d(Math.max(this.corner.x,a.corner.x),Math.max(this.corner.y,a.corner.y)),Math.min(this.otherCorner.x,a.otherCorner.x)-this.otherCorner.x,Math.min(this.otherCorner.y,a.otherCorner.y)-this.otherCorner.y):null},Rectangle.prototype.isContainedBy=function(a){},Rectangle.prototype.blend=function(a,b){return new this.constructor(this.corner.sub(a.corner).scale(b).add(this.corner),this.width*(1-b)+a.width*b,this.height*(1-b)+a.height+b)},Object.defineProperty(Vector2d.prototype,"length",{get:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},enumerable:!0}),Vector2d.prototype.add=function(a){return a instanceof this.constructor?new this.constructor(this.x+a.x,this.y+a.y):new this.constructor(this.x+a,this.y+a)},Vector2d.prototype.sub=function(a){return this.add(a instanceof this.constructor?a.neg():-a)},Vector2d.prototype.neg=function(){return new this.constructor(-this.x,-this.y)},Vector2d.prototype.scale=function(a){return new this.constructor(this.x*a,this.y*a)},Vector2d.prototype.dot=function(a){return this.x*a.x+this.y*a.y},Vector2d.prototype.towards=function(a){return a.sub(this).normalize()},Vector2d.prototype.normalize=function(){return this.scale(1/this.length)},Vector2d.random=function(a){var b=Math.random()*Math.PI*2,c=a?1:Math.random();return new this(c*Math.cos(b),c*Math.sin(b))},Vector2d.randomWithin=function(a){return new this(a.corner.x+Math.random()*a.width,a.corner.y+Math.random()*a.height)},Vector2d.prototype.rotate=function(a){return new this.constructor(this.x*Math.cos(a)-this.y*Math.sin(a),this.x*Math.sin(a)+this.y*Math.cos(a))},Vector2d.prototype.clone=function(){return new this.constructor(this.x,this.y)},Common.extend(Blob.prototype,EventEmitter),Blob.counter=0,Blob.thrust={speed:80,radius:.02},Blob.getImage=function(a){var b=new Image;return b.src=a,b},Blob.images={player:Blob.getImage("assets/yellow.png"),smaller:Blob.getImage("assets/blue.png"),bigger:Blob.getImage("assets/red.png"),highlight:Blob.getImage("assets/highlight.png")},Object.defineProperty(Blob.prototype,"mass",{get:function(){return Math.PI*this.radius*this.radius},set:function(a){this.radius=Math.sqrt(a/Math.PI)},enumerable:!0}),Object.defineProperty(Blob.prototype,"momentum",{get:function(){return this.speed.scale(this.mass)},set:function(a){this.speed=a.scale(1/this.mass)},enumerable:!0}),Blob.prototype.toString=function(){return this._name},Blob.prototype.getBoundingBox=function(){return new Rectangle(new Vector2d(this.position.x-this.radius,this.position.y-this.radius),2*this.radius,2*this.radius)},Blob.prototype.intersectsWith=function(a){return this.radius+a.radius>a.position.sub(this.position).length},Blob.prototype.absorb=function(a){return this.mass+=a.mass,this.momentum=this.momentum.add(a.momentum),a.emit("absorbed",this,a),this},Blob.prototype.slurp=function(a){var b=this.position.sub(a.position).length,c=.5*(b+Math.sqrt(2*(this.radius*this.radius+a.radius*a.radius)-b*b)),d=c-this.radius,e=Math.PI*d*d;return c>=b?void this.absorb(a):(this.radius=c,a.radius=b-c,this.momentum=this.momentum.add(a.momentum.scale(e/a.mass)),this.emit("slurped",this,a),this)},Blob.prototype.squirt=function(a){var b=this.position.sub(a).normalize().neg(),c=b.scale(1.2*this.radius).add(this.position),d=this.radius*(1-this.constructor.thrust.radius),e=new Blob({position:c,speed:b.scale(4*this.constructor.thrust.speed).add(this.speed)});return e.mass=Math.PI*(this.radius*this.radius-d*d),this.radius=d,this.speed=this.speed.add(b.neg().scale(this.constructor.thrust.speed)),this.emit("squirt",this,e),this},Blob.prototype.intersect=function(a){var b=this.radius>a.radius?this:a,c=this.radius<=a.radius?this:a,d=c.position.sub(b.position).length,e=!1;return d<=b.radius?(b.absorb(c),e=!0):d<c.radius+b.radius&&(b.slurp(c),e=!0),e},Blob.prototype.getBlobImage=function(a){return this.isPlayer?this.constructor.images.player:a&&this.radius>a.radius?this.constructor.images.bigger:this.constructor.images.smaller},Blob.prototype.render=function(a,b){this._currentRotation||(this._currentRotation=0),this._currentRotation=Math.sin(+new Date/this.rotationRate)*Math.PI/4+this.rotation;var c=this.getBlobImage(b),d=this.constructor.images.highlight;a.rotate(this._currentRotation),a.drawImage(c,-this.radius,-this.radius,2*this.radius,2*this.radius),a.rotate(-this._currentRotation),a.globalAlpha=.5,a.drawImage(d,-this.radius,-this.radius,2*this.radius,2*this.radius),a.globalAlpha=1},GameLoop.prototype.start=function(){this.running=!0,this.tick()},GameLoop.prototype.stop=function(){this.running&&(this._rafId&&cancelAnimationFrame(this._rafId),this._rafId=null,this.running=!1,this._lastUpdateTime=null,this.world.reset())},GameLoop.prototype.tick=function(){this._rafId=requestAnimationFrame(this.tick);var a=+new Date;null==this._lastUpdateTime&&(this._lastUpdateTime=a);var b=a-this._lastUpdateTime;this.update(b),this.draw(),this._lastUpdateTime=a},GameLoop.prototype.update=function(a){this.world.stepSimulation(a)},GameLoop.prototype.draw=function(){this.world.draw()},Particle.prototype.tick=function(a){this.age+=a,this._lastPosition=this.position,this.position=this.position.add(this.speed.scale(a/1e3))},Particle.prototype.render=function(a){var b=1-this.age/this.lifetime;if(!(0>=b)){{this.size*b}a.save(),a.strokeStyle=this.color,a.lineWidth=2*b,a.beginPath(),a.moveTo(this._lastPosition.x,this._lastPosition.y),a.lineTo(this.position.x,this.position.y),a.closePath(),a.globalAlpha=b,a.stroke(),a.globalAlpha=1,a.restore()}},Common.extend(ParticleEmitter.prototype,EventEmitter),ParticleEmitter.prototype.start=function(){for(var a=this.direction.scale(this.speedScale),b=0;b<this.count;b++){var c=a.add(Vector2d.random().scale(this.speedScale/4));this.particles.push(new Particle({color:Math.random()<.5?"#ff0000":"#ff6600",lifetime:this.lifetime,speed:this.mirrored?b%2?c:c.neg():c}))}},ParticleEmitter.prototype.tick=function(a){this.particles.forEach(function(b){b.tick(a)}),this.hasLiveParticles()||this.emit("dead",this)},ParticleEmitter.prototype.hasLiveParticles=function(){return this.particles.reduce(function(a,b){return a||b.age<b.lifetime},!1)},ParticleEmitter.prototype.render=function(a){a.save(),a.translate(this.position.x,this.position.y),this.particles.forEach(function(b){b.render(a)}),a.restore()},Common.extend(World.prototype,EventEmitter),World.boundFunctions=["handleBlobAbsorbed","handleBlobSlurped","handleBlobSquirt","handleMouseDown"],World.prototype.reset=function(){var a=this;setTimeout(function(){a.ctx.restore(),a.clearBlobs(),a.clearParticleEmitters(),a.timeMultiplier=1,a.clear()},0)},World.prototype.addBlob=function(a){a.on("absorbed",this.handleBlobAbsorbed),a.on("slurped",this.handleBlobSlurped),a.on("squirt",this.handleBlobSquirt),this.blobs.push(a)},World.prototype.removeBlob=function(a){this.blobs=this.blobs.filter(function(b){return b!=a})},World.prototype.clearBlobs=function(){this.blobs=[]},World.prototype.getPlayerBlobs=function(){return this.blobs.filter(function(a){return a.isPlayer})},World.prototype.handleBlobAbsorbed=function(a,b){this.removeBlob(b),b.isPlayer?this.emit("playerDied"):this.emit("absorbed",a,b)},World.prototype.handleBlobSlurped=function(a,b){var c=a.position.add(a.position.towards(b.position).scale(a.radius)),d=this.mapWorldToScreen(c),e=new ParticleEmitter({lifetime:1e3,position:d,ctx:this.ctx,direction:a.position.towards(b.position).rotate(Math.PI/2)});this.addParticleEmitter(e),e.start()},World.prototype.handleBlobSquirt=function(a,b){this.addBlob(b);var c=this.mapWorldToScreen(b.position),d=new ParticleEmitter({lifetime:1e3,position:c,ctx:this.ctx,direction:a.position.towards(b.position),mirrored:!1});this.addParticleEmitter(d),d.start(),this.emit("squirted",a,b)},World.prototype.addParticleEmitter=function(a){var b=this;this.particleEmitters.push(a),a.on("dead",function(a){b.removeParticleEmitter(a)})},World.prototype.removeParticleEmitter=function(a){this.particleEmitters=this.particleEmitters.filter(function(b){return b!=a})},World.prototype.clearParticleEmitters=function(){this.particleEmitters=[]},World.prototype.handleMouseDown=function(a){a.preventDefault();var b=a.pageX,c=a.pageY,d=this.mapScreenToWorld(new Vector2d(b,c));this.getPlayerBlobs().forEach(function(a){a.squirt(d)})},World.prototype.generate=function(a){for(var b=0;b<a.count;b++)this.addBlob(new Blob({position:0==b?this.extents.center.clone():Vector2d.randomWithin(this.extents),radius:0==b?.5*a.radius:.1*a.radius+Math.random()*a.radius*.9,speed:Vector2d.random().scale(a.speed),isPlayer:0==b}))},World.prototype.clear=function(){this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height)},World.prototype.draw=function(){var a=this,b=this.getPlayerBlobs()[0],c=this.mapScalarToScreen(1);this.clear(),this.blobs.forEach(function(d){var e=a.mapWorldToScreen(d.position);e.x<-d.radius||e.x>a.canvas.width+d.radius||e.y<-d.radius||e.y>a.canvas.height+d.radius||(a.ctx.save(),a.ctx.translate(e.x,e.y),a.ctx.scale(c,c),d.render(a.ctx,b),a.ctx.restore())}),this.particleEmitters.forEach(function(b){b.render(a.ctx)});var d=this.mapWorldToScreen(this.extents.corner),e=this.mapWorldToScreen(this.extents.otherCorner);this.ctx.strokeStyle="rgba(255,255,255,0.4)",this.ctx.lineWidth=4,this.ctx.strokeRect(d.x,d.y,e.x-d.x,e.y-d.y);var f=this.mapWorldToScreen(this.extents.corner);this.backgroundEl.style.backgroundPosition=f.x+"px "+f.y+"px"},World.prototype.mapWorldToScreen=function(a){return new Vector2d((a.x-this.viewport.corner.x)/this.viewport.width*this.canvas.width,(a.y-this.viewport.corner.y)/this.viewport.height*this.canvas.height)},World.prototype.mapScreenToWorld=function(a){return new Vector2d(a.x/this.canvas.width*this.viewport.width+this.viewport.corner.x,a.y/this.canvas.height*this.viewport.height+this.viewport.corner.y)},World.prototype.mapScalarToScreen=function(a){return a/this.viewport.width*this.canvas.width},World.prototype.stepSimulation=function(a){var b=this;this.particleEmitters.forEach(function(b){b.tick(a)}),this.blobs.forEach(function(c){c.position=c.position.add(c.speed.scale(a/1e3*b.timeMultiplier)),(c.position.x-c.radius<b.extents.corner.x&&c.speed.x<0||c.position.x+c.radius>b.extents.corner.x+b.extents.width&&c.speed.x>0)&&(c.speed.x*=-1),(c.position.y-c.radius<b.extents.corner.y&&c.speed.y<0||c.position.y+c.radius>b.extents.corner.y+b.extents.height&&c.speed.y>0)&&(c.speed.y*=-1)});do for(var c=!1,d=0;d<this.blobs.length;d++)for(var e=0;e<this.blobs.length;e++)e!=d&&this.blobs[d].intersect(this.blobs[e])&&(c=!0);while(c);this.updateViewport()},World.prototype.updateViewport=function(){var a=this.getPlayerBlobs(),b=a.length?a[0]:!1;b&&(this.viewport.center=b.position)},window.addEventListener("load",function(){var a=document.querySelector("canvas");a.width=window.innerWidth,a.height=window.innerHeight,a.style.width=window.innerWidth+"px",a.style.height=window.innerHeight+"px";var b={game:new GameLoop({world:new World({canvas:a,extents:new Rectangle(new Vector2d(0,0),2e3,2e3),viewport:new Rectangle(new Vector2d(0,0),a.width,a.height),backgroundEl:document.documentElement})})};b.game.world.clear();for(var c=document.querySelectorAll("[data-action=startGame]"),d=document.querySelector("#startScreen"),e=document.querySelector("#replayScreen"),f=document.querySelector("#score"),g=0;g<c.length;g++)c[g].addEventListener("click",function(a){a.preventDefault(),b.game.running&&b.game.stop(),b.game.world.generate({count:160,radius:20,speed:80}),b.game.start(),f.style.display="block",d.style.display="none",e.style.display="none"},!1);b.game.world.on("playerDied",function(){b.game.stop(),e.style.display="block",f.style.display="none"}),b.game.world.on("absorbed",function(){var a=b.game.world.blobs.length-1;f.querySelector("span").textContent=a,0>=a&&(b.game.stop(),e.style.display="block",f.style.display="none")}),b.game.world.on("squirted",function(){f.querySelector("span").textContent=b.game.world.blobs.length-1}),this.Squirts=b},!1);