// Jean Luc Biellmann - contact@alsatux.com

"use strict";

Date.prototype.to_yyyymmdd = function () {
	var spacer = arguments.length ? arguments[0] : '';
	var day = _Fmt.two_digits(this.getDate());
	var month = _Fmt.two_digits(this.getMonth() + 1);
	return this.getFullYear() + spacer + month + spacer + day;
}

Date.prototype.to_yyyymmddhhiiss = function () {
	var yyyy = this.getFullYear();
	var mm = _Fmt.two_digits(this.getMonth() + 1);
	var dd = _Fmt.two_digits(this.getDate());
	var hh = _Fmt.two_digits(this.getHours());
	var ii = _Fmt.two_digits(this.getMinutes());
	var ss = _Fmt.two_digits(this.getSeconds());
	return yyyy + mm + dd + hh + ii + ss;
}

Date.prototype.to_locale = function () {
	var yyyy = this.getFullYear();
	var mm = _Fmt.two_digits(this.getMonth() + 1);
	var dd = _Fmt.two_digits(this.getDate());
	if (_TabSettings.date_pattern=='YYYY-MM-DD') {
		 return yyyy + '-' + mm + '-' + dd;
	}
	if (_TabSettings.date_pattern=='MM/DD/YYYY') {
		 return mm + '/' + dd + '/' + yyyy;
	}
	if (_TabSettings.date_pattern=='DD/MM/YYYY') {
		 return dd + '/' + mm + '/' + yyyy;
	}
}

var _DateString = {
	pattern: 'YYYY-MM-DD', // MUST always be YYYY-MM-DD on submit(), but can be other for addCar()
	to_epoc: function (datestring) {
		try {
			if (!_DateString.is_valid(datestring))
				return null;
			var d1,dd,dm,dy;
			if (_DateString.pattern=='YYYY-MM-DD') {
				d1 = datestring.match(/^(\d\d\d\d)-(\d\d)-(\d\d)$/);
				dy = _Fmt.to_uint(d1[1]);
				dm = _Fmt.to_uint(d1[2])-1;
				dd = _Fmt.to_uint(d1[3]);
			}
			if (_DateString.pattern=='MM/DD/YYYY') {
				d1 = datestring.match(/^(\d\d)\/(\d\d)\/(\d\d\d\d)$/);
				dy = _Fmt.to_uint(d1[3]);
				dm = _Fmt.to_uint(d1[1])-1;
				dd = _Fmt.to_uint(d1[2]);
			}
			if (_DateString.pattern=='DD/MM/YYYY') {
				d1 = datestring.match(/^(\d\d)\/(\d\d)\/(\d\d\d\d)$/);
				dy = _Fmt.to_uint(d1[3]);
				dm = _Fmt.to_uint(d1[2])-1;
				dd = _Fmt.to_uint(d1[1]);
			}
			return (new Date(dy,dm,dd));
		} catch (e) {
			throw '_DateString::to_epoc:' + e;
		}
	},
	is_valid: function (datestring) {
		var d1,d2,dd,dm,dy;
		try {
			if (_DateString.pattern=='YYYY-MM-DD') {
				d1 = datestring.match(/^(\d\d\d\d)-(\d\d)-(\d\d)$/);
				if (d1==null || d1.length!=4)
					return false;
				dy = _Fmt.to_uint(d1[1]);
				dm = _Fmt.to_uint(d1[2])-1;
				dd = _Fmt.to_uint(d1[3]);
			}
			if (_DateString.pattern=='MM/DD/YYYY') {
				d1 = datestring.match(/^(\d\d)\/(\d\d)\/(\d\d\d\d)$/);
				if (d1==null || d1.length!=4)
					return false;
				dy = _Fmt.to_uint(d1[3]);
				dm = _Fmt.to_uint(d1[1])-1;
				dd = _Fmt.to_uint(d1[2]);
			}
			if (_DateString.pattern=='DD/MM/YYYY') {
				d1 = datestring.match(/^(\d\d)\/(\d\d)\/(\d\d\d\d)$/);
				if (d1==null || d1.length!=4)
					return false;
				dy = _Fmt.to_uint(d1[3]);
				dm = _Fmt.to_uint(d1[2])-1;
				dd = _Fmt.to_uint(d1[1]);
			}
			d2 = new Date(dy,dm,dd);
			return (d2.getFullYear()==dy && d2.getMonth()==dm && d2.getDate()==dd);
		} catch (e) {
			throw '_DateString::is_valid:' + e;
		}
	}
};
