// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _Fmt = {
	two_digits: function (value) {
		var val = _Fmt.to_uint(value);
		return (val<10 ? '0' : '') + val;
	},
	to_int: function (value) {
		try {
			var v = String(value).replace(/[^0-9\-]+/g,'');
			v = parseInt(v,10);
			if (isNaN(v)) {
				throw tr('Bad integer') + ' !';
			}
			return v;
		} catch (e) {
			throw '_Fmt::to_int: ' + e;
		}
	},
	to_uint: function (value) {
		try {
			var v = String(value).replace(/[^0-9]+/g,'');
			v = Math.abs(_Fmt.to_int(v));
			if (isNaN(v)) {
				throw tr('Bad unsigned') + ' !';
			}
			return v;
		} catch (e) {
			throw '_Fmt::to_uint: ' + e;
		}
	},
	round: function (value, dec) {
		try {
			var v = String(value).replace(/,+/g,'.');
			v = v.replace(/[^0-9\.]+/g,'');
			v = Math.round((Math.pow(10,dec)*parseFloat(v)))/Math.pow(10,dec);
			if (isNaN(v)) {
				throw tr('Round failed') + ' !';
			}
			return v;
		} catch (e) {
			throw '_Fmt::round: ' + e;
		}
	}
};

