// Jean Luc Biellmann - contact@alsatux.com

"use strict";

function tr (txt) {
	var pos = _Lang.dict.indexOf(txt);
	return _Lang.dict[pos + _Lang.index];
}

var _Lang = {
	index: 0,
	current: 'English',
	available: ['English', 'Français'],
	dict: [
// fmt.js
'Bad integer','Format d\'entier erroné',
'Bad unsigned','Format d\'entier non signé erroné',
'Round failed','Arrondi erroné',
//global
'Missing or wrong datas !','Données vides ou erronnées !',
// car.ctrl.js
'Delete this car and all datas related ?','Effacer ce véhicule et toutes les données rattachées ?',
'Car purchase','Achat du véhicule',
'Fills','Pleins',
'Nb','Nb',
'Without last fill','Sans le dernier plein',
'Price / km','Prix / km',
'Total','Total',
'Bad car ignored: ','Données véhicules erronnées et ignorées : ',
'Bad fill record ignored: ','Enregistrement de type "plein" erronné et ignoré : ',
'Bad repair record ignored: ','Enregistrement de type "réparation" erronné et ignoré : ',
'Bad insurance record ignored: ','Enregistrement de type "assureur" erronné et ignoré : ',
'Bad photo ignored: ','Photo du véhicule erronnée et ignorée : ',
'Car added:','Véhicule ajouté',
'No car to add ?!','Aucun véhicule à ajouter ?!',
// lang.js
'Lang is now','Langue courante',
'Object','L\'objet',
'has no translation','n\'a pas été traduit',
// lock.js
'Pending action','Action en cours',
'Select a car please !','Sélectionnez un véhicule svp !',
'Select a fill please !','Sélectionnez un plein svp !',
'Select a repair please !','Sélectionnez une réparation svp !',
'Select a photo please !','Sélectionnez une photo svp !',
// local.js
'Reading backup from local session','Lecture de la sauvegarde depuis le cache local',
'No backup found','Aucune sauvegarde n\'a été trouvée',
'Records found','Engistrements trouvés',
// local.storage.js
'Local storage API not available','API de stockage local non disponible',
// main.js
'Error while uploading file','Erreur durant le chargement du fichier',
'Local storage available','Stockage local disponible',
'Please report any bug to','Veuillez signaler tout bug à',
'Storage allowed','Stockage autorisé',
'Searching for the last backup file','Recherche de la dernière sauvegarde',
'Storage not allowed','Stockage non autorisé',
'Warning: your browser doesn\'t support XML file creation on the fly ! Please use Mozilla Firefox !','Attention : votre navigateur ne supporte pas la création de fichier XML à la volée ! Merci d\'utiliser Mozilla Firefox !',
// mdl.car.js
'Photo width must be < 320px !','La largeur de la photo doit être < 320px !',
'Photo height must be < 240px !','La hauteur de la photo doit être < 240px !',
'Bad photo format','Le format de la photo est invalide',
'Missing car name','Vous devez donner un nom de voiture',
'Missing driver name','Vous devez donner un nom pour le/la conducteur(-trice) du véhicule',
'Missing purchase date','Vous devez donner la date d\'achat du véhicule',
'Missing purchase counter','Vous devez donner le kilométrage d\'achat du véhicule',
'Missing purchase price','Vous devez donner le prix d\'achat du véhicule',
// mdl.fill.js
'Missing fill date','Vous devez donner la date du plein',
'Missing fill counter','Vous devez donner le kilométrage du véhicule à la date du plein',
'Missing price per volume','Vous devez donner le prix par unité de volume à la date du plein',
'Missing fill price','Vous devez donner le prix du plein',
// mdl.insurance.js
'Missing insurance date','Vous devez donner la date du contrat d\'assurance',
'Missing insurance name','Vous devez donner le nom de l\'assureur',
'Missing insurance price','Vous devez donner le prix de l\'assurance',
// mdl.repair.js
'Missing repair date','Vous devez donner la date de la réparation',
'Missing repair garage','Vous devez donner le nom du garage de la réparation',
'Missing repair desc','Vous devez donner la description de la réparation',
'Missing repair price','Vous devez donner le prix de la réparation',
// sd.js
' files found',' fichiers disponibles',
'Last backup','Dernière sauvegarde',
'No backup found','Aucune sauvegarde n\'a été trouvée',
'File','Fichier',
'succesfully readed','lu avec succès',
'Unable to read the file','Impossible de lire le fichier',
'Unable to read the last backup','Impossible de lire la dernière sauvegarde',
'Records found','Engistrements trouvés',
// tab stats
'Repairs','Réparations',
'Counter','Compteur',
'Consumption','Consommation',
'Nb repairs','Nb réparations',
'Price','Prix',
'Insurances','Assurances',
'Nb records','Nb enregistrements',
'Total insurances','Total assurances',
'Year','Année',
'Details','Détails',
'Costs','Coûts',
'No car selected','Pas de véhicule sélectionné',
'Average','Moyenne',
// storage.js
'Storage API not available','API de stockage non disponible',
'Storage device','Périphérique de stockage',
'not found','introuvable',
'Unable to write the file','Impossible d\'écrire le fichier',
'The file','Le fichier',
'has been written','a été écrit',
'Unable to write','Impossible d\'écrire',
'Unable to read the directory','Impossible de lire le répertoire',
'Reading directory','Lecture du répertoire',
'Adding a file','Ajout d\'un fichier',
'Continue','Continu',
'Finished','Terminé',
'RegExp ok','RegExp ok',
'USB not unplugged','cordon USB non débranché',
// uploader.js
'Drag and drop your XML file on this button','Glissez/déposez votre fichier XML sur ce bouton',
// xml.js
'Parsing XML failed','L\'analyse XML a échoué',
'Reading settings failed','La lecture des préférences a échoué',
'Reading car failed','La lecture de la voiture a échoué',
'Recording settings failed','L\'enregistrement des préférences a échoué',
'Recording car failed','L\'enregistrement  d\'une voiture a échoué',
	],
	gui: [ // for index.html
// tab_log
'log_title','Log','Journal',
// tab_settings
'label_lang','Language ?','Langue ?',
'label_currency','Currency ?','Monnaie ?',
'label_distance','Distance unit ?','Unité de distance ?',
'label_volume','Volume unit ?','Unité de volume ?',
'settings_lang',['French','English'],['Français','Anglais'],
'label_date_pattern','Date format ?','Format des dates ?',
'label_comma','Comma format ?','Format virgule ?',
// tab_cars_list
'welcome','Welcome to StatsCars !','Bienvenue dans Statscar',
'welcome_resume','Cars manager with financial statistics.','Gestionnaire de voitures avec statistiques financières.',
'welcome_start','Press the + button to begin.','Utilisez le bouton + pour commencer.',
// tab_car_sel
'car_sel_selected','Car selected','Voiture sélectionnée',
'but_car_sel_gas_label','Gas','Pleins',
'but_car_sel_repair_label','Repair','Réparations',
'but_car_sel_insurance_label','Insurance','Assurance',
'but_car_sel_stats_label','Stats','Stats',
// tab_car_editor
'car_name','Name','Nom',
'car_driver','Driver','Conducteur',
'car_purchase_date','Purchase date','Date d\'achat',
'car_purchase_counter','Purchase counter','Compteur à l\'achat',
'car_purchase_price','Purchase price','Prix à l\'achat',
'title_car_editor','Car editor','Edition voiture',
// tab_car_list
'nb_of_cars_label','Cars available','Voitures disponibles',
// tab_fills_list
'title_fill_up','Fill up','Pleins',
'fills_list_col_date','Date','Date',
'fills_list_col_total','Total','Total',
'no_fills_list_warning','No fills yet for this car.','Il n\'y a pas encore eu de plein pour ce véhicule.',
// tab_fill_editor
'fill_date','Date','Date',
'fill_counter','Counter','Compteur',
'fill_price_per_vol','Price per volume','Prix par vol',
'fill_price','Price','Prix',
// tab_insurances_list
'title_insurance','Insurance','Asssurance',
'insurances_list_col_date','Date','Date',
'insurances_list_col_insurer','Insurer','Assureur',
'no_insurances_list_warning','No insurances yet for this car.','Il n\'y a pas encore d\'assurances pour ce véhicule.',
// tab_insurance_editor
'insurance_date','From','Du',
'insurance_name','Insurer','Assureur',
'insurance_price','Price','Prix',
// tab_repairs_list
'title_repair','Repair','Réparations',
'repairs_list_col_date','Date','Date',
'repairs_list_col_garage','Garage','Garage',
'repairs_list_col_desc','Description','Description',
'no_repairs_list_warning','No repairs yet for this car.','Il n\'y a pas encore de réparations pour ce véhicule.',
// tab_repair_editor
'repair_date','Date','Date',
'repair_garage','Garage','Garage',
'repair_desc','Description','Description',
'repair_price','Price','Prix',
// tab_photos_list
'title_car_photos','Car photos','Photos du véhicule',
'nb_of_photos_label','Photos available','Photos disponibles',
'no_photos_list_warning','No photos yet for this car.','Pas de photos pour ce véhicule.',
// tab_photo_editor
'but_photos_change_label','Change photo','Changer la photo',
// tab_stats
'title_stats','Stats','Stats',
	],
	reset: function () {
		_Lang.current = _Lang.available[_Lang.index];
		_Log.info(tr('Lang is now') + ' : ' + _Lang.current);
		// by id
		for (var i=0;i<_Lang.gui.length;i+=3) {
			var obj = _DOM.id(_Lang.gui[i]);
			if (obj==null) {
				alert(tr('Object') + ' "' + _Lang.gui[i] + '" has no translation' + ' !');
			} else {
				var value = _Lang.gui[i+1+_Lang.index];
				// object is a placeholder
				if (obj.hasAttribute('placeholder')) {
					obj.setAttribute('placeholder',value);
					continue;
				}
				// value is an array
				if (typeof value == 'object') {
					var v = String(value[0]).split(',');
					// obj is an ul
					var nodes = obj.querySelectorAll('li');
					if (nodes.length) {
						for (var j=0;j<v.length;j++)
							nodes[j].innerHTML = v[j];
						continue;
					}
					// obj is a span
					var nodes = obj.querySelectorAll('span');
					if (nodes.length) {
						for (var j=0;j<v.length;j++)
							nodes[j].innerHTML = v[j];
						continue;
					}
				}
				// value is a node
				obj.innerHTML = value;
			}
		}
		// by classname (dynamic labels)
		var nodes = obj.querySelectorAll('.settings_volume_unit');
		for (var i=0;i<nodes.length;i++)
			nodes[i].innerHTML = _TabSettings.volume;
		var nodes = obj.querySelectorAll('.settings_distance_unit');
		for (var i=0;i<nodes.length;i++)
			nodes[i].innerHTML = _TabSettings.distance;
		var nodes = obj.querySelectorAll('.settings_currency_unit');
		for (var i=0;i<nodes.length;i++)
			nodes[i].innerHTML = _TabSettings.currencies[_TabSettings.currency];
	}
};
