// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _LocalStorage = {
	debug: false,
	allowed: function () {
		return Storage!==undefined;
	},
	read: function () {
		if (!_LocalStorage.allowed()) {
			_Log.warn(tr('Local storage API not available') + '.');
			return null;
		}
		return localStorage.getItem('statscars');
	},
	write: function (xml_string) {
		if (!_LocalStorage.allowed()) {
			_Log.warn(tr('Local storage API not available') + '.');
			return null;
		}
		try {
			// backup last file
			var old_xml_string = localStorage.getItem('statscars');
			if (old_xml_string!=null)
				localStorage.setItem('statscars_bak', old_xml_string);
			// record the new one
			localStorage.setItem('statscars', xml_string);
		} catch (err) {
			alert(err.message);
		}
	}
};

