// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _Lock = {
	flag: false,
	on: function () {
		if (_Lock.flag==false) {
			_Lock.flag = true;
			return true;
		} else {
			alert(tr('Pending action') + '...');
			return false;
		}
	},
	off: function () {
		_Lock.flag = false;
	},
	action: function (e, f) {
		e.preventDefault();
		e.stopPropagation();
		if (_Lock.on()) {
			try {
				f.apply(f,[e]);
				_Lock.off();
			} catch (err) {
				alert(err);
				_Lock.off();
			}
		}
		return false;
	},
	action_need_car_selected: function (e, f) {
		e.preventDefault();
		e.stopPropagation();
		if (_Lock.on()) {
			try {
				if (_TabCar.selected!=null) {
					f.apply(f,[e]);
				} else {
					throw tr('Select a car please !');
				}
				_Lock.off();
			} catch (err) {
				alert(err);
				_Lock.off();
			}
		}
		return false;
	},
	action_need_fill_selected: function (e, f) {
		e.preventDefault();
		e.stopPropagation();
		if (_Lock.on()) {
			try {
				if (_TabCar.selected!=null) {
					f.apply(f,[e]);
				} else {
					throw tr('Select a fill please !');
				}
				_Lock.off();
			} catch (err) {
				alert(err);
				_Lock.off();
			}
		}
		return false;
	},
	action_need_repair_selected: function (e, f) {
		e.preventDefault();
		e.stopPropagation();
		if (_Lock.on()) {
			try {
				if (_TabCar.selected!=null) {
					f.apply(f,[e]);
				} else {
					throw tr('Select a repair please !');
				}
				_Lock.off();
			} catch (err) {
				alert(err);
				_Lock.off();
			}
		}
		return false;
	},
	action_need_photo_selected: function (e, f) {
		e.preventDefault();
		e.stopPropagation();
		if (_Lock.on()) {
			try {
				if (_TabCar.selected!=null) {
					f.apply(f,[e]);
				} else {
					throw tr('Select a photo please !');
				}
				_Lock.off();
			} catch (err) {
				alert(err);
				_Lock.off();
			}
		}
		return false;
	},
	action_with_spinner: function (e, f) {
		e.preventDefault();
		e.stopPropagation();
		if (_Lock.on()) {
			_TabSpinner.show();
			setTimeout(function () {
				try {
					f.apply(f,[e]);
					_Lock.off();
					_TabSpinner.hide();
				} catch (err) {
					alert(err);
					_Lock.off();
					_TabSpinner.hide();
				}
			}, 100);
		}
		return false;
	}
};

