// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _Log = {
	last_tab_id: null,
	init: function () {
		var nodeList = document.getElementsByClassName('but_log_open');
		for (var i=0;i<nodeList.length;i++) {
			nodeList[i].addEventListener('click', _Log.slot.open);
		}
		_DOM.listen('but_log_close', 'click', _Log.slot.close);
	},
	slot: {
		open: function (e) {
			_Log.last_tab_id = _Tabs.currrent_id;
			_Tabs.show('tab_log');
		},
		close: function (e) {
			_Tabs.show(_Log.last_tab_id);
		}
	},
	clear: function () {
		_DOM.id('log').innerHTML = '';
	},
	push: function (mess, className) {
		_DOM.id('log').innerHTML = '<p' + (className.length ? ' class="' + className + '"' : '') + '>' + mess + '</p>' + _DOM.id('log').innerHTML;
		//console.log(mess);
	},
	info: function (mess) {
		_Log.push(mess, 'info');
	},
	warn: function (mess) {
		_Log.push(mess, 'warn');
	},
	error: function (mess) {
		_Log.push(mess, 'error');
		alert(mess);
	}
};
