// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var version = 'v0.4';
var DEFAULT_CAR = 'img/default.png';

var _Main = {
	reset: function () {
		_TabCar.reset();
		_TabFill.reset();
		_TabInsurance.reset();
		_TabRepair.reset();
		_TabPhoto.reset();
	}
};

window.onload = function () {
	_TabSettings.chg_lang('English');
	_TabSettings.chg_currency('euro');
	_TabSettings.chg_distance('km');
	_TabSettings.chg_volume('l');
	_TabSettings.chg_date_pattern('YYYY-MM-DD');
	_TabSettings.chg_comma('.');
	// init all
	_Tabs.init();
	_Log.init();
	_TabCar.init();
	_TabFill.init();
	_TabInsurance.init();
	_TabRepair.init();
	_TabPhoto.init();
	_TabSettings.init();
	_TabSpinner.show();
	// Get last backup
	if (_SDStorage.allowed()) {
		// FFOS device
		_DOM.hide('main_import');
		_DOM.hide('main_export');
		_Log.info(tr('Storage allowed') + '...' + tr('Searching for the last backup file') + '...');
		_SD.recall_last_backup();
	} else {
		if (_LocalStorage.allowed()) {
			// Web navigator
			_Log.info(tr('Local storage available') + '...');
			_Local.recall_last_backup();
			// add uploader
			var _Uploader1 = new Uploader();
			_Uploader1.init('main_import', function (file) {
				var reader = new FileReader();
				reader.onload = function (e) {
					try {
						var parser = new DOMParser();
						// sanitize XML using two ways...
						var xml_doc = parser.parseFromString(e.target.result, "text/xml");
						xml_doc.normalize();
						var xml_string = (new XMLSerializer()).serializeToString(xml_doc);
						_Main.reset();
						_XML.read(xml_string);
						_TabCar.list();
					} catch (err) {
						alert(err.message);
					}
				}
				reader.onerror = function (e) {
					alert(tr('Error while uploading file') + ' !');
				}
				reader.readAsText(file, "UTF-8");
			});
		} else {
			alert(tr('Storage not allowed') + ' !');
			_TabSpinner.hide();
		}
	}
	if (_TabCar.db.length==1) {
		// most users have only one car so we select it directly
		_TabCar.selector(0);
	} else {
		_TabCar.list();
	}
}
