// Jean Luc Biellmann - contact@alsatux.com

"use strict";

function MdlCar () {
	this.row = {
		'name': '', // mandatory
		'driver': '', // mandatory
		'purchase': {
			'date': '', // timestamp
			'counter': 0., // float
			'price': 0. // float
		}
	};
	this.photo = []; // array of urldata
	this.fill = []; // array of MdlFill
	this.repair = []; // array of MdlRepair
	this.insurance = []; // array of MdlInsurance
	return this;
}

MdlCar.prototype = {
	upd_row: function (row) {
		try {
			row.name = String(row.name).trim().substr(0,50);
			if (!row.name.length) {
				throw tr('Missing car name') + ' !';
			}
			row.driver = String(row.driver).trim().substr(0,50);
			if (!row.driver.length) {
				throw tr('Missing driver name') + ' !';
			}
			row.purchase.date = _DateString.to_epoc(String(row.purchase.date).trim().substr(0,10));
			if (!row.purchase.date==null) {
				throw tr('Missing purchase date') + ' !';
			}
			row.purchase.counter = _Fmt.round(String(row.purchase.counter).trim().substr(0,7),2);
			if (row.purchase.counter<=0) {
				throw tr('Missing purchase counter') + ' !';
			}
			row.purchase.price = _Fmt.round(String(row.purchase.price).trim().substr(0,7),2);
			if (row.purchase.price<=0) {
				throw tr('Missing purchase price') + ' !';
			}
			this.row = row;
			return this;
		} catch (e) {
			throw 'MdlCar::updrow(): ' + e;
		}
	},
	to_html_list: function () {
		var photo = DEFAULT_CAR;
		if (this.photo.length)
			photo = this.photo[0];
		return '<div class="row"><p><img class="pict" src="' + photo + '" />' + '</p>' + this.to_html_editor() + '</div>';
	},
	to_html_editor: function () {
		return '<p>' + this.row.name.escape_html() + '&nbsp;/ ' + this.row.driver.escape_html() + '&nbsp;/ ' + this.row.purchase.date.to_locale() + '</p>';
	},
	to_string: function () {
		return 'Name: ' + this.row.name.escape_html() + '<br/>' + 'Driver: ' + this.row.driver.escape_html() + '<br/>' + 'Purchase date: ' + this.row.purchase.date.to_locale() + '<br/>' + 'Purchase counter: ' + String(this.row.purchase.counter).to_comma() + '<br/>' + 'Purchase price: ' + String(this.row.purchase.price).to_comma() + '<br/>';
	},
	// photos
	chk_photo: function (dataurl) {
		var m = dataurl.match(/^(data:image\/jpe?g;base64,([0-9a-zA-Z+\/]{4})*(([0-9a-zA-Z+\/]{2}==)|([0-9a-zA-Z+\/]{3}=))?)$/);
		if (m==null)
			throw tr('Bad photo format');
		var img = document.createElement('img');
		img.src = dataurl;
		if (img.width>320)
			throw tr('Photo width must be < 320px !');
		if (img.height>240)
			throw tr('Photo height must be < 240px !');
	},
	add_photo: function (dataurl) {
		try {
			this.chk_photo(dataurl);
			this.photo.push( dataurl );
			return this;
		} catch (e) {
			throw e;
		}
	},
	upd_photo: function (i, dataurl) {
		try {
			this.chk_photo(dataurl);
			this.photo[i] = dataurl;
			return this;
		} catch (e) {
			throw e;
		}
	},
	del_photo: function (i) {
		this.photo.splice(i,1);
		return this;
	},
	add_fill: function (row) {
		this.fill.push((new MdlFill()).upd_row(row));
		return this;
	},
	upd_fill: function (i,row) {
		this.fill[i].upd_row(row);
		return this;
	},
	del_fill: function (i) {
		this.fill.splice(i,1);
		return this;
	},
	add_repair: function (row) {
		this.repair.push((new MdlRepair()).upd_row(row));
		return this;
	},
	upd_repair: function (i,row) {
		this.repair[i].upd_row(row);
		return this;
	},
	del_repair: function (i) {
		this.repair.splice(i,1);
		return this;
	},
	add_insurance: function (row) {
		this.insurance.push((new MdlInsurance()).upd_row(row));
		return this;
	},
	upd_insurance: function (i,row) {
		this.insurance[i].upd_row(row);
		return this;
	},
	del_insurance: function (i) {
		this.insurance.splice(i,1);
		return this;
	}
}
