// Jean Luc Biellmann - contact@alsatux.com

"use strict";

function MdlFill () {
	this.row = {
		'date': '', // timestamp
		'counter': 0, // uint
		'price_per_vol': 0, // float
		'price': 0 // float
	};
	return this;
}

MdlFill.prototype = {
	upd_row: function (row) {
		try {
			row.date = _DateString.to_epoc(String(row.date).trim().substr(0,10));
			if (row.date==null) {
				throw tr('Missing fill date') + ' !';
			}
			row.counter = _Fmt.round(String(row.counter).trim().substr(0,8),2);
			if (row.counter<=0) {
				throw tr('Missing fill counter') + ' !';
			}
			if ('price_per_litre' in row) {
				// patch v0.3 -> v0.4
				row.price_per_vol = row.price_per_litre;
				delete row.price_per_litre;
			}
			row.price_per_vol = _Fmt.round(String(row.price_per_vol).trim().substr(0,8),2);
			if (row.price_per_vol<=0) {
				throw tr('Missing price per volume') + ' !';
			}
			row.price = _Fmt.round(String(row.price).trim().substr(0,8),2);
			if (row.price<=0) {
				throw tr('Missing fill price') + ' !';
			}
			this.row = row;
			return this;
		} catch (e) {
			throw 'MdlFill::upd_row(): ' + e;
		}
	},
	to_HTML: function () {
		var html = '';
			var vol=0.;
			var td = '';
			td += '<td>' + this.row.date.to_locale() + '</td>';
			td += '<td>' + String(this.row.counter).to_comma() + '</td>';
			if (this.row.price>0. && this.row.price_per_vol>0.) {
				vol = _Fmt.round(this.row.price/this.row.price_per_vol,2);
			} else {
				vol = '-';
			}
			td += '<td>' + String(vol).to_comma() + '</td>';
			td += '<td>' + String(this.row.price_per_vol).to_comma() + '</td>';
			td += '<td>' + String(this.row.price).to_comma() + '</td>';
			return '<tr>' + td + '</tr>';
	}
}
