// Jean Luc Biellmann - contact@alsatux.com

"use strict";

function MdlInsurance () {
	this.row = {
		'date': '', // timestamp
		'name': '', // insurer name
		'price': 0 // float
	};
	return this;
}

MdlInsurance.prototype = {
	upd_row: function (row) {
		try {
			row.date = _DateString.to_epoc(String(row.date).trim().substr(0,10));
			if (row.date==null) {
				throw tr('Missing insurance date') + ' !';
			}
			row.name = String(row.name).trim().substr(0,1000);
			if (row.name.length==0) {
				throw tr('Missing insurance name') + ' !';
			}
			row.price = _Fmt.round(String(row.price).trim().substr(0,8),2);
			if (row.price<=0) {
				throw tr('Missing insurance price') + ' !';
			}
			this.row = row;
			return this;
		} catch (e) {
			throw 'MdlInsurance::upd_row(): ' + e;
		}
	},
	to_HTML: function () {
		var td = '';
		td += '<td>' + this.row.date.to_locale() + '</td>';
		td += '<td>' + String(this.row.name).escape_html() + '</td>';
		td += '<td>' + String(this.row.price).to_comma() + '</td>';
		return '<tr>' + td + '</tr>';
	}
}
