// Jean Luc Biellmann - contact@alsatux.com

"use strict";

function MdlRepair () {
	this.row = {
		'date': '', // timestamp
		'garage': 0, // garage
		'desc': '', // description
		'price': 0. // float
	};
	return this;
}

MdlRepair.prototype = {
	upd_row: function (row) {
		try {
			row.date = _DateString.to_epoc(String(row.date).trim().substr(0,10));
			if (row.date==null) {
				throw tr('Missing repair date') + ' !';
			}
			row.garage = String(row.garage).trim().substr(0,100);
			if (row.garage.length==0) {
				throw tr('Missing repair garage') + ' !';
			}
			row.desc = String(row.desc).trim().substr(0,1000);
			if (row.desc.length==0) {
				throw tr('Missing repair desc') + ' !';
			}
			row.price = _Fmt.round(String(row.price).trim().substr(0,8),2);
			if (row.price<=0) {
				throw tr('Missing repair price') + ' !';
			}
			this.row = row;
			return this;
		} catch (e) {
			throw 'MdlRepair::upd_row(): ' + e;
		}
	},
	to_HTML: function () {
		var html = '';
		var td = '';
		td += '<td>' + this.row.date.to_locale() + '<br/>' + String(this.row.garage).escape_html() + '</td>';
		td += '<td class="left">' + String(this.row.desc).escape_html() + '</td>';
		td += '<td>' + String(this.row.price).to_comma() + '</td>';
		return '<tr>' + td + '</tr>';
	}
}
