// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabCar = {
	db: [],
	selected: null,
	photo: [], // array of dataurl
	init: function () {
		// list of cars
		_DOM.listen('but_car_list_add', 'click', _TabCar.slot.add);
		_DOM.listen('cars_rows', 'click', _TabCar.slot.sel);
		// car selected
		_DOM.listen('but_car_sel_back', 'click', _TabCar.slot.ls);
		_DOM.listen('but_car_sel_edit', 'click', _TabCar.slot.edit);
		_DOM.listen('but_car_sel_del', 'click', _TabCar.slot.del);
		_DOM.listen('but_car_sel_fill', 'click', _TabCar.slot.fill);
		_DOM.listen('but_car_sel_repair', 'click', _TabCar.slot.repair);
		_DOM.listen('but_car_sel_insurance', 'click', _TabCar.slot.insurance);
		_DOM.listen('but_car_sel_stats', 'click', _TabStats.slot.stats);
		// car editor
		_DOM.listen('but_car_edit_rec', 'click', _TabCar.slot.submit);
		_DOM.listen('but_car_edit_back', 'click', _TabCar.slot.sel_back);
		// car photos
		_DOM.listen('but_car_sel_photos', 'click', _TabPhoto.slot.ls);
		// stats
		_DOM.listen('but_car_stats_back', 'click', _TabCar.slot.sel_back);
		// export
		_DOM.listen('main_export', 'click', _TabCar.slot.click_export);
	},
	reset: function() {
		_TabCar.db = [];
		_TabCar.selected = null;
		_TabCar.photo = [];
	},
	slot: {
		add: function (e) {
			return _Lock.action(e, function (e) {
				_TabCar.editor(null);
			});
		},
		fill: function (e) {
			return _Lock.action_need_car_selected(e, function (e) {
				_TabFill.list();
			});
		},
		repair: function (e) {
			return _Lock.action_need_car_selected(e, function (e) {
				_TabRepair.list();
			});
		},
		insurance: function (e) {
			return _Lock.action_need_car_selected(e, function (e) {
				_TabInsurance.list();
			});
		},
		edit: function (e) {
			return _Lock.action_need_car_selected(e, function (e) {
				_TabCar.editor(_TabCar.selected);
			});
		},
		sel: function (e) {
			return _Lock.action(e, function (e) {
				var el = e.target;
				while (el!=null && !el.classList.contains('row'))
					el = el.parentNode;
				if (el!=null && el.parentNode!=null) {
					var childs = el.parentNode.childNodes;
					for (var i=0;i<childs.length;i++) {
						if (childs[i]==el) {
							_TabCar.selector(i);
						}
					}
				}
			});
		},
		sel_back: function (e) {
			return _Lock.action(e, function (e) {
				if (_TabCar.selected!=null) {
					_TabCar.selector(_TabCar.selected);
				} else {
					_TabCar.list();
				}
			});
		},
		ls: function (e) {
			return _Lock.action(e, function (e) {
				_TabCar.list();
			});
		},
		del: function (e) {
			return _Lock.action_need_car_selected(e, function (e) {
				if (confirm(tr('Delete this car and all datas related ?'))) {
					_TabCar.db.splice(_TabCar.selected,1);
					_TabCar.save();
					_TabCar.list();
				}
			});
		},
		submit: function (e) {
			return _Lock.action_with_spinner(e, function (e) {
				var row = {
					'name': _DOM.id('car_name').value,
					'driver': _DOM.id('car_driver').value,
					'purchase': {
						'date': _DOM.id('car_purchase_date').value,
						'counter': _DOM.id('car_purchase_counter').value,
						'price': _DOM.id('car_purchase_price').value,
					}
				};
				try {
					_DateString.pattern = 'YYYY-MM-DD';
					if (_TabCar.selected!=null) {
						_TabCar.db[_TabCar.selected].upd_row(row);
					} else {
						_TabCar.db.push((new MdlCar()).upd_row(row));
						_TabCar.selected = _TabCar.db.length-1;
					}
					_TabCar.save();
					_TabCar.selector(_TabCar.selected);
				} catch (e) {
					alert(e);
				}
			});
		},
		click_export: function (e) {
			return _Lock.action(e, function (e) {
				_TabCar.export();
			});
		}
	},
	list: function () {
		_Tabs.show('tab_cars_list');
		_TabCar.selected = null;
		_DOM.id('nb_of_cars').innerHTML = _TabCar.db.length;
		if (!_TabCar.db.length) {
			_DOM.show('no_cars_list');
			_DOM.hide('cars_list');
		} else {
			var html = '';
			for (var i=0;i<_TabCar.db.length;i++) {
				html += _TabCar.db[i].to_html_list();
			}
			_DOM.id('cars_rows').innerHTML = html;
			_DOM.hide('no_cars_list');
			_DOM.show('cars_list');
		}
	},
	editor: function (i) {
		_Tabs.show('tab_car_editor');
		_TabCar.selected = i;
		if (i!=null) {
			var row = _TabCar.db[i].row;
			_DOM.id('car_name').value = String(row.name);
			_DOM.id('car_driver').value = String(row.driver);
			_DOM.id('car_purchase_date').value = row.purchase.date.to_yyyymmdd('-');
			_DOM.id('car_purchase_counter').value = String(row.purchase.counter).to_comma();
			_DOM.id('car_purchase_price').value = String(row.purchase.price).to_comma();
		} else {
			_DOM.id('car_name').value = '';
			_DOM.id('car_driver').value =  '';
			_DOM.id('car_purchase_date').value = (new Date()).to_yyyymmdd('-');
			_DOM.id('car_purchase_counter').value = '';
			_DOM.id('car_purchase_price').value = '';
		}
	},
	selector: function (i) {
		_TabCar.selected = i;
		var car = _TabCar.db[i];
		_Tabs.show('tab_car_sel');
		var photo = DEFAULT_CAR;
		if (car.photo.length)
			photo = car.photo[0];
		_DOM.id('car_sel_photo_src').src = photo;
		_DOM.id('car_sel_text').innerHTML = _TabCar.db[i].to_html_editor();
	},
	addCar: function (obj) {
		try {
			_DateString.pattern = _TabSettings.date_pattern;
			if ('row' in obj) {
				var car = (new MdlCar()).upd_row(obj.row);
				_TabCar.db.push(car); // before fill/repair/insurance/photo
				_TabCar.selected = _TabCar.db.length-1;
				if ('fill' in obj) {
					for (var j=0;j<obj.fill.length;j++) {
						try {
							car.add_fill(obj.fill[j].row);
						} catch (e) {
							_Log.error(tr('Bad fill record ignored: ') + e);
						}
					}
				}
				if ('repair' in obj) {
					for (var j=0;j<obj.repair.length;j++) {
						try {
							car.add_repair(obj.repair[j].row);
						} catch (e) {
							_Log.error(tr('Bad repair record ignored: ') + e);
						}
					}
				}
				if ('insurance' in obj) {
					for (var j=0;j<obj.insurance.length;j++) {
						try {
							car.add_insurance(obj.insurance[j].row);
						} catch (e) {
							_Log.error(tr('Bad insurance record ignored: ') + e);
						}
					}
				}
				if ('photo' in obj) {
					for (var j=0;j<obj.photo.length;j++) {
						try {
							car.add_photo(obj.photo[j]);
						} catch (e) {
							_Log.error(tr('Bad photo ignored: ') + e);
						}
					}
				}
				_Log.info(tr('Car added:') + '<br/>' + car.to_string());
			} else {
				_Log.warn(tr('No car to add ?!'));
			}
		} catch(e) {
			_Log.error(tr('Bad car ignored: ') + e);
		}
	},
	save: function () {
		var filename = 'statscars/' + (new Date()).to_yyyymmddhhiiss() + '.xml';
		var xml_string = _XML.write();
		if (_SDStorage.allowed()) {
			// FFOS device
			_SDStorage.write('sdcard', filename, xml_string, 'text/plain');
		} else {
			// Web browser
			if (_LocalStorage.allowed())
				_LocalStorage.write(xml_string);
		}
	},
	export: function () {
		var xml_string = _XML.write();
		if (!window.URL || !window.URL.createObjectURL)
			return alert(tr('Warning: your browser doesn\'t support XML file creation on the fly ! Please use Mozilla Firefox !'));
		var blob = new Blob([xml_string], {type:'text/plain;charset=utf-8'});
		var a = document.createElementNS("http://www.w3.org/1999/xhtml", "a");
		a.href = window.URL.createObjectURL(blob);
		a.download = (new Date()).to_yyyymmddhhiiss() + '.xml';
		var event = document.createEvent("MouseEvents");
		event.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
		a.dispatchEvent(event);
	}
};
