// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabFill = {
	selected: null,
	init: function () {
		_DOM.listen('but_fills_add', 'click', _TabFill.slot.add);
		_DOM.listen('but_fills_return', 'click', _TabCar.slot.sel_back);
		_DOM.listen('but_fills_del', 'click', _TabFill.slot.del);
		_DOM.listen('but_fills_rec', 'click', _TabFill.slot.submit);
		_DOM.listen('but_fills_back', 'click', _TabFill.slot.ls);
		_DOM.listen('fills_list', 'click', _TabFill.slot.sel);
	},
	reset: function() {
		_TabFill.selected = null;
	},
	slot: {
		add: function (e) {
			return _Lock.action(e, function (e) {
				_TabFill.editor(null);
			});
		},
		edit: function (e) {
			return _Lock.action_need_fill_selected(e, function (e) {
				_TabFill.editor(_TabFill.selected);
			});
		},
		sel: function (e) {
			return _Lock.action(e, function (e) {
				var el = e.target;
				while (el!=null && el.nodeName!='TR')
					el = el.parentNode;
				if (el!=null && el.parentNode!=null) {
					var childs = el.parentNode.childNodes;
					for (var i=0;i<childs.length;i++) {
						if (childs[i]==el) {
							_TabFill.editor(i);
							break;
						}
					}
				}
			});
		},
		del: function (e) {
			return _Lock.action_need_fill_selected(e, function (e) {
				if (confirm('Delete this record ?')) {
					_TabCar.db[_TabCar.selected].del_fill(_TabFill.selected);
					_TabCar.save();
					_TabFill.list();
				}
			});
		},
		submit: function (e) {
			return _Lock.action_with_spinner(e, function (e) {
				var row = {
					'date': _DOM.id('fill_date').value,
					'counter': _DOM.id('fill_counter').value,
					'price_per_vol': _DOM.id('fill_price_per_vol').value,
					'price': _DOM.id('fill_price').value
				};
				try {
					_DateString.pattern = 'YYYY-MM-DD';
					if (_TabFill.selected!=null) {
						_TabCar.db[_TabCar.selected].upd_fill(_TabFill.selected,row);
					} else {
						_TabCar.db[_TabCar.selected].add_fill(row);
					}
					_TabCar.save();
					_TabFill.list();
				} catch(e) {
					_Log.error(e);
				}
			});
		},
		ls: function (e) {
			return _Lock.action(e, function (e) {
				_TabFill.list();
			});
		}
	},
	list: function () {
		_Tabs.show('tab_fills_list');
		_TabFill.selected = null;
		var rows = _TabCar.db[_TabCar.selected].fill;
		if (!rows.length) {
			_DOM.hide('fills_list');
			_DOM.show('no_fills_list');
		} else {
			rows.sort(function (a,b) {
				return b.row.date-a.row.date;
			});
			var html = '';
			for (var i=0;i<rows.length;i++) {
				html += rows[i].to_HTML();
			}
			_DOM.id('fills_rows').innerHTML = html;
			_DOM.hide('no_fills_list');
			_DOM.show('fills_list');
		}
	},
	editor: function (i) {
		_Tabs.show('tab_fill_editor');
		_TabFill.selected = i;
		if (i!=null) {
			var row = _TabCar.db[_TabCar.selected].fill[i].row;
			_DOM.id('fill_date').value = row.date.to_yyyymmdd('-');
			_DOM.id('fill_counter').value = String(row.counter).to_comma();
			_DOM.id('fill_price_per_vol').value = String(row.price_per_vol).to_comma();
			_DOM.id('fill_price').value = String(row.price).to_comma();
		} else {
			_DOM.id('fill_date').value = (new Date()).to_yyyymmdd('-');
			_DOM.id('fill_counter').value = '';
			_DOM.id('fill_price_per_vol').value = '';
			_DOM.id('fill_price').value = '';
		}
	}
};
