// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabInsurance = {
	selected: null,
	init: function () {
		_DOM.listen('but_insurances_add', 'click', _TabInsurance.slot.add);
		_DOM.listen('but_insurances_return', 'click', _TabCar.slot.sel_back);
		_DOM.listen('but_insurances_del', 'click', _TabInsurance.slot.del);
		_DOM.listen('but_insurances_rec', 'click', _TabInsurance.slot.submit);
		_DOM.listen('but_insurances_back', 'click', _TabInsurance.slot.ls);
		_DOM.listen('insurances_list', 'click', _TabInsurance.slot.sel);
	},
	reset: function() {
		_TabInsurance.selected = null;
	},
	slot: {
		add: function (e) {
			return _Lock.action(e, function (e) {
				_TabInsurance.editor(null);
			});
		},
		edit: function (e) {
			return _Lock.action_need_insurance_selected(e, function (e) {
				_TabInsurance.editor(_TabInsurance.selected);
			});
		},
		sel: function (e) {
			return _Lock.action(e, function (e) {
				var el = e.target;
				while (el!=null && el.nodeName!='TR')
					el = el.parentNode;
				if (el!=null && el.parentNode!=null) {
					var childs = el.parentNode.childNodes;
					for (var i=0;i<childs.length;i++) {
						if (childs[i]==el) {
							_TabInsurance.editor(i);
							break;
						}
					}
				}
			});
		},
		del: function (e) {
			return _Lock.action_need_insurance_selected(e, function (e) {
				if (confirm('Delete this record ?')) {
					_TabCar.db[_TabCar.selected].del_insurance(_TabInsurance.selected);
					_TabCar.save();
					_TabInsurance.list();
				}
			});
		},
		submit: function (e) {
			return _Lock.action_with_spinner(e, function (e) {
				var row = {
					'date': _DOM.id('insurance_date').value,
					'name': _DOM.id('insurance_name').value,
					'price': _DOM.id('insurance_price').value
				};
				try {
					_DateString.pattern = 'YYYY-MM-DD';
					if (_TabInsurance.selected!=null) {
						_TabCar.db[_TabCar.selected].upd_insurance(_TabInsurance.selected, row);
					} else {
						_TabCar.db[_TabCar.selected].add_insurance(row);
					}
					_TabCar.save();
					_TabInsurance.list();
				} catch(e) {
					_Log.error(e);
				}
			});
		},
		ls: function (e) {
			return _Lock.action(e, function (e) {
				_TabInsurance.list();
			});
		}
	},
	list: function () {
		_Tabs.show('tab_insurances_list');
		_TabInsurance.selected = null;
		var rows = _TabCar.db[_TabCar.selected].insurance;
		if (!rows.length) {
			_DOM.hide('insurances_list');
			_DOM.show('no_insurances_list');
		} else {
			var html = '';
			for (var i=0;i<rows.length;i++) {
				html += rows[i].to_HTML();
			}
			_DOM.id('insurances_rows').innerHTML = html;
			_DOM.hide('no_insurances_list');
			_DOM.show('insurances_list');
		}
	},
	editor: function (i) {
		_Tabs.show('tab_insurance_editor');
		_TabInsurance.selected = i;
		if (i!=null) {
			var row = _TabCar.db[_TabCar.selected].insurance[i].row;
			_DOM.id('insurance_date').value = row.date.to_yyyymmdd('-');
			_DOM.id('insurance_name').value = String(row.name);
			_DOM.id('insurance_price').value = String(row.price).to_comma();
		} else {
			_DOM.id('insurance_date').value = (new Date()).to_yyyymmdd('-');
			_DOM.id('insurance_name').value = '';
			_DOM.id('insurance_price').value = '';
		}
	}
};
