// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabPhoto = {
	selected: null,
	dataurl: null,
	init: function () {
		_DOM.listen('but_photos_add', 'click', _TabPhoto.slot.add);
		_DOM.listen('but_photos_return', 'click', _TabCar.slot.sel_back);
		_DOM.listen('but_photos_del', 'click', _TabPhoto.slot.del);
		_DOM.listen('but_photos_rec', 'click', _TabPhoto.slot.submit);
		_DOM.listen('but_photos_back', 'click', _TabPhoto.slot.ls);
		_DOM.listen('but_photos_change', 'click', _TabPhoto.slot.change);
		_DOM.listen('photos_list', 'click', _TabPhoto.slot.sel);
	},
	reset: function() {
		_TabPhoto.selected = null;
		_TabPhoto.dataurl = null;
	},
	slot: {
		add: function (e) {
			return _Lock.action(e, function (e) {
				_TabPhoto.editor(null);
			});
		},
		edit: function (e) {
			return _Lock.action_need_photo_selected(e, function (e) {
				_TabPhoto.editor(_TabPhoto.selected);
			});
		},
		sel: function (e) {
			return _Lock.action(e, function (e) {
				var el = e.target;
				while (el!=null && !el.classList.contains('row'))
					el = el.parentNode;
				if (el!=null && el.parentNode!=null) {
					var childs = el.parentNode.childNodes;
					for (var i=0;i<childs.length;i++) {
						if (childs[i]==el) {
							_TabPhoto.editor(i);
							break;
						}
					}
				}
			});
		},
		del: function (e) {
			return _Lock.action_need_photo_selected(e, function (e) {
				if (confirm('Delete this record ?')) {
					_TabCar.db[_TabCar.selected].del_photo(_TabPhoto.selected);
					_TabCar.save();
					_TabPhoto.list();
				}
			});
		},
		change: function (e) {
			return _Lock.action(e, function (e) {
				_TabPhoto.dataurl = null;
				var pick = new MozActivity({
					name: 'pick',
					data: {
						type: ['image/jpg', 'image/jpeg']
					}
				});
				pick.onsuccess = function () {
					var img = new Image();
					img.src = window.URL.createObjectURL(this.result.blob);
					img.onload = function() {
						var MAX_WIDTH = 320;
						var MAX_HEIGHT = 240;
						var width = img.width;
						var height = img.height;
						if (width > MAX_WIDTH) {
							height *= MAX_WIDTH / width;
							width = MAX_WIDTH;
						}
						if (height > MAX_HEIGHT) {
							width *= MAX_HEIGHT / height;
							height = MAX_HEIGHT;
						}
						var canvas = document.createElement('canvas');
						canvas.width = width;
						canvas.height = height;
						var ctx = canvas.getContext('2d');
						ctx.drawImage(this, 0, 0, width, height);
						_TabPhoto.dataurl = canvas.toDataURL('image/jpeg');
						_DOM.id('photo_car_edit').src = _TabPhoto.dataurl;
					}
				};
				pick.onerror = function () {
				};
			});
		},
		submit: function (e) {
			return _Lock.action(e, function (e) {
				try {
					if (_TabPhoto.dataurl!=null) { // true is user cancel activity
						if (_TabPhoto.selected!=null) {
							_TabCar.db[_TabCar.selected].upd_photo(_TabPhoto.selected, _TabPhoto.dataurl);
						} else {
							_TabCar.db[_TabCar.selected].add_photo(_TabPhoto.dataurl);
						}
						_TabCar.save();
					}
					_TabPhoto.list();
				} catch (e) {
					_Log.error(e);
				}
			});
		},
		ls: function (e) {
			return _Lock.action(e, function (e) {
				_TabPhoto.list();
			});
		}
	},
	list: function () {
		_Tabs.show('tab_photos_list');
		_TabPhoto.selected = null;
		_TabPhoto.dataurl = null;
		var dataurls = _TabCar.db[_TabCar.selected].photo;
		_DOM.id('nb_of_photos').innerHTML = dataurls.length;
		if (!dataurls.length) {
			_DOM.hide('photos_list');
			_DOM.show('no_photos_list');
		} else {
			var html = '';
			for (var i=0;i<dataurls.length;i++) {
				html += '<div class="row"><img class="pict s160x120" src="' + dataurls[i] + '"/></div>';
			}
			_DOM.id('photos_rows').innerHTML = html;
			_DOM.hide('no_photos_list');
			_DOM.show('photos_list');
		}
	},
	editor: function (i) {
		_Tabs.show('tab_photo_editor');
		_TabPhoto.selected = i;
		if (i!=null) {
			_TabPhoto.dataurl = _TabCar.db[_TabCar.selected].photo[i];
			_DOM.id('photo_car_edit').src = _TabPhoto.dataurl;
		} else {
			_TabPhoto.dataurl = null;
			_DOM.id('photo_car_edit').src = DEFAULT_CAR;
		}
	}
};
