// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabRepair = {
	selected: null,
	init: function () {
		_DOM.listen('but_repairs_add', 'click', _TabRepair.slot.add);
		_DOM.listen('but_repairs_return', 'click', _TabCar.slot.sel_back);
		_DOM.listen('but_repairs_del', 'click', _TabRepair.slot.del);
		_DOM.listen('but_repairs_rec', 'click', _TabRepair.slot.submit);
		_DOM.listen('but_repairs_back', 'click', _TabRepair.slot.ls);
		_DOM.listen('repairs_list', 'click', _TabRepair.slot.sel);
	},
	reset: function() {
		_TabRepair.selected = null;
	},
	slot: {
		add: function (e) {
			return _Lock.action(e, function (e) {
				_TabRepair.editor(null);
			});
		},
		edit: function (e) {
			return _Lock.action_need_repair_selected(e, function (e) {
				_TabRepair.editor(_TabRepair.selected);
			});
		},
		sel: function (e) {
			return _Lock.action(e, function (e) {
				var el = e.target;
				while (el!=null && el.nodeName!='TR')
					el = el.parentNode;
				if (el!=null && el.parentNode!=null) {
					var childs = el.parentNode.childNodes;
					for (var i=0;i<childs.length;i++) {
						if (childs[i]==el) {
							_TabRepair.editor(i);
							break;
						}
					}
				}
			});
		},
		del: function (e) {
			return _Lock.action_need_repair_selected(e, function (e) {
				if (confirm('Delete this record ?')) {
					_TabCar.db[_TabCar.selected].del_repair(_TabRepair.selected);
					_TabCar.save();
					_TabRepair.list();
				}
			});
		},
		submit: function (e) {
			return _Lock.action_with_spinner(e, function (e) {
				var row = {
					'date': _DOM.id('repair_date').value,
					'garage': _DOM.id('repair_garage').value,
					'desc': _DOM.id('repair_desc').value,
					'price': _DOM.id('repair_price').value
				};
				try {
					_DateString.pattern = 'YYYY-MM-DD';
					if (_TabRepair.selected!=null) {
						_TabCar.db[_TabCar.selected].upd_repair(_TabRepair.selected, row);
					} else {
						_TabCar.db[_TabCar.selected].add_repair(row);
					}
					_TabCar.save();
					_TabRepair.list();
				} catch(e) {
					_Log.error(e);
				}
			});
		},
		ls: function (e) {
			return _Lock.action(e, function (e) {
				_TabRepair.list();
			});
		}
	},
	list: function () {
		_Tabs.show('tab_repairs_list');
		_TabRepair.selected = null;
		var rows = _TabCar.db[_TabCar.selected].repair;
		if (!rows.length) {
			_DOM.hide('repairs_list');
			_DOM.show('no_repairs_list');
		} else {
			var html = '';
			for (var i=0;i<rows.length;i++) {
				html += rows[i].to_HTML();
			}
			_DOM.id('repairs_rows').innerHTML = html;
			_DOM.hide('no_repairs_list');
			_DOM.show('repairs_list');
		}
	},
	editor: function (i) {
		_Tabs.show('tab_repair_editor');
		_TabRepair.selected = i;
		if (i!=null) {
			var row = _TabCar.db[_TabCar.selected].repair[i].row;
			_DOM.id('repair_date').value = row.date.to_yyyymmdd('-');
			_DOM.id('repair_garage').value = String(row.garage);
			_DOM.id('repair_desc').value = String(row.desc);
			_DOM.id('repair_price').value = String(row.price).to_comma();
		} else {
			_DOM.id('repair_date').value = (new Date()).to_yyyymmdd('-');
			_DOM.id('repair_garage').value = '';
			_DOM.id('repair_desc').value = '';
			_DOM.id('repair_price').value = '';
		}
	}
};
