// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabSettings = {
	currency: 'euro',
	currencies: {
		'euro': '€',
		'dollard': '$',
		'poundsterling': '£',
		'yen' : '¥'
	},
	distance: 'km',
	distances: ['km','mi'],
	volume: 'l',
	volumes: ['l','gal'],
	date_pattern: 'YYYY-MM-DD',
	date_patterns: {
		'YYYY-MM-DD': /[0-9]{4}-[0-9]{2}-[0-9]{2}/,
		'MM/DD/YYYY': /[0-9]{2}\/[0-9]{2}\/[0-9]{4}/,
		'DD/MM/YYYY': /[0-9]{2}\/[0-9]{2}\/[0-9]{4}/
	},
	comma: '.',
	commas: ['.', ','],
	init: function () {
		_DOM.listen('but_settings_open', 'click', _TabSettings.slot.open);
		_DOM.listen('but_settings_back', 'click', _TabCar.slot.ls);
		_DOM.listen('settings_lang', 'click', _TabSettings.slot.lang);
		_DOM.listen('settings_currency', 'click', _TabSettings.slot.currency);
		_DOM.listen('settings_distance', 'click', _TabSettings.slot.distance);
		_DOM.listen('settings_volume', 'click', _TabSettings.slot.volume);
		_DOM.listen('settings_date_pattern', 'click', _TabSettings.slot.date_pattern);
		_DOM.listen('settings_comma', 'click', _TabSettings.slot.comma);
	},
	slot: {
		open: function (e) {
			return _Lock.action(e, function (e) {
				_Tabs.show('tab_settings');
			});
		},
		lang: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					_TabSettings.chg_lang(o.getAttribute('data-value'));
					//_Lang.chg_to(o.getAttribute('data-value'));
					_TabCar.save();
				}
			});
		},
		currency: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					_TabSettings.chg_currency(o.getAttribute('data-value'));
					_TabCar.save();
				}
			});
		},
		distance: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					_TabSettings.chg_distance(o.getAttribute('data-value'));
					_TabCar.save();
				}
			});
		},
		volume: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					_TabSettings.chg_volume(o.getAttribute('data-value'));
					_TabCar.save();
				}
			});
		},
		date_pattern: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					_TabSettings.chg_date_pattern(o.getAttribute('data-value'));
					_TabCar.save();
				}
			});
		},
		comma: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					_TabSettings.chg_comma(o.getAttribute('data-value'));
					_TabCar.save();
				}
			});
		}
	},
	set_lang: function (value) {
		var lis = _DOM.id('settings_lang').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	},
	chg_lang: function (value) {
		if (_Lang.available.indexOf(value)!=-1) {
			_Lang.index = _Lang.available.indexOf(value);
			_Lang.reset();
			_TabSettings.set_lang(value);
		}
	},
	set_currency: function (value) {
		var lis = _DOM.id('settings_currency').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	},
	chg_currency: function (value) {
		if (Object.keys(_TabSettings.currencies).indexOf(value)!=-1) {
			_TabSettings.currency = value;
			_TabSettings.set_currency(value);
		}
	},
	set_distance: function (value) {
		var lis = _DOM.id('settings_distance').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	},
	chg_distance: function (value) {
		if (_TabSettings.distances.indexOf(value)!=-1) {
			_TabSettings.distance = value;
			_TabSettings.set_distance(value);
		}
	},
	set_volume: function (value) {
		var lis = _DOM.id('settings_volume').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	},
	chg_volume: function (value) {
		if (_TabSettings.volumes.indexOf(value)!=-1) {
			_TabSettings.volume = value;
			_TabSettings.set_volume(value);
		}
	},
	set_date_pattern: function (value) {
		var lis = _DOM.id('settings_date_pattern').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	},
	chg_date_pattern: function (value) {
		if (Object.keys(_TabSettings.date_patterns).indexOf(value)!=-1) {
			_TabSettings.date_pattern = value;
			var input = document.querySelectorAll('input[type="date"]');
			for (var i=0;i<input.length;i++) {
				if (input[i].hasAttribute('pattern')) {
					input[i].removeAttribute('pattern')
				}
				input[i].setAttribute('pattern',_TabSettings.date_patterns[value]);
			}
			_TabSettings.set_date_pattern(value);
		}
	},
	set_comma: function (value) {
		var lis = _DOM.id('settings_comma').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	},
	chg_comma: function (value) {
		if (_TabSettings.commas.indexOf(value)!=-1) {
			_TabSettings.comma = value;
			_TabSettings.set_comma(value);
		}
	}
};
