// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabStats = {
	init: function () {
	},
	slot: {
		stats: function (event) {
			_Tabs.show('tab_stats');
			// main stats
			var total = 0.;
			var total_gas_price = 0.;
			var total_gas_vol = 0.;
			var currency = '&nbsp;' + _TabSettings.currencies[_TabSettings.currency];
			var volume = '&nbsp;' + _TabSettings.volume;
			var distance = '&nbsp;' + _TabSettings.distance;
			var html = '', html2 = '';
			if (_TabCar.selected == null) {
				html = tr('No car selected');
			} else {
				var car = _TabCar.db[_TabCar.selected];
				total += parseFloat(car.row.purchase.price);
				var counter_min = car.row.purchase.counter;
				var counter_max = car.row.purchase.counter;
				var fills = null;
				if (car.fill.length) {
					fills = {};
					for (var i=0;i<car.fill.length;i++) {
						var y = String(car.fill[i].row.date.getFullYear());
						if (!(y in fills))
							fills[y] = {nb: 0, gas_vol: 0., gas_price: 0.};
						fills[y].nb++;
						if (car.fill[i].row.price_per_vol!=0) {
							fills[y].gas_vol += car.fill[i].row.price/car.fill[i].row.price_per_vol;
						}
						fills[y].gas_price += car.fill[i].row.price;
						total += car.fill[i].row.price;
						total_gas_price += car.fill[i].row.price;
						if (car.fill[i].row.price_per_vol!=0) {
							total_gas_vol += car.fill[i].row.price/car.fill[i].row.price_per_vol;
						}
						if (car.fill[i].row.counter>counter_max) {
							counter_max = car.fill[i].row.counter;
						}
					}
				}
				var counter_delta = counter_max-counter_min;
				var total_repairs = 0;
				var repairs = null;
				if (car.repair.length) {
					repairs = {};
					for (var i=0;i<car.repair.length;i++) {
						var y = String(car.repair[i].row.date.getFullYear());
						if (!(y in repairs))
							repairs[y] = {nb: 0, total: 0};
						repairs[y].nb++;
						repairs[y].total += car.repair[i].row.price;
						total += car.repair[i].row.price;
						total_repairs += car.repair[i].row.price;
					}
				}
				var total_insurances = 0.;
				if (car.insurance.length) {
					var insurances = {};
					for (var i=0;i<car.insurance.length;i++) {
						var y = String(car.insurance[i].row.date.getFullYear());
						if (!(y in insurances))
							insurances[y] = {nb: 0, total: 0};
						insurances[y].nb++;
						insurances[y].total += car.insurance[i].row.price;
						total += car.insurance[i].row.price;
						total_insurances += car.insurance[i].row.price;
					}
				}
				/* COUNTER */
				html2 = '<table class="list"><thead><tr><th>' + tr('Counter') + '</th><th>' + distance + '</th><tbody>';
				html2 += '<tr><td>min</td><td>' + String(_Fmt.round(counter_min,2)).to_comma() +  '</td></tr>';
				html2 += '<tr><td>max</td><td>' + String(_Fmt.round(counter_max,2)).to_comma() + '</td></tr>';
				if (counter_delta!=0) {
					html2 += '<tr><td>&Delta;' + tr('Counter') + '</td><td>' + String(_Fmt.round(counter_delta,2)).to_comma() + '</td></tr>';
				} else {
					html2 += '<tr><td>&Delta;' + tr('Counter') + '</td><td>0' + distance + '</td></tr>';
				}
				html2 += '</tbody></table>';
				html += '<div>' + html2 + '</div>';
				/* TOTAL */
				html2 = '<table class="list"><thead><tr><th>' + tr('Costs') + '</th><th>' + tr('Nb') + '</th><th>' + currency + '</th><tbody>';
				html2 += '<tr><td>' + tr('Car purchase') + '</td><td>&nbsp;</td><td>' + String(_Fmt.round(car.row.purchase.price,2)).to_comma() + '</td></tr>';
				if (car.fill.length)
					html2 += '<tr><td>' + tr('Fills') + '</td><td>' + car.fill.length + '</td><td>' + String(_Fmt.round(total_gas_price,2)).to_comma() + '</td></tr>';
				if (car.repair.length)
					html2 += '<tr><td>' + tr('Repairs') + '</td><td>' + car.repair.length + '</td><td>' + String(_Fmt.round(total_repairs,2)).to_comma() + '</td></tr>';
				if (car.insurance.length)
					html2 += '<tr><td>' + tr('Insurances') + '</td><td>' + car.insurance.length + '</td><td>' + String(_Fmt.round(total_insurances,2)).to_comma() + '</td></tr>';
				html2 += '<tr><td>' + tr('Total') + '</td><td>&nbsp;</td><td>' + String(_Fmt.round(total,2)).to_comma() + '</td></tr>';
				html2 += '</tbody></table>';
				html += '<div>' + html2 + '</div>';
				/* STATS */
				html2 = '<table class="list"><tbody>';
				if (counter_delta!=0) {
					html2 += '<tr><td>' + tr('Total') + '&nbsp;/&nbsp;&Delta;' + tr('Counter') + '</td><td>' + String(_Fmt.round(total/counter_delta,2)).to_comma() + currency + ' /' + distance + '</td></tr>';
				}
				html2 += '</tbody></table>';
				html += '<div>' + html2 + '</div>';
				html2 = '<table class="list"><thead>';
				if (counter_delta!=0 && car.fill.length>1) {
					var last_fill = car.fill[car.fill.length-1];
					html2 += '<tr><th colspan="2">' + tr('Consumption') + '</th></tr></thead><tbody>';
					html2 += '<tr><td>' + tr('Without last fill') + '</td><td>' + String(_Fmt.round((total_gas_price-last_fill.row.price)/counter_delta,4)).to_comma() + currency + ' /' + distance + '</td></tr>';
					if (last_fill.row.price_per_vol!=0) {
						html2 += '<tr><td>' + tr('Average') + '</td><td>' + String(_Fmt.round((100*(total_gas_vol-(last_fill.row.price/last_fill.row.price_per_vol)))/counter_delta,2)).to_comma() + volume + ' / ' + '100' + distance + '</td></tr>';
					}
				}
				html2 += '</tbody></table>';
				html += '<div>' + html2 + '</div>';
				/* FILLS */
				if (car.fill.length) {
					html2 = '<table class="list"><thead><tr><th>' + tr ('Fills') + '</th><th>' + tr('Nb') + '</th><th>' + volume + '</th><th>' + currency + '</th><tbody>';
					if (fills!=null) {
						for (var y in fills) {
							html2 += '<tr><td>' + y + '</td><td>' + fills[y].nb + '</td><td>' + String(_Fmt.round(fills[y].gas_vol,2)).to_comma() + '</td><td>' + String(_Fmt.round(fills[y].gas_price,2)).to_comma() + '</td></tr>';
						}
					}
					html2 += '<tr><td>' + tr('Total') + '</td><td>' + car.fill.length + '</td><td>' + String(_Fmt.round(total_gas_vol,2)).to_comma() + '</td><td>' + String(_Fmt.round(total_gas_price,2)).to_comma() + '</td></tr>';
					html2 += '</tbody></table>';
					html += '<div>' + html2 + '</div>';
				}
				/* REPAIRS */
				if (car.repair.length) {
					html2 = '<table class="list"><thead><tr><th>' + tr ('Repairs') + '</th><th>' + tr('Nb') + '</th><th>' + currency + '</th></tr></th><tbody>';
					if (repairs!=null) {
						for (var y in repairs) {
							html2 += '<tr><td>' + y + '</td><td>' + repairs[y].nb + '</td><td>' + String(_Fmt.round(repairs[y].total,2)).to_comma() + '</td></tr>';
						}
					}
					html2 += '<tr><td>' + tr('Total') + '</td><td>' + car.repair.length + '</td><td>' + String(_Fmt.round(total_repairs,2)).to_comma() + '</td></tr>';
					html2 += '</tbody></table>';
					html += '<div>' + html2 + '</div>';
				}
				/* INSURANCES */
				if (car.insurance.length) {
					html2 = '<table class="list"><thead><tr><th>' + tr ('Insurances') + '</th><th>' + tr('Nb') + '</th><th>' + currency + '</th></tr></th><tbody>';
					if (insurances!=null) {
						for (var y in insurances) {
							html2 += '<tr><td>' + y + '</td><td>' + insurances[y].nb + '</td><td>' + String(_Fmt.round(insurances[y].total,2)).to_comma() + '</td></tr>';
						}
					}
					html2 += '<tr><td>' + tr('Total') + '</td><td>' + car.insurance.length + '</td><td>' + String(_Fmt.round(total_insurances,2)).to_comma() + '</td></tr>';
					html2 += '</tbody></table>';
					html += '<div>' + html2 + '</div>';
				}
			}
			_DOM.id('stats_list').innerHTML = html;
		}
	}
};
