// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _XML = {
	debug: false,
	read: function (text)	{
		var xml_doc;
		try {
			var str = text.replace('<?xml version="1.0" encoding="UTF-8"?>','');
			var parser = new DOMParser();
			xml_doc = parser.parseFromString(str, 'text/xml');
		} catch (err) {
			return _Log.error(tr('Parsing XML failed') + ' : ' + err);
		}
		// read settings
		try {
			if (xml_doc.getElementsByTagName("settings").length) {
				var xml_settings = xml_doc.getElementsByTagName("settings")[0];
				// lang
				if (xml_settings.getElementsByTagName("lang").length)
					_TabSettings.chg_lang(xml_settings.getElementsByTagName('lang')[0].childNodes[0].nodeValue);
				// currency
				if (xml_settings.getElementsByTagName("currency").length)
					_TabSettings.chg_currency(xml_settings.getElementsByTagName('currency')[0].childNodes[0].nodeValue);
				// distance
				if (xml_settings.getElementsByTagName("distance").length)
					_TabSettings.chg_distance(xml_settings.getElementsByTagName('distance')[0].childNodes[0].nodeValue);
				// volume
				if (xml_settings.getElementsByTagName("volume").length)
					_TabSettings.chg_volume(xml_settings.getElementsByTagName('volume')[0].childNodes[0].nodeValue);
				// date_pattern
				if (xml_settings.getElementsByTagName("date_pattern").length)
					_TabSettings.chg_date_pattern(xml_settings.getElementsByTagName('date_pattern')[0].childNodes[0].nodeValue);
				// comma
				if (xml_settings.getElementsByTagName("comma").length)
					_TabSettings.chg_comma(xml_settings.getElementsByTagName('comma')[0].childNodes[0].nodeValue);
			}
		} catch (err) {
			_Log.error(tr('Reading settings failed') + ' : ' + err);
			// continue (non fatal errors)
		}
		// read cars
		if (xml_doc.getElementsByTagName("car").length) {
			var xml_cars = xml_doc.getElementsByTagName("car");
			for (var i=0;i<xml_cars.length;i++) {
				try {
					var obj = _XML.import(xml_cars[i]);
					_TabCar.addCar(obj);
				} catch (err) {
					_Log.error(tr('Reading car failed') + ' : ' + err);
				}
			}
		}
	},
	import: function (xml) {
		var obj = {};
		if (xml.hasChildNodes()) {
			for(var i=0; i<xml.childNodes.length; i++) {
				var item = xml.childNodes.item(i);
				if ('nodeName' in item) {
					var nodeName = item.nodeName;
					if (item.nodeType==3) {
						return item.nodeValue;
					}
					else if (item.nodeType==1) {
						if (item.childNodes.length) {
							if (nodeName.match(/^photo/)!=null) {
								var xml_serializer = new XMLSerializer();
						    var data = xml_serializer.serializeToString(item);
						    var m = data.match(/^<photo>(data:image\/jpe?g;base64,([0-9a-zA-Z+\/]{4})*(([0-9a-zA-Z+\/]{2}==)|([0-9a-zA-Z+\/]{3}=))?)<\/photo>$/);
								if (m!=null) {
									if (!(nodeName in obj))
										obj[nodeName] = [];
									obj[nodeName].push( m[1] );
								}
							} else if (nodeName=='row' || nodeName=='purchase') {
								if (!(nodeName in obj))
									obj[nodeName] = {};
								obj[nodeName] = _XML.import(item);
							} else if (nodeName=='fill' || nodeName=='repair' ||  nodeName=='insurance') {
								if (!(nodeName in obj))
									obj[nodeName] = [];
								obj[nodeName].push(_XML.import(item));
							} else {
								obj[nodeName] = _XML.import(item);
							}
						} else {
							_Log.warn('What should i do with ' + nodeName + ' ?');
						}
					}
				}
			}
		}
		return obj;
	},
	write: function () {
		var markup, xml_doc, xml_settings, xml_element, xml_textnode, xml_cars, xml_car;
		markup = '<?xml version="1.0" encoding="UTF-8"?><calendar name="default"><settings></settings><cars></cars></calendar>';
		xml_doc = (new DOMParser()).parseFromString(markup, 'application/xml');
		// record settings
		try {
			xml_settings = xml_doc.getElementsByTagName("settings")[0];
			// lang
			xml_element = xml_doc.createElement('lang');
			xml_settings.appendChild(xml_element);
			xml_textnode = xml_doc.createTextNode(_Lang.current);
			xml_element.appendChild(xml_textnode);
			// currency
			xml_element = xml_doc.createElement('currency');
			xml_settings.appendChild(xml_element);
			xml_textnode = xml_doc.createTextNode(_TabSettings.currency);
			xml_element.appendChild(xml_textnode);
			// distance
			xml_element = xml_doc.createElement('distance');
			xml_settings.appendChild(xml_element);
			xml_textnode = xml_doc.createTextNode(_TabSettings.distance);
			xml_element.appendChild(xml_textnode);
			// volume
			xml_element = xml_doc.createElement('volume');
			xml_settings.appendChild(xml_element);
			xml_textnode = xml_doc.createTextNode(_TabSettings.volume);
			xml_element.appendChild(xml_textnode);
			// date_pattern
			xml_element = xml_doc.createElement('date_pattern');
			xml_settings.appendChild(xml_element);
			xml_textnode = xml_doc.createTextNode(_TabSettings.date_pattern);
			xml_element.appendChild(xml_textnode);
			// comma
			xml_element = xml_doc.createElement('comma');
			xml_settings.appendChild(xml_element);
			xml_textnode = xml_doc.createTextNode(_TabSettings.comma);
			xml_element.appendChild(xml_textnode);
		} catch (err) {
			_Log.error(tr('Recording settings failed') + ' : ' + err);
		}
		// record car
		try {
			var xml_cars = xml_doc.getElementsByTagName('cars')[0];
			for (var i=0;i<_TabCar.db.length;i++) {
				var xml_car = xml_doc.createElement('car');
				xml_cars.appendChild(xml_car);
				_XML.export(xml_doc, xml_car, _TabCar.db[i]);
			}
		} catch (err) {
			_Log.error(tr('Recording car failed') + ' : ' + err);
		}
		var xml_string = (new XMLSerializer()).serializeToString(xml_doc);
		return xml_string;
	},
	export: function (xml_doc, xml_root, obj) {
		for (var key in obj) {
			if (obj[key]!==null && obj[key]!==undefined) {
				if (typeof(obj[key])=='string' || typeof(obj[key])=='number') {
					var xml_node = xml_doc.createElement(key);
					xml_root.appendChild(xml_node);
					var xml_text = xml_doc.createTextNode(String(obj[key]));
					xml_node.appendChild(xml_text);
				} else { // object
					if (typeof(obj[key])=='function') {
						// ignore
					} else {
						if (Object.prototype.toString.call(obj[key]) === '[object Date]') {
							var xml_node = xml_doc.createElement(key);
							xml_root.appendChild(xml_node);
							var xml_text = xml_doc.createTextNode(String(obj[key].to_locale()));
							xml_node.appendChild(xml_text);
						} else {
							if (Object.prototype.toString.call(obj[key]) === '[object Array]') {
								if (obj[key].length) {
									if (typeof(obj[key][0])=='string' || typeof(obj[key][0])=='number') {
										for (var i=0;i<obj[key].length;i++) {
											var xml_node = xml_doc.createElement(key);
											xml_root.appendChild(xml_node);
											var xml_text = xml_doc.createTextNode(String(obj[key][i]));
											xml_node.appendChild(xml_text);
										}
									} else {
										for (var i=0;i<obj[key].length;i++) {
											var xml_node = xml_doc.createElement(key);
											xml_root.appendChild(xml_node);
											_XML.export(xml_doc, xml_node, obj[key][i]);
										}
									}
								}
							} else {
								if (Object.prototype.toString.call(obj[key]) === '[object Object]') {
									var xml_node = xml_doc.createElement(key);
									xml_root.appendChild(xml_node);
									_XML.export(xml_doc, xml_node, obj[key]);
								}
							}
							// boolean and symbol not used
						}
					}
				}
			}
		}
	}
};
