/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 0.19.0
 * @date    2014-03-30
 *
 * @license
 * Copyright (C) 2013-2014 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(e,r){"object"==typeof exports&&"object"==typeof module?module.exports=r():"function"==typeof define&&define.amd?define(r):"object"==typeof exports?exports.mathjs=r():e.mathjs=r()}(this,function(){return function(e){function r(t){if(n[t])return n[t].exports;var i=n[t]={exports:{},id:t,loaded:!1};return e[t].call(i.exports,i,i.exports,r),i.loaded=!0,i.exports}var n={};return r.m=e,r.c=n,r.p="",r(0)}([function(e,r,n){e.exports=n(1)},function(e,r,n){function t(e){if("function"!=typeof Object.create)throw new Error("ES5 not supported by this JavaScript engine. Please load the es5-shim and es5-sham library for compatibility.");var r={},t={matrix:"matrix",number:"number"};return r.config=function(e){var r=n(111);if(e){if(i.deepExtend(t,e),e.decimals&&r.config({DECIMAL_PLACES:e.decimals}),e.number&&e.number.defaultType)throw new Error("setting `number.defaultType` is deprecated. Use `number` instead.");if(e.number&&e.number.precision)throw new Error("setting `number.precision` is deprecated. Use `decimals` instead.");if(e.matrix&&e.matrix.defaultType)throw new Error("setting `matrix.defaultType` is deprecated. Use `matrix` instead.");if(e.matrix&&e.matrix["default"])throw new Error("setting `matrix.default` is deprecated. Use `matrix` instead.")}var o=i.clone(t);return o.decimals=r.config().DECIMAL_PLACES,o},r.config(e),r.expression={},r.expression.node=n(6),r.expression.parse=n(4),r.expression.Scope=function(){throw new Error("Scope is deprecated. Use a regular Object instead")},r.expression.Parser=n(5),r.expression.docs=n(7),r.type={},r.type.BigNumber=n(111),r.type.Complex=n(8),r.type.Range=n(9),r.type.Index=n(10),r.type.Matrix=n(11),r.type.Unit=n(12),r.type.Help=n(13),r.collection=n(14),n(15)(r),n(17)(r,t),n(18)(r,t),n(19)(r,t),n(20)(r,t),n(21)(r,t),n(22)(r,t),n(23)(r,t),n(24)(r,t),n(25)(r,t),n(26)(r,t),n(27)(r,t),n(28)(r,t),n(29)(r,t),n(30)(r,t),n(31)(r,t),n(32)(r,t),n(33)(r,t),n(34)(r,t),n(35)(r,t),n(36)(r,t),n(37)(r,t),n(38)(r,t),n(39)(r,t),n(40)(r,t),n(41)(r,t),n(42)(r,t),n(43)(r,t),n(44)(r,t),n(45)(r,t),n(46)(r,t),n(47)(r,t),n(48)(r,t),n(49)(r,t),n(50)(r,t),n(51)(r,t),n(52)(r,t),n(53)(r,t),n(54)(r,t),n(55)(r,t),n(56)(r,t),n(57)(r,t),n(58)(r,t),n(59)(r,t),n(60)(r,t),n(61)(r,t),n(62)(r,t),n(63)(r,t),n(64)(r,t),n(65)(r,t),n(66)(r,t),n(67)(r,t),n(68)(r,t),n(69)(r,t),n(70)(r,t),n(71)(r,t),n(72)(r,t),n(73)(r,t),n(74)(r,t),n(75)(r,t),n(76)(r,t),n(77)(r,t),n(78)(r,t),n(79)(r,t),n(80)(r,t),n(81)(r,t),n(82)(r,t),n(83)(r,t),n(84)(r,t),n(85)(r,t),n(86)(r,t),n(87)(r,t),n(88)(r,t),n(89)(r,t),n(90)(r,t),n(91)(r,t),n(92)(r,t),n(93)(r,t),n(94)(r,t),n(95)(r,t),n(96)(r,t),n(97)(r,t),n(98)(r,t),n(99)(r,t),n(100)(r,t),n(101)(r,t),n(102)(r,t),n(103)(r,t),n(104)(r,t),n(105)(r,t),n(106)(r,t),n(107)(r,t),n(108)(r,t),n(109)(r,t),n(110)(r,t),n(2)(r,t),r.chaining={},r.chaining.Selector=n(16)(r,t),r}var i=n(3);e.exports=t},function(e,r,n){e.exports=function(e){var r=n(8);e.pi=Math.PI,e.e=Math.E,e.tau=2*Math.PI,e.i=new r(0,1),e.Infinity=1/0,e.NaN=0/0,e["true"]=!0,e["false"]=!1,e.E=Math.E,e.LN2=Math.LN2,e.LN10=Math.LN10,e.LOG2E=Math.LOG2E,e.LOG10E=Math.LOG10E,e.PI=Math.PI,e.SQRT1_2=Math.SQRT1_2,e.SQRT2=Math.SQRT2}},function(e,r){r.clone=function n(e){var r=typeof e;if("number"===r||"string"===r||"boolean"===r||null===e||void 0===e)return e;if("function"==typeof e.clone)return e.clone();if(Array.isArray(e))return e.map(function(e){return n(e)});if(e instanceof Number)return new Number(e.valueOf());if(e instanceof String)return new String(e.valueOf());if(e instanceof Boolean)return new Boolean(e.valueOf());if(e instanceof Date)return new Date(e.valueOf());if(e instanceof RegExp)throw new TypeError("Cannot clone "+e);var t={};for(var i in e)e.hasOwnProperty(i)&&(t[i]=n(e[i]));return t},r.extend=function(e,r){for(var n in r)r.hasOwnProperty(n)&&(e[n]=r[n]);return e},r.deepExtend=function t(e,r){if(Array.isArray(r))throw new TypeError("Arrays are not supported by deepExtend");for(var n in r)if(r.hasOwnProperty(n))if(r[n]&&r[n].constructor===Object)void 0===e[n]&&(e[n]={}),e[n].constructor===Object?t(e[n],r[n]):e[n]=r[n];else{if(Array.isArray(r[n]))throw new TypeError("Arrays are not supported by deepExtend");e[n]=r[n]}return e},r.deepEqual=function(e,n){var t,i,o;if(Array.isArray(e)){if(!Array.isArray(n))return!1;if(e.length!=n.length)return!1;for(i=0,o=e.length;o>i;i++)if(!r.deepEqual(e[i],n[i]))return!1;return!0}if(e instanceof Object){if(Array.isArray(n)||!(n instanceof Object))return!1;for(t in e)if(!r.deepEqual(e[t],n[t]))return!1;for(t in n)if(!r.deepEqual(e[t],n[t]))return!1;return!0}return typeof e==typeof n&&e==n}},function(e,r,n){function t(e,r){if(1!=arguments.length&&2!=arguments.length)throw new SyntaxError("Wrong number of arguments: 1 or 2 expected");if(sr="object"===D(r)?r:{},F(e))return ur=e,m();if(G(e)||e instanceof H)return V.deepMap(e,function(e){if(!F(e))throw new TypeError("String expected");return ur=e,m()});throw new TypeError("String or matrix expected")}function i(){fr=0,cr=ur.charAt(0)}function o(){fr++,cr=ur.charAt(fr)}function a(){return ur.charAt(fr+1)}function s(){for(mr=ir.NULL,lr="";" "==cr||"	"==cr;)o();if("#"==cr)for(;"\n"!=cr&&""!=cr;)o();if(""==cr)return void(mr=ir.DELIMITER);var e=cr+a();if(or[e])return mr=ir.DELIMITER,lr=e,o(),void o();if(or[cr])return mr=ir.DELIMITER,lr=cr,void o();if(!c(cr)){if(f(cr)){for(;f(cr)||l(cr);)lr+=cr,o();return void(mr=ar[lr]?ir.DELIMITER:ir.SYMBOL)}for(mr=ir.UNKNOWN;""!=cr;)lr+=cr,o();throw j('Syntax error in part "'+lr+'"')}if(mr=ir.NUMBER,"."==cr)lr+=cr,o(),l(cr)||(mr=ir.UNKNOWN);else{for(;l(cr);)lr+=cr,o();"."==cr&&(lr+=cr,o())}for(;l(cr);)lr+=cr,o();if("E"==cr||"e"==cr)for(lr+=cr,o(),("+"==cr||"-"==cr)&&(lr+=cr,o()),l(cr)||(mr=ir.UNKNOWN);l(cr);)lr+=cr,o()}function u(){for(;"\n"==lr;)s()}function f(e){return e>="a"&&"z">=e||e>="A"&&"Z">=e||"_"==e}function c(e){return e>="0"&&"9">=e||"."==e}function l(e){return e>="0"&&"9">=e}function m(){i(),s();var e=p();if(""!=lr)throw mr==ir.DELIMITER?P("Unknown operator "+lr):j('Unexpected part "'+lr+'"');return e}function p(){var e,r,n;if(""==lr)return new Q("undefined","undefined");for("\n"!=lr&&";"!=lr&&(e=h());"\n"==lr||";"==lr;)r||(r=new Z,e&&(n=";"!=lr,r.add(e,n))),s(),"\n"!=lr&&";"!=lr&&""!=lr&&(e=h(),n=";"!=lr,r.add(e,n));return r?r:e}function h(){var e=g(),r="ans";return new Y(r,e)}function g(){if(mr==ir.SYMBOL&&"function"==lr)throw new Error('Deprecated keyword "function". Functions can now be assigned without it, like "f(x) = x^2".');return d()}function d(){var e,r,n,t=x();if("="==lr){if(t instanceof rr)return e=t.name,s(),n=d(),new Y(e,n);if(t instanceof $)return s(),n=d(),new tr(t,n);if(t instanceof J){var i=!0;if(r=[],t.object instanceof rr?(e=t.object.name,t.params.forEach(function(e,n){e instanceof rr?r[n]=e.name:i=!1})):i=!1,i)return s(),n=d(),new K(e,r,n)}throw j("Invalid left hand side of assignment operator =")}return t}function x(){var e,r=[];if(e=":"==lr?new Q("number","1"):w(),":"==lr){for(r.push(e);":"==lr;)s(),r.push(")"==lr||"]"==lr||","==lr||""==lr?new rr("end"):w());if(3==r.length){var n=r[2];r[2]=r[1],r[1]=n}e=new er(r)}return e}function w(){var e=v();return e}function v(){var e,r,n,t,i;for(e=y(),r={"==":"equal","!=":"unequal","<":"smaller",">":"larger","<=":"smallereq",">=":"largereq"};lr in r;)n=lr,t=r[n],s(),i=[e,y()],e=new X(n,t,i);return e}function y(){var e,r,n,t,i;for(e=b(),r={to:"to","in":"to"};lr in r;)n=lr,t=r[n],s(),i=[e,b()],e=new X(n,t,i);return e}function b(){var e,r,n,t,i;for(e=E(),r={"+":"add","-":"subtract"};lr in r;)n=lr,t=r[n],s(),i=[e,E()],e=new X(n,t,i);return e}function E(){var e,r,n,t,i;for(e=N(),r={"*":"multiply",".*":"emultiply","/":"divide","./":"edivide","%":"mod",mod:"mod"};lr in r;)n=lr,t=r[n],s(),i=[e,N()],e=new X(n,t,i);return e}function N(){var e,r;return e=M(),(mr==ir.SYMBOL||"in"==lr)&&(r=lr,s(),e=new nr(e,r)),e}function M(){var e,r,n;return"-"==lr?(e=lr,r="unary",s(),n=[M()],new X(e,r,n)):A()}function A(){var e,r,n,t,i,o,a;for(n=[T()],t=[];"^"==lr||".^"==lr;)t.push(lr),s(),n.push(T());for(e=n.pop();n.length;)r=n.pop(),i=t.pop(),o="^"==i?"pow":"epow",a=[r,e],e=new X(i,o,a);return e}function T(){var e,r,n,t,i;for(e=O(),r={"!":"factorial","'":"transpose"};lr in r;)n=lr,t=r[n],s(),i=[e],e=new X(n,t,i);return e}function O(){var e,r=[];if(mr==ir.SYMBOL&&sr[lr]){if(e=sr[lr],s(),"("==lr){if(r=[],s(),")"!=lr)for(r.push(x());","==lr;)s(),r.push(x());if(")"!=lr)throw j("Parenthesis ) expected");s()}return new e(r)}return S()}function S(){var e,r;return mr==ir.SYMBOL||mr==ir.DELIMITER&&lr in ar?(r=lr,s(),e=new rr(r),C(e)):U()}function C(e){for(var r,n;"("==lr||"["==lr;){if(r=lr,n=[],s(),")"!=lr&&"]"!=lr)for(n.push(x());","==lr;)s(),n.push(x());if("("==r&&")"!=lr)throw j("Parenthesis ) expected");if("["==r&&"]"!=lr)throw j("Parenthesis ] expected");s(),e="("==r?new J(e,n):new $(e,n)}return e}function U(){var e,r,n;if('"'==lr){for(r="",n="";""!=cr&&('"'!=cr||"\\"==n);)r+=cr,n=cr,o();if(s(),'"'!=lr)throw j('End of string " expected');return s(),e=new Q("string",r),e=C(e)}return q()}function q(){var e,r,n,t;if("["==lr){if(s(),u(),"]"!=lr){var i=z();if(";"==lr){for(n=1,r=[i];";"==lr;)s(),u(),r[n]=z(),n++,u();if("]"!=lr)throw j("End of matrix ] expected");s(),t=r[0].nodes.length;for(var o=1;n>o;o++)if(r[o].nodes.length!=t)throw P("Column dimensions mismatch ("+r[o].nodes.length+" != "+t+")");e=new W(r)}else{if("]"!=lr)throw j("End of matrix ] expected");s(),e=i}}else s(),e=new W([]);return e=C(e)}return R()}function z(){for(var e=[d()],r=1;","==lr;)s(),u(),e[r]=d(),r++,u();return new W(e)}function R(){var e,r;return mr==ir.NUMBER?(r=lr,s(),"i"==lr||"I"==lr?(s(),e=new Q("complex",r)):e=new Q("number",r),e=C(e)):I()}function I(){var e;if("("==lr){if(s(),e=d(),")"!=lr)throw j("Parenthesis ) expected");return s(),e=C(e)}return _()}function _(){throw j(""==lr?"Unexpected end of expression":"Value expected")}function L(){return fr-lr.length+1}function B(e){return e+" (char "+L()+")"}function j(e){return new SyntaxError(B(e))}function P(e){return new Error(B(e))}var k=n(112),F=(k.number.toNumber,k.string.isString),G=Array.isArray,D=k.types.type,H=(n(8),n(11)),V=(n(12),n(14)),W=n(113),Y=n(114),Z=n(115),Q=n(116),K=n(117),$=n(118),X=n(119),J=n(120),er=n(121),rr=n(122),nr=n(123),tr=n(124),ir={NULL:0,DELIMITER:1,NUMBER:2,SYMBOL:3,UNKNOWN:4},or={",":!0,"(":!0,")":!0,"[":!0,"]":!0,'"':!0,"\n":!0,";":!0,"+":!0,"-":!0,"*":!0,".*":!0,"/":!0,"./":!0,"%":!0,"^":!0,".^":!0,"!":!0,"'":!0,"=":!0,":":!0,"==":!0,"!=":!0,"<":!0,">":!0,"<=":!0,">=":!0},ar={mod:!0,to:!0,"in":!0},sr={},ur="",fr=0,cr="",lr="",mr=ir.NULL;e.exports=t},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if("object"!=typeof e)throw new TypeError("Object expected as parameter math");this.math=e,this.scope={}}var i=n(4);t.prototype.parse=function(e){return i(e)},t.prototype.compile=function(e){return i(e).compile(this.math)},t.prototype.eval=function(e){return i(e).compile(this.math).eval(this.scope)},t.prototype.get=function(e){return this.scope[e]},t.prototype.set=function(e,r){return this.scope[e]=r},t.prototype.remove=function(e){delete this.scope[e]},t.prototype.clear=function(){for(var e in this.scope)this.scope.hasOwnProperty(e)&&delete this.scope[e]},e.exports=t},function(e,r,n){r.ArrayNode=n(113),r.AssignmentNode=n(114),r.BlockNode=n(115),r.ConstantNode=n(116),r.IndexNode=n(118),r.FunctionNode=n(117),r.Node=n(125),r.OperatorNode=n(119),r.ParamsNode=n(120),r.RangeNode=n(121),r.SymbolNode=n(122),r.UnitNode=n(123),r.UpdateNode=n(124)},function(e,r,n){r.e=n(128),r.E=n(128),r["false"]=n(129),r.i=n(130),r.Infinity=n(131),r.LN2=n(132),r.LN10=n(133),r.LOG2E=n(134),r.LOG10E=n(135),r.NaN=n(136),r.pi=n(137),r.PI=n(137),r.SQRT1_2=n(138),r.SQRT2=n(139),r.tau=n(140),r["true"]=n(141),r.abs=n(145),r.add=n(146),r.ceil=n(147),r.compare=n(148),r.cube=n(149),r.divide=n(150),r.edivide=n(151),r.emultiply=n(152),r.epow=n(153),r.equal=n(154),r.exp=n(155),r.fix=n(156),r.floor=n(157),r.gcd=n(158),r.larger=n(159),r.largereq=n(160),r.lcm=n(161),r.log=n(162),r.log10=n(163),r.mod=n(164),r.multiply=n(165),r.pow=n(166),r.round=n(167),r.sign=n(168),r.smaller=n(169),r.smallereq=n(170),r.sqrt=n(171),r.square=n(172),r.subtract=n(173),r.unary=n(174),r.unequal=n(175),r.xgcd=n(176),r.arg=n(177),r.conj=n(178),r.re=n(179),r.im=n(180),r.bignumber=n(181),r["boolean"]=n(182),r.complex=n(183),r.index=n(184),r.matrix=n(185),r.number=n(186),r.string=n(187),r.unit=n(188),r.eval=n(189),r.help=n(190),r.concat=n(191),r.det=n(192),r.diag=n(193),r.eye=n(194),r.inv=n(195),r.ones=n(196),r.range=n(197),r.resize=n(198),r.size=n(199),r.squeeze=n(200),r.subset=n(201),r.transpose=n(202),r.zeros=n(203),r.combinations=n(204),r.distribution=n(205),r.factorial=n(206),r.permutations=n(207),r.pickRandom=n(208),r.random=n(209),r.randomInt=n(210),r.max=n(211),r.mean=n(212),r.median=n(213),r.min=n(214),r.prod=n(215),r.std=n(216),r.sum=n(217),r["var"]=n(218),r.acos=n(219),r.asin=n(220),r.atan=n(221),r.atan2=n(222),r.cos=n(223),r.cot=n(224),r.csc=n(225),r.sec=n(226),r.sin=n(227),r.tan=n(228),r.to=n(229),r.clone=n(230),r.map=n(231),r.forEach=n(232),r.format=n(233),r.ifElse=n(234),r["import"]=n(235),r["typeof"]=n(236)},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");switch(arguments.length){case 0:this.re=0,this.im=0;break;case 2:if(!p(e)||!p(r))throw new TypeError("Two numbers expected in Complex constructor");this.re=e,this.im=r;break;default:throw new SyntaxError("Two or zero arguments expected in Complex constructor")}}function i(){for(;" "==x||"	"==x;)s()}function o(e){return e>="0"&&"9">=e||"."==e}function a(e){return e>="0"&&"9">=e}function s(){d++,x=g.charAt(d)}function u(e){d=e,x=g.charAt(d)}function f(){var e,r="";if(e=d,"+"==x?s():"-"==x&&(r+=x,s()),!o(x))return u(e),null;if("."==x){if(r+=x,s(),!a(x))return u(e),null}else{for(;a(x);)r+=x,s();"."==x&&(r+=x,s())}for(;a(x);)r+=x,s();if("E"==x||"e"==x){if(r+=x,s(),("+"==x||"-"==x)&&(r+=x,s()),!a(x))return u(e),null;for(;a(x);)r+=x,s()}return r}function c(){var e=g.charAt(d+1);if("I"==x||"i"==x)return s(),"1";if(!("+"!=x&&"-"!=x||"I"!=e&&"i"!=e)){var r="+"==x?"1":"-1";return s(),s(),r}return null}var l=n(112),m=l.number,p=l.number.isNumber,h=l.string.isString;t.isComplex=function(e){return e instanceof t};var g,d,x;t.parse=function(e){if(g=e,d=-1,x="",!h(g))return null;s(),i();var r=f();if(r){if("I"==x||"i"==x)return s(),i(),x?null:new t(0,Number(r));i();var n=x;if("+"!=n&&"-"!=n)return i(),x?null:new t(Number(r),0);s(),i();var o=f();if(o){if("I"!=x&&"i"!=x)return null;s()}else if(o=c(),!o)return null;return"-"==n&&(o="-"==o[0]?"+"+o.substring(1):"-"+o),s(),i(),x?null:new t(Number(r),Number(o))}return(r=c())?(i(),x?null:new t(0,Number(r))):null},t.prototype.clone=function(){return new t(this.re,this.im)},t.prototype.equals=function(e){return this.re===e.re&&this.im===e.im},t.prototype.format=function(e){var r="",n=m.format(this.re,e),t=m.format(this.im,e);return r=0==this.im?n:0==this.re?1==this.im?"i":-1==this.im?"-i":t+"i":this.im>0?1==this.im?n+" + i":n+" + "+t+"i":-1==this.im?n+" - i":n+" - "+t.substring(1)+"i"},t.prototype.toString=function(){return this.format()},e.exports=t,r.isComplex=t.isComplex,r.parse=t.parse},function(e,r,n){function t(e,r,n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(null!=e&&!o.isNumber(e))throw new TypeError("Parameter start must be a number");if(null!=r&&!o.isNumber(r))throw new TypeError("Parameter end must be a number");if(null!=n&&!o.isNumber(n))throw new TypeError("Parameter step must be a number");this.start=null!=e?parseFloat(e):0,this.end=null!=r?parseFloat(r):0,this.step=null!=n?parseFloat(n):1}{var i=n(112),o=i.number,a=i.string;i.array}t.parse=function(e){if(!a.isString(e))return null;var r=e.split(":"),n=r.map(function(e){return parseFloat(e)}),i=n.some(function(e){return isNaN(e)});if(i)return null;switch(n.length){case 2:return new t(n[0],n[1]);case 3:return new t(n[0],n[2],n[1]);default:return null}},t.prototype.clone=function(){return new t(this.start,this.end,this.step)},t.isRange=function(e){return e instanceof t},t.prototype.size=function(){var e=0,r=this.start,n=this.step,t=this.end,i=t-r;return o.sign(n)==o.sign(i)?e=Math.ceil(i/n):0==i&&(e=0),isNaN(e)&&(e=0),[e]},t.prototype.min=function(){var e=this.size()[0];return e>0?this.step>0?this.start:this.start+(e-1)*this.step:void 0},t.prototype.max=function(){var e=this.size()[0];return e>0?this.step>0?this.start+(e-1)*this.step:this.start:void 0},t.prototype.forEach=function(e){var r=this.start,n=this.step,t=this.end,i=0;if(n>0)for(;t>r;)e(r,i,this),r+=n,i++;else if(0>n)for(;r>t;)e(r,i,this),r+=n,i++},t.prototype.map=function(e){var r=[];return this.forEach(function(n,t,i){r[t]=e(n,t,i)}),r},t.prototype.toArray=function(){var e=[];return this.forEach(function(r,n){e[n]=r}),e},t.prototype.valueOf=function(){return this.toArray()},t.prototype.format=function(e){var r=o.format(this.start,e);return 1!=this.step&&(r+=":"+o.format(this.step,e)),r+=":"+o.format(this.end,e)},t.prototype.toString=function(){return this.format()},e.exports=t,r.isRange=t.isRange,r.parse=t.parse},function(e,r,n){function t(){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this._ranges=[];for(var e=0,r=arguments.length;r>e;e++){var n=arguments[e];if(n instanceof a)this._ranges.push(n);else if(c(n))this._ranges.push(i(n));else{if(!u(n))throw new TypeError("Ranges must be an Array, Number, or Range");this._ranges.push(i([n,n+1]))}}}function i(e){for(var r=e.length,n=0;r>n;n++)if(!u(e[n])||!f(e[n]))throw new TypeError("Index parameters must be integer numbers");switch(e.length){case 2:return new a(e[0],e[1]);case 3:return new a(e[0],e[1],e[2]);default:throw new SyntaxError("Wrong number of arguments in Index (2 or 3 expected)")}}{var o=n(112),a=n(9),s=o.number,u=s.isNumber,f=s.isInteger,c=Array.isArray;o.array.validateIndex}t.prototype.clone=function(){var e=new t;return e._ranges=o.object.clone(this._ranges),e},t.isIndex=function(e){return e instanceof t},t.create=function(e){var r=new t;return t.apply(r,e),r},t.prototype.size=function l(){for(var l=[],e=0,r=this._ranges.length;r>e;e++){var n=this._ranges[e];l[e]=n.size()[0]}return l},t.prototype.max=function(){for(var e=[],r=0,n=this._ranges.length;n>r;r++){var t=this._ranges[r];e[r]=t.max()}return e},t.prototype.min=function(){for(var e=[],r=0,n=this._ranges.length;n>r;r++){var t=this._ranges[r];e[r]=t.min()}return e},t.prototype.forEach=function(e){for(var r=0,n=this._ranges.length;n>r;r++)e(this._ranges[r],r,this)},t.prototype.range=function(e){return this._ranges[e]||null},t.prototype.isScalar=function(){for(var e=this.size(),r=0,n=e.length;n>r;r++)if(1!==e[r])return!1;return!0},t.prototype.toArray=function(){for(var e=[],r=0,n=this._ranges.length;n>r;r++){var t=this._ranges[r],i=[],o=t.start,a=t.end,s=t.step;if(s>0)for(;a>o;)i.push(o),o+=s;else if(0>s)for(;o>a;)i.push(o),o+=s;e.push(i)}return e},t.prototype.valueOf=t.prototype.toArray,t.prototype.toString=function(){for(var e=[],r=0,n=this._ranges.length;n>r;r++){var t=this._ranges[r],i=s.format(t.start);1!=t.step&&(i+=":"+s.format(t.step)),i+=":"+s.format(t.end),e.push(i)}return"["+e.join(", ")+"]"},e.exports=t,r.isIndex=t.isIndex,r.create=t.create},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(e instanceof t)this._data=e.clone()._data;else if(g(e))this._data=f(e);else{if(null!=e)throw new TypeError("Unsupported type of data ("+c.types.type(e)+")");this._data=[]}this._size=p.size(this._data)}function i(e,r){if(!(r instanceof l))throw new TypeError("Invalid index");var n=r.isScalar();if(n)return e.get(r.min());var i=r.size();if(i.length!=e._size.length)throw new RangeError("Dimension mismatch ("+i.length+" != "+e._size.length+")");for(var a=new t(o(e._data,r,i.length,0));g(a._data)&&1==a._data.length;)a._data=a._data[0],a._size.shift();return a}function o(e,r,n,t){var i=t==n-1,a=r.range(t);return a.map(i?function(r){return d(r,e.length),e[r]}:function(i){d(i,e.length);var a=e[i];return o(a,r,n,t+1)})}function a(e,r,n,i){if(!(r instanceof l))throw new TypeError("Invalid index");var o,a=r.size(),f=r.isScalar();if(n instanceof t?(o=n.size(),n=n.valueOf()):o=p.size(n),f){if(0!=o.length)throw new TypeError("Scalar value expected");e.set(r.min(),n,i)}else{if(a.length<e._size.length)throw new RangeError("Dimension mismatch ("+a.length+" < "+e._size.length+")");for(var c=0,g=a.length-o.length;g>c;c++)n=[n],o.unshift(1);if(!h.deepEqual(a,o))throw new RangeError("Dimensions mismatch ("+m.format(a)+" != "+m.format(o)+")");var d=r.max().map(function(e){return e+1});u(e,d,i);var x=a.length,w=0;s(e._data,r,n,x,w)}return e}function s(e,r,n,t,i){var o=i==t-1,a=r.range(i);a.forEach(o?function(r,t){d(r),e[r]=n[t]}:function(o,a){d(o),s(e[o],r,n[a],t,i+1)})}function u(e,r,n){if(!g(r))throw new Error("Array expected");for(var t=h.clone(e._size),i=!1;t.length<r.length;)t.unshift(0),i=!0;for(var o=0,a=r.length;a>o;o++)r[o]>t[o]&&(t[o]=r[o],i=!0);i&&e.resize(t,n)}function f(e){for(var r=0,n=e.length;n>r;r++){var i=e[r];g(i)?e[r]=f(i):i instanceof t&&(e[r]=f(i._data))}return e}var c=n(112),l=n(10),m=(c.number,c.string),p=c.array,h=c.object,g=Array.isArray,d=p.validateIndex;t.isMatrix=function(e){return e instanceof t},t.prototype.subset=function(e,r,n){switch(arguments.length){case 1:return i(this,e);case 2:case 3:return a(this,e,r,n);default:throw new SyntaxError("Wrong number of arguments")}},t.prototype.get=function(e){if(!g(e))throw new Error("Array expected");if(e.length!=this._size.length)throw new RangeError("Dimension mismatch ("+e.length+" != "+this._size.length+")");for(var r=this._data,n=0,t=e.length;t>n;n++){var i=e[n];d(i,r.length),r=r[i]}return h.clone(r)},t.prototype.set=function(e,r,n){var t,i;if(!g(e))throw new Error("Array expected");if(e.length<this._size.length)throw new RangeError("Dimension mismatch ("+e.length+" < "+this._size.length+")");var o=e.map(function(e){return e+1});u(this,o,n);var a=this._data;for(t=0,i=e.length-1;i>t;t++){var s=e[t];d(s,a.length),a=a[s]}return s=e[e.length-1],d(s,a.length),a[s]=r,this},t.prototype.resize=function(e,r){return this._size=h.clone(e),this._data=p.resize(this._data,this._size,r),this},t.prototype.clone=function(){var e=new t;return e._data=h.clone(this._data),e._size=h.clone(this._size),e},t.prototype.size=function(){return this._size},t.prototype.map=function(e){var r=this,n=new t,i=[],o=function(n,t){return g(n)?n.map(function(e,r){return i[t]=r,o(e,t+1)}):e(n,i,r)};return n._data=o(this._data,0),n._size=h.clone(this._size),n},t.prototype.forEach=function(e){var r=this,n=[],t=function(i,o){g(i)?i.forEach(function(e,r){n[o]=r,t(e,o+1)}):e(i,n,r)};t(this._data,0)},t.prototype.toArray=function(){return h.clone(this._data)},t.prototype.valueOf=function(){return this._data},t.prototype.format=function(e){return m.format(this._data,e)},t.prototype.toString=function(){return m.format(this._data)},e.exports=t,r.isMatrix=t.isMatrix},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new Error("Constructor must be called with the new operator");if(null!=e&&!w(e))throw new TypeError("First parameter in Unit constructor must be a number");if(null!=r&&!v(r))throw new TypeError("Second parameter in Unit constructor must be a string");if(null!=r){var n=l(r);if(!n)throw new SyntaxError('Unknown unit "'+r+'"');this.unit=n.unit,this.prefix=n.prefix}else this.unit=UNIT_NONE,this.prefix=b;null!=e?(this.value=this._normalize(e),this.fixPrefix=!1):(this.value=null,this.fixPrefix=!0)}function i(){for(;" "==h||"	"==h;)s()}function o(e){return e>="0"&&"9">=e||"."==e}function a(e){return e>="0"&&"9">=e}function s(){p++,h=m.charAt(p)}function u(e){p=e,h=m.charAt(p)}function f(){var e,r="";if(e=p,"+"==h?s():"-"==h&&(r+=h,s()),!o(h))return u(e),null;if("."==h){if(r+=h,s(),!a(h))return u(e),null}else{for(;a(h);)r+=h,s();"."==h&&(r+=h,s())}for(;a(h);)r+=h,s();if("E"==h||"e"==h){if(r+=h,s(),("+"==h||"-"==h)&&(r+=h,s()),!a(h))return u(e),null;for(;a(h);)r+=h,s()}return r}function c(){var e="";for(i();h&&" "!=h&&"	"!=h;)e+=h,s();return e||null}function l(e){for(var r in N)if(N.hasOwnProperty(r)&&x.endsWith(e,r)){var n=N[r],t=e.length-r.length,i=e.substring(0,t),o=n.prefixes[i];if(void 0!==o)return{unit:n,prefix:o}}return null}var m,p,h,g=n(112),d=g.number,x=g.string,w=g.number.isNumber,v=g.string.isString;t.parse=function(e){if(m=e,p=-1,h="",!v(m))return null;s(),i();var r,n=f();return n?(r=c(),s(),i(),h?null:n&&r?new t(Number(n),r):null):(r=c(),s(),i(),h?null:new t(null,r))},t.isUnit=function(e){return e instanceof t},t.prototype.clone=function(){var e=new t;for(var r in this)this.hasOwnProperty(r)&&(e[r]=this[r]);return e},t.prototype._normalize=function(e){return(e+this.unit.offset)*this.unit.value*this.prefix.value},t.prototype._unnormalize=function(e,r){return void 0==r?e/this.unit.value/this.prefix.value-this.unit.offset:e/this.unit.value/r-this.unit.offset},t.isPlainUnit=function(e){return null!=l(e)},t.prototype.hasBase=function(e){return void 0===this.unit.base?void 0===e:this.unit.base===e},t.prototype.equalBase=function(e){return this.unit.base===e.unit.base},t.prototype.equals=function(e){return this.equalBase(e)&&this.value==e.value},t.prototype.to=function(e){var r;if(v(e)){if(r=new t(null,e),!this.equalBase(r))throw new Error("Units do not match");return r.value=this.value,r}if(e instanceof t){if(!this.equalBase(e))throw new Error("Units do not match");if(null!=e.value)throw new Error("Cannot convert to a unit with a value");if(null==e.unit)throw new Error("Unit expected on the right hand side of function in");return r=e.clone(),r.value=this.value,r.fixPrefix=!0,r}throw new Error("String or Unit expected as parameter")},t.prototype.toNumber=function(e){var r=this.to(e),n=this.fixPrefix?r._bestPrefix():r.prefix;return r._unnormalize(r.value,n.value)},t.prototype.toString=function(){return this.format()},t.prototype.format=function(e){var r,n;if(this.fixPrefix)r=this._unnormalize(this.value),n=null!=this.value?d.format(r,e)+" ":"",n+=this.prefix.name+this.unit.name;else{var t=this._bestPrefix();r=this._unnormalize(this.value,t.value),n=null!=this.value?d.format(r,e)+" ":"",n+=t.name+this.unit.name}return n},t.prototype._bestPrefix=function(){var e=Math.abs(this.value/this.unit.value),r=b,n=Math.abs(Math.log(e/r.value)/Math.LN10-1.2),t=this.unit.prefixes;for(var i in t)if(t.hasOwnProperty(i)){var o=t[i];if(o.scientific){var a=Math.abs(Math.log(e/o.value)/Math.LN10-1.2);n>a&&(r=o,n=a)}}return r};var y={NONE:{"":{name:"",value:1,scientific:!0}},SHORT:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:10,scientific:!1},h:{name:"h",value:100,scientific:!1},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},d:{name:"d",value:.1,scientific:!1},c:{name:"c",value:.01,scientific:!1},m:{name:"m",value:.001,scientific:!0},u:{name:"u",value:1e-6,scientific:!0},n:{name:"n",value:1e-9,scientific:!0},p:{name:"p",value:1e-12,scientific:!0},f:{name:"f",value:1e-15,scientific:!0},a:{name:"a",value:1e-18,scientific:!0},z:{name:"z",value:1e-21,scientific:!0},y:{name:"y",value:1e-24,scientific:!0}},LONG:{"":{name:"",value:1,scientific:!0},deca:{name:"deca",value:10,scientific:!1},hecto:{name:"hecto",value:100,scientific:!1},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},deci:{name:"deci",value:.1,scientific:!1},centi:{name:"centi",value:.01,scientific:!1},milli:{name:"milli",value:.001,scientific:!0},micro:{name:"micro",value:1e-6,scientific:!0},nano:{name:"nano",value:1e-9,scientific:!0},pico:{name:"pico",value:1e-12,scientific:!0},femto:{name:"femto",value:1e-15,scientific:!0},atto:{name:"atto",value:1e-18,scientific:!0},zepto:{name:"zepto",value:1e-21,scientific:!0},yocto:{name:"yocto",value:1e-24,scientific:!0}},SQUARED:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:100,scientific:!1},h:{name:"h",value:1e4,scientific:!1},k:{name:"k",value:1e6,scientific:!0},M:{name:"M",value:1e12,scientific:!0},G:{name:"G",value:1e18,scientific:!0},T:{name:"T",value:1e24,scientific:!0},P:{name:"P",value:1e30,scientific:!0},E:{name:"E",value:1e36,scientific:!0},Z:{name:"Z",value:1e42,scientific:!0},Y:{name:"Y",value:1e48,scientific:!0},d:{name:"d",value:.01,scientific:!1},c:{name:"c",value:1e-4,scientific:!1},m:{name:"m",value:1e-6,scientific:!0},u:{name:"u",value:1e-12,scientific:!0},n:{name:"n",value:1e-18,scientific:!0},p:{name:"p",value:1e-24,scientific:!0},f:{name:"f",value:1e-30,scientific:!0},a:{name:"a",value:1e-36,scientific:!0},z:{name:"z",value:1e-42,scientific:!0},y:{name:"y",value:1e-42,scientific:!0}},CUBIC:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:1e3,scientific:!1},h:{name:"h",value:1e6,scientific:!1},k:{name:"k",value:1e9,scientific:!0},M:{name:"M",value:1e18,scientific:!0},G:{name:"G",value:1e27,scientific:!0},T:{name:"T",value:1e36,scientific:!0},P:{name:"P",value:1e45,scientific:!0},E:{name:"E",value:1e54,scientific:!0},Z:{name:"Z",value:1e63,scientific:!0},Y:{name:"Y",value:1e72,scientific:!0},d:{name:"d",value:.001,scientific:!1},c:{name:"c",value:1e-6,scientific:!1},m:{name:"m",value:1e-9,scientific:!0},u:{name:"u",value:1e-18,scientific:!0},n:{name:"n",value:1e-27,scientific:!0},p:{name:"p",value:1e-36,scientific:!0},f:{name:"f",value:1e-45,scientific:!0},a:{name:"a",value:1e-54,scientific:!0},z:{name:"z",value:1e-63,scientific:!0},y:{name:"y",value:1e-72,scientific:!0}},BINARY_SHORT:{"":{name:"",value:1,scientific:!0},k:{name:"k",value:1024,scientific:!0},M:{name:"M",value:Math.pow(1024,2),scientific:!0},G:{name:"G",value:Math.pow(1024,3),scientific:!0},T:{name:"T",value:Math.pow(1024,4),scientific:!0},P:{name:"P",value:Math.pow(1024,5),scientific:!0},E:{name:"E",value:Math.pow(1024,6),scientific:!0},Z:{name:"Z",value:Math.pow(1024,7),scientific:!0},Y:{name:"Y",value:Math.pow(1024,8),scientific:!0},Ki:{name:"Ki",value:1024,scientific:!0},Mi:{name:"Mi",value:Math.pow(1024,2),scientific:!0},Gi:{name:"Gi",value:Math.pow(1024,3),scientific:!0},Ti:{name:"Ti",value:Math.pow(1024,4),scientific:!0},Pi:{name:"Pi",value:Math.pow(1024,5),scientific:!0},Ei:{name:"Ei",value:Math.pow(1024,6),scientific:!0},Zi:{name:"Zi",value:Math.pow(1024,7),scientific:!0},Yi:{name:"Yi",value:Math.pow(1024,8),scientific:!0}},BINARY_LONG:{"":{name:"",value:1,scientific:!0},kilo:{name:"kilo",value:1024,scientific:!0},mega:{name:"mega",value:Math.pow(1024,2),scientific:!0},giga:{name:"giga",value:Math.pow(1024,3),scientific:!0},tera:{name:"tera",value:Math.pow(1024,4),scientific:!0},peta:{name:"peta",value:Math.pow(1024,5),scientific:!0},exa:{name:"exa",value:Math.pow(1024,6),scientific:!0},zetta:{name:"zetta",value:Math.pow(1024,7),scientific:!0},yotta:{name:"yotta",value:Math.pow(1024,8),scientific:!0},kibi:{name:"kibi",value:1024,scientific:!0},mebi:{name:"mebi",value:Math.pow(1024,2),scientific:!0},gibi:{name:"gibi",value:Math.pow(1024,3),scientific:!0},tebi:{name:"tebi",value:Math.pow(1024,4),scientific:!0},pebi:{name:"pebi",value:Math.pow(1024,5),scientific:!0},exi:{name:"exi",value:Math.pow(1024,6),scientific:!0},zebi:{name:"zebi",value:Math.pow(1024,7),scientific:!0},yobi:{name:"yobi",value:Math.pow(1024,8),scientific:!0}}},b={name:"",value:1,scientific:!0},E={NONE:{},LENGTH:{},MASS:{},TIME:{},CURRENT:{},TEMPERATURE:{},LUMINOUS_INTENSITY:{},AMOUNT_OF_SUBSTANCE:{},FORCE:{},SURFACE:{},VOLUME:{},ANGLE:{},BIT:{}};BASE_UNIT_NONE={},UNIT_NONE={name:"",base:BASE_UNIT_NONE,value:1,offset:0};
var N={meter:{name:"meter",base:E.LENGTH,prefixes:y.LONG,value:1,offset:0},inch:{name:"inch",base:E.LENGTH,prefixes:y.NONE,value:.0254,offset:0},foot:{name:"foot",base:E.LENGTH,prefixes:y.NONE,value:.3048,offset:0},yard:{name:"yard",base:E.LENGTH,prefixes:y.NONE,value:.9144,offset:0},mile:{name:"mile",base:E.LENGTH,prefixes:y.NONE,value:1609.344,offset:0},link:{name:"link",base:E.LENGTH,prefixes:y.NONE,value:.201168,offset:0},rod:{name:"rod",base:E.LENGTH,prefixes:y.NONE,value:5.02921,offset:0},chain:{name:"chain",base:E.LENGTH,prefixes:y.NONE,value:20.1168,offset:0},angstrom:{name:"angstrom",base:E.LENGTH,prefixes:y.NONE,value:1e-10,offset:0},m:{name:"m",base:E.LENGTH,prefixes:y.SHORT,value:1,offset:0},"in":{name:"in",base:E.LENGTH,prefixes:y.NONE,value:.0254,offset:0},ft:{name:"ft",base:E.LENGTH,prefixes:y.NONE,value:.3048,offset:0},yd:{name:"yd",base:E.LENGTH,prefixes:y.NONE,value:.9144,offset:0},mi:{name:"mi",base:E.LENGTH,prefixes:y.NONE,value:1609.344,offset:0},li:{name:"li",base:E.LENGTH,prefixes:y.NONE,value:.201168,offset:0},rd:{name:"rd",base:E.LENGTH,prefixes:y.NONE,value:5.02921,offset:0},ch:{name:"ch",base:E.LENGTH,prefixes:y.NONE,value:20.1168,offset:0},mil:{name:"mil",base:E.LENGTH,prefixes:y.NONE,value:254e-7,offset:0},m2:{name:"m2",base:E.SURFACE,prefixes:y.SQUARED,value:1,offset:0},sqin:{name:"sqin",base:E.SURFACE,prefixes:y.NONE,value:64516e-8,offset:0},sqft:{name:"sqft",base:E.SURFACE,prefixes:y.NONE,value:.09290304,offset:0},sqyd:{name:"sqyd",base:E.SURFACE,prefixes:y.NONE,value:.83612736,offset:0},sqmi:{name:"sqmi",base:E.SURFACE,prefixes:y.NONE,value:2589988.110336,offset:0},sqrd:{name:"sqrd",base:E.SURFACE,prefixes:y.NONE,value:25.29295,offset:0},sqch:{name:"sqch",base:E.SURFACE,prefixes:y.NONE,value:404.6873,offset:0},sqmil:{name:"sqmil",base:E.SURFACE,prefixes:y.NONE,value:6.4516e-10,offset:0},m3:{name:"m3",base:E.VOLUME,prefixes:y.CUBIC,value:1,offset:0},L:{name:"L",base:E.VOLUME,prefixes:y.SHORT,value:.001,offset:0},l:{name:"l",base:E.VOLUME,prefixes:y.SHORT,value:.001,offset:0},litre:{name:"litre",base:E.VOLUME,prefixes:y.LONG,value:.001,offset:0},cuin:{name:"cuin",base:E.VOLUME,prefixes:y.NONE,value:16387064e-12,offset:0},cuft:{name:"cuft",base:E.VOLUME,prefixes:y.NONE,value:.028316846592,offset:0},cuyd:{name:"cuyd",base:E.VOLUME,prefixes:y.NONE,value:.764554857984,offset:0},teaspoon:{name:"teaspoon",base:E.VOLUME,prefixes:y.NONE,value:5e-6,offset:0},tablespoon:{name:"tablespoon",base:E.VOLUME,prefixes:y.NONE,value:15e-6,offset:0},minim:{name:"minim",base:E.VOLUME,prefixes:y.NONE,value:6.161152e-8,offset:0},fluiddram:{name:"fluiddram",base:E.VOLUME,prefixes:y.NONE,value:36966911e-13,offset:0},fluidounce:{name:"fluidounce",base:E.VOLUME,prefixes:y.NONE,value:2957353e-11,offset:0},gill:{name:"gill",base:E.VOLUME,prefixes:y.NONE,value:.0001182941,offset:0},cc:{name:"cc",base:E.VOLUME,prefixes:y.NONE,value:1e-6,offset:0},cup:{name:"cup",base:E.VOLUME,prefixes:y.NONE,value:.0002365882,offset:0},pint:{name:"pint",base:E.VOLUME,prefixes:y.NONE,value:.0004731765,offset:0},quart:{name:"quart",base:E.VOLUME,prefixes:y.NONE,value:.0009463529,offset:0},gallon:{name:"gallon",base:E.VOLUME,prefixes:y.NONE,value:.003785412,offset:0},beerbarrel:{name:"beerbarrel",base:E.VOLUME,prefixes:y.NONE,value:.1173478,offset:0},oilbarrel:{name:"oilbarrel",base:E.VOLUME,prefixes:y.NONE,value:.1589873,offset:0},hogshead:{name:"hogshead",base:E.VOLUME,prefixes:y.NONE,value:.238481,offset:0},fldr:{name:"fldr",base:E.VOLUME,prefixes:y.NONE,value:36966911e-13,offset:0},floz:{name:"floz",base:E.VOLUME,prefixes:y.NONE,value:2957353e-11,offset:0},gi:{name:"gi",base:E.VOLUME,prefixes:y.NONE,value:.0001182941,offset:0},cp:{name:"cp",base:E.VOLUME,prefixes:y.NONE,value:.0002365882,offset:0},pt:{name:"pt",base:E.VOLUME,prefixes:y.NONE,value:.0004731765,offset:0},qt:{name:"qt",base:E.VOLUME,prefixes:y.NONE,value:.0009463529,offset:0},gal:{name:"gal",base:E.VOLUME,prefixes:y.NONE,value:.003785412,offset:0},bbl:{name:"bbl",base:E.VOLUME,prefixes:y.NONE,value:.1173478,offset:0},obl:{name:"obl",base:E.VOLUME,prefixes:y.NONE,value:.1589873,offset:0},g:{name:"g",base:E.MASS,prefixes:y.SHORT,value:.001,offset:0},gram:{name:"gram",base:E.MASS,prefixes:y.LONG,value:.001,offset:0},ton:{name:"ton",base:E.MASS,prefixes:y.SHORT,value:907.18474,offset:0},tonne:{name:"tonne",base:E.MASS,prefixes:y.SHORT,value:1e3,offset:0},grain:{name:"grain",base:E.MASS,prefixes:y.NONE,value:6479891e-11,offset:0},dram:{name:"dram",base:E.MASS,prefixes:y.NONE,value:.0017718451953125,offset:0},ounce:{name:"ounce",base:E.MASS,prefixes:y.NONE,value:.028349523125,offset:0},poundmass:{name:"poundmass",base:E.MASS,prefixes:y.NONE,value:.45359237,offset:0},hundredweight:{name:"hundredweight",base:E.MASS,prefixes:y.NONE,value:45.359237,offset:0},stick:{name:"stick",base:E.MASS,prefixes:y.NONE,value:.115,offset:0},gr:{name:"gr",base:E.MASS,prefixes:y.NONE,value:6479891e-11,offset:0},dr:{name:"dr",base:E.MASS,prefixes:y.NONE,value:.0017718451953125,offset:0},oz:{name:"oz",base:E.MASS,prefixes:y.NONE,value:.028349523125,offset:0},lbm:{name:"lbm",base:E.MASS,prefixes:y.NONE,value:.45359237,offset:0},cwt:{name:"cwt",base:E.MASS,prefixes:y.NONE,value:45.359237,offset:0},s:{name:"s",base:E.TIME,prefixes:y.SHORT,value:1,offset:0},min:{name:"min",base:E.TIME,prefixes:y.NONE,value:60,offset:0},h:{name:"h",base:E.TIME,prefixes:y.NONE,value:3600,offset:0},second:{name:"second",base:E.TIME,prefixes:y.LONG,value:1,offset:0},sec:{name:"sec",base:E.TIME,prefixes:y.LONG,value:1,offset:0},minute:{name:"minute",base:E.TIME,prefixes:y.NONE,value:60,offset:0},hour:{name:"hour",base:E.TIME,prefixes:y.NONE,value:3600,offset:0},day:{name:"day",base:E.TIME,prefixes:y.NONE,value:86400,offset:0},rad:{name:"rad",base:E.ANGLE,prefixes:y.NONE,value:1,offset:0},deg:{name:"deg",base:E.ANGLE,prefixes:y.NONE,value:.017453292519943295,offset:0},grad:{name:"grad",base:E.ANGLE,prefixes:y.NONE,value:.015707963267948967,offset:0},cycle:{name:"cycle",base:E.ANGLE,prefixes:y.NONE,value:6.283185307179586,offset:0},A:{name:"A",base:E.CURRENT,prefixes:y.SHORT,value:1,offset:0},ampere:{name:"ampere",base:E.CURRENT,prefixes:y.LONG,value:1,offset:0},K:{name:"K",base:E.TEMPERATURE,prefixes:y.NONE,value:1,offset:0},degC:{name:"degC",base:E.TEMPERATURE,prefixes:y.NONE,value:1,offset:273.15},degF:{name:"degF",base:E.TEMPERATURE,prefixes:y.NONE,value:1/1.8,offset:459.67},degR:{name:"degR",base:E.TEMPERATURE,prefixes:y.NONE,value:1/1.8,offset:0},kelvin:{name:"kelvin",base:E.TEMPERATURE,prefixes:y.NONE,value:1,offset:0},celsius:{name:"celsius",base:E.TEMPERATURE,prefixes:y.NONE,value:1,offset:273.15},fahrenheit:{name:"fahrenheit",base:E.TEMPERATURE,prefixes:y.NONE,value:1/1.8,offset:459.67},rankine:{name:"rankine",base:E.TEMPERATURE,prefixes:y.NONE,value:1/1.8,offset:0},mol:{name:"mol",base:E.AMOUNT_OF_SUBSTANCE,prefixes:y.NONE,value:1,offset:0},mole:{name:"mole",base:E.AMOUNT_OF_SUBSTANCE,prefixes:y.NONE,value:1,offset:0},cd:{name:"cd",base:E.LUMINOUS_INTENSITY,prefixes:y.NONE,value:1,offset:0},candela:{name:"candela",base:E.LUMINOUS_INTENSITY,prefixes:y.NONE,value:1,offset:0},N:{name:"N",base:E.FORCE,prefixes:y.SHORT,value:1,offset:0},newton:{name:"newton",base:E.FORCE,prefixes:y.LONG,value:1,offset:0},lbf:{name:"lbf",base:E.FORCE,prefixes:y.NONE,value:4.4482216152605,offset:0},poundforce:{name:"poundforce",base:E.FORCE,prefixes:y.NONE,value:4.4482216152605,offset:0},b:{name:"b",base:E.BIT,prefixes:y.BINARY_SHORT,value:1,offset:0},bits:{name:"bits",base:E.BIT,prefixes:y.BINARY_LONG,value:1,offset:0},B:{name:"B",base:E.BIT,prefixes:y.BINARY_SHORT,value:8,offset:0},bytes:{name:"bytes",base:E.BIT,prefixes:y.BINARY_LONG,value:8,offset:0}},M={meters:"meter",inches:"inch",feet:"foot",yards:"yard",miles:"mile",links:"link",rods:"rod",chains:"chain",angstroms:"angstrom",litres:"litre",teaspoons:"teaspoon",tablespoons:"tablespoon",minims:"minim",fluiddrams:"fluiddram",fluidounces:"fluidounce",gills:"gill",cups:"cup",pints:"pint",quarts:"quart",gallons:"gallon",beerbarrels:"beerbarrel",oilbarrels:"oilbarrel",hogsheads:"hogshead",grams:"gram",tons:"ton",tonnes:"tonne",grains:"grain",drams:"dram",ounces:"ounce",poundmasses:"poundmass",hundredweights:"hundredweight",sticks:"stick",seconds:"second",minutes:"minute",hours:"hour",days:"day",radians:"rad",degrees:"deg",gradients:"grad",cycles:"cycle",amperes:"ampere",moles:"mole"};for(var A in M)if(M.hasOwnProperty(A)){var T=N[M[A]],O=Object.create(T);O.name=A,N[A]=O}N.lt=N.l,N.liter=N.litre,N.liters=N.litres,N.lb=N.lbm,t.PREFIXES=y,t.BASE_UNITS=E,t.UNITS=N,e.exports=t,r.isUnit=t.isUnit,r.isPlainUnit=t.isPlainUnit,r.parse=t.parse},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this.math=e,this.doc=r}var i=n(112),o=i.object,a=i.string;t.isHelp=function(e){return e instanceof t},t.prototype.toString=function(){var e=this.doc||{},r="\n";if(e.name&&(r+="Name: "+e.name+"\n\n"),e.category&&(r+="Category: "+e.category+"\n\n"),e.description&&(r+="Description:\n    "+e.description+"\n\n"),e.syntax&&(r+="Syntax:\n    "+e.syntax.join("\n    ")+"\n\n"),e.examples){var n=this.math.parser();r+="Examples:\n";for(var i=0;i<e.examples.length;i++){var o,s=e.examples[i];try{o=n.eval(s)}catch(u){o=u}r+="    "+s+"\n",!o||o instanceof t||(r+="        "+a.format(o)+"\n")}r+="\n"}return e.seealso&&(r+="See also: "+e.seealso.join(", ")+"\n"),r},t.prototype.toJSON=function(){return o.clone(this.doc)},e.exports=t,r.isHelp=t.isHelp},function(e,r,n){function t(e,r,n){var o,a,u,f;if(0>=r){if(s(e[0])){for(f=i(e),a=[],o=0;o<f.length;o++)a[o]=t(f[o],r-1,n);return a}for(u=e[0],o=1;o<e.length;o++)u=n(u,e[o]);return u}for(a=[],o=0;o<e.length;o++)a[o]=t(e[o],r-1,n);return a}function i(e){var r,n,t=e.length,i=e[0].length,o=[];for(n=0;i>n;n++){var a=[];for(r=0;t>r;r++)a.push(e[r][n]);o.push(a)}return o}{var o=n(112),a=n(11),s=o.array.isArray;o.string.isString}r.argsToArray=function(e){var r;return 0==e.length?r=[]:1==e.length?(r=e[0],r instanceof a&&(r=r.valueOf()),s(r)||(r=[r])):r=Array.prototype.slice.apply(e),r},r.isCollection=function(e){return s(e)||e instanceof a},r.deepMap=function u(e,r){return e&&"function"==typeof e.map?e.map(function(e){return u(e,r)}):r(e)},r.deepMap2=function f(e,r,n){var t,i,o;if(s(e))if(s(r)){if(e.length!=r.length)throw new RangeError("Dimension mismatch ("+e.length+" != "+r.length+")");for(t=[],i=e.length,o=0;i>o;o++)t[o]=f(e[o],r[o],n)}else{if(r instanceof a)return t=f(e,r.valueOf(),n),new a(t);for(t=[],i=e.length,o=0;i>o;o++)t[o]=f(e[o],r,n)}else{if(e instanceof a)return r instanceof a?(t=f(e.valueOf(),r.valueOf(),n),new a(t)):(t=f(e.valueOf(),r,n),new a(t));if(s(r))for(t=[],i=r.length,o=0;i>o;o++)t[o]=f(e,r[o],n);else{if(r instanceof a)return t=f(e,r.valueOf(),n),new a(t);t=n(e,r)}}return t},r.reduce=function(e,r,n){return e instanceof a?new a(t(e.valueOf(),r,n)):t(e,r,n)},r.deepForEach=function c(e,r){e instanceof a&&(e=e.valueOf());for(var n=0,t=e.length;t>n;n++){var i=e[n];s(i)?c(i,r):r(i)}}},function(e,r,n){e.exports=function(e){var r=(n(126),{});e.error=r,r.UnsupportedTypeError=function t(r,n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");switch(arguments.length){case 0:this.message="Unsupported type of argument";break;case 1:this.message="Unsupported type of argument in function "+r;break;case 2:var i=e["typeof"](n);this.message="Function "+r+"("+i+") not supported";break;default:var o=Array.prototype.splice.call(arguments,1),a=o.map(function(r){return e["typeof"](r)});this.message="Function "+r+"("+a.join(", ")+") not supported"}this.stack=(new Error).stack},r.UnsupportedTypeError.prototype=new TypeError,r.UnsupportedTypeError.prototype.constructor=TypeError,r.UnsupportedTypeError.prototype.name="UnsupportedTypeError",r.ArgumentsError=function i(e,r,n,t){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this.message="Wrong number of arguments in function "+e+" ("+r+" provided, "+n+(void 0!=t?"-"+t:"")+" expected)",this.stack=(new Error).stack},r.ArgumentsError.prototype=new Error,r.ArgumentsError.prototype.constructor=Error,r.ArgumentsError.prototype.name="ArgumentsError"}},function(e,r,n){e.exports=function(e){function r(e){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.value=e instanceof r?e.value:e}function t(e,n){var t=Array.prototype.slice;r.prototype[e]="function"==typeof n?function(){var e=[this.value].concat(t.call(arguments,0));return new r(n.apply(this,e))}:new r(n)}var i=n(127);r.prototype.done=function(){return this.value},r.prototype.valueOf=function(){return this.value},r.prototype.toString=function(){return i.format(this.value)},r.createProxy=t;for(var o in e)e.hasOwnProperty(o)&&t(o,e[o]);return r}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(4),i=n(14),o=r.string.isString,a=i.isCollection;e.compile=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("compile",arguments.length,1);if(o(r))return t(r).compile(e);if(a(r))return i.deepMap(r,function(r){return t(r).compile(e)});throw new TypeError("String, array, or matrix expected")}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(4),i=n(14),o=r.string.isString,a=i.isCollection;e.eval=function(r,n){if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("eval",arguments.length,1,2);if(n=n||{},o(r))return t(r).compile(e).eval(n);if(a(r))return i.deepMap(r,function(r){return t(r).compile(e).eval(n)});throw new TypeError("String, array, or matrix expected")}}},function(e,r,n){e.exports=function(e){var r=n(13);e.help=function(n){if(1!=arguments.length)throw new SyntaxError("Wrong number of arguments in function help ("+arguments.length+" provided, 1 expected)");var t=null;if(n instanceof String||"string"==typeof n)t=n;else{var i;for(i in e)if(e.hasOwnProperty(i)&&n===e[i]){t=i;break}}var o=e.expression.docs[t];if(!t||!o)throw new Error('No documentation found on "'+t+'"');return new r(e,o)}}},function(e,r,n){e.exports=function(e){var r=n(4);e.parse=function(){return r.apply(r,arguments)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=(n(11),n(14)),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.abs=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("abs",arguments.length,1);if(a(r))return Math.abs(r);if(u(r))return Math.sqrt(r.re*r.re+r.im*r.im);if(r instanceof t)return r.abs();if(f(r))return o.deepMap(r,c);if(s(r))return Math.abs(r);throw new e.error.UnsupportedTypeError("abs",r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=(n(11),n(12)),a=n(14),s=r["boolean"].isBoolean,u=r.number.isNumber,f=r.number.toNumber,c=r.number.toBigNumber,l=r.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;e.add=function g(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("add",arguments.length,2);if(u(r)){if(u(n))return r+n;if(m(n))return new i(r+n.re,n.im)}if(m(r)){if(m(n))return new i(r.re+n.re,r.im+n.im);if(u(n))return new i(r.re+n,r.im)}if(p(r)&&p(n)){if(null==r.value)throw new Error("Parameter x contains a unit with undefined value");if(null==n.value)throw new Error("Parameter y contains a unit with undefined value");if(!r.equalBase(n))throw new Error("Units do not match");var o=r.clone();return o.value+=n.value,o.fixPrefix=!1,o}if(r instanceof t)return u(n)?n=c(n):s(n)&&(n=new t(n?1:0)),n instanceof t?r.plus(n):g(f(r),n);if(n instanceof t)return u(r)?r=c(r):s(r)&&(r=new t(r?1:0)),r instanceof t?r.plus(n):g(r,f(n));if(l(r)||l(n))return r+n;if(h(r)||h(n))return a.deepMap2(r,n,g);if(s(r))return g(+r,n);if(s(n))return g(r,+n);throw new e.error.UnsupportedTypeError("add",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=o.isCollection,f=i.isComplex;e.ceil=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("ceil",arguments.length,1);if(a(r))return Math.ceil(r);if(f(r))return new i(Math.ceil(r.re),Math.ceil(r.im));if(r instanceof t)return r.ceil();if(u(r))return o.deepMap(r,c);if(s(r))return Math.ceil(r);throw new e.error.UnsupportedTypeError("ceil",r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r.number.toNumber,f=r.number.toBigNumber,c=r["boolean"].isBoolean,l=r.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;e.compare=function g(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("compare",arguments.length,2);if(s(r)&&s(n))return r>n?1:n>r?-1:0;if(r instanceof t)return s(n)?n=f(n):c(n)&&(n=new t(n?1:0)),n instanceof t?new t(r.cmp(n)):g(u(r),n);if(n instanceof t)return s(r)?r=f(r):c(r)&&(r=new t(r?1:0)),r instanceof t?new t(r.cmp(n)):g(r,u(n));if(p(r)&&p(n)){if(!r.equalBase(n))throw new Error("Cannot compare units with different base");return r.value>n.value?1:r.value<n.value?-1:0}if(l(r)||l(n))return r>n?1:n>r?-1:0;if(h(r)||h(n))return a.deepMap2(r,n,g);if(c(r))return g(+r,n);if(c(n))return g(r,+n);if(m(r)||m(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("compare",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.cube=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("cube",arguments.length,1);if(a(r))return r*r*r;if(u(r))return e.multiply(e.multiply(r,r),r);if(r instanceof t)return r.times(r).times(r);if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("cube",r)}}},function(e,r,n){e.exports=function(e){function r(e,r){var n=r.re*r.re+r.im*r.im;return 0!=n?new o((e.re*r.re+e.im*r.im)/n,(e.im*r.re-e.re*r.im)/n):new o(0!=e.re?e.re/0:0,0!=e.im?e.im/0:0)}var t=n(112),i=n(111),o=n(8),a=(n(11),n(12)),s=n(14),u=t.number.isNumber,f=t.number.toNumber,c=t.number.toBigNumber,l=t["boolean"].isBoolean,m=o.isComplex,p=a.isUnit,h=s.isCollection;e.divide=function g(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("divide",arguments.length,2);if(u(n)){if(u(t))return n/t;if(m(t))return r(new o(n,0),t)}if(m(n)){if(m(t))return r(n,t);if(u(t))return r(n,new o(t,0))}if(n instanceof i)return u(t)?t=c(t):l(t)&&(t=new i(t?1:0)),t instanceof i?n.div(t):g(f(n),t);if(t instanceof i)return u(n)?n=c(n):l(n)&&(n=new i(n?1:0)),n instanceof i?n.div(t):g(n,f(t));if(p(n)&&u(t)){var a=n.clone();return a.value/=t,a}if(h(n))return h(t)?e.multiply(n,e.inv(t)):s.deepMap2(n,t,g);if(h(t))return e.multiply(n,e.inv(t));if(l(n))return g(+n,t);if(l(t))return g(n,+t);throw new e.error.UnsupportedTypeError("divide",n,t)}}},function(e,r,n){e.exports=function(e){var r=n(14);e.edivide=function(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("edivide",arguments.length,2);return r.deepMap2(n,t,e.divide)}}},function(e,r,n){e.exports=function(e){var r=n(14);e.emultiply=function(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("emultiply",arguments.length,2);return r.deepMap2(n,t,e.multiply)}}},function(e,r,n){e.exports=function(e){var r=n(14);e.epow=function(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("epow",arguments.length,2);return r.deepMap2(n,t,e.pow)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r.number.toNumber,f=r.number.toBigNumber,c=r["boolean"].isBoolean,l=r.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;e.equal=function g(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("equal",arguments.length,2);if(s(r)){if(s(n))return r==n;if(m(n))return r==n.re&&0==n.im}if(m(r)){if(s(n))return r.re==n&&0==r.im;if(m(n))return r.re==n.re&&r.im==n.im}if(r instanceof t)return s(n)?n=f(n):c(n)&&(n=new t(n?1:0)),n instanceof t?r.eq(n):g(u(r),n);if(n instanceof t)return s(r)?r=f(r):c(r)&&(r=new t(r?1:0)),r instanceof t?r.eq(n):g(r,u(n));if(p(r)&&p(n)){if(!r.equalBase(n))throw new Error("Cannot compare units with different base");return r.value==n.value}if(l(r)||l(n))return r==n;if(h(r)||h(n))return a.deepMap2(r,n,g);if(c(r))return g(+r,n);if(c(n))return g(r,+n);throw new e.error.UnsupportedTypeError("equal",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=(n(11),n(14)),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.exp=function c(n){if(1!=arguments.length)throw new e.error.ArgumentsError("exp",arguments.length,1);if(a(n))return Math.exp(n);if(u(n)){var l=Math.exp(n.re);return new i(l*Math.cos(n.im),l*Math.sin(n.im))}if(n instanceof t)return c(r.number.toNumber(n));if(f(n))return o.deepMap(n,c);if(s(n))return Math.exp(n);throw new e.error.UnsupportedTypeError("exp",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.fix=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("fix",arguments.length,1);if(a(r))return r>0?Math.floor(r):Math.ceil(r);if(u(r))return new i(r.re>0?Math.floor(r.re):Math.ceil(r.re),r.im>0?Math.floor(r.im):Math.ceil(r.im));if(r instanceof t)return r.isNegative()?r.ceil():r.floor();if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("fix",r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.floor=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("floor",arguments.length,1);if(a(r))return Math.floor(r);if(u(r))return new i(Math.floor(r.re),Math.floor(r.im));if(r instanceof t)return r.floor();if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("floor",r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(14),o=r.number.isNumber,a=r.number.toNumber,s=r["boolean"].isBoolean,u=r.number.isInteger,f=i.isCollection;e.gcd=function c(){var r,n=arguments[0],l=arguments[1];if(2==arguments.length){if(o(n)&&o(l)){if(!u(n)||!u(l))throw new Error("Parameters in function gcd must be integer numbers");for(;0!=l;)r=n%l,n=l,l=r;return 0>n?-n:n}if(f(n)||f(l))return i.deepMap2(n,l,c);if(n instanceof t)return c(a(n),l);if(l instanceof t)return c(n,a(l));if(s(n))return c(+n,l);if(s(l))return c(n,+l);throw new e.error.UnsupportedTypeError("gcd",n,l)}if(arguments.length>2){for(var m=1;m<arguments.length;m++)n=c(n,arguments[m]);return n}throw new SyntaxError("Function gcd expects two or more arguments")}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r.number.toNumber,f=r.number.toBigNumber,c=r["boolean"].isBoolean,l=r.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;e.larger=function g(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("larger",arguments.length,2);if(s(r)&&s(n))return r>n;if(r instanceof t)return s(n)?n=f(n):c(n)&&(n=new t(n?1:0)),n instanceof t?r.gt(n):g(u(r),n);if(n instanceof t)return s(r)?r=f(r):c(r)&&(r=new t(r?1:0)),r instanceof t?r.gt(n):g(r,u(n));if(p(r)&&p(n)){if(!r.equalBase(n))throw new Error("Cannot compare units with different base");return r.value>n.value}if(l(r)||l(n))return r>n;if(h(r)||h(n))return a.deepMap2(r,n,g);if(c(r))return g(+r,n);if(c(n))return g(r,+n);if(m(r)||m(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("larger",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r.number.toNumber,f=r.number.toBigNumber,c=r["boolean"].isBoolean,l=r.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;e.largereq=function g(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("largereq",arguments.length,2);if(s(r)&&s(n))return r>=n;if(r instanceof t)return s(n)?n=f(n):c(n)&&(n=new t(n?1:0)),n instanceof t?r.gte(n):g(u(r),n);if(n instanceof t)return s(r)?r=f(r):c(r)&&(r=new t(r?1:0)),r instanceof t?r.gte(n):g(r,u(n));if(p(r)&&p(n)){if(!r.equalBase(n))throw new Error("Cannot compare units with different base");return r.value>=n.value}if(l(r)||l(n))return r>=n;if(h(r)||h(n))return a.deepMap2(r,n,g);if(c(r))return g(+r,n);if(c(n))return g(r,+n);if(m(r)||m(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("largereq",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(14),o=r.number.isNumber,a=r.number.toNumber,s=r["boolean"].isBoolean,u=r.number.isInteger,f=i.isCollection;e.lcm=function c(){var r,n=arguments[0],l=arguments[1];if(2==arguments.length){if(o(n)&&o(l)){if(!u(n)||!u(l))throw new Error("Parameters in function lcm must be integer numbers");if(0==n||0==l)return 0;for(var m=n*l;0!=l;)r=l,l=n%r,n=r;return Math.abs(m/n)}if(f(n)||f(l))return i.deepMap2(n,l,c);if(s(n))return c(+n,l);if(s(l))return c(n,+l);if(n instanceof t)return c(a(n),l);if(l instanceof t)return c(n,a(l));throw new e.error.UnsupportedTypeError("lcm",n,l)}if(arguments.length>2){for(var p=1;p<arguments.length;p++)n=c(n,arguments[p]);return n}throw new SyntaxError("Function lcm expects two or more arguments")}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.log=function c(n,l){if(1==arguments.length){if(a(n))return n>=0?Math.log(n):c(new i(n,0));if(u(n))return new i(Math.log(Math.sqrt(n.re*n.re+n.im*n.im)),Math.atan2(n.im,n.re));if(n instanceof t)return c(r.number.toNumber(n));if(f(n))return o.deepMap(n,c);if(s(n))return c(+n);throw new e.error.UnsupportedTypeError("log",n)}if(2==arguments.length)return e.divide(c(n),c(l));throw new e.error.ArgumentsError("log",arguments.length,1,2)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.log10=function c(n){if(1!=arguments.length)throw new e.error.ArgumentsError("log10",arguments.length,1);if(a(n))return n>=0?Math.log(n)/Math.LN10:c(new i(n,0));if(n instanceof t)return c(r.number.toNumber(n));if(u(n))return new i(Math.log(Math.sqrt(n.re*n.re+n.im*n.im))/Math.LN10,Math.atan2(n.im,n.re)/Math.LN10);if(f(n))return o.deepMap(n,c);if(s(n))return c(+n);throw new e.error.UnsupportedTypeError("log10",n)}}},function(e,r,n){e.exports=function(e){function r(e,r){if(r>0)return e>0?e%r:0==e?0:e-r*Math.floor(e/r);if(0==r)return e;throw new Error("Cannot calculate mod for a negative divisor")}var t=n(112),i=n(111),o=n(14),a=t.number.isNumber,s=t.number.toNumber,u=t.number.toBigNumber,f=t["boolean"].isBoolean,c=o.isCollection;e.mod=function l(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("mod",arguments.length,2);if(a(n)&&a(t))return r(n,t);if(n instanceof i)return a(t)?t=u(t):f(t)&&(t=new i(t?1:0)),t instanceof i?n.mod(t):l(s(n),t);if(t instanceof i)return a(n)?n=u(n):f(n)&&(n=new i(n?1:0)),n instanceof i?n.mod(t):l(n,s(t));if(c(n)||c(t))return o.deepMap2(n,t,l);if(f(n))return l(+n,t);if(f(t))return l(n,+t);throw new e.error.UnsupportedTypeError("mod",n,t)}}},function(e,r,n){e.exports=function(e){function r(r,n){for(var t=[],i=r.length,o=n[0].length,a=r[0].length,s=0;i>s;s++){t[s]=[];for(var u=0;o>u;u++){for(var f=null,c=0;a>c;c++){var l=e.multiply(r[s][c],n[c][u]);f=null===f?l:e.add(f,l)}t[s][u]=f}}return t}function t(r,n){for(var t=[],i=n.length,o=n[0].length,a=0;o>a;a++){for(var s=null,u=0;i>u;u++){var f=e.multiply(r[u],n[u][a]);s=0===u?f:e.add(s,f)}t[a]=s}return t}function i(r,n){for(var t=[],i=r.length,o=r[0].length,a=0;i>a;a++){for(var s=null,u=0;o>u;u++){var f=e.multiply(r[a][u],n[u]);s=0===u?f:e.add(s,f)}t[a]=s}return t}function o(r,n){var t=r.length;if(!t)throw new Error("Cannot multiply two empty vectors");for(var i=0,o=0;t>o;o++)i=e.add(i,e.multiply(r[o],n[o]));return i}function a(e,r){return 0==e.im?0==r.im?new f(e.re*r.re,0):0==r.re?new f(0,e.re*r.im):new f(e.re*r.re,e.re*r.im):0==e.re?0==r.im?new f(0,e.im*r.re):0==r.re?new f(-e.im*r.im,0):new f(-e.im*r.im,e.im*r.re):0==r.im?new f(e.re*r.re,e.im*r.re):0==r.re?new f(-e.im*r.im,e.re*r.im):new f(e.re*r.re-e.im*r.im,e.re*r.im+e.im*r.re)}var s=n(112),u=n(111),f=n(8),c=n(11),l=n(12),m=n(14),p=s.array,h=s.number.isNumber,g=s.number.toNumber,d=s.number.toBigNumber,x=s["boolean"].isBoolean,w=f.isComplex,v=Array.isArray,y=l.isUnit;e.multiply=function b(n,s){if(2!=arguments.length)throw new e.error.ArgumentsError("multiply",arguments.length,2);if(h(n)){if(h(s))return n*s;if(w(s))return a(new f(n,0),s);if(y(s))return res=s.clone(),res.value*=n,res}if(w(n)){if(h(s))return a(n,new f(s,0));if(w(s))return a(n,s)}if(n instanceof u)return h(s)?s=d(s):x(s)&&(s=new u(s?1:0)),s instanceof u?n.times(s):b(g(n),s);if(s instanceof u)return h(n)?n=d(n):x(n)&&(n=new u(n?1:0)),n instanceof u?n.times(s):b(n,g(s));if(y(n)&&h(s))return res=n.clone(),res.value*=s,res;if(v(n)){if(v(s)){var l=p.size(n),E=p.size(s);if(1==l.length){if(1==E.length){if(l[0]!=E[0])throw new RangeError("Dimensions mismatch in multiplication. Length of A must match length of B (A is "+l[0]+", B is "+E[0]+l[0]+" != "+E[0]+")");return o(n,s)}if(2==E.length){if(l[0]!=E[0])throw new RangeError("Dimensions mismatch in multiplication. Length of A must match rows of B (A is "+l[0]+", B is "+E[0]+"x"+E[1]+", "+l[0]+" != "+E[0]+")");return t(n,s)}throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has "+E.length+" dimensions)")}if(2==l.length){if(1==E.length){if(l[1]!=E[0])throw new RangeError("Dimensions mismatch in multiplication. Columns of A must match length of B (A is "+l[0]+"x"+l[0]+", B is "+E[0]+", "+l[1]+" != "+E[0]+")");return i(n,s)}if(2==E.length){if(l[1]!=E[0])throw new RangeError("Dimensions mismatch in multiplication. Columns of A must match rows of B (A is "+l[0]+"x"+l[1]+", B is "+E[0]+"x"+E[1]+", "+l[1]+" != "+E[0]+")");return r(n,s)}throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has "+E.length+" dimensions)")}throw new Error("Can only multiply a 1 or 2 dimensional matrix (A has "+l.length+" dimensions)")}return s instanceof c?new c(b(n,s.valueOf())):m.deepMap2(n,s,b)}if(n instanceof c)return new c(s instanceof c?b(n.valueOf(),s.valueOf()):b(n.valueOf(),s));if(v(s))return m.deepMap2(n,s,b);if(s instanceof c)return new c(m.deepMap2(n,s.valueOf(),b));if(x(n))return b(+n,s);if(x(s))return b(n,+s);throw new e.error.UnsupportedTypeError("multiply",n,s)}}},function(e,r,n){e.exports=function(e){function r(r,n){var t=e.log(r),i=e.multiply(t,n);return e.exp(i)}var t=n(112),i=n(111),o=n(8),a=n(11),s=(n(14),t.array),u=t.number.isNumber,f=t.number.toNumber,c=t.number.toBigNumber,l=t["boolean"].isBoolean,m=Array.isArray,p=t.number.isInteger,h=o.isComplex;e.pow=function g(n,t){if(2!=arguments.length)throw new e.error.ArgumentsError("pow",arguments.length,2);if(u(n)){if(u(t))return p(t)||n>=0?Math.pow(n,t):r(new o(n,0),new o(t,0));if(h(t))return r(new o(n,0),t)}if(h(n)){if(u(t))return r(n,new o(t,0));if(h(t))return r(n,t)}if(n instanceof i)return u(t)?t=c(t):l(t)&&(t=new i(t?1:0)),t instanceof i?n.pow(t):g(f(n),t);if(t instanceof i)return u(n)?n=c(n):l(n)&&(n=new i(n?1:0)),n instanceof i?n.pow(t):g(n,f(t));if(m(n)){if(!u(t)||!p(t)||0>t)throw new TypeError("For A^b, b must be a positive integer (value is "+t+")");var d=s.size(n);if(2!=d.length)throw new Error("For A^b, A must be 2 dimensional (A has "+d.length+" dimensions)");if(d[0]!=d[1])throw new Error("For A^b, A must be square (size is "+d[0]+"x"+d[1]+")");for(var x=e.eye(d[0]).valueOf(),w=n;t>=1;)1==(1&t)&&(x=e.multiply(w,x)),t>>=1,w=e.multiply(w,w);return x}if(n instanceof a)return new a(g(n.valueOf(),t));if(l(n))return g(+n,t);if(l(t))return g(n,+t);throw new e.error.UnsupportedTypeError("pow",n,t)}}},function(e,r,n){e.exports=function(e){function r(e,r){var n=Math.pow(10,r);return Math.round(e*n)/n}var t=n(112),i=n(111),o=n(8),a=n(14),s=t.number.isNumber,u=t.number.isInteger,f=t["boolean"].isBoolean,c=o.isComplex,l=a.isCollection;
e.round=function m(n,t){if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("round",arguments.length,1,2);if(void 0==t){if(s(n))return Math.round(n);if(c(n))return new o(Math.round(n.re),Math.round(n.im));if(n instanceof i)return n.round();if(l(n))return a.deepMap(n,m);if(f(n))return Math.round(n);throw new e.error.UnsupportedTypeError("round",n)}if(!s(t)||!u(t)){if(!(t instanceof i)){if(f(t))return m(n,+t);throw new TypeError("Number of decimals in function round must be an integer")}t=parseFloat(t.valueOf())}if(0>t||t>15)throw new Error("Number of decimals in function round must be in te range of 0-15");if(s(n))return r(n,t);if(c(n))return new o(r(n.re,t),r(n.im,t));if(n instanceof i)return n.round(t);if(l(n)||l(t))return a.deepMap2(n,t,m);if(f(n))return m(+n,t);throw new e.error.UnsupportedTypeError("round",n,t)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number,s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isCollection;e.sign=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sign",arguments.length,1);if(s(r))return a.sign(r);if(f(r)){var n=Math.sqrt(r.re*r.re+r.im*r.im);return new i(r.re/n,r.im/n)}if(r instanceof t)return new t(r.cmp(0));if(c(r))return o.deepMap(r,l);if(u(r))return a.sign(r);throw new e.error.UnsupportedTypeError("sign",r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r.number.toNumber,f=r.number.toBigNumber,c=r["boolean"].isBoolean,l=r.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;e.smaller=function g(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("smaller",arguments.length,2);if(s(r)&&s(n))return n>r;if(r instanceof t)return s(n)?n=f(n):c(n)&&(n=new t(n?1:0)),n instanceof t?r.lt(n):g(u(r),n);if(n instanceof t)return s(r)?r=f(r):c(r)&&(r=new t(r?1:0)),r instanceof t?r.lt(n):g(r,u(n));if(p(r)&&p(n)){if(!r.equalBase(n))throw new Error("Cannot compare units with different base");return r.value<n.value}if(l(r)||l(n))return n>r;if(h(r)||h(n))return a.deepMap2(r,n,g);if(c(r))return g(+r,n);if(c(n))return g(r,+n);if(m(r)||m(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("smaller",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r.number.toNumber,f=r.number.toBigNumber,c=r["boolean"].isBoolean,l=r.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;e.smallereq=function g(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("smallereq",arguments.length,2);if(s(r)&&s(n))return n>=r;if(r instanceof t)return s(n)?n=f(n):c(n)&&(n=new t(n?1:0)),n instanceof t?r.lte(n):g(u(r),n);if(n instanceof t)return s(r)?r=f(r):c(r)&&(r=new t(r?1:0)),r instanceof t?r.lte(n):g(r,u(n));if(p(r)&&p(n)){if(!r.equalBase(n))throw new Error("Cannot compare units with different base");return r.value<=n.value}if(l(r)||l(n))return n>=r;if(h(r)||h(n))return a.deepMap2(r,n,g);if(c(r))return g(+r,n);if(c(n))return g(r,+n);if(m(r)||m(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("smallereq",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.sqrt=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sqrt",arguments.length,1);if(a(r))return r>=0?Math.sqrt(r):c(new i(r,0));if(u(r)){var n=Math.sqrt(r.re*r.re+r.im*r.im);return r.im>=0?new i(.5*Math.sqrt(2*(n+r.re)),.5*Math.sqrt(2*(n-r.re))):new i(.5*Math.sqrt(2*(n+r.re)),-.5*Math.sqrt(2*(n-r.re)))}if(r instanceof t)return r.sqrt();if(f(r))return o.deepMap(r,c);if(s(r))return c(+r);throw new e.error.UnsupportedTypeError("sqrt",r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.square=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("square",arguments.length,1);if(a(r))return r*r;if(u(r))return e.multiply(r,r);if(r instanceof t)return r.times(r);if(f(r))return o.deepMap(r,c);if(s(r))return r*r;throw new e.error.UnsupportedTypeError("square",r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=(n(11),n(12)),a=n(14),s=r.number.toNumber,u=r.number.toBigNumber,f=r["boolean"].isBoolean,c=r.number.isNumber,l=i.isComplex,m=o.isUnit,p=a.isCollection;e.subtract=function h(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("subtract",arguments.length,2);if(c(r)){if(c(n))return r-n;if(l(n))return new i(r-n.re,-n.im)}else if(l(r)){if(c(n))return new i(r.re-n,r.im);if(l(n))return new i(r.re-n.re,r.im-n.im)}if(r instanceof t)return c(n)?n=u(n):f(n)&&(n=new t(n?1:0)),n instanceof t?r.minus(n):h(s(r),n);if(n instanceof t)return c(r)?r=u(r):f(r)&&(r=new t(r?1:0)),r instanceof t?r.minus(n):h(r,s(n));if(m(r)&&m(n)){if(null==r.value)throw new Error("Parameter x contains a unit with undefined value");if(null==n.value)throw new Error("Parameter y contains a unit with undefined value");if(!r.equalBase(n))throw new Error("Units do not match");var o=r.clone();return o.value-=n.value,o.fixPrefix=!1,o}if(p(r)||p(n))return a.deepMap2(r,n,h);if(f(r))return h(+r,n);if(f(n))return h(r,+n);throw new e.error.UnsupportedTypeError("subtract",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.unary=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("unary",arguments.length,1);if(s(r))return-r;if(f(r))return new i(-r.re,-r.im);if(r instanceof t)return r.neg();if(c(r)){var n=r.clone();return n.value=-r.value,n}if(l(r))return a.deepMap(r,m);if(u(r))return-r;throw new e.error.UnsupportedTypeError("unary",r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r.number.toNumber,f=r.number.toBigNumber,c=r["boolean"].isBoolean,l=r.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;e.unequal=function g(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("unequal",arguments.length,2);if(s(r)){if(s(n))return r!=n;if(m(n))return r!=n.re||0!=n.im}if(m(r)){if(s(n))return r.re!=n||0!=r.im;if(m(n))return r.re!=n.re||r.im!=n.im}if(r instanceof t)return s(n)?n=f(n):c(n)&&(n=new t(n?1:0)),n instanceof t?!r.eq(n):g(u(r),n);if(n instanceof t)return s(r)?r=f(r):c(r)&&(r=new t(r?1:0)),r instanceof t?!r.eq(n):g(r,u(n));if(p(r)&&p(n)){if(!r.equalBase(n))throw new Error("Cannot compare units with different base");return r.value!=n.value}if(l(r)||l(n))return r!=n;if(h(r)||h(n))return a.deepMap2(r,n,g);if(c(r))return g(+r,n);if(c(n))return g(r,+n);throw new e.error.UnsupportedTypeError("unequal",r,n)}}},function(e,r,n){e.exports=function(e){function r(e,r){for(var n,t,i,o=0,a=1,s=1,u=0;r;)t=Math.floor(e/r),i=e%r,n=o,o=a-t*o,a=n,n=s,s=u-t*s,u=n,e=r,r=i;return 0>e?[-e,-a,-u]:[e,e?a:0,u]}var t=n(112),i=n(111),o=t.number.toNumber,a=t.number.isNumber,s=t["boolean"].isBoolean,u=t.number.isInteger;e.xgcd=function f(n,t){if(2==arguments.length){if(a(n)&&a(t)){if(!u(n)||!u(t))throw new Error("Parameters in function xgcd must be integer numbers");return r(n,t)}if(n instanceof i)return f(o(n),t);if(t instanceof i)return f(n,o(t));if(s(n))return f(+n,t);if(s(t))return f(n,+t);throw new e.error.UnsupportedTypeError("xgcd",n,t)}throw new SyntaxError("Function xgcd expects two arguments")}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=o.isCollection,f=i.isComplex;e.arg=function c(n){if(1!=arguments.length)throw new e.error.ArgumentsError("arg",arguments.length,1);if(a(n))return Math.atan2(0,n);if(f(n))return Math.atan2(n.im,n.re);if(u(n))return o.deepMap(n,c);if(s(n))return c(+n);if(n instanceof t)return c(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("arg",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.object,s=r.number.isNumber,u=r["boolean"].isBoolean,f=o.isCollection,c=i.isComplex;e.conj=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("conj",arguments.length,1);return s(r)?r:r instanceof t?new t(r):c(r)?new i(r.re,-r.im):f(r)?o.deepMap(r,l):u(r)?+r:a.clone(r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.object,s=r.number.isNumber,u=r["boolean"].isBoolean,f=o.isCollection,c=i.isComplex;e.re=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("re",arguments.length,1);return s(r)?r:r instanceof t?new t(r):c(r)?r.re:f(r)?o.deepMap(r,l):u(r)?+r:a.clone(r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=o.isCollection,f=i.isComplex;e.im=function c(r){if(1!=arguments.length)throw new e.error.ArgumentsError("im",arguments.length,1);return a(r)?0:r instanceof t?new t(0):f(r)?r.im:u(r)?o.deepMap(r,c):s(r)?0:0}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(14),o=i.isCollection,a=r.number.isNumber,s=r.string.isString,u=r["boolean"].isBoolean;"function"!=typeof t.prototype.clone&&(t.prototype.clone=function(){return new t(this)}),e.bignumber=function f(r){if(arguments.length>1)throw new e.error.ArgumentsError("bignumber",arguments.length,0,1);if(r instanceof t||a(r)||s(r))return new t(r);if(u(r))return new t(+r);if(o(r))return i.deepMap(r,f);if(0==arguments.length)return new t(0);throw new e.error.UnsupportedTypeError("bignumber",r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(14),o=i.isCollection,a=r.number.isNumber,s=r.string.isString;e["boolean"]=function u(r){if(1!=arguments.length)throw new e.error.ArgumentsError("boolean",arguments.length,0,1);if("true"===r||r===!0)return!0;if("false"===r||r===!1)return!1;if(r instanceof Boolean)return 1==r;if(a(r))return 0!==r;if(r instanceof t)return!r.isZero();if(s(r)){var n=r.toLowerCase();if("true"===n)return!0;if("false"===n)return!1;var f=Number(r);if(""!=r&&!isNaN(f))return 0!==f}if(o(r))return i.deepMap(r,u);throw new SyntaxError(r.toString()+" is no valid boolean")}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=o.isCollection,s=r.number.isNumber,u=r.number.toNumber,f=r.string.isString,c=i.isComplex;e.complex=function l(){switch(arguments.length){case 0:return new i(0,0);case 1:var r=arguments[0];if(s(r))return new i(r,0);if(r instanceof t)return new i(u(r),0);if(c(r))return r.clone();if(f(r)){var n=i.parse(r);if(n)return n;throw new SyntaxError('String "'+r+'" is no valid complex number')}if(a(r))return o.deepMap(r,l);throw new TypeError("Two numbers or a single string expected in function complex");case 2:var m=arguments[0],p=arguments[1];if(m instanceof t&&(m=u(m)),p instanceof t&&(p=u(p)),s(m)&&s(p))return new i(m,p);throw new TypeError("Two numbers or a single string expected in function complex");default:throw new e.error.ArgumentsError("complex",arguments.length,0,2)}}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(10),o=r.number.toNumber;e.index=function(){var e=new i,r=Array.prototype.slice.apply(arguments).map(function(e){return e instanceof t?o(e):Array.isArray(e)?e.map(function(e){return e instanceof t?o(e):e}):e});return i.apply(e,r),e}}},function(e,r,n){e.exports=function(e){var r=n(11);e.matrix=function(n){if(arguments.length>1)throw new e.error.ArgumentsError("matrix",arguments.length,0,1);return new r(n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(14),o=i.isCollection,a=r.number.toNumber,s=r.number.isNumber,u=r["boolean"].isBoolean,f=r.string.isString;e.number=function c(r){switch(arguments.length){case 0:return 0;case 1:if(o(r))return i.deepMap(r,c);if(r instanceof t)return a(r);if(f(r)){var n=Number(r);if(isNaN(n)&&(n=Number(r.valueOf())),isNaN(n))throw new SyntaxError(r.toString()+" is no valid number");return n}if(u(r))return r+0;if(s(r))return r;throw new e.error.UnsupportedTypeError("number",r);default:throw new e.error.ArgumentsError("number",arguments.length,0,1)}}}},function(e,r,n){e.exports=function(e){var r=n(5);e.parser=function(){return new r(e)}}},function(e){e.exports=function(e){e.select=function(r){return new e.chaining.Selector(r)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(14),i=r.number,o=r.number.isNumber,a=t.isCollection;e.string=function s(r){switch(arguments.length){case 0:return"";case 1:return o(r)?i.format(r):a(r)?t.deepMap(r,s):null===r?"null":r.toString();default:throw new e.error.ArgumentsError("string",arguments.length,0,1)}}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(12),o=n(14),a=o.isCollection,s=r.number.toNumber,u=r.string.isString;e.unit=function f(r){switch(arguments.length){case 1:var n=arguments[0];if(n instanceof i)return n.clone();if(u(n)){if(i.isPlainUnit(n))return new i(null,n);var c=i.parse(n);if(c)return c;throw new SyntaxError('String "'+n+'" is no valid unit')}if(a(r))return o.deepMap(r,f);throw new TypeError("A string or a number and string expected in function unit");case 2:return arguments[0]instanceof t?new i(s(arguments[0]),arguments[1]):new i(arguments[0],arguments[1]);default:throw new e.error.ArgumentsError("unit",arguments.length,1,2)}}}},function(e,r,n){e.exports=function(e){function r(e,n,t,i){if(t>i){if(e.length!=n.length)throw new Error("Dimensions mismatch ("+e.length+" != "+n.length+")");for(var o=[],a=0;a<e.length;a++)o[a]=r(e[a],n[a],t,i+1);return o}return e.concat(n)}var t=n(112),i=n(11),o=n(14),a=t.object,s=t.array,u=t.number.isNumber,f=t.number.isInteger,c=o.isCollection;e.concat=function(){var n,t,o=arguments.length,l=-1,m=!1,p=[];for(n=0;o>n;n++){var h=arguments[n];if(h instanceof i&&(m=!0),n==o-1&&u(h)){if(t=l,l=h,!f(l)||0>l)throw new TypeError("Dimension number must be a positive integer (dim = "+l+")");if(n>0&&l>t)throw new RangeError("Dimension out of range ("+l+" > "+t+")")}else{if(!c(h))throw new e.error.UnsupportedTypeError("concat",h);var g=a.clone(h).valueOf(),d=s.size(h.valueOf());if(p[n]=g,t=l,l=d.length-1,n>0&&l!=t)throw new RangeError("Dimension mismatch ("+t+" != "+l+")")}}if(0==p.length)throw new SyntaxError("At least one matrix expected");for(var x=p.shift();p.length;)x=r(x,p.shift(),l,0);return m?new i(x):x}}},function(e,r,n){e.exports=function(e){function r(r,n,t){if(1==n)return o.clone(r[0][0]);if(2==n)return e.subtract(e.multiply(r[0][0],r[1][1]),e.multiply(r[1][0],r[0][1]));for(var i,a=1,s=0,u=0;n>u&&!(s>=t);u++){for(var f=u;0==r[f][s];)if(f++,f==n&&(f=u,s++,s==t))return o.deepEqual(r,e.eye(n).valueOf())?e.round(a,6):0;if(f!=u){for(i=0;t>i;i++){var c=r[f][i];r[f][i]=r[u][i],r[u][i]=c}a*=-1}var l=r[u][s];for(i=0;t>i;i++)r[u][i]=r[u][i]/l;a*=l;for(var m=0;n>m;m++)if(m!=u){var p=r[m][s];for(i=0;t>i;i++)r[m][i]=r[m][i]-r[u][i]*p}s++}return o.deepEqual(r,e.eye(n).valueOf())?e.round(a,6):0}var t=n(112),i=n(11),o=t.object,a=t.string;e.det=function(n){if(1!=arguments.length)throw new e.error.ArgumentsError("det",arguments.length,1);var t;switch(n instanceof i?t=n.size():n instanceof Array?(n=new i(n),t=n.size()):t=[],t.length){case 0:return o.clone(n);case 1:if(1==t[0])return o.clone(n.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+a.format(t)+")");case 2:var s=t[0],u=t[1];if(s==u)return r(n.clone().valueOf(),s,u);throw new RangeError("Matrix must be square (size: "+a.format(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+a.format(t)+")")}}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(11),i=r.object,o=r.array.isArray,a=r.number.isNumber,s=r.number.isInteger;e.diag=function(r,n){var u,f,c,l;if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("diag",arguments.length,1,2);if(n){if(!a(n)||!s(n))throw new TypeError("Second parameter in function diag must be an integer")}else n=0;var m,p=n>0?n:0,h=0>n?-n:0;if(r instanceof t)m=!1;else{if(!o(r))throw new TypeError("First parameter in function diag must be a Matrix or Array");r=new t(r),m=!0}var g=r.size();switch(g.length){case 1:f=r.valueOf();var d=new t,x=0;for(d.resize([f.length+h,f.length+p],x),u=d.valueOf(),l=f.length,c=0;l>c;c++)u[c+h][c+p]=i.clone(f[c]);return m?d.valueOf():d;case 2:for(f=[],u=r.valueOf(),l=Math.min(g[0]-h,g[1]-p),c=0;l>c;c++)f[c]=i.clone(u[c+h][c+p]);return m?f:new t(f);default:throw new RangeError("Matrix for function diag must be 2 dimensional")}}}},function(e,r,n){e.exports=function(e,r){var t=n(112),i=n(111),o=n(11),a=n(14),s=t.number.toNumber,u=t.number.isNumber,f=t.number.isInteger,c=Array.isArray;e.eye=function(n){var t=a.argsToArray(arguments),l=n instanceof o?!0:c(n)?!1:"matrix"===r.matrix;if(0==t.length)return l?new o:[];if(1==t.length)t[1]=t[0];else if(t.length>2)throw new e.error.ArgumentsError("eye",t.length,0,2);var m=t[0]instanceof i,p=t[0],h=t[1];if(p instanceof i&&(p=s(p)),h instanceof i&&(h=s(h)),!u(p)||!f(p)||1>p)throw new Error("Parameters in function eye must be positive integers");if(!u(h)||!f(h)||1>h)throw new Error("Parameters in function eye must be positive integers");var g=new o,d=m?new i(1):1,x=m?new i(0):0;g.resize(t.map(s),x);for(var w=e.min(t),v=g.valueOf(),y=0;w>y;y++)v[y][y]=d;return l?g:g.valueOf()}}},function(e,r,n){e.exports=function(e){function r(r,n,t){var i,o,a,s,u;if(1==n){if(s=r[0][0],0==s)throw Error("Cannot calculate inverse, determinant is zero");return[[e.divide(1,s)]]}if(2==n){var f=e.det(r);if(0==f)throw Error("Cannot calculate inverse, determinant is zero");return[[e.divide(r[1][1],f),e.divide(e.unary(r[0][1]),f)],[e.divide(e.unary(r[1][0]),f),e.divide(r[0][0],f)]]}var c=r.concat();for(i=0;n>i;i++)c[i]=c[i].concat();for(var l=e.eye(n).valueOf(),m=0;t>m;m++){for(i=m;n>i&&0==c[i][m];)i++;if(i==n||0==c[i][m])throw Error("Cannot calculate inverse, determinant is zero");i!=m&&(u=c[m],c[m]=c[i],c[i]=u,u=l[m],l[m]=l[i],l[i]=u);var p=c[m],h=l[m];for(i=0;n>i;i++){var g=c[i],d=l[i];if(i!=m){if(0!=g[m]){for(a=e.divide(e.unary(g[m]),p[m]),o=m;t>o;o++)g[o]=e.add(g[o],e.multiply(a,p[o]));for(o=0;t>o;o++)d[o]=e.add(d[o],e.multiply(a,h[o]))}}else{for(a=p[m],o=m;t>o;o++)g[o]=e.divide(g[o],a);for(o=0;t>o;o++)d[o]=e.divide(d[o],a)}}}return l}{var t=n(127),i=n(11);n(14)}e.inv=function(n){if(1!=arguments.length)throw new e.error.ArgumentsError("inv",arguments.length,1);var o=e.size(n).valueOf();switch(o.length){case 0:return e.divide(1,n);case 1:if(1==o[0])return n instanceof i?new i([e.divide(1,n.valueOf()[0])]):[e.divide(1,n[0])];throw new RangeError("Matrix must be square (size: "+t.format(o)+")");case 2:var a=o[0],s=o[1];if(a==s)return n instanceof i?new i(r(n.valueOf(),a,s)):r(n,a,s);throw new RangeError("Matrix must be square (size: "+t.format(o)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+t.format(o)+")")}}}},function(e,r,n){e.exports=function(e,r){var t=n(112),i=n(111),o=n(11),a=n(14),s=t.array,u=t.number.toNumber,f=Array.isArray;e.ones=function(e){var n=a.argsToArray(arguments),t=e instanceof o?!0:f(e)?!1:"matrix"===r.matrix;if(0==n.length)return t?new o:[];var c=[],l=n[0]instanceof i?new i(1):1;return c=s.resize(c,n.map(u),l),t?new o(c):c}}},function(e,r,n){e.exports=function(e,r){function t(e,r,n){var t=[],i=e;if(n>0)for(;r>i;)t.push(i),i+=n;else if(0>n)for(;i>r;)t.push(i),i+=n;return t}function i(e,r,n){var t=[],i=e;if(n>0)for(;r>=i;)t.push(i),i+=n;else if(0>n)for(;i>=r;)t.push(i),i+=n;return t}function o(e,r,n){var t=[],i=e.clone(),o=new f(0);if(n.gt(o))for(;i.lt(r);)t.push(i),i=i.plus(n);else if(n.lt(o))for(;i.gt(r);)t.push(i),i=i.plus(n);return t}function a(e,r,n){var t=[],i=e.clone(),o=new f(0);if(n.gt(o))for(;i.lte(r);)t.push(i),i=i.plus(n);else if(n.lt(o))for(;i.gte(r);)t.push(i),i=i.plus(n);return t}function s(e){var n=e.split(":"),t=null;if("bignumber"===r.number)try{t=n.map(function(e){return new f(e)})}catch(i){return null}else{t=n.map(function(e){return Number(e)});var o=t.some(function(e){return isNaN(e)});if(o)return null}switch(t.length){case 2:return{start:t[0],end:t[1],step:1};case 3:return{start:t[0],end:t[2],step:t[1]};default:return null}}var u=n(112),f=n(111),c=n(11),l=(n(14),u["boolean"].isBoolean),m=u.string.isString,p=u.number.isNumber,h=u.number.toNumber,g=u.number.toBigNumber;e.range=function(){var n,u,d,x=Array.prototype.slice.call(arguments),w=!1;switch(l(x[x.length-1])&&(w=x.pop()?!0:!1),x.length){case 1:if(!m(x[0]))throw new TypeError("Two or three numbers or a single string expected in function range");var v=s(x[0]);if(!v)throw new SyntaxError('String "'+x[0]+'" is no valid range');n=v.start,u=v.end,d=v.step;break;case 2:n=x[0],u=x[1],d=1;break;case 3:n=x[0],u=x[1],d=x[2];break;case 4:throw new TypeError("Parameter includeEnd must be a boolean");default:throw new e.error.ArgumentsError("range",arguments.length,2,4)}if(!(p(n)||n instanceof f))throw new TypeError("Parameter start must be a number");if(!(p(u)||u instanceof f))throw new TypeError("Parameter end must be a number");if(!(p(d)||d instanceof f))throw new TypeError("Parameter step must be a number");if(n instanceof f||u instanceof f||d instanceof f){var y=!0;n instanceof f||(n=g(n)),u instanceof f||(u=g(u)),d instanceof f||(d=g(d)),n instanceof f&&u instanceof f&&d instanceof f||(y=!1,n=h(n),u=h(u),d=h(d))}var b=y?w?a:o:w?i:t,E=b(n,u,d);return"array"===r.matrix?E:new c(E)}}},function(e,r,n){e.exports=function(e,r){function t(e,r,n){if(void 0!==n){if(!c(n)||1!==n.length)throw new TypeError("Single character expected as defaultValue")}else n=" ";if(1!==r.length)throw new Error("Dimension mismatch: ("+r.length+" != 1)");var t=r[0];if(!m(t)||!p(t))throw new TypeError("Invalid size, must contain positive integers (size: "+f.format(r)+")");if(e.length>t)return e.substring(0,t);if(e.length<t){for(var i=e,o=0,a=t-e.length;a>o;o++)i+=n;return i}return e}var i=n(112),o=n(111),a=n(11),s=i.array,u=i.object.clone,f=i.string,c=i.string.isString,l=i.number.toNumber,m=i.number.isNumber,p=i.number.isInteger,h=s.isArray;e.resize=function(n,i,f){if(2!=arguments.length&&3!=arguments.length)throw new e.error.ArgumentsError("resize",arguments.length,2,3);var m=n instanceof a?!0:h(n)?!1:"array"!==r.matrix;if(n instanceof a&&(n=n.valueOf()),i instanceof a&&(i=i.valueOf()),i.length&&i[0]instanceof o&&(i=i.map(l)),c(n))return t(n,i,f);if(0==i.length){for(;h(n);)n=n[0];return u(n)}h(n)||(n=[n]),n=u(n);var p=s.resize(n,i,f);return m?new a(p):p}}},function(e,r,n){e.exports=function(e,r){var t=n(112),i=n(111),o=n(8),a=n(12),s=n(11),u=t.array,f=t.number.isNumber,c=t["boolean"].isBoolean,l=t.string.isString,m=o.isComplex,p=a.isUnit;e.size=function(n){if(1!=arguments.length)throw new e.error.ArgumentsError("size",arguments.length,1);var t="array"===r.matrix;if(f(n)||m(n)||p(n)||c(n)||null==n||n instanceof i)return t?[]:new s([]);if(l(n))return t?[n.length]:new s([n.length]);if(Array.isArray(n))return u.size(n);if(n instanceof s)return new s(n.size());throw new e.error.UnsupportedTypeError("size",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(11),i=r.object,o=r.array,a=Array.isArray;e.squeeze=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("squeeze",arguments.length,1);if(a(r))return o.squeeze(i.clone(r));if(r instanceof t){var n=o.squeeze(r.toArray());return a(n)?new t(n):n}return i.clone(r)}}},function(e,r,n){e.exports=function(e){function r(r,n){var i,o;if(l(r))return i=new s(r),o=i.subset(n),o.valueOf();if(r instanceof s)return r.subset(n);if(c(r))return t(r,n);throw new e.error.UnsupportedTypeError("subset",r)}function t(e,r){if(!(r instanceof u))throw new TypeError("Index expected");if(1!=r.size().length)throw new RangeError("Dimension mismatch ("+r.size().length+" != 1)");var n=r.range(0),t="",i=e.length;return n.forEach(function(r){f.validateIndex(r,i),t+=e.charAt(r)}),t}function i(r,n,t,i){var a;if(l(r))return a=new s(e.clone(r)),a.subset(n,t,i),a.valueOf();if(r instanceof s)return r.clone().subset(n,t,i);if(c(r))return o(r,n,t,i);throw new e.error.UnsupportedTypeError("subset",r)}function o(e,r,n,t){if(!(r instanceof u))throw new TypeError("Index expected");if(1!=r.size().length)throw new RangeError("Dimension mismatch ("+r.size().length+" != 1)");if(void 0!==t){if(!c(t)||1!==t.length)throw new TypeError("Single character expected as defaultValue")}else t=" ";var i=r.range(0),o=i.size()[0];if(o!=n.length)throw new RangeError("Dimension mismatch ("+i.size()[0]+" != "+n.length+")");for(var a=e.length,s=[],l=0;a>l;l++)s[l]=e.charAt(l);if(i.forEach(function(e,r){f.validateIndex(e),s[e]=n.charAt(r)}),s.length>a)for(l=a-1,o=s.length;o>l;l++)s[l]||(s[l]=t);return s.join("")}var a=n(112),s=n(11),u=n(10),f=a.array,c=a.string.isString,l=Array.isArray;e.subset=function(){switch(arguments.length){case 2:return r(arguments[0],arguments[1]);case 3:case 4:return i(arguments[0],arguments[1],arguments[2],arguments[3]);default:throw new e.error.ArgumentsError("subset",arguments.length,2,4)}}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(11),i=(n(14),r.object),o=r.string;e.transpose=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("transpose",arguments.length,1);var n=e.size(r).valueOf();switch(n.length){case 0:return i.clone(r);case 1:return i.clone(r);case 2:var a,s=n[1],u=n[0],f=r instanceof t,c=r.valueOf(),l=[],m=i.clone;if(0===s)throw new RangeError("Cannot transpose a 2D matrix with no rows(size: "+o.format(n)+")");for(var p=0;s>p;p++){a=l[p]=[];for(var h=0;u>h;h++)a[h]=m(c[h][p])}return f?new t(l):l;default:throw new RangeError("Matrix must be two dimensional (size: "+o.format(n)+")")}}}},function(e,r,n){e.exports=function(e,r){var t=n(112),i=n(111),o=n(11),a=n(14),s=t.array,u=t.number.toNumber,f=Array.isArray;e.zeros=function(e){var n=a.argsToArray(arguments),t=e instanceof o?!0:f(e)?!1:"matrix"===r.matrix;if(0==n.length)return t?new o:[];var c=[],l=n[0]instanceof i?new i(0):0;return c=s.resize(c,n.map(u),l),t?new o(c):c}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(14),o=r.number.isNumber,a=r["boolean"].isBoolean,s=r.number.isInteger,u=i.isCollection;e.factorial=function c(r){var n,l;if(1!=arguments.length)throw new e.error.ArgumentsError("factorial",arguments.length,1);if(o(r)){if(!s(r)||0>r)throw new TypeError("Positive integer value expected in function factorial");for(n=r-1,l=r;n>1;)l*=n,n--;return 0==l&&(l=1),l}if(r instanceof t){if(!f(r))throw new TypeError("Positive integer value expected in function factorial");var m=new t(1);for(n=r.minus(m),l=r;n.gt(m);)l=l.times(n),n=n.minus(m);return l.equals(0)&&(l=m),l}if(a(r))return 1;if(u(r))return i.deepMap(r,c);throw new e.error.UnsupportedTypeError("factorial",r)};var f=function(e){return e.round().equals(e)&&e.gte(0)}}},function(e,r,n){e.exports=function(e,r){var t=n(11),i=(n(14),{uniform:function(){return Math.random},normal:function(){return function(){for(var e,r,n=-1;0>n||n>1;)e=Math.random(),r=Math.random(),n=1/6*Math.pow(-2*Math.log(e),.5)*Math.cos(2*Math.PI*r)+.5;return n}}});e.distribution=function(n){if(!i.hasOwnProperty(n))throw new Error("unknown distribution "+n);var o=Array.prototype.slice.call(arguments,1),a=i[n].apply(this,o);return function(n){var i={random:function(n,i,a){var u,f,c;if(arguments.length>3)throw new e.error.ArgumentsError("random",arguments.length,0,3);if(1===arguments.length?Array.isArray(n)?u=n:c=n:2===arguments.length?Array.isArray(n)?u=n:(f=n,c=i):(u=n,f=i,c=a),void 0===c&&(c=1),void 0===f&&(f=0),void 0!==u){var l=s(u,f,c,o);return"array"===r.matrix?l:new t(l)}return o(f,c)},randomInt:function(n,i,o){var u,f,c;if(arguments.length>3||arguments.length<1)throw new e.error.ArgumentsError("randomInt",arguments.length,1,3);if(1===arguments.length?c=n:2===arguments.length?"[object Array]"===Object.prototype.toString.call(n)?u=n:(f=n,c=i):(u=n,f=i,c=o),void 0===f&&(f=0),void 0!==u){var l=s(u,f,c,a);return"array"===r.matrix?l:new t(l)}return a(f,c)},pickRandom:function(r){if(1!==arguments.length)throw new e.error.ArgumentsError("pickRandom",arguments.length,1);if(!Array.isArray(r))throw new e.error.UnsupportedTypeError("pickRandom",r);return r[Math.floor(Math.random()*r.length)]}},o=function(e,r){return e+n()*(r-e)},a=function(e,r){return Math.floor(e+n()*(r-e))},s=function(e,r,n,t){var i,o,a=[];if(e=e.slice(0),e.length>1)for(o=0,i=e.shift();i>o;o++)a.push(s(e,r,n,t));else for(o=0,i=e.shift();i>o;o++)a.push(t(r,n));return a};return i}(a)};var o=e.distribution("uniform");e.random=o.random,e.randomInt=o.randomInt,e.pickRandom=o.pickRandom}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=r.number.isNumber,o=r.number.isInteger,a=r.number.toBigNumber;e.permutations=function(r,n){var u,f,c=arguments.length;if(c>2)throw new e.error.ArgumentsError("permutations",arguments.length,2);if(i(r)){if(!o(r)||0>r)throw new TypeError("Positive integer value expected in function permutations");if(1==c)return e.factorial(r);if(2==c&&i(n)){if(!o(n)||0>n)throw new TypeError("Positive integer value expected in function permutations");if(n>r)throw new TypeError("second argument k must be less than or equal to first argument n");for(u=1,f=r-n+1;r>=f;f++)u*=f;return u}}if(r instanceof t){if(void 0===n&&s(r))return e.factorial(r);if(n=a(n),!(n instanceof t&&s(r)&&s(n)))throw new TypeError("Positive integer value expected in function permutations");if(n.gt(r))throw new TypeError("second argument k must be less than or equal to first argument n");for(u=new t(1),f=r.minus(n).plus(1);f.lte(r);f=f.plus(1))u=u.times(f);return u}throw new e.error.UnsupportedTypeError("permutations",r)};var s=function(e){return e.round().equals(e)&&e.gte(0)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=(n(14),r.number.isNumber),o=r.number.isInteger,a=r.number.toBigNumber;e.combinations=function(r,n){var u,f,c,l,m=arguments.length;if(2!=m)throw new e.error.ArgumentsError("combinations",arguments.length,2);if(i(r)){if(!o(r)||0>r)throw new TypeError("Positive integer value enpected in function combinations");if(n>r)throw new TypeError("k must be less than or equal to n");for(u=Math.max(n,r-n),f=1,c=1;r-u>=c;c++)f=f*(u+c)/c;return f}if(r instanceof t){if(n=a(n),!(n instanceof t&&s(r)&&s(n)))throw new TypeError("Positive integer value expected in function combinations");if(n.gt(r))throw new TypeError("k must be less than n in function combinations");for(u=r.minus(n),n.lt(u)&&(u=n),f=new t(1),c=new t(1),l=r.minus(u);c.lte(l);c=c.plus(1))f=f.times(u.plus(c)).dividedBy(c);return f}throw new e.error.UnsupportedTypeError("combinations",r)};var s=function(e){return e.round().equals(e)&&e.gte(0)}}},function(e,r,n){e.exports=function(e){function r(r,n){return e.smaller(r,n)?r:n}function t(r){var n=void 0;if(i.deepForEach(r,function(r){(void 0===n||e.smaller(r,n))&&(n=r)}),void 0===n)throw new Error("Cannot calculate min of an empty array");return n}var i=(n(11),n(14)),o=i.isCollection;e.min=function(e){if(0==arguments.length)throw new SyntaxError("Function min requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return t(e);if(2==arguments.length)return i.reduce(arguments[0],arguments[1],r);throw new SyntaxError("Wrong number of parameters")}return t(arguments)}}},function(e,r,n){e.exports=function(e){function r(r,n){return e.larger(r,n)?r:n}function t(r){var n=void 0;if(i.deepForEach(r,function(r){(void 0===n||e.larger(r,n))&&(n=r)}),void 0===n)throw new Error("Cannot calculate max of an empty array");return n}var i=(n(11),n(14)),o=i.isCollection;e.max=function(e){if(0==arguments.length)throw new SyntaxError("Function max requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return t(e);if(2==arguments.length)return i.reduce(arguments[0],arguments[1],r);throw new SyntaxError("Wrong number of parameters")}return t(arguments)}}},function(e,r,n){e.exports=function(e){function r(r,n){var t;return t=i.reduce(r,n,e.add),e.divide(t,a(r)[n])}function t(r){var n=0,t=0;if(i.deepForEach(r,function(r){n=e.add(n,r),t++}),0===t)throw new Error("Cannot calculate mean of an empty array");
return e.divide(n,t)}var i=(n(11),n(14)),o=i.isCollection,a=n(142).size;e.mean=function(e){if(0==arguments.length)throw new SyntaxError("Function mean requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return t(e);if(2==arguments.length)return r(arguments[0],arguments[1]);throw new SyntaxError("Wrong number of parameters")}return t(arguments)}}},function(e,r,n){e.exports=function(e){function r(r){var n=u(r);n.sort(e.compare);var o=n.length;if(0==o)throw new Error("Cannot calculate median of an empty array");if(o%2==0){var s=n[o/2-1],f=n[o/2];if(!(a(s)||s instanceof i||s instanceof t))throw new e.error.UnsupportedTypeError("median",s);if(!(a(f)||f instanceof i||f instanceof t))throw new e.error.UnsupportedTypeError("median",f);return e.divide(e.add(s,f),2)}var c=n[(o-1)/2];if(!(a(c)||c instanceof i||c instanceof t))throw new e.error.UnsupportedTypeError("median",c);return c}var t=(n(11),n(12)),i=n(111),o=n(14),a=n(143).isNumber,s=o.isCollection,u=n(142).flatten;e.median=function(e){if(0==arguments.length)throw new SyntaxError("Function median requires one or more parameters (0 provided)");if(s(e)){if(1==arguments.length)return r(e.valueOf());throw 2==arguments.length?new Error("median(A, dim) is not yet supported"):new SyntaxError("Wrong number of parameters")}return r(Array.prototype.slice.call(arguments))}}},function(e,r,n){e.exports=function(e){function r(r){var n=void 0;if(t.deepForEach(r,function(r){n=void 0===n?r:e.multiply(n,r)}),void 0===n)throw new Error("Cannot calculate prod of an empty array");return n}var t=(n(11),n(14)),i=t.isCollection;e.prod=function(e){if(0==arguments.length)throw new SyntaxError("Function prod requires one or more parameters (0 provided)");if(i(e)){if(1==arguments.length)return r(e);throw 2==arguments.length?new Error("prod(A, dim) is not yet supported"):new SyntaxError("Wrong number of parameters")}return r(arguments)}}},function(e){e.exports=function(e){e.std=function(){if(0==arguments.length)throw new SyntaxError("Function std requires one or more parameters (0 provided)");var r=e["var"].apply(null,arguments);return e.sqrt(r)}}},function(e,r,n){e.exports=function(e){function r(r){var n=void 0;if(t.deepForEach(r,function(r){n=void 0===n?r:e.add(n,r)}),void 0===n)throw new Error("Cannot calculate sum of an empty array");return n}var t=(n(11),n(14)),i=t.isCollection;e.sum=function(e){if(0==arguments.length)throw new SyntaxError("Function sum requires one or more parameters (0 provided)");if(i(e)){if(1==arguments.length)return r(e);throw 2==arguments.length?new Error("sum(A, dim) is not yet supported"):new SyntaxError("Wrong number of parameters")}return r(arguments)}}},function(e,r,n){e.exports=function(e){function r(r,n){var o=0,a=0;if(i.deepForEach(r,function(r){o=e.add(o,r),a++}),0===a)throw new Error("Cannot calculate var of an empty array");var s=e.divide(o,a);switch(o=0,i.deepForEach(r,function(r){var n=e.subtract(r,s);o=e.add(o,e.multiply(n,n))}),n){case"uncorrected":return e.divide(o,a);case"biased":return e.divide(o,a+1);case"unbiased":var u=o instanceof t?new t(0):0;return 1==a?u:e.divide(o,a-1);default:throw new Error('Unknown normalization "'+n+'". Choose "unbiased" (default), "uncorrected", or "biased".')}}var t=(n(11),n(111)),i=n(14),o=i.isCollection,a=n(127).isString,s="unbiased";e["var"]=function(e,n){if(0==arguments.length)throw new SyntaxError("Function var requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return r(e,s);if(2==arguments.length){if(!a(n))throw new Error("String expected for parameter normalization");return r(e,n)}throw new SyntaxError("Wrong number of parameters")}return r(arguments,s)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.acos=function c(n){if(1!=arguments.length)throw new e.error.ArgumentsError("acos",arguments.length,1);if(a(n))return n>=-1&&1>=n?Math.acos(n):c(new i(n,0));if(u(n)){var l=new i(n.im*n.im-n.re*n.re+1,-2*n.re*n.im),m=e.sqrt(l),p=new i(m.re-n.im,m.im+n.re),h=e.log(p);return new i(1.5707963267948966-h.im,h.re)}if(f(n))return o.deepMap(n,c);if(s(n))return Math.acos(n);if(n instanceof t)return c(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("acos",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.asin=function c(n){if(1!=arguments.length)throw new e.error.ArgumentsError("asin",arguments.length,1);if(a(n))return n>=-1&&1>=n?Math.asin(n):c(new i(n,0));if(u(n)){var l=n.re,m=n.im,p=new i(m*m-l*l+1,-2*l*m),h=e.sqrt(p),g=new i(h.re-m,h.im+l),d=e.log(g);return new i(d.im,-d.re)}if(f(n))return o.deepMap(n,c);if(s(n))return Math.asin(n);if(n instanceof t)return c(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("asin",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,f=o.isCollection;e.atan=function c(n){if(1!=arguments.length)throw new e.error.ArgumentsError("atan",arguments.length,1);if(a(n))return Math.atan(n);if(u(n)){var l=n.re,m=n.im,p=l*l+(1-m)*(1-m),h=new i((1-m*m-l*l)/p,-2*l/p),g=e.log(h);return new i(-.5*g.im,.5*g.re)}if(f(n))return o.deepMap(n,c);if(s(n))return Math.atan(n);if(n instanceof t)return c(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("atan",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(14),a=r.number.toNumber,s=r.number.isNumber,u=r["boolean"].isBoolean,f=(i.isComplex,o.isCollection);e.atan2=function c(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("atan2",arguments.length,2);if(s(r)&&s(n))return Math.atan2(r,n);if(f(r)||f(n))return o.deepMap2(r,n,c);if(u(r))return c(+r,n);if(u(n))return c(r,+n);if(r instanceof t)return c(a(r),n);if(n instanceof t)return c(r,a(n));throw new e.error.UnsupportedTypeError("atan2",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.cos=function m(n){if(1!=arguments.length)throw new e.error.ArgumentsError("cos",arguments.length,1);if(s(n))return Math.cos(n);if(f(n))return new i(.5*Math.cos(n.re)*(Math.exp(-n.im)+Math.exp(n.im)),.5*Math.sin(n.re)*(Math.exp(-n.im)-Math.exp(n.im)));if(c(n)){if(!n.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return Math.cos(n.value)}if(l(n))return a.deepMap(n,m);if(u(n))return Math.cos(n);if(n instanceof t)return m(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("cos",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.cot=function m(n){if(1!=arguments.length)throw new e.error.ArgumentsError("cot",arguments.length,1);if(s(n))return 1/Math.tan(n);if(f(n)){var p=Math.exp(-4*n.im)-2*Math.exp(-2*n.im)*Math.cos(2*n.re)+1;return new i(2*Math.exp(-2*n.im)*Math.sin(2*n.re)/p,(Math.exp(-4*n.im)-1)/p)}if(c(n)){if(!n.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cot is no angle");return 1/Math.tan(n.value)}if(l(n))return a.deepMap(n,m);if(u(n))return m(+n);if(n instanceof t)return m(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("cot",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.csc=function m(n){if(1!=arguments.length)throw new e.error.ArgumentsError("csc",arguments.length,1);if(s(n))return 1/Math.sin(n);if(f(n)){var p=.25*(Math.exp(-2*n.im)+Math.exp(2*n.im))-.5*Math.cos(2*n.re);return new i(.5*Math.sin(n.re)*(Math.exp(-n.im)+Math.exp(n.im))/p,.5*Math.cos(n.re)*(Math.exp(-n.im)-Math.exp(n.im))/p)}if(c(n)){if(!n.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csc is no angle");return 1/Math.sin(n.value)}if(l(n))return a.deepMap(n,m);if(u(n))return m(+n);if(n instanceof t)return m(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("csc",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.sec=function m(n){if(1!=arguments.length)throw new e.error.ArgumentsError("sec",arguments.length,1);if(s(n))return 1/Math.cos(n);if(f(n)){var p=.25*(Math.exp(-2*n.im)+Math.exp(2*n.im))+.5*Math.cos(2*n.re);return new i(.5*Math.cos(n.re)*(Math.exp(-n.im)+Math.exp(n.im))/p,.5*Math.sin(n.re)*(Math.exp(n.im)-Math.exp(-n.im))/p)}if(c(n)){if(!n.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sec is no angle");return 1/Math.cos(n.value)}if(l(n))return a.deepMap(n,m);if(u(n))return m(+n);if(n instanceof t)return m(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("sec",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.sin=function m(n){if(1!=arguments.length)throw new e.error.ArgumentsError("sin",arguments.length,1);if(s(n))return Math.sin(n);if(f(n))return new i(.5*Math.sin(n.re)*(Math.exp(-n.im)+Math.exp(n.im)),.5*Math.cos(n.re)*(Math.exp(n.im)-Math.exp(-n.im)));if(c(n)){if(!n.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sin is no angle");return Math.sin(n.value)}if(l(n))return a.deepMap(n,m);if(u(n))return Math.sin(n);if(n instanceof t)return m(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("sin",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(111),i=n(8),o=n(12),a=n(14),s=r.number.isNumber,u=r["boolean"].isBoolean,f=i.isComplex,c=o.isUnit,l=a.isCollection;e.tan=function m(n){if(1!=arguments.length)throw new e.error.ArgumentsError("tan",arguments.length,1);if(s(n))return Math.tan(n);if(f(n)){var p=Math.exp(-4*n.im)+2*Math.exp(-2*n.im)*Math.cos(2*n.re)+1;return new i(2*Math.exp(-2*n.im)*Math.sin(2*n.re)/p,(1-Math.exp(-4*n.im))/p)}if(c(n)){if(!n.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tan is no angle");return Math.tan(n.value)}if(l(n))return a.deepMap(n,m);if(u(n))return Math.tan(n);if(n instanceof t)return m(r.number.toNumber(n));throw new e.error.UnsupportedTypeError("tan",n)}}},function(e,r,n){e.exports=function(e){var r=n(112),t=n(12),i=n(14),o=r.string.isString,a=t.isUnit,s=i.isCollection;e.to=function u(r,n){if(2!=arguments.length)throw new e.error.ArgumentsError("to",arguments.length,2);if(a(r)&&(a(n)||o(n)))return r.to(n);if(s(r)||s(n))return i.deepMap2(r,n,u);throw new e.error.UnsupportedTypeError("to",r,n)}}},function(e,r,n){e.exports=function(e){var r=n(3);e.clone=function(n){if(1!=arguments.length)throw new e.error.ArgumentsError("clone",arguments.length,1);return r.clone(n)}}},function(e,r,n){e.exports=function(e){var r=n(127);e.format=function(n,t){var i=arguments.length;if(1!==i&&2!==i)throw new e.error.ArgumentsError("format",i,1,2);return r.format(n,t)}}},function(e){e.exports=function(e){e.ifElse=function(r,n,t){if(3!=arguments.length)throw new e.error.ArgumentsError("ifElse",arguments.length,3);return r?n:t}}},function(e,r,n){e.exports=function(e){function r(r,n,t){(t.override||void 0===e[r])&&(e[r]=t.wrap&&"function"==typeof n?function(){for(var r=[],t=0,i=arguments.length;i>t;t++)r[t]=arguments[t].valueOf();return n.apply(e,r)}:n,e.chaining.Selector.createProxy(r,n))}function t(e){return"function"==typeof e||s(e)||u(e)||f(e)||c(e)}var i=n(112),o=n(8),a=n(12),s=i.number.isNumber,u=i.string.isString,f=o.isComplex,c=a.isUnit;e["import"]=function l(o,a){var s=arguments.length;if(1!=s&&2!=s)throw new e.error.ArgumentsError("import",s,1,2);var f,c={override:!1,wrap:!0};if(a&&a instanceof Object&&i.object.extend(c,a),u(o)){var m=n(144)(o);l(m)}else{if("object"!=typeof o)throw new TypeError("Object or module name expected");for(f in o)if(o.hasOwnProperty(f)){var p=o[f];t(p)?r(f,p,c):l(p)}}}}},function(e,r,n){e.exports=function(e){function r(e,r){var n=[],t=function(i,o){return Array.isArray(i)?i.map(function(e,r){return n[o]=r,t(e,o+1)}):r(i,n,e)};return t(e,0)}var t=n(11).isMatrix;e.map=function(n,i){if(2!=arguments.length)throw new e.error.ArgumentsError("map",arguments.length,2);if(Array.isArray(n))return r(n,i);if(t(n))return n.map(i);throw new e.error.UnsupportedTypeError("map",n)}}},function(e,r,n){e.exports=function(e){var r=n(127),t=r.isString;e.print=function(r,n,i){var o=arguments.length;if(2!=o&&3!=o)throw new e.error.ArgumentsError("print",o,2,3);if(!t(r))throw new TypeError("String expected as first parameter in function format");if(!(n instanceof Object))throw new TypeError("Object expected as second parameter in function format");return r.replace(/\$([\w\.]+)/g,function(r,o){for(var a=o.split("."),s=n[a.shift()];a.length&&void 0!==s;){var u=a.shift();s=u?s[u]:s+"."}return void 0!==s?t(s)?s:e.format(s,i):r})}}},function(e,r,n){e.exports=function(e){var r=n(126),t=n(111),i=n(8),o=n(11),a=n(12),s=n(10),u=n(9),f=n(13);e["typeof"]=function(n){if(1!=arguments.length)throw new e.error.ArgumentsError("typeof",arguments.length,1);var c=r.type(n);if("object"===c){if(n instanceof i)return"complex";if(n instanceof t)return"bignumber";if(n instanceof o)return"matrix";if(n instanceof a)return"unit";if(n instanceof s)return"index";if(n instanceof u)return"range";if(n instanceof f)return"help";if(n instanceof e.chaining.Selector)return"selector"}return c}}},function(e,r,n){e.exports=function(e){function r(e,r){var n=[],t=function(i,o){Array.isArray(i)?i.forEach(function(e,r){n[o]=r,t(e,o+1)}):r(i,n,e)};t(e,0)}var t=n(11).isMatrix;e.forEach=function(n,i){if(2!=arguments.length)throw new e.error.ArgumentsError("forEach",arguments.length,2);if(Array.isArray(n))return r(n,i);if(t(n))return n.forEach(i);throw new e.error.UnsupportedTypeError("forEach",n)}}},function(e,r,n){var t;!function(i){"use strict";function o(e,r){var n,t,i,u,f,c,p=this;if(!(p instanceof o))return new o(e,r);if(e instanceof o){if(A=0,r===n)return p.s=e.s,p.e=e.e,void(p.c=(e=e.c)?e.slice():e);e+=""}if("string"!=typeof e&&(e=(i="number"==typeof e||"[object Number]"==Object.prototype.toString.call(e))&&0===e&&0>1/e?"-0":e+""),c=e,r===n&&T.test(e))p.s="-"==e.charAt(0)?(e=e.slice(1),-1):1;else{if(10==r)return l(e,g,d);if(e=O.call(e).replace(/^\+(?!-)/,""),p.s="-"==e.charAt(0)?(e=e.replace(/^-(?!-)/,""),-1):1,null!=r?r!=(0|r)&&b||(m=!(r>=2&&65>r))?(a(r,2),f=T.test(e)):(u="["+M.slice(0,r=0|r)+"]+",e=e.replace(/\.$/,"").replace(/^\./,"0."),(f=new RegExp("^"+u+"(?:\\."+u+")?$",37>r?"i":"").test(e))?(i&&(e.replace(/^0\.0*|\./,"").length>15&&a(c,0),i=!i),e=s(e,10,r,p.s)):"Infinity"!=e&&"NaN"!=e&&(a(c,1,r),e="NaN")):f=T.test(e),!f)return p.c=p.e=null,"Infinity"!=e&&("NaN"!=e&&a(c,3),p.s=null),void(A=0)}for((n=e.indexOf("."))>-1&&(e=e.replace(".","")),(t=e.search(/e/i))>0?(0>n&&(n=t),n+=+e.slice(t+1),e=e.substring(0,t)):0>n&&(n=e.length),t=0;"0"==e.charAt(t);t++);if(r=e.length,i&&r>15&&e.slice(t).length>15&&a(c,0),A=0,(n-=t+1)>y)p.c=p.e=null;else if(t==r||v>n)p.c=[p.e=0];else{for(;"0"==e.charAt(--r););for(p.e=n,p.c=[],n=0;r>=t;p.c[n++]=+e.charAt(t++));}}function a(e,r,n,t,i,o){if(b){var a,s=["new BigNumber","cmp","div","eq","gt","gte","lt","lte","minus","mod","plus","times","toFr"][A?0>A?-A:A:0>1/A?1:0]+"()",u=m?" out of range":" not a"+(i?" non-zero":"n")+" integer";throw u=([s+" number type has more than 15 significant digits",s+" not a base "+n+" number",s+" base"+u,s+" not a number"][r]||n+"() "+r+(o?" not a boolean or binary digit":u+(t?" or not ["+(m?" negative, positive":" integer, integer")+" ]":"")))+": "+e,m=A=0,a=new Error(u),a.name="BigNumber Error",a}}function s(e,r,n,t){function i(e,t){var i,o,a=0,s=e.length,u=[0];for(t=t||n;s>a;a++){for(o=u.length,i=0;o>i;u[i]*=t,i++);for(u[0]+=M.indexOf(e.charAt(a)),i=0;i<u.length;i++)u[i]>r-1&&(null==u[i+1]&&(u[i+1]=0),u[i+1]+=u[i]/r^0,u[i]%=r)}return u.reverse()}function a(e){for(var r=0,n=e.length,t="";n>r;t+=M.charAt(e[r++]));return t}var s,f,c,l,m,p;if(37>n&&(e=e.toLowerCase()),(s=e.indexOf("."))>-1)if(s=e.length-s-1,f=i(new o(n).pow(s).toF(),10),l=e.split("."),c=i(l[1]),l=i(l[0]),p=u(c,f,c.length-f.length,t,r,1&l[l.length-1]),m=p.c,s=p.e){for(;++s;m.unshift(0));e=a(l)+"."+a(m)}else m[0]?l[s=l.length-1]<r-1?(++l[s],e=a(l)):e=new o(a(l),r).plus(S).toS(r):e=a(l);else e=a(i(e));return e}function u(e,r,n,t,i,a){var s,u,f,l,m,p=r.slice(),h=s=r.length,d=e.length,x=e.slice(0,s),w=x.length,b=new o(S),E=b.c=[],N=0,M=g+(b.e=n)+1;for(b.s=t,t=0>M?0:M;w++<s;x.push(0));p.unshift(0);do{for(f=0;i>f;f++){if(s!=(w=x.length))l=s>w?1:-1;else for(m=-1,l=0;++m<s;)if(r[m]!=x[m]){l=r[m]>x[m]?1:-1;break}if(!(0>l))break;for(u=w==s?r:p;w;){if(x[--w]<u[w]){for(m=w;m&&!x[--m];x[m]=i-1);--x[m],x[w]+=i}x[w]-=u[w]}for(;!x[0];x.shift());}E[N++]=l?f:++f,x[0]&&l?x[w]=e[h]||0:x=[e[h]]}while((h++<d||null!=x[0])&&t--);return E[0]||1==N||(--b.e,E.shift()),N>M&&c(b,g,i,a,null!=x[0]),b.e>y?b.c=b.e=null:b.e<v&&(b.c=[b.e=0]),b}function f(e,r,n){var t=r-(e=new o(e)).e,i=e.c;if(!i)return e.toS();for(i.length>++r&&c(e,t,10),t=0==i[0]?t+1:n?r:e.e+t+1;i.length<t;i.push(0));return t=e.e,1==n||2==n&&(--r<t||x>=t)?(e.s<0&&i[0]?"-":"")+(i.length>1?(i.splice(1,0,"."),i.join("")):i[0])+(0>t?"e":"e+")+t:e.toS()}function c(e,r,n,t,i){var o=e.c,a=e.s<0,s=n/2,u=e.e+r+1,f=o[u],c=i||0>u||null!=o[u+1];if(i=4>d?(null!=f||c)&&(0==d||2==d&&!a||3==d&&a):f>s||f==s&&(4==d||c||6==d&&(1&o[u-1]||!r&&t)||7==d&&!a||8==d&&a),1>u||!o[0])return o.length=0,o.push(0),i?(o[0]=1,e.e=-r):e.e=0,e;if(o.length=u--,i)for(--n;++o[u]>n;)o[u]=0,u--||(++e.e,o.unshift(1));for(u=o.length;!o[--u];o.pop());return e}function l(e,r,n){var t=d;return d=n,e=new o(e),e.c&&c(e,r,10),d=t,e}var m,p=1e9,h=1e6,g=20,d=4,x=-7,w=21,v=-p,y=p,b=!0,E=parseInt,N=o.prototype,M="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_",A=0,T=/^-?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,O=String.prototype.trim||function(){return this.replace(/^\s+|\s+$/g,"")},S=o(1);o.ROUND_UP=0,o.ROUND_DOWN=1,o.ROUND_CEIL=2,o.ROUND_FLOOR=3,o.ROUND_HALF_UP=4,o.ROUND_HALF_DOWN=5,o.ROUND_HALF_EVEN=6,o.ROUND_HALF_CEIL=7,o.ROUND_HALF_FLOOR=8,o.config=function(){var e,r,n=0,t={},i=arguments,o=i[0],s="config",u=function(e,r,n){return!((m=r>e||e>n)||E(e)!=e&&0!==e)},f=o&&"object"==typeof o?function(){return o.hasOwnProperty(r)?null!=(e=o[r]):void 0}:function(){return i.length>n?null!=(e=i[n++]):void 0};return f(r="DECIMAL_PLACES")&&(u(e,0,p)?g=0|e:a(e,r,s)),t[r]=g,f(r="ROUNDING_MODE")&&(u(e,0,8)?d=0|e:a(e,r,s)),t[r]=d,f(r="EXPONENTIAL_AT")&&(u(e,-p,p)?x=-(w=~~(0>e?-e:+e)):!m&&e&&u(e[0],-p,0)&&u(e[1],0,p)?(x=~~e[0],w=~~e[1]):a(e,r,s,1)),t[r]=[x,w],f(r="RANGE")&&(u(e,-p,p)&&~~e?v=-(y=~~(0>e?-e:+e)):!m&&e&&u(e[0],-p,-1)&&u(e[1],1,p)?(v=~~e[0],y=~~e[1]):a(e,r,s,1,1)),t[r]=[v,y],f(r="ERRORS")&&(e===!!e||1===e||0===e?(m=A=0,E=(b=!!e)?parseInt:parseFloat):a(e,r,s,0,0,1)),t[r]=b,t},N.abs=N.absoluteValue=function(){var e=new o(this);return e.s<0&&(e.s=1),e},N.ceil=function(){return l(this,0,2)},N.comparedTo=N.cmp=function(e,r){var n,t=this,i=t.c,a=(A=-A,e=new o(e,r)).c,s=t.s,u=e.s,f=t.e,c=e.e;if(!s||!u)return null;if(n=i&&!i[0],r=a&&!a[0],n||r)return n?r?0:-u:s;if(s!=u)return s;if(n=0>s,r=f==c,!i||!a)return r?0:!i^n?1:-1;if(!r)return f>c^n?1:-1;for(s=-1,u=(f=i.length)<(c=a.length)?f:c;++s<u;)if(i[s]!=a[s])return i[s]>a[s]^n?1:-1;return f==c?0:f>c^n?1:-1},N.dividedBy=N.div=function(e,r){var n=this.c,t=this.e,i=this.s,a=(A=2,e=new o(e,r)).c,s=e.e,f=e.s,c=i==f?1:-1;return(t||n&&n[0])&&(s||a&&a[0])?u(n,a,t-s,c,10):new o(i&&f&&(n?!a||n[0]!=a[0]:a)?n&&0==n[0]||!a?0*c:c/0:0/0)},N.equals=N.eq=function(e,r){return A=3,0===this.cmp(e,r)},N.floor=function(){return l(this,0,3)},N.greaterThan=N.gt=function(e,r){return A=4,this.cmp(e,r)>0},N.greaterThanOrEqualTo=N.gte=function(e,r){return A=5,1==(r=this.cmp(e,r))||0===r},N.isFinite=N.isF=function(){return!!this.c},N.isNaN=function(){return!this.s},N.isNegative=N.isNeg=function(){return this.s<0},N.isZero=N.isZ=function(){return!!this.c&&0==this.c[0]},N.lessThan=N.lt=function(e,r){return A=6,this.cmp(e,r)<0},N.lessThanOrEqualTo=N.lte=function(e,r){return A=7,-1==(r=this.cmp(e,r))||0===r},N.minus=function(e,r){var n,t,i,a,s=this,u=s.s;if(r=(A=8,e=new o(e,r)).s,!u||!r)return new o(0/0);if(u!=r)return e.s=-r,s.plus(e);var f=s.c,c=s.e,l=e.c,m=e.e;if(!c||!m){if(!f||!l)return f?(e.s=-r,e):new o(l?s:0/0);if(!f[0]||!l[0])return l[0]?(e.s=-r,e):new o(f[0]?s:3==d?-0:0)}if(f=f.slice(),u=c-m){for(n=(a=0>u)?(u=-u,f):(m=c,l),n.reverse(),r=u;r--;n.push(0));n.reverse()}else for(i=((a=f.length<l.length)?f:l).length,u=r=0;i>r;r++)if(f[r]!=l[r]){a=f[r]<l[r];break}if(a&&(n=f,f=l,l=n,e.s=-e.s),(r=-((i=f.length)-l.length))>0)for(;r--;f[i++]=0);for(r=l.length;r>u;){if(f[--r]<l[r]){for(t=r;t&&!f[--t];f[t]=9);--f[t],f[r]+=10}f[r]-=l[r]}for(;0==f[--i];f.pop());for(;0==f[0];f.shift(),--m);return(v>m||!f[0])&&(f[0]||(e.s=3==d?-1:1),f=[m=0]),e.c=f,e.e=m,e},N.modulo=N.mod=function(e,r){var n=this,t=n.c,i=(A=9,e=new o(e,r)).c,a=n.s,s=e.s;return r=!a||!s||i&&!i[0],r||t&&!t[0]?new o(r?0/0:n):(n.s=e.s=1,r=1==e.cmp(n),n.s=a,e.s=s,r?new o(n):(a=g,s=d,g=0,d=1,n=n.div(e),g=a,d=s,this.minus(n.times(e))))},N.negated=N.neg=function(){var e=new o(this);return e.s=-e.s||null,e},N.plus=function(e,r){var n,t=this,i=t.s;if(r=(A=10,e=new o(e,r)).s,!i||!r)return new o(0/0);if(i!=r)return e.s=-r,t.minus(e);var a=t.e,s=t.c,u=e.e,f=e.c;if(!a||!u){if(!s||!f)return new o(i/0);if(!s[0]||!f[0])return f[0]?e:new o(s[0]?t:0*i)}if(s=s.slice(),i=a-u){for(n=i>0?(u=a,f):(i=-i,s),n.reverse();i--;n.push(0));n.reverse()}for(s.length-f.length<0&&(n=f,f=s,s=n),i=f.length,r=0;i;r=(s[--i]=s[i]+f[i]+r)/10^0,s[i]%=10);for(r&&(s.unshift(r),++u>y&&(s=u=null)),i=s.length;0==s[--i];s.pop());return e.c=s,e.e=u,e},N.toPower=N.pow=function(e){var r=0*e==0?0|e:e,n=new o(this),t=new o(S);if(((m=-h>e||e>h)&&(r=1*e/0)||E(e)!=e&&0!==e&&!(r=0/0))&&!a(e,"exponent","pow")||!r)return new o(Math.pow(n.toS(),r));for(r=0>r?-r:r;1&r&&(t=t.times(n)),r>>=1,r;)n=n.times(n);return 0>e?S.div(t):t},N.round=function(e,r){return e=null==e||((m=0>e||e>p)||E(e)!=e)&&!a(e,"decimal places","round")?0:0|e,r=null==r||((m=0>r||r>8)||E(r)!=r&&0!==r)&&!a(r,"mode","round")?d:0|r,l(this,e,r)},N.squareRoot=N.sqrt=function(){var e,r,n,t,i=this,a=i.c,s=i.s,u=i.e,f=g,l=d,m=new o("0.5");if(1!==s||!a||!a[0])return new o(!s||0>s&&(!a||a[0])?0/0:a?i:1/0);for(s=Math.sqrt(i.toS()),d=1,0==s||s==1/0?(e=a.join(""),e.length+u&1||(e+="0"),r=new o(Math.sqrt(e)+""),r.c||(r.c=[1]),r.e=((u+1)/2|0)-(0>u||1&u)):r=new o(e=s.toString()),n=r.e,s=n+(g+=4),3>s&&(s=0),u=s;;)if(t=r,r=m.times(t.plus(i.div(t))),t.c.slice(0,s).join("")===r.c.slice(0,s).join("")){if(a=r.c,s-=e&&r.e<n,9!=a[s]||9!=a[s-1]||9!=a[s-2]||!(9==a[s-3]||e&&4==a[s-3])){if(!(a[u]||a[u-1]||a[u-2]||a[u-3]&&5!=a[u-3]||(a.length>u-2&&(a.length=u-2),r.times(r).eq(i)))){for(;a.length<u-3;)a.push(0);a[u-3]++}return d=l,c(r,g=f,10),r}if(e&&9==a[s-3]&&(t=r.round(f,0),t.times(t).eq(i)))return d=l,g=f,t;g+=4,s+=4,e=""}},N.times=function(e,r){var n,t=this,i=t.c,a=(A=11,e=new o(e,r)).c,s=t.e,u=e.e,f=t.s;if(e.s=f==(r=e.s)?1:-1,!((s||i&&i[0])&&(u||a&&a[0])))return new o(!f||!r||i&&!i[0]&&!a||a&&!a[0]&&!i?0/0:i&&a?0*e.s:e.s/0);for(e.e=s+u,(f=i.length)<(r=a.length)&&(n=i,i=a,a=n,u=f,f=r,r=u),u=f+r,n=[];u--;n.push(0));for(s=r-1;s>-1;s--){for(r=0,u=f+s;u>s;r=n[u]+a[s]*i[u-s-1]+r,n[u--]=r%10|0,r=r/10|0);r&&(n[u]=(n[u]+r)%10)}for(r&&++e.e,!n[0]&&n.shift(),u=n.length;!n[--u];n.pop());return e.c=e.e>y?e.e=null:e.e<v?[e.e=0]:n,e},N.toExponential=N.toE=function(e){return f(this,(null==e||((m=0>e||e>p)||E(e)!=e&&0!==e)&&!a(e,"decimal places","toE"))&&this.c?this.c.length-1:0|e,1)},N.toFixed=N.toF=function(e){var r,n,t,i=this;return null==e||((m=0>e||e>p)||E(e)!=e&&0!==e)&&!a(e,"decimal places","toF")||(t=i.e+(0|e)),r=x,e=w,x=-(w=1/0),t==n?n=i.toS():(n=f(i,t),i.s<0&&i.c&&(i.c[0]?n.indexOf("-")<0&&(n="-"+n):n=n.replace(/^-/,""))),x=r,w=e,n},N.toFraction=N.toFr=function(e){var r,n,t,i,s,u,f,c=i=new o(S),l=t=new o("0"),p=this,h=p.c,x=y,w=g,v=d,E=new o(S);if(!h)return p.toS();for(f=E.e=h.length-p.e-1,(null==e||(!(A=12,u=new o(e)).s||(m=u.cmp(c)<0||!u.c)||b&&u.e<u.c.length-1)&&!a(e,"max denominator","toFr")||(e=u).cmp(E)>0)&&(e=f>0?E:c),y=1/0,u=new o(h.join("")),g=0,d=1;r=u.div(E),s=i.plus(r.times(l)),1!=s.cmp(e);)i=l,l=s,c=t.plus(r.times(s=c)),t=s,E=u.minus(r.times(s=E)),u=s;return s=e.minus(i).div(l),t=t.plus(s.times(c)),i=i.plus(s.times(l)),t.s=c.s=p.s,g=2*f,d=v,n=c.div(l).minus(p).abs().cmp(t.div(i).minus(p).abs())<1?[c.toS(),l.toS()]:[t.toS(),i.toS()],y=x,g=w,n},N.toPrecision=N.toP=function(e){return null==e||((m=1>e||e>p)||E(e)!=e)&&!a(e,"precision","toP")?this.toS():f(this,0|--e,2)},N.toString=N.toS=function(e){var r,n,t,i=this,o=i.e;if(null===o)n=i.s?"Infinity":"NaN";else{if(e===r&&(x>=o||o>=w))return f(i,i.c.length-1,1);if(n=i.c.join(""),0>o){for(;++o;n="0"+n);n="0."+n}else if(t=n.length,o>0)if(++o>t)for(o-=t;o--;n+="0");else t>o&&(n=n.slice(0,o)+"."+n.slice(o));else if(r=n.charAt(0),t>1)n=r+"."+n.slice(1);else if("0"==r)return r;if(null!=e)if((m=!(e>=2&&65>e))||e!=(0|e)&&b)a(e,"base","toS");else if(n=s(n,0|e,10,i.s),"0"==n)return n}return i.s<0?"-"+n:n},N.valueOf=function(){return this.toS()},"undefined"!=typeof e&&e.exports?e.exports=o:(t=function(){return o}.call(r,n,r,e),!(void 0!==t&&(e.exports=t)))}(this)},function(e,r,n){r.array=n(142),r["boolean"]=n(237),r.number=n(143),r.object=n(3),r.string=n(127),r.types=n(126)},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(this.nodes=e||[],!a(this.nodes)||!this.nodes.every(s))throw new TypeError("Array containing Nodes expected")}var i=n(125),o=(n(3),n(127)),a=(n(14),n(11),n(112),Array.isArray),s=i.isNode;t.prototype=new i,t.prototype._compile=function(e){var r="array"!==e.math.config().matrix,n=this.nodes.map(function(r){return r._compile(e)});return(r?"math.matrix([":"[")+n.join(",")+(r?"])":"]")},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this);for(var n=this.nodes,t=0,i=n.length;i>t;t++)r=r.concat(n[t].find(e));return r},t.prototype.toString=function(){return o.format(this.nodes)},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!o(e))throw new TypeError('String expected for parameter "name"');if(!(r instanceof i))throw new TypeError('Node expected for parameter "expr"');this.name=e,this.expr=r}var i=n(125),o=n(127).isString;t.prototype=new i,t.prototype._compile=function(e){return'scope["'+this.name+'"] = '+this.expr._compile(e)},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.expr.find(e))},t.prototype.toString=function(){return this.name+" = "+this.expr.toString()},e.exports=t},function(e,r,n){function t(){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this.params=[]}var i=n(125),o=n(237).isBoolean;t.prototype=new i,t.prototype.add=function(e,r){if(void 0===r&&(r=!0),!(e instanceof i))throw new TypeError('Node expected for parameter "expr"');if(!o(r))throw new TypeError('Boolean expected for parameter "visible"');var n=this.params.length;this.params[n]={node:e,visible:r}},t.prototype._compile=function(e){var r=this.params.map(function(r){var n=r.node._compile(e);return r.visible?"results.push("+n+");":n+";"});return"(function () {var results = [];"+r.join("")+"return results;})()"},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this);for(var n=this.params,t=0,i=n.length;i>t;t++)r=r.concat(n[t].node.find(e));return r},t.prototype.toString=function(){return this.params.map(function(e){return e.node.toString()+(e.visible?"":";")}).join("\n")},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!a(e))throw new TypeError('String expected for parameter "type"');if(!a(r))throw new TypeError('String expected for parameter "value"');this.type=e,this.value=r}var i=n(125),o=(n(8),n(111),n(127)),a=o.isString;t.prototype=new i,t.prototype._compile=function(e){switch(this.type){case"number":return"bignumber"===e.math.config().number?'math.bignumber("'+this.value+'")':this.value.replace(/^(0*)[0-9]/,function(e,r){return e.substring(r.length)});case"string":return'"'+this.value+'"';case"complex":return"math.complex(0, "+this.value+")";case"boolean":return this.value;case"undefined":return this.value;case"null":return this.value;default:throw new TypeError('Unsupported type of constant "'+this.type+'"')}},t.prototype.toString=function(){switch(this.type){case"string":return'"'+this.value+'"';case"complex":return this.value+"i";default:return this.value}},e.exports=t},function(e,r,n){function t(e,r,n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!o(e))throw new TypeError('String expected for parameter "name"');if(!isArray(r)||!r.every(o))throw new TypeError('Array containing strings expected for parameter "args"');if(!(n instanceof i))throw new TypeError('Node expected for parameter "expr"');this.name=e,this.args=r,this.expr=n}var i=n(125),o=n(127).isString;isArray=Array.isArray,t.prototype=new i,t.prototype._compile=function(e){return'scope["'+this.name+'"] =   (function (scope) {    scope = Object.create(scope);     var fn = function '+this.name+"("+this.args.join(",")+") {      if (arguments.length != "+this.args.length+') {        throw new SyntaxError("Wrong number of arguments in function '+this.name+' (" + arguments.length + " provided, '+this.args.length+' expected)");      }'+this.args.map(function(e,r){return'scope["'+e+'"] = arguments['+r+"];"}).join("")+"      return "+this.expr._compile(e)+'    };    fn.syntax = "'+this.name+"("+this.args.join(", ")+')";    return fn;  })(scope);'},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.expr.find(e))},t.prototype.toString=function(){return"function "+this.name+"("+this.args.join(", ")+") = "+this.expr.toString()},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof o))throw new TypeError('Node expected for parameter "object"');if(!isArray(r)||!r.every(u))throw new TypeError('Array containing Nodes expected for parameter "ranges"');this.object=e,this.ranges=r}var i=n(143),o=n(125),a=n(121),s=n(122),u=(n(111),n(10),n(9),i.isNumber,i.toNumber,o.isNode);t.prototype=new o,t.prototype._compile=function(e){return this.compileSubset(e)},t.prototype.compileSubset=function(e,r){var n={type:s,properties:{name:"end"}},t=!1,i=this.ranges.map(function(e){var r=e.find(n).length>0;return t=r?r:t,r}),o=this.ranges.map(function(r,n){var t=i[n];return r instanceof a?t?'(function (scope) {  scope = Object.create(scope);   scope["end"] = size['+n+"];  var step = "+(r.step?r.step._compile(e):"1")+";  return [    "+r.start._compile(e)+" - 1,     "+r.end._compile(e)+" - (step > 0 ? 0 : 2),     step  ];})(scope)":"(function () {  var step = "+(r.step?r.step._compile(e):"1")+";  return [    "+r.start._compile(e)+" - 1,     "+r.end._compile(e)+" - (step > 0 ? 0 : 2),     step  ];})()":t?'(function (scope) {  scope = Object.create(scope);   scope["end"] = size['+n+"];  return "+r._compile(e)+" - 1;})(scope)":r._compile(e)+" - 1"});return t?"(function () {  var obj = "+this.object._compile(e)+";  var size = math.size(obj).valueOf();  return math.subset(    obj,     math.index("+o.join(", ")+")    "+(r?", "+r:"")+"  );})()":"math.subset("+this.object._compile(e)+",math.index("+o.join(", ")+")"+(r?", "+r:"")+")"},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this),r=r.concat(this.object.find(e));for(var n=this.ranges,t=0,i=n.length;i>t;t++)r=r.concat(n[t].find(e));return r},t.prototype.objectName=function(){return this.object.name},t.prototype.toString=function(){return this.object.toString()+"["+this.ranges.join(", ")+"]"
},e.exports=t},function(e,r,n){function t(e,r,n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this.op=e,this.fn=r,this.params=n}var i=n(125);t.prototype=new i,t.prototype._compile=function(e){if(!(this.fn in e.math))throw new Error("Function "+this.fn+' missing in provided namespace "math"');var r=this.params.map(function(r){return r._compile(e)});return"math."+this.fn+"("+r.join(", ")+")"},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this);var n=this.params;if(n)for(var t=0,i=n.length;i>t;t++)r=r.concat(n[t].find(e));return r},t.prototype.toString=function(){var e=this.params;switch(e.length){case 1:return"-"==this.op?"-"+e[0].toString():e[0].toString()+this.op;case 2:var r=e[0].toString();e[0]instanceof t&&(r="("+r+")");var n=e[1].toString();return e[1]instanceof t&&(n="("+n+")"),r+" "+this.op+" "+n;default:return this.op+"("+this.params.join(", ")+")"}},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof o))throw new TypeError('Node expected for parameter "object"');if(!isArray(r)||!r.every(a))throw new TypeError('Array containing Nodes expected for parameter "params"');this.object=e,this.params=r}var i=n(143),o=n(125),a=(n(121),n(122),n(111),n(10),n(9),i.isNumber,i.toNumber,o.isNode);t.prototype=new o,t.prototype._compile=function(e){var r=this.params.map(function(r){return r._compile(e)});return this.object._compile(e)+"("+r.join(", ")+")"},t.prototype.find=function(e){var r=[];this.match(e)&&r.push(this),r=r.concat(this.object.find(e));for(var n=this.params,t=0,i=n.length;i>t;t++)r=r.concat(n[t].find(e));return r},t.prototype.toString=function(){return this.object.toString()+"("+this.params.join(", ")+")"},e.exports=t},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!a(e)||2!=e.length&&3!=e.length||!e.every(isNode))throw new TypeError('Expected an Array containing 2 or 3 Nodes as parameter "params"');this.start=e[0],this.end=e[1],this.step=e[2]}var i=n(143),o=n(125),a=(n(111),n(9),n(11),i.toNumber,Array.isArray);isNode=o.isNode,t.prototype=new o,t.prototype._compile=function(e){return"math.range("+this.start._compile(e)+", "+this.end._compile(e)+", "+(this.step?this.step._compile(e)+", ":"")+"true)"},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.start.find(e)),this.step&&(r=r.concat(this.step.find(e))),r=r.concat(this.end.find(e))},t.prototype.toString=function(){var e=this.start.toString();return this.step&&(e+=":"+this.step.toString()),e+=":"+this.end.toString()},e.exports=t},function(e,r,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!s(e))throw new TypeError('String expected for parameter "name"');this.name=e}function i(e){throw new Error("Undefined symbol "+e)}var o=n(125),a=n(12),s=n(127).isString;t.prototype=new o,t.prototype._compile=function(e){return e.undef=i,e.Unit=a,'(scope["'+this.name+'"] !== undefined ? scope["'+this.name+'"] : math["'+this.name+'"] !== undefined ? math["'+this.name+'"] : '+(a.isPlainUnit(this.name)?'new Unit(null, "'+this.name+'")':'undef("'+this.name+'")')+")"},t.prototype.toString=function(){return this.name},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof i))throw new TypeError('Node expected for parameter "value"');if(!o(r))throw new TypeError('String expected for parameter "unit"');this.value=e,this.unit=r}var i=n(125),o=(n(111),n(8),n(12),n(143).toNumber,n(127).isString);t.prototype=new i,t.prototype._compile=function(e){return"math.unit("+this.value._compile(e)+', "'+this.unit+'")'},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.value.find(e))},t.prototype.toString=function(){return this.value+" "+this.unit},e.exports=t},function(e,r,n){function t(e,r){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof a))throw new TypeError('Expected IndexNode for parameter "index"');if(!(r instanceof o))throw new TypeError('Expected Node for parameter "expr"');this.index=e,this.expr=r}{var i=n(143),o=n(125),a=(n(121),n(118));n(122),n(111),n(10),n(9),i.isNumber,i.toNumber}t.prototype=new o,t.prototype._compile=function(e){return'scope["'+this.index.objectName()+'"] = '+this.index.compileSubset(e,this.expr._compile(e))},t.prototype.find=function(e){var r=[];return this.match(e)&&r.push(this),r=r.concat(this.index.find(e)),r=r.concat(this.expr.find(e))},t.prototype.toString=function(){return this.index.toString()+" = "+this.expr.toString()},e.exports=t},function(e){function r(){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator")}r.prototype.eval=function(){throw new Error("Node.eval is deprecated. Use Node.compile(math).eval([scope]) instead.")},r.prototype.compile=function(e){if("object"!=typeof e)throw new TypeError("Object expected for parameter math");var r={math:e},n=this._compile(r),t=Object.keys(r).map(function(e){return"    var "+e+' = defs["'+e+'"];'}),i=t.join(" ")+'return {  "eval": function (scope) {    scope = scope || {};    return '+n+";  }};",o=new Function("defs",i);return o(r)},r.prototype._compile=function(){throw new Error("Cannot compile a Node interface")},r.prototype.find=function(e){return this.match(e)?[this]:[]},r.prototype.match=function(e){var r=!0;if(e){!e.type||this instanceof e.type||(r=!1);var n=e.properties;if(r&&n)for(var t in n)if(n.hasOwnProperty(t)&&this[t]!==n[t]){r=!1;break}}return r},r.prototype.toString=function(){return""},r.isNode=function(e){return e instanceof r},e.exports=r},function(e,r){r.type=function n(e){var n=typeof e;if("object"===n){if(null===e)return"null";if(e instanceof Boolean)return"boolean";if(e instanceof Number)return"number";if(e instanceof String)return"string";if(Array.isArray(e))return"array";if(e instanceof Date)return"date"}return n}},function(e,r,n){function t(e,n){if(Array.isArray(e)){for(var i="[",o=e.length,a=0;o>a;a++)0!=a&&(i+=", "),i+=t(e[a],n);return i+="]"}return r.format(e,n)}var i=n(143),o=n(111);r.isString=function(e){return e instanceof String||"string"==typeof e},r.endsWith=function(e,r){var n=e.length-r.length,t=e.length;return e.substring(n,t)===r},r.format=function(e,n){return i.isNumber(e)||e instanceof o?i.format(e,n):Array.isArray(e)?t(e,n):r.isString(e)?'"'+e+'"':"function"==typeof e?e.syntax?e.syntax+"":"function":e instanceof Object?"function"==typeof e.format?e.format(n):e.toString():String(e)}},function(e){e.exports={name:"e",category:"Constants",syntax:["e"],description:"Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",examples:["e","e ^ 2","exp(2)","log(e)"],seealso:["exp"]}},function(e){e.exports={name:"false",category:"Constants",syntax:["false"],description:"Boolean value false",examples:["false"],seealso:["true"]}},function(e){e.exports={name:"i",category:"Constants",syntax:["i"],description:"Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",examples:["i","i * i","sqrt(-1)"],seealso:[]}},function(e){e.exports={name:"Infinity",category:"Constants",syntax:["Infinity"],description:"Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",examples:["Infinity","1 / 0"],seealso:[]}},function(e){e.exports={name:"LN2",category:"Constants",syntax:["LN2"],description:"Returns the natural logarithm of 2, approximately equal to 0.693",examples:["LN2","log(2)"],seealso:[]}},function(e){e.exports={name:"LN10",category:"Constants",syntax:["LN10"],description:"Returns the natural logarithm of 10, approximately equal to 2.302",examples:["LN10","log(10)"],seealso:[]}},function(e){e.exports={name:"LOG2E",category:"Constants",syntax:["LOG2E"],description:"Returns the base-2 logarithm of E, approximately equal to 1.442",examples:["LOG2E","log(e, 2)"],seealso:[]}},function(e){e.exports={name:"LOG10E",category:"Constants",syntax:["LOG10E"],description:"Returns the base-10 logarithm of E, approximately equal to 0.434",examples:["LOG10E","log(e, 10)"],seealso:[]}},function(e){e.exports={name:"NaN",category:"Constants",syntax:["NaN"],description:"Not a number",examples:["NaN","0 / 0"],seealso:[]}},function(e){e.exports={name:"pi",category:"Constants",syntax:["pi"],description:"The number pi is a mathematical constant that is the ratio of a circle's circumference to its diameter, and is approximately equal to 3.14159",examples:["pi","sin(pi/2)"],seealso:["tau"]}},function(e){e.exports={name:"SQRT1_2",category:"Constants",syntax:["SQRT1_2"],description:"Returns the square root of 1/2, approximately equal to 0.707",examples:["SQRT1_2","sqrt(1/2)"],seealso:[]}},function(e){e.exports={name:"SQRT2",category:"Constants",syntax:["SQRT2"],description:"Returns the square root of 2, approximately equal to 1.414",examples:["SQRT2","sqrt(2)"],seealso:[]}},function(e){e.exports={name:"tau",category:"Constants",syntax:["pi"],description:"Tau is the ratio constant of a circle's circumference to radius, equal to 2 * pi, approximately 6.2832.",examples:["tau","2 * pi"],seealso:["pi"]}},function(e){e.exports={name:"true",category:"Constants",syntax:["true"],description:"Boolean value true",examples:["true"],seealso:["false"]}},function(e,r,n){function t(e){for(var r=[];f(e);)r.push(e.length),e=e[0];return r}function i(e,r,n){var t,o=e.length;if(o!=r[n])throw new RangeError("Dimension mismatch ("+o+" != "+r[n]+")");if(n<r.length-1){var a=n+1;for(t=0;o>t;t++){var s=e[t];if(!f(s))throw new RangeError("Dimension mismatch ("+(r.length-1)+" < "+r.length+")");i(e[t],r,a)}}else for(t=0;o>t;t++)if(f(e[t]))throw new RangeError("Dimension mismatch ("+(r.length+1)+" > "+r.length+")")}function o(e,r,n,t){if(!f(e))throw Error("Array expected");var i,a,s=e.length,c=r[n],l=Math.min(s,c);if(e.length=c,n<r.length-1){var m=n+1;for(i=0;l>i;i++)a=e[i],o(a,r,m,t);for(i=l;c>i;i++)a=[],e[i]=a,o(a,r,m,t)}else if(void 0!==t)for(i=s;c>i;i++)e[i]=u.clone(t)}var a=n(143),s=n(127),u=n(3),f=(n(126),Array.isArray);r.size=function(e){var n=t(e);return r.validate(e,n),n},r.validate=function(e,r){var n=0==r.length;if(n){if(f(e))throw new RangeError("Dimension mismatch ("+e.length+" != 0)")}else i(e,r,0)},r.validateIndex=function(e,r){if(!a.isNumber(e)||!a.isInteger(e))throw new TypeError("Index must be an integer (value: "+e+")");if(0>e)throw new RangeError("Index out of range ("+e+" < 0)");if(void 0!==r&&e>=r)throw new RangeError("Index out of range ("+e+" > "+(r-1)+")")},r.resize=function(e,r,n){if(!f(e)||!f(r))throw new TypeError("Array expected");if(0===r.length)throw new Error("Resizing to scalar is not supported");r.forEach(function(e){if(!a.isNumber(e)||!a.isInteger(e)||0>e)throw new TypeError("Invalid size, must contain positive integers (size: "+s.format(r)+")")});for(var t=1,i=e[0];f(i);)t++,i=i[0];for(;t<r.length;)e=[e],t++;for(;t>r.length;)e=e[0],t--;return o(e,r,0,n),e},r.squeeze=function(e){for(;f(e)&&1===e.length;)e=e[0];return e},r.unsqueeze=function(e,n){for(var t=r.size(e),i=0,o=n-t.length;o>i;i++)e=[e];return e},r.flatten=function(e){for(var r=e,n=Array.isArray;n(r[0]);){for(var t=[],i=0,o=r.length;o>i;i++)t=t.concat.apply(t,r[i]);r=t}return r},r.isArray=f},function(e,r,n){function t(e){return e instanceof o?e.isZero():0===e}function i(e,r,n){var t;return e instanceof o?(t=e.abs(),t.gte(r)&&t.lt(n)):(t=Math.abs(e),t>=r&&n>t)}var o=n(111);r.isNumber=function(e){return e instanceof Number||"number"==typeof e},r.isInteger=function(e){return e==Math.round(e)},r.sign=function(e){return e>0?1:0>e?-1:0},r.format=function(e,n){if("function"==typeof n)return n(e);if(1/0===e)return"Infinity";if(e===-1/0)return"-Infinity";if(isNaN(e))return"NaN";var a="auto",s=void 0;switch(void 0!==n&&(n.notation&&(a=n.notation),r.isNumber(n)?s=n:n.precision&&(s=n.precision)),a){case"fixed":return r.toFixed(e,s);case"scientific":throw new Error('Format notation "scientific" is deprecated. Use "exponential" instead.');case"exponential":return r.toExponential(e,s);case"auto":var u=.001,f=1e5;if(n&&n.exponential)void 0!==n.exponential.lower&&(u=n.exponential.lower),void 0!==n.exponential.upper&&(f=n.exponential.upper);else if(n&&n.scientific)throw new Error("options.scientific is deprecated, use options.exponential instead.");var c=e instanceof o;if(c){var l=o.config().EXPONENTIAL_AT;o.config({EXPONENTIAL_AT:[Math.round(Math.log(u)/Math.LN10),Math.round(Math.log(f)/Math.LN10)]})}if(t(e))return"0";var m;if(i(e,u,f))if(c)m=new o(e.toPrecision(s)).toString();else{var p=s?e.toPrecision(Math.min(s,21)):e.toPrecision();m=parseFloat(p)+""}else m=r.toExponential(e,s);return c&&o.config({EXPONENTIAL_AT:l}),m.replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],r=arguments[4];return"."!==e?e+r:r});default:throw new Error('Unknown notation "'+a+'". Choose "auto", "exponential", or "fixed".')}},r.toExponential=function(e,r){return void 0!==r?e.toExponential(e instanceof o?r-1:Math.min(r-1,20)):e.toExponential()},r.toFixed=function(e,r){return e.toFixed(e instanceof o?r||0:Math.min(r,20))},r.digits=function(e){return e.toExponential().replace(/e[\+\-0-9]*$/,"").replace(/^0\.0*|\./,"").length},r.toBigNumber=function(e){return r.digits(e)>15?e:new o(e)},r.toNumber=function(e){return parseFloat(e.valueOf())}},function(e,r,n){function t(e){return n(i(e))}function i(e){return o[e]||function(){throw new Error("Cannot find module '"+e+"'.")}()}var o={"./clone":103,"./clone.js":103,"./forEach":110,"./forEach.js":110,"./format":104,"./format.js":104,"./ifElse":105,"./ifElse.js":105,"./import":106,"./import.js":106,"./map":107,"./map.js":107,"./print":108,"./print.js":108,"./typeof":109,"./typeof.js":109};t.keys=function(){return Object.keys(o)},t.resolve=i,e.exports=t},function(e){e.exports={name:"abs",category:"Arithmetic",syntax:["abs(x)"],description:"Compute the absolute value.",examples:["abs(3.5)","abs(-4.2)"],seealso:["sign"]}},function(e){e.exports={name:"add",category:"Operators",syntax:["x + y","add(x, y)"],description:"Add two values.",examples:["2.1 + 3.6","ans - 3.6","3 + 2i",'"hello" + " world"',"3 cm + 2 inch"],seealso:["subtract"]}},function(e){e.exports={name:"ceil",category:"Arithmetic",syntax:["ceil(x)"],description:"Round a value towards plus infinity.If x is complex, both real and imaginary part are rounded towards plus infinity.",examples:["ceil(3.2)","ceil(3.8)","ceil(-4.2)"],seealso:["floor","fix","round"]}},function(e){e.exports={name:"compare",category:"Operators",syntax:["compare(x, y)"],description:"Compare two values. Returns 1 if x is larger than y, -1 if x is smaller than y, and 0 if x and y are equal.",examples:["compare(2, 3)","compare(3, 2)","compare(2, 2)","compare(5cm, 40mm)","compare(2, [1, 2, 3])"],seealso:["equal","unequal","smaller","smallereq","largereq"]}},function(e){e.exports={name:"cube",category:"Arithmetic",syntax:["cube(x)"],description:"Compute the cube of a value. The cube of x is x * x * x.",examples:["cube(2)","2^3","2 * 2 * 2"],seealso:["multiply","square","pow"]}},function(e){e.exports={name:"divide",category:"Operators",syntax:["x / y","divide(x, y)"],description:"Divide two values.",examples:["2 / 3","ans * 3","4.5 / 2","3 + 4 / 2","(3 + 4) / 2","18 km / 4.5"],seealso:["multiply"]}},function(e){e.exports={name:"edivide",category:"Operators",syntax:["x ./ y","edivide(x, y)"],description:"divide two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a ./ b"],seealso:["multiply","emultiply","divide"]}},function(e){e.exports={name:"emultiply",category:"Operators",syntax:["x .* y","emultiply(x, y)"],description:"multiply two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a .* b"],seealso:["multiply","divide","edivide"]}},function(e){e.exports={name:"epow",category:"Operators",syntax:["x .^ y","epow(x, y)"],description:"Calculates the power of x to y element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","a .^ 2"],seealso:["pow"]}},function(e){e.exports={name:"equal",category:"Operators",syntax:["x == y","equal(x, y)"],description:"Check equality of two values. Returns true if the values are equal, and false if not.",examples:["2+2 == 3","2+2 == 4","a = 3.2","b = 6-2.8","a == b","50cm == 0.5m"],seealso:["unequal","smaller","larger","smallereq","largereq","compare"]}},function(e){e.exports={name:"exp",category:"Arithmetic",syntax:["exp(x)"],description:"Calculate the exponent of a value.",examples:["exp(1.3)","e ^ 1.3","log(exp(1.3))","x = 2.4","(exp(i*x) == cos(x) + i*sin(x))   # Euler's formula"],seealso:["square","multiply","log"]}},function(e){e.exports={name:"fix",category:"Arithmetic",syntax:["fix(x)"],description:"Round a value towards zero.If x is complex, both real and imaginary part are rounded towards zero.",examples:["fix(3.2)","fix(3.8)","fix(-4.2)","fix(-4.8)"],seealso:["ceil","floor","round"]}},function(e){e.exports={name:"floor",category:"Arithmetic",syntax:["floor(x)"],description:"Round a value towards minus infinity.If x is complex, both real and imaginary part are rounded towards minus infinity.",examples:["floor(3.2)","floor(3.8)","floor(-4.2)"],seealso:["ceil","fix","round"]}},function(e){e.exports={name:"gcd",category:"Arithmetic",syntax:["gcd(a, b)","gcd(a, b, c, ...)"],description:"Compute the greatest common divisor.",examples:["gcd(8, 12)","gcd(-4, 6)","gcd(25, 15, -10)"],seealso:["lcm","xgcd"]}},function(e){e.exports={name:"larger",category:"Operators",syntax:["x > y","larger(x, y)"],description:"Check if value x is larger than y. Returns true if x is larger than y, and false if not.",examples:["2 > 3","5 > 2*2","a = 3.3","b = 6-2.8","(a > b)","(b < a)","5 cm > 2 inch"],seealso:["equal","unequal","smaller","smallereq","largereq","compare"]}},function(e){e.exports={name:"largereq",category:"Operators",syntax:["x >= y","largereq(x, y)"],description:"Check if value x is larger or equal to y. Returns true if x is larger or equal to y, and false if not.",examples:["2 > 1+1","2 >= 1+1","a = 3.2","b = 6-2.8","(a > b)"],seealso:["equal","unequal","smallereq","smaller","largereq","compare"]}},function(e){e.exports={name:"lcm",category:"Arithmetic",syntax:["lcm(x, y)"],description:"Compute the least common multiple.",examples:["lcm(4, 6)","lcm(6, 21)","lcm(6, 21, 5)"],seealso:["gcd"]}},function(e){e.exports={name:"log",category:"Arithmetic",syntax:["log(x)","log(x, base)"],description:"Compute the logarithm of a value. If no base is provided, the natural logarithm of x is calculated. If base if provided, the logarithm is calculated for the specified base. log(x, base) is defined as log(x) / log(base).",examples:["log(3.5)","a = log(2.4)","exp(a)","10 ^ 3","log(1000, 10)","log(1000) / log(10)","b = logb(1024, 2)","2 ^ b"],seealso:["exp","log10"]}},function(e){e.exports={name:"log10",category:"Arithmetic",syntax:["log10(x)"],description:"Compute the 10-base logarithm of a value.",examples:["log10(1000)","10 ^ 3","log10(0.01)","log(1000) / log(10)","log(1000, 10)"],seealso:["exp","log"]}},function(e){e.exports={name:"mod",category:"Operators",syntax:["x % y","x mod y","mod(x, y)"],description:"Calculates the modulus, the remainder of an integer division.",examples:["7 % 3","11 % 2","10 mod 4","function isOdd(x) = x % 2","isOdd(2)","isOdd(3)"],seealso:[]}},function(e){e.exports={name:"multiply",category:"Operators",syntax:["x * y","multiply(x, y)"],description:"multiply two values.",examples:["2.1 * 3.6","ans / 3.6","2 * 3 + 4","2 * (3 + 4)","3 * 2.1 km"],seealso:["divide"]}},function(e){e.exports={name:"pow",category:"Operators",syntax:["x ^ y","pow(x, y)"],description:"Calculates the power of x to y, x^y.",examples:["2^3 = 8","2*2*2","1 + e ^ (pi * i)"],seealso:["unequal","smaller","larger","smallereq","largereq"]}},function(e){e.exports={name:"round",category:"Arithmetic",syntax:["round(x)","round(x, n)"],description:"round a value towards the nearest integer.If x is complex, both real and imaginary part are rounded towards the nearest integer. When n is specified, the value is rounded to n decimals.",examples:["round(3.2)","round(3.8)","round(-4.2)","round(-4.8)","round(pi, 3)","round(123.45678, 2)"],seealso:["ceil","floor","fix"]}},function(e){e.exports={name:"sign",category:"Arithmetic",syntax:["sign(x)"],description:"Compute the sign of a value. The sign of a value x is 1 when x>1, -1 when x<0, and 0 when x=0.",examples:["sign(3.5)","sign(-4.2)","sign(0)"],seealso:["abs"]}},function(e){e.exports={name:"smaller",category:"Operators",syntax:["x < y","smaller(x, y)"],description:"Check if value x is smaller than value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 3","5 < 2*2","a = 3.3","b = 6-2.8","(a < b)","5 cm < 2 inch"],seealso:["equal","unequal","larger","smallereq","largereq","compare"]}},function(e){e.exports={name:"smallereq",category:"Operators",syntax:["x <= y","smallereq(x, y)"],description:"Check if value x is smaller or equal to value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 1+1","2 <= 1+1","a = 3.2","b = 6-2.8","(a < b)"],seealso:["equal","unequal","larger","smaller","largereq","compare"]}},function(e){e.exports={name:"sqrt",category:"Arithmetic",syntax:["sqrt(x)"],description:"Compute the square root value. If x = y * y, then y is the square root of x.",examples:["sqrt(25)","5 * 5","sqrt(-1)"],seealso:["square","multiply"]}},function(e){e.exports={name:"square",category:"Arithmetic",syntax:["square(x)"],description:"Compute the square of a value. The square of x is x * x.",examples:["square(3)","sqrt(9)","3^2","3 * 3"],seealso:["multiply","pow","sqrt","cube"]}},function(e){e.exports={name:"subtract",category:"Operators",syntax:["x - y","subtract(x, y)"],description:"subtract two values.",examples:["5.3 - 2","ans + 2","2/3 - 1/6","2 * 3 - 3","2.1 km - 500m"],seealso:["add"]}},function(e){e.exports={name:"unary",category:"Operators",syntax:["-x","unary(x)"],description:"Inverse the sign of a value.",examples:["-4.5","-(-5.6)"],seealso:["add","subtract"]}},function(e){e.exports={name:"unequal",category:"Operators",syntax:["x != y","unequal(x, y)"],description:"Check unequality of two values. Returns true if the values are unequal, and false if they are equal.",examples:["2+2 != 3","2+2 != 4","a = 3.2","b = 6-2.8","a != b","50cm != 0.5m","5 cm != 2 inch"],seealso:["equal","smaller","larger","smallereq","largereq","compare"]}},function(e){e.exports={name:"xgcd",category:"Arithmetic",syntax:["xgcd(a, b)"],description:"Calculate the extended greatest common divisor for two values",examples:["xgcd(8, 12)","gcd(8, 12)","xgcd(36163, 21199)"],seealso:["gcd","lcm"]}},function(e){e.exports={name:"arg",category:"Complex",syntax:["arg(x)"],description:"Compute the argument of a complex value. If x = a+bi, the argument is computed as atan2(b, a).",examples:["arg(2 + 2i)","atan2(3, 2)","arg(2 - 3i)"],seealso:["re","im","conj","abs"]}},function(e){e.exports={name:"conj",category:"Complex",syntax:["conj(x)"],description:"Compute the complex conjugate of a complex value. If x = a+bi, the complex conjugate is a-bi.",examples:["conj(2 + 3i)","conj(2 - 3i)","conj(-5.2i)"],seealso:["re","im","abs","arg"]}},function(e){e.exports={name:"re",category:"Complex",syntax:["re(x)"],description:"Get the real part of a complex number.",examples:["re(2 + 3i)","im(2 + 3i)","re(-5.2i)","re(2.4)"],seealso:["im","conj","abs","arg"]}},function(e){e.exports={name:"im",category:"Complex",syntax:["im(x)"],description:"Get the imaginary part of a complex number.",examples:["im(2 + 3i)","re(2 + 3i)","im(-5.2i)","im(2.4)"],seealso:["re","conj","abs","arg"]}},function(e){e.exports={name:"bignumber",category:"Type",syntax:["bignumber(x)"],description:"Create a big number from a number or string.",examples:["0.1 + 0.2","bignumber(0.1) + bignumber(0.2)",'bignumber("7.2")','bignumber("7.2e500")',"bignumber([0.1, 0.2, 0.3])"],seealso:["boolean","complex","index","matrix","string","unit"]}},function(e){e.exports={name:"boolean",category:"Type",syntax:["x","boolean(x)"],description:"Convert a string or number into a boolean.",examples:["boolean(0)","boolean(1)","boolean(3)",'boolean("true")','boolean("false")',"boolean([1, 0, 1, 1])"],seealso:["bignumber","complex","index","matrix","number","string","unit"]}},function(e){e.exports={name:"complex",category:"Type",syntax:["complex()","complex(re, im)","complex(string)"],description:"Create a complex number.",examples:["complex()","complex(2, 3)",'complex("7 - 2i")'],seealso:["bignumber","boolean","index","matrix","number","string","unit"]}},function(e){e.exports={name:"index",category:"Type",syntax:["[start]","[start:end]","[start:step:end]","[start1, start 2, ...]","[start1:end1, start2:end2, ...]","[start1:step1:end1, start2:step2:end2, ...]"],description:"Create an index to get or replace a subset of a matrix",examples:["[]","[1, 2, 3]","A = [1, 2, 3; 4, 5, 6]","A[1, :]","A[1, 2] = 50","A[0:2, 0:2] = ones(2, 2)"],seealso:["bignumber","boolean","complex","matrix,","number","range","string","unit"]}},function(e){e.exports={name:"matrix",category:"Type",syntax:["[]","[a1, b1, ...; a2, b2, ...]","matrix()","matrix([...])"],description:"Create a matrix.",examples:["[]","[1, 2, 3]","[1, 2, 3; 4, 5, 6]","matrix()","matrix([3, 4])"],seealso:["bignumber","boolean","complex","index","number","string","unit"]}},function(e){e.exports={name:"number",category:"Type",syntax:["x","number(x)"],description:"Create a number or convert a string or boolean into a number.",examples:["2","2e3","4.05","number(2)",'number("7.2")',"number(true)","number([true, false, true, true])"],seealso:["bignumber","boolean","complex","index","matrix","string","unit"]}},function(e){e.exports={name:"string",category:"Type",syntax:['"text"',"string(x)"],description:"Create a string or convert a value to a string",examples:['"Hello World!"',"string(4.2)","string(3 + 2i)"],seealso:["bignumber","boolean","complex","index","matrix","number","unit"]}},function(e){e.exports={name:"unit",category:"Type",syntax:["value unit","unit(value, unit)","unit(string)"],description:"Create a unit.",examples:["5.5 mm","3 inch",'unit(7.1, "kilogram")','unit("23 deg")'],seealso:["bignumber","boolean","complex","index","matrix","number","string"]}},function(e){e.exports={name:"eval",category:"Expression",syntax:["eval(expression)","eval([expr1, expr2, expr3, ...])"],description:"Evaluate an expression or an array with expressions.",examples:['eval("2 + 3")','eval("sqrt(" + 4 + ")")'],seealso:[]}},function(e){e.exports={name:"help",category:"Expression",syntax:["help(object)","help(string)"],description:"Display documentation on a function or data type.",examples:["help(sqrt)",'help("complex")'],seealso:[]}},function(e){e.exports={name:"concat",category:"Matrix",syntax:["concat(a, b, c, ...)","concat(a, b, c, ..., dim)"],description:"Concatenate matrices. By default, the matrices are concatenated by the first dimension. The dimension on which to concatenate can be provided as last argument.",examples:["a = [1, 2; 5, 6]","b = [3, 4; 7, 8]","concat(a, b)","[a, b]","concat(a, b, 2)","[a; b]"],seealso:["det","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"det",category:"Matrix",syntax:["det(x)"],description:"Calculate the determinant of a matrix",examples:["det([1, 2; 3, 4])","det([-2, 2, 3; -1, 1, 3; 2, 0, -1])"],seealso:["concat","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"diag",category:"Matrix",syntax:["diag(x)","diag(x, k)"],description:"Create a diagonal matrix or retrieve the diagonal of a matrix. When x is a vector, a matrix with the vector values on the diagonal will be returned. When x is a matrix, a vector with the diagonal values of the matrix is returned.When k is provided, the k-th diagonal will be filled in or retrieved, if k is positive, the values are placed on the super diagonal. When k is negative, the values are placed on the sub diagonal.",examples:["diag(1:3)","diag(1:3, 1)","a = [1, 2, 3; 4, 5, 6; 7, 8, 9]","diag(a)"],seealso:["concat","det","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"eye",category:"Matrix",syntax:["eye(n)","eye(m, n)","eye([m, n])","eye"],description:"Returns the identity matrix with size m-by-n. The matrix has ones on the diagonal and zeros elsewhere.",examples:["eye(3)","eye(3, 5)","a = [1, 2, 3; 4, 5, 6]","eye(size(a))"],seealso:["concat","det","diag","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"inv",category:"Matrix",syntax:["inv(x)"],description:"Calculate the inverse of a matrix",examples:["inv([1, 2; 3, 4])","inv(4)","1 / 4"],seealso:["concat","det","diag","eye","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"ones",category:"Matrix",syntax:["ones(m)","ones(m, n)","ones(m, n, p, ...)","ones([m])","ones([m, n])","ones([m, n, p, ...])","ones"],description:"Create a matrix containing ones.",examples:["ones(3)","ones(3, 5)","ones([2,3]) * 4.5","a = [1, 2, 3; 4, 5, 6]","ones(size(a))"],seealso:["concat","det","diag","eye","inv","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"range",category:"Type",syntax:["start:end","start:step:end","range(start, end)","range(start, end, step)","range(string)"],description:"Create a range. Lower bound of the range is included, upper bound is excluded.",examples:["1:5","3:-1:-3","range(3, 7)","range(0, 12, 2)",'range("4:10")',"a = [1, 2, 3, 4; 5, 6, 7, 8]","a[1:2, 1:2]"],seealso:["concat","det","diag","eye","inv","ones","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"resize",category:"Matrix",syntax:["resize(x, size)","resize(x, size, defaultValue)"],description:"Resize a matrix.",examples:["resize([1,2,3,4,5], [3])","resize([1,2,3], [5], 0)","resize(2, [2, 3], 0)",'resize("hello", [8], "!")'],seealso:["size","subset","squeeze"]}},function(e){e.exports={name:"size",category:"Matrix",syntax:["size(x)"],description:"Calculate the size of a matrix.",examples:["size(2.3)",'size("hello world")',"a = [1, 2; 3, 4; 5, 6]","size(a)","size(1:6)"],seealso:["concat","det","diag","eye","inv","ones","range","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"squeeze",category:"Matrix",syntax:["squeeze(x)"],description:"Remove singleton dimensions from a matrix.",examples:["a = zeros(1,3,2)","size(squeeze(a))","b = zeros(3,1,1)","size(squeeze(b))"],seealso:["concat","det","diag","eye","inv","ones","range","size","subset","transpose","zeros"]}},function(e){e.exports={name:"subset",category:"Matrix",syntax:["value(index)","value(index) = replacement","subset(value, [index])","subset(value, [index], replacement)"],description:"Get or set a subset of a matrix or string. Indexes are one-based. Both the ranges lower-bound and upper-bound are included.",examples:["d = [1, 2; 3, 4]","e = []","e[1, 1:2] = [5, 6]","e[2, :] = [7, 8]","f = d * e","f[2, 1]","f[:, 1]"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","transpose","zeros"]}},function(e){e.exports={name:"transpose",category:"Matrix",syntax:["x'","transpose(x)"],description:"Transpose a matrix",examples:["a = [1, 2, 3; 4, 5, 6]","a'","transpose(a)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","zeros"]}},function(e){e.exports={name:"zeros",category:"Matrix",syntax:["zeros(m)","zeros(m, n)","zeros(m, n, p, ...)","zeros([m])","zeros([m, n])","zeros([m, n, p, ...])","zeros"],description:"Create a matrix containing zeros.",examples:["zeros(3)","zeros(3, 5)","a = [1, 2, 3; 4, 5, 6]","zeros(size(a))"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","transpose"]}
},function(e){e.exports={name:"combinations",category:"Probability",syntax:["combinations(n, k)"],description:"Compute the number of combinations of n items taken k at a time",examples:["combinations(7, 5)"],seealso:["permutations","factorial"]}},function(e){e.exports={name:"distribution",category:"Probability",syntax:["distribution(name)","distribution(name, arg1, arg2, ...)"],description:'Create a distribution object of a specific type. A distribution object contains functions `random([size,] [min,] [max])`, `randomInt([size,] [min,] [max])`, and `pickRandom(array)`. Available types of distributions: "uniform", "normal". Note that the function distribution is currently not available via the expression parser.',examples:[],seealso:["random","randomInt"]}},function(e){e.exports={name:"factorial",category:"Probability",syntax:["n!","factorial(n)"],description:"Compute the factorial of a value",examples:["5!","5*4*3*2*1","3!"],seealso:[]}},function(e){e.exports={name:"permutations",category:"Probability",syntax:["permutations(n)","permutations(n, k)"],description:"Compute the number of permutations of n items taken k at a time",examples:["permutations(5)","permutations(5, 4)"],seealso:["combinations","factorial"]}},function(e){e.exports={name:"pickRandom",category:"Probability",syntax:["pickRandom(array)"],description:"Pick a random entry from a given array.",examples:["pickRandom(0:10)","pickRandom([1, 3, 1, 6])"],seealso:["distribution","random","randomInt"]}},function(e){e.exports={name:"random",category:"Probability",syntax:["random()","random(max)","random(min, max)","random(size)","random(size, max)","random(size, min, max)"],description:"Return a random number.",examples:["random()","random(10, 20)","random([2, 3])"],seealso:["distribution","pickRandom","randomInt"]}},function(e){e.exports={name:"randInt",category:"Probability",syntax:["randInt()","randInt(max)","randInt(min, max)","randInt(size)","randInt(size, max)","randInt(size, min, max)"],description:"Return a random integer number",examples:["randInt()","randInt(10, 20)","randInt([2, 3], 10)"],seealso:["distribution","pickRandom","random"]}},function(e){e.exports={name:"max",category:"Statistics",syntax:["max(a, b, c, ...)","max(A)","max(A, dim)"],description:"Compute the maximum value of a list of values.",examples:["max(2, 3, 4, 1)","max([2, 3, 4, 1])","max([2, 5; 4, 3], 0)","max([2, 5; 4, 3], 1)","max(2.7, 7.1, -4.5, 2.0, 4.1)","min(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["mean","median","min","prod","std","sum","var"]}},function(e){e.exports={name:"mean",category:"Statistics",syntax:["mean(a, b, c, ...)","mean(A)","mean(A, dim)"],description:"Compute the arithmetic mean of a list of values.",examples:["mean(2, 3, 4, 1)","mean([2, 3, 4, 1])","mean([2, 5; 4, 3], 0)","mean([2, 5; 4, 3], 1)","mean([1.0, 2.7, 3.2, 4.0])"],seealso:["max","median","min","prod","std","sum","var"]}},function(e){e.exports={name:"median",category:"Statistics",syntax:["median(a, b, c, ...)","median(A)"],description:"Compute the median of all values. The values are sorted and the middle value is returned. In case of an even number of values, the average of the two middle values is returned.",examples:["median(4, 2, 7)","median([3, -1, 5, 7])"],seealso:["max","mean","min","prod","std","sum","var"]}},function(e){e.exports={name:"min",category:"Statistics",syntax:["min(a, b, c, ...)","min(A)","min(A, dim)"],description:"Compute the minimum value of a list of values.",examples:["min(2, 3, 4, 1)","min([2, 3, 4, 1])","min([2, 5; 4, 3], 0)","min([2, 5; 4, 3], 1)","min(2.7, 7.1, -4.5, 2.0, 4.1)","max(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["max","mean","median","prod","std","sum","var"]}},function(e){e.exports={name:"prod",category:"Statistics",syntax:["prod(a, b, c, ...)","prod(A)"],description:"Compute the product of all values.",examples:["prod(2, 3, 4)","prod([2, 3, 4])","prod([2, 5; 4, 3])"],seealso:["max","mean","min","median","min","std","sum","var"]}},function(e){e.exports={name:"std",category:"Statistics",syntax:["std(a, b, c, ...)","std(A)","std(A, normalization)"],description:'Compute the standard deviation of all values, defined as std(A) = sqrt(var(A)). Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["std(2, 4, 6)","std([2, 4, 6, 8])",'std([2, 4, 6, 8], "uncorrected")','std([2, 4, 6, 8], "biased")',"std([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","sum","var"]}},function(e){e.exports={name:"sum",category:"Statistics",syntax:["sum(a, b, c, ...)","sum(A)"],description:"Compute the sum of all values.",examples:["sum(2, 3, 4, 1)","sum([2, 3, 4, 1])","sum([2, 5; 4, 3])"],seealso:["max","mean","median","min","prod","std","sum","var"]}},function(e){e.exports={name:"var",category:"Statistics",syntax:["var(a, b, c, ...)","var(A)","var(A, normalization)"],description:'Compute the variance of all values. Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["var(2, 4, 6)","var([2, 4, 6, 8])",'var([2, 4, 6, 8], "uncorrected")','var([2, 4, 6, 8], "biased")',"var([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","std","sum"]}},function(e){e.exports={name:"acos",category:"Trigonometry",syntax:["acos(x)"],description:"Compute the inverse cosine of a value in radians.",examples:["acos(0.5)","acos(cos(2.3))"],seealso:["cos","acos","asin"]}},function(e){e.exports={name:"asin",category:"Trigonometry",syntax:["asin(x)"],description:"Compute the inverse sine of a value in radians.",examples:["asin(0.5)","asin(sin(2.3))"],seealso:["sin","acos","asin"]}},function(e){e.exports={name:"atan",category:"Trigonometry",syntax:["atan(x)"],description:"Compute the inverse tangent of a value in radians.",examples:["atan(0.5)","atan(tan(2.3))"],seealso:["tan","acos","asin"]}},function(e){e.exports={name:"atan2",category:"Trigonometry",syntax:["atan2(y, x)"],description:"Computes the principal value of the arc tangent of y/x in radians.",examples:["atan2(2, 2) / pi","angle = 60 deg in rad","x = cos(angle)","y = sin(angle)","atan2(y, x)"],seealso:["sin","cos","tan"]}},function(e){e.exports={name:"cos",category:"Trigonometry",syntax:["cos(x)"],description:"Compute the cosine of x in radians.",examples:["cos(2)","cos(pi / 4) ^ 2","cos(180 deg)","cos(60 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["acos","sin","tan"]}},function(e){e.exports={name:"cot",category:"Trigonometry",syntax:["cot(x)"],description:"Compute the cotangent of x in radians. Defined as 1/tan(x)",examples:["cot(2)","1 / tan(2)"],seealso:["sec","csc","tan"]}},function(e){e.exports={name:"csc",category:"Trigonometry",syntax:["csc(x)"],description:"Compute the cosecant of x in radians. Defined as 1/sin(x)",examples:["csc(2)","1 / sin(2)"],seealso:["sec","cot","sin"]}},function(e){e.exports={name:"sec",category:"Trigonometry",syntax:["sec(x)"],description:"Compute the secant of x in radians. Defined as 1/cos(x)",examples:["sec(2)","1 / cos(2)"],seealso:["cot","csc","cos"]}},function(e){e.exports={name:"sin",category:"Trigonometry",syntax:["sin(x)"],description:"Compute the sine of x in radians.",examples:["sin(2)","sin(pi / 4) ^ 2","sin(90 deg)","sin(30 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["asin","cos","tan"]}},function(e){e.exports={name:"tan",category:"Trigonometry",syntax:["tan(x)"],description:"Compute the tangent of x in radians.",examples:["tan(0.5)","sin(0.5) / cos(0.5)","tan(pi / 4)","tan(45 deg)"],seealso:["atan","sin","cos"]}},function(e){e.exports={name:"to",category:"Units",syntax:["x to unit","to(x, unit)"],description:"Change the unit of a value.",examples:["5 inch in cm","3.2kg in g","16 bytes in bits"],seealso:[]}},function(e){e.exports={name:"clone",category:"Utils",syntax:["clone(x)"],description:"Clone a variable. Creates a copy of primitive variables,and a deep copy of matrices",examples:["clone(3.5)","clone(2 - 4i)","clone(45 deg)","clone([1, 2; 3, 4])",'clone("hello world")'],seealso:[]}},function(e){e.exports={name:"map",category:"Utils",syntax:["map(x, callback)"],description:"Create a new matrix or array with the results of the callback function executed on each entry of the matrix/array.",examples:["map([1, 2, 3], function(val) { return math.max(val, 1.5) })"],seealso:[]}},function(e){e.exports={name:"forEach",category:"Utils",syntax:["forEach(x, callback)"],description:"Iterates over all elements of a matrix/array, and executes the given callback.",examples:["forEach([1, 2, 3], function(val) { console.log(val) })"],seealso:[]}},function(e){e.exports={name:"format",category:"Utils",syntax:["format(value)","format(value, precision)"],description:"Format a value of any type as string.",examples:["format(2.3)","format(3 - 4i)","format([])","format(pi, 3)"],seealso:["print"]}},function(e){e.exports={name:"ifElse",category:"Utils",syntax:["ifElse(conditionalExpr, trueExpr, falseExpr)"],description:"Executes a ternary operation.",examples:["ifElse(10 > 0, 10, 0)"],seealso:[]}},function(e){e.exports={name:"import",category:"Utils",syntax:["import(string)"],description:"Import functions from a file.",examples:['import("numbers")','import("./mylib.js")'],seealso:[]}},function(e){e.exports={name:"typeof",category:"Utils",syntax:["typeof(x)"],description:"Get the type of a variable.",examples:["typeof(3.5)","typeof(2 - 4i)","typeof(45 deg)",'typeof("hello world")'],seealso:[]}},function(e,r){r.isBoolean=function(e){return e instanceof Boolean||"boolean"==typeof e}}])});
//# sourceMappingURL=math.map