//Dimensiones del canvas.
var display = 
{
	left_x: 0,
	top_y: 0,
	width: 1000,
	height: 700
};
	
//Rotacion
var rotation = 0.2;

//Vidas
var vidas = 5;

//Imagenes
var imgFondo;
var imgWall;
var imgLine;
var imgLimitD;
var imgLimitI;
var imgLimitD1;
var imgLimitI1;
var imgEnemy_1;
var imgEnemy_2;
var imgEnemy_3;

//Codigo de las teclas
var KEY_LEFT = 37;
var KEY_RIGHT = 39;
var KEY_PAUSE = 80;
var KEY_UP = 38;
var KEY_DOWN = 40;
var KEY_A = 65;
var KEY_D = 68;
var KEY_W = 87;
var KEY_S = 83;
var KEY_RESET = 82;
var KEY_MENU = 77;

//Variable para pausar el juego.
var PAUSA = false;

//Varible para volver al menu
var  MENU = false;

//Variable que almacena la direccion de la barrera
var dir = -1;
var dir1 = -1;
var dir2 = -1;

//Aqui se almacenan las teclas
var teclado = {};

//Iniciamos el juego a iniciando.
var juego = 
{
	estado: 'iniciando'
};
	
//Para almacenar los enemigos.
var enemigos  = [];
var enemigos1 = [];
var enemigos2 = [];

//Contamos los enemigos que vamos creando.
var enemigosCount = 0;

//Permitimos que se creen enemigos.
var crearEnemigos = true;
var crearEnemigos1 = true;
var crearEnemigos2 = true;
var crearEnemigos3 = true;

//Intervalo para crear enemigos.
var refreshInterval;
var refreshInterval1;
var refreshInterval2;

//Puntos.
var puntuacion = 0;

//Variables para calcular los FPS.
var time=0,FPS=0,frames=0,acumDelta=0;	


//Creamos la funcion que calcula los FPS
function mirarFPS()
{
	//Calculo los FPS
	var now = Date.now();//Date.now(); es una funcion que te da la fecha de ??
	var deltaTime = now-time;
	if(deltaTime>1000) deltaTime = 0;
	{
		time=now;
	}
	frames++;
	acumDelta+=deltaTime;
		
	if(acumDelta>1000)
	{
		FPS=frames;
		frames=0;
		acumDelta-=1000;
	}
}

//Comprobamos la colision entre el enemigo y la barrera.
function colision(a,b)
{
	var colision=false; 
	
	if (b.left_x + b.width >= a.left_x && b.left_x < a.left_x +a.width)
	{ 
		if (b.top_y + b.height >= a.top_y && b.top_y < a.top_y + a.height)
		{
			colision = true;
		}
	} 
	
	if (b.left_x <= a.left_x && b.left_x + b.width >= a.left_x + a.width)
	{ 
		if (b.top_y <= a.top_y && b.top_y + b.height >= a.top_y + a.height)
		{ 
			colision = true;
		}
	} 
	
	if (a.left_x <= b.left_x && a.left_x + a.width >= b.left_x + b.width)
	{ 
		if (a.top_y <= b.top_y && a.top_y + a.height >= b.top_y + b.height)
		{
			colision = true;
		}
	} 
	
	return colision; 
}

//dibujar enemigos.
function dibujarEnemigos()
{	
	for (var i in enemigos)
	{
		var enemigo = enemigos[i];
		
		ctx.save();
		ctx.translate(enemigo.left_x, enemigo.top_y);
		ctx.rotate(rotation);
		ctx.translate(-(enemigo.left_x + (enemigo.width/2)), -(enemigo.top_y +(enemigo.height/2)));
		ctx.drawImage(enemigo.imagen, enemigo.left_x, enemigo.top_y);
		ctx.restore();
	}
	rotation += 0.3;
}

//pintar textos.
function pintarTextos()
{
	//Texto para los FPS
	ctx.save();
	ctx.fillStyle = "White";
	ctx.textAlign='center';
    ctx.fillText('FPS: '+ FPS, 25, 20);
	ctx.restore();
	
	//Numeros de enemigos creado.
	ctx.save();
	ctx.fillStyle = "White";
	ctx.textAlign='center';
	ctx.fillText('Enemigos: '+ enemigosCount, 100, 20);
	ctx.restore();
	
	//Puntuacion
	ctx.save();
	ctx.fillStyle = "White";
	ctx.textAlign='center';
	ctx.font="bold 18px Arial";
	ctx.fillText('Puntos: '+ puntuacion, 450, 30);
	ctx.restore();
		
	if(vidas <= 0)
	{
		//Texto para el Game Over.
		ctx.save();
		ctx.fillStyle = "White";
		ctx.textAlign = 'center';
		ctx.font="bold 25px Arial";
		ctx.fillText('GAME OVER', 495, 200);
		ctx.textAlign = 'left';
		ctx.restore();
		
		//Texto para la puntuacion final.
		ctx.save();
		ctx.fillStyle = "White";
		ctx.textAlign = 'center';
		ctx.font="bold 25px Arial";
		ctx.fillText('Puntos: '+ puntuacion, 490, 250);
		ctx.textAlign = 'left';
		ctx.restore();
		
		//Texto para la info de como resetear.
		ctx.save();
		ctx.fillStyle = "White";
		ctx.textAlign = 'center';
		ctx.font="bold 12px Arial";
		ctx.fillText('R to reset.', 490, 400);
		ctx.textAlign = 'left';
		ctx.restore();
		
		//Texto para la info de como backear al menu principal.
		ctx.save();
		ctx.fillStyle = "White";
		ctx.textAlign = 'center';
		ctx.font="bold 12px Arial";
		ctx.fillText('M to main menu.', 490, 415);
		ctx.textAlign = 'left';
		ctx.restore();
	}
	
	if(PAUSA)
	{
		//Texto para el pausa.
		ctx.save();
		ctx.fillStyle = "White";
		ctx.textAlign = 'center';
		ctx.font="bold 25px Arial";
		ctx.fillText('PAUSA', 495, 200);
		ctx.textAlign = 'left';
		ctx.restore();
	}
}



//Agregamos los eventos de listener para el teclado
function agregarEventosTeclado()
{
    agregarEvento(document,"keydown",function(e){
        teclado[e.keyCode] = true;
		lastPressed = e.KeyCode;
		console.log(e.keyCode);
		});
		
    agregarEvento(document,"keyup",function(e){
        teclado[e.keyCode] = false;
		});

    function agregarEvento(elemento,nombreEvento,funcion)
    {
        if(elemento.addEventListener)
        {
            elemento.addEventListener(nombreEvento, funcion, false);
        }  
        else if (elemento.attachEvent)
        {
            elemento.attachEvent(nombreEvento, funcion);
        }
    }
}

//Cargamos las imagenes que vamos a usar.
function cargarImagenes()
{
	//Explosion enemigo.
	imgExplosion = new Image();
	imgExplosion.src = 'Img/Explosion.png';
	
	imgExplosion1 = new Image();
	imgExplosion1.src = 'Img/Explosion1.png';
	
	imgExplosion2 = new Image();
	imgExplosion2.src = 'Img/Explosion2.png';
	
	//Enemigo 1
	imgEnemy_1 = new Image();
	imgEnemy_1.src = 'Img/Enemigo_1.png';
	
	imgEnemy_2 = new Image();
	imgEnemy_2.src = 'Img/Enemigo_2.png';
	
	imgEnemy_3 = new Image();
	imgEnemy_3.src = 'Img/Enemigo_3.png';
		
	//Limite izquierdo.
	imgLimitI = new Image();
	imgLimitI.src = 'Img/Limite_i.png';
	
	//Limite derecho.
	imgLimitD = new Image();
	imgLimitD.src = 'Img/Limite_d.png';
	
	//Limite izquierdo.
	imgLimitI1 = new Image();
	imgLimitI1.src = 'Img/Limite_i1.png';
	
	//Limite derecho.
	imgLimitD1 = new Image();
	imgLimitD1.src = 'Img/Limite_d1.png';
	
	//Imagen de la linea.
	imgLine = new Image();
	imgLine.src = 'Img/Linea.png';
	
	//Imagen de la barrera.
	imgWall = new Image();
	imgWall.src = 'Img/Wall.png';
	
	//Imagen de la barrera1.
	imgWall1 = new Image();
	imgWall1.src = 'Img/Wall1.png';
	
	//Imagen de la barrera2.
	imgWall2 = new Image();
	imgWall2.src = 'Img/Wall2.png';
	
	//Imagen del fondo
	imgFondo = new Image();
	imgFondo.src = 'Img/Fondo.png';
}