//Dimensiones de la linea.
var linea = {
	left_x: 0,
	top_y: 300,
	width: 1000,
	height: 1
	};

//Dimensiones de la barrera.
var wall = {
	left_x: 450,
	top_y: 296,
	width: 145,
	height: 8,
	estado: 'vivo'
	};

//Limite por la derecha.
var limiteD = {
	left_x: 0,
	top_y: 0,
	width: 24,
	height: 43
	};

//Limite por la izquierda.
var limiteI = {
	left_x: 0,
	top_y: 0,
	width: 24,
	height: 43
	};
	
var i,j,k;
var enemigo, enemigo1, enemigo2;
//Creamos la imagen para la animacion del enemigo.
var imgVidas;
imgVidas = new Image(); 
imgVidas.src = 'Img/sprite.png';
imgVidas.frames= 10;
imgVidas.currentFrame= 0; 
imgVidas.ticks=0; 
imgVidas.ticksPerFrame= 2; 

//Setup.
function setup_lv1()
{
	if (canvas.getContext)
	{
		agregarEventosTeclado();
		
		//Inicializamos el juego.
		initialize_lv1();
		
		//Cargo las imagenes.
		cargarImagenes();
		
		imgFondo.onload = function()
		{
			if(imgFondo === null)
			{
					alert("No se carga la imagen.");
			}
			loop_lv1();
		};	
	}
}

//Initialize.
function initialize_lv1()
{
	//Inicializo las vidas del jugador.
	vidas = 5;
	
	jugandoNivel=1;
	
	//Posicionamos la barrera en el centro.
	wall.left_x = 450;
	wall.width = 145;
	dir = -1;
	//enemigo.top_y = 0;
	
	//Quitamos el pause.
	PAUSA = false;
	
	//Ponemos a false el menu
	MENU = false;
	
	//Los enemigos creados son 0.
	enemigosCount = 0;
	
	//Reseteamos la rotacion de los enemigos.
	rotation = 0.2;
	
	//Limpiamos el intervalo de creacion de enemigos y reseteamos su bool.
	clearInterval(refreshInterval);
	crearEnemigos = true;
	
	//Reseteamos la puntuacion.
	puntuacion = 0;
	 
	//Reseteamos las variables de los FPS.
	time=0;FPS=0;frames=0;acumDelta=0;	
	 
	//Limpiamos el array de enemigos.
	enemigos = enemigos.filter(function(enemigo)
	{
		return false; 
	});
	
}

//Accion.
function accion_lv1()
{
	
	if(!PAUSA)
	{
		//Comprobamos la dirección
		if(teclado[KEY_RIGHT] && (wall.left_x <= (display.width - wall.width - 3)))
		{
			dir = 0;
		}
		
		if(teclado[KEY_LEFT] && (wall.left_x >= 0 + 3))
		{
			dir = 1;
		}
		
		//Movemos la nave teniendo en cuenta los límites
		if(dir === 0)
		{
			wall.left_x += 13;
		}
		if(dir == 1)
		{
			wall.left_x -= 13;
		}
		
		//Para que no continue moviendose si no apretamos una tecla
		dir = -1;
	}
	
	//Variable para el pause.
	if(teclado[KEY_PAUSE])
	{
		PAUSA = !PAUSA;
		teclado[KEY_PAUSE] = false;
		//Paramos el intervalo crear enemigos.
		clearInterval(refreshInterval);
		//Permitimos que despues del pause se creen enemigos.
		crearEnemigos = true;
	}	

}

//Loop.
function loop_lv1()
{
	
	if(jugandoNivel==1)
	{
		//Llamamos a la funcion que mira los fps
		mirarFPS();
		
		//Llamo a la funcion Loop() cada frame
		requestAnimationFrame(loop_lv1);
	
		if(vidas > 0)
		{	
			//Funciones a llamar
			accion_lv1();
			
			if(!PAUSA)
			{
				actualizarEnemigos_lv1();
			}
			
			comprobarColision_lv1();
					
		
		
			dibujarFondo_lv1();
			dibujarBarrera_lv1();
			dibujarEnemigos();
			dibujarLimites_lv1();
			dibujarObjeto(); 
			pintarTextos();
		}
		else
		{
			//Si la tecla que se pulsa despues de morir es la R volvemos a iniciar el nivel
			if(teclado[KEY_RESET])
			{
				initialize_lv1();
				comprobarPunt();
			}
	
			//Si la tecla que se pulsa despues de morir es la M volvemos al menu		
			if(teclado[KEY_MENU])
			{
				
				initialize();
				teclado[KEY_MENU]=false;
				
				jugandoNivel=0;
				
				//Indica si estamos jugando
				jugando=false;
				MostrarMenu();
				comprobarPunt();
			}
		
		}
	}
}

//Comprobamos la colision entre el enemigo y la barrera.
function comprobarColision_lv1()
{
	for(i in enemigos)
	{
		enemigo = enemigos[i];
		if(colision(enemigo, wall))
		{
			enemigo.estado = 'colision';
			enemigo.imagen = imgExplosion;
			//Con esta linea llamamos al sonido y lo reproducimos al colisionar.
			document.getElementById('sonido').play();
		}
	}
}

//Actualizar enemigos.
function actualizarEnemigos_lv1()
{
	//Creamos al enemigo.
	if(crearEnemigos)
	{
		refreshInterval = setInterval('crearEnemigo_lv1();', 1000);
		crearEnemigos = false;
	}
	
	//Movemos al enemigo.
	for (i in enemigos)
	{
		//movemos enemigos.
		enemigo = enemigos[i];
		if(enemigo.estado == 'vivo')
		{
			enemigo.top_y -= 2;
		}
	}
	
	//Dibujamos la explosion del enemigo.
	for(i in enemigos)
	{
		enemigo = enemigos[i];
		if(enemigo.estado == 'colision')
		{
			
			enemigo.estado = 'muerto';
			
			console.log("dead");
		}
	}
	
	//Eliminamos enemigos.
	enemigos = enemigos.filter(function(enemigo)
	{ 		
		if (enemigo && enemigo.estado == 'muerto') 
		{
			puntuacion += 1;
			enemigosCount -= 1;
			return false;
		}
		return true; 
	});
	
	//El enemigo ha salido de la pantalla por la parte de arriba, lo eliminamos.
	enemigos= enemigos.filter(function(enemigo)
	{ 
		if (enemigo && enemigo.estado == 'vivo' && enemigo.top_y < 0) 
		{
			enemigosCount -= 1;
			vidas -= 1;
			return false;
		}
		return true; 
	});	
}


//Crear enemigo.
function crearEnemigo_lv1()
{
	enemigo_x =Math.random(1000)*1000;
	
	//Controlo el limite por la izquierda.
	if(enemigo_x <=100)
	{
		enemigo_x += 100;
	}
	
	//Controlo el limite por la derecha.
	if(enemigo_x >=900)
	{
		enemigo_x -= 100;
	}
	
	enemigos.push(
	{
		left_x: enemigo_x,
		top_y: 650,
		width: 15,
		height: 15,
		estado: 'vivo',
		imagen: imgEnemy_1
	});
	enemigosCount += 1;
}

//Aqui dibujo la barrera.
function dibujarBarrera_lv1()
{
	ctx.drawImage(imgWall, wall.left_x, wall.top_y, wall.width, wall.height );
}

//Aqui Dibujo los limites.
function dibujarLimites_lv1()
{
	ctx.drawImage(imgLimitD, (display.width - (limiteD.width)), (linea.top_y - (limiteD.height/2)) );
	ctx.drawImage(imgLimitI, 0, (linea.top_y - (limiteI.height/2)) );
}

//Aqui dibujo el fondo
function dibujarFondo_lv1()
{	
	ctx.drawImage(imgFondo, 0, 0);
	ctx.drawImage(imgLine, linea.left_x, linea.top_y);
}

//Creamos la animacion del enemigo con las siguientes funciones.
function dibujarObjeto()
{ 
	imgVidas.ticks++; 
	if (imgVidas.ticks>=imgVidas.ticksPerFrame)
 	{ 
		imgVidas.currentFrame++; 
		imgVidas.ticks=0; 
	} 
	
	if (imgVidas.currentFrame>=10) 
	{
		imgVidas.currentFrame= imgVidas.currentFrame%10;
	}
	
    var imgX= imgVidas.currentFrame*imgVidas.width/imgVidas.frames; 
	
	if(vidas==5)
	{
		ctx.drawImage(imgVidas, imgX,0,20,20, 265,13,20,20); 
	}
	if(vidas>=4)
	{
		ctx.drawImage(imgVidas, imgX,0,20,20, 245,13,20,20); 
	}
	if(vidas>=3)
	{
		ctx.drawImage(imgVidas, imgX,0,20,20, 225,13,20,20); 
	}
	if(vidas>=2)
	{
		ctx.drawImage(imgVidas, imgX,0,20,20, 205,13,20,20); 
	}
	if(vidas>=1)
	{
		ctx.drawImage(imgVidas, imgX,0,20,20, 185,13,20,20); 
	}
} 