
//Dimensiones de la linea 1.
var linea = {
	left_x: 0,
	top_y: 350,
	width: 1000,
	height: 1
	};
	
//Dimensiones de la linea 2.
var linea2 = {
	left_x: 0,
	top_y: 150,
	width: 1000,
	height: 1
	};

//Dimensiones de la barrera.
var wall = {
	left_x: 450,
	top_y: 346,
	width: 100,
	height: 8
	};

//Dimensiones de la barrera 2.
var wall2 = {
	left_x: 450,
	top_y: 146,
	width: 100,
	height: 8
	};

//Limite por la derecha.
var limiteD = {
	left_x: 0,
	top_y: 0,
	width: 24,
	height: 43
	};
	
//Limite por la derecha 2.
var limiteD2 = {
	left_x: 0,
	top_y: 0,
	width: 24,
	height: 43
	};

//Limite por la izquierda.
var limiteI = {
	left_x: 0,
	top_y: 0,
	width: 24,
	height: 43
	};

//Limite por la izquierda 2.
var limiteI2 = {
	left_x: 0,
	top_y: 0,
	width: 24,
	height: 43
	};

//Setup.
function setup_lv2()
{
	canvas = document.getElementById('miCanvas');
	
	if (canvas.getContext)
	{
		ctx = canvas.getContext('2d');
		agregarEventosTeclado();
		
		//Inicializamos el juego.
		initialize_lv2();
		
		//Cargo las imagenes.
		cargarImagenes();
		
		imgFondo.onload = function()
		{
			loop_lv2();
		};			
	}
}

//Initialize.
function initialize_lv2()
{
	//Inicializo las vidas del jugador.
	vidas = 5;
	
	jugandoNivel=2;
	//Posicionamos la barrera en el centro.
	wall.left_x = 450;
	wall2.left_x = 450;
	wall.width = 100;
	wall2.width = 100;
	dir = -1;
	//enemigo.top_y = 0;
	
	//Quitamos el pause.
	PAUSA = false;
	
	//Ponemos a false el menu
	MENU = false;
	
	//Los enemigos creados son 0.
	enemigosCount = 0;
	
	//Reseteamos la rotacion de los enemigos.
	rotation = 0.2;
	
	//Limpiamos el intervalo de creacion de enemigos y reseteamos su bool.
	clearInterval(refreshInterval);
	crearEnemigos = true;
	
	//Reseteamos la puntuacion.
	puntuacion = 0;
	 
	//Reseteamos las variables de los FPS.
	time=0;FPS=0;frames=0;acumDelta=0;	
	 
	//Limpiamos el array de enemigos.
	enemigos = enemigos.filter(function(enemigo)
	{
		return false; 
	});
}

//Loop.
function loop_lv2()
{

	if(jugandoNivel==2)
	{
		//Llamamos a la funcion que mira los fps
		mirarFPS();
		
		//Llamo a la funcion Loop() cada frame
		requestAnimationFrame(loop_lv2);
	
		if(vidas > 0)
		{	
			//Funciones a llamar
			accion_lv2();
			if(!PAUSA)
			{
				actualizarEnemigos_lv2();
			}
			
			comprobarColision_lv2();
			
			dibujarFondo_lv2();
			dibujarBarrera_lv2();
			dibujarEnemigos();
			dibujarLimites_lv2();
			dibujarObjeto(); 
			pintarTextos();
		}
		else
		{
			//Si la tecla que se pulsa despues de morir es la R volvemos a iniciar el nivel
			if(teclado[KEY_RESET])
			{
				//setup();
				initialize_lv2();
				comprobarPunt();
			}
			
			//Si la tecla que se pulsa despues de morir es la M volvemos al menu
			if(teclado[KEY_MENU])
			{
				initialize();
				teclado[KEY_MENU]=false;
				
				jugandoNivel=0;
				//Indica si estamos jugando
				jugando=false;
				MostrarMenu();
				
				comprobarPunt();
	
			}
			
		}
	}
}

//Accion.
function accion_lv2()
{
	if(!PAUSA)
	{
		//Comprobamos la dirección de la barrera 1.
		if(teclado[KEY_RIGHT] && (wall.left_x <= (display.width - wall.width - 3)))
		{
			dir = 0;
		}
		
		if(teclado[KEY_LEFT] && (wall.left_x >= 0 + 3))
		{
			dir = 1;
		}
		
		//Movemos la barrera teniendo en cuenta los límites
		if(dir === 0)
		{
			wall.left_x += 10;
		}
		if(dir == 1)
		{
			wall.left_x -= 10;
		}
		
		//Comprobamos la dirección de la barrera 2.
		if(teclado[KEY_D] && (wall2.left_x <= (display.width - wall2.width - 3)))
		{
			dir1 = 0;
		}
		
		if(teclado[KEY_A] && (wall2.left_x >= 0 + 3))
		{
			dir1 = 1;
		}
		
		//Movemos la barrera teniendo en cuenta los límites
		if(dir1 === 0)
		{
			wall2.left_x += 10;
		}
		if(dir1 == 1)
		{
			wall2.left_x -= 10;
		}
		
		//Para que no continue moviendose si no apretamos una tecla
		dir = -1;
		dir1 = -1;
	}
	
	//Variable para el pause.
	if(teclado[KEY_PAUSE])
	{
		PAUSA = !PAUSA;
		teclado[KEY_PAUSE] = false;
		//Paramos el intervalo crear enemigos.
		clearInterval(refreshInterval);
		//Permitimos que despues del pause se creen enemigos.
		crearEnemigos = true;
	}
	
}

//Comprobamos la colision entre el enemigo y la barrera.
function comprobarColision_lv2()
{
	for(i in enemigos)
	{
		//Colision con la primera barrera.
		enemigo = enemigos[i];
		if(colision(enemigo, wall))
		{
			enemigo.estado = 'colision';
			//Con esta linea llamamos al sonido y lo reproducimos al colisionar.
			document.getElementById('sonido').play();
		}
		
		//Colisiion con la segunda barrera.
		if(colision(enemigo, wall2))
		{
			enemigo.estado = 'colision';
			//Con esta linea llamamos al sonido y lo reproducimos al colisionar.
			document.getElementById('sonido').play();
		}
	}
}

//Actualizar enemigos.
function actualizarEnemigos_lv2()
{
	//Creamos al enemigo.
	if(crearEnemigos)
	{
		refreshInterval = setInterval('crearEnemigo_lv2();', 950);
		crearEnemigos = false;
	}
	
	//Movemos al enemigo.
	for (i in enemigos)
	{
		//movemos enemigos.
		enemigo = enemigos[i];
		if(enemigo.estado == 'vivo')
		{
			enemigo.top_y -= 2;
		}
	}
	
	//Dibujamos la explosion del enemigo.
	for(i in enemigos)
	{
		enemigo = enemigos[i];
		if(enemigo.estado == 'colision')
		{
			enemigo.estado = 'muerto';
			
			console.log("dead");
		}
	}
	
	//Eliminamos enemigos.
	enemigos = enemigos.filter(function(enemigo)
	{ 		
		if (enemigo && enemigo.estado == 'muerto') 
		{
			puntuacion += 1;
			enemigosCount -= 1;
			return false;
		}
		return true; 
	});
	
	//El enemigo ha salido de la pantalla por la parte de arriba, lo eliminamos.
	enemigos= enemigos.filter(function(enemigo)
	{ 
		if (enemigo && enemigo.estado == 'vivo' && enemigo.top_y < 0) 
		{
			enemigosCount -= 1;
			vidas -= 1;
			return false;
		}
		return true; 
	});	
}



//Crear enemigo.
function crearEnemigo_lv2()
{
	enemigo_x =Math.random(1000)*1000;
	
	//Controlo el limite por la izquierda.
	if(enemigo_x <=100)
	{
		enemigo_x += 100;
	}
	
	//Controlo el limite por la derecha.
	if(enemigo_x >=900)
	{
		enemigo_x -= 100;
	}
	
	enemigos.push(
	{
		left_x: enemigo_x,
		top_y: 650,
		width: 15,
		height: 15,
		estado: 'vivo',
		imagen: imgEnemy_1
	});
	enemigosCount += 1;
}

//Aqui dibujo la barrera.
function dibujarBarrera_lv2()
{
	//Barrera 1.
	ctx.drawImage(imgWall, wall.left_x, wall.top_y, wall.width, wall.height);
	//Barrera 2.
	ctx.drawImage(imgWall2, wall2.left_x, wall2.top_y, wall2.width, wall2.height);
}

//Aqui Dibujo los limites.
function dibujarLimites_lv2()
{
	//Limites linea 1.
	ctx.drawImage(imgLimitD, (display.width - (limiteD.width)), (linea.top_y - (limiteD.height/2)) );
	ctx.drawImage(imgLimitI, 0, (linea.top_y - (limiteI.height/2)) );
	//Limites linea 2.
	ctx.drawImage(imgLimitD, (display.width - (limiteD2.width)), (linea2.top_y - (limiteD2.height/2)) );
	ctx.drawImage(imgLimitI, 0, (linea2.top_y - (limiteI2.height/2)) );
}

//Aqui dibujo el fondo
function dibujarFondo_lv2()
{	
	//Fondo negro.
	ctx.drawImage(imgFondo, 0, 0);
	//Linea 1.
	ctx.drawImage(imgLine, linea.left_x, linea.top_y);
	//Linea 2.
	ctx.drawImage(imgLine, linea2.left_x, linea2.top_y);
}
