
//Dimensiones de la lineas.
var lv3_linea = {
	left_x: 300,
	top_y: 350,
	width: 400,
	height: 1
	};	

var lv3_linea1 = {
	left_x: 300,
	top_y: 50,
	width: 1,
	height: 350
	};
	
var lv3_linea2 = {
	left_x: 700,
	top_y: 50,
	width: 1,
	height: 350
	};


//Dimensiones de la barrera.
var lv3_wall = {
	left_x: 450,
	top_y: 346,
	width: 50,
	height: 8
	};

//Dimensiones de la barrera1.
var lv3_wall1 = {
	left_x: 296,
	top_y: 200,
	width: 8,
	height: 50
	};
	
//Dimensiones de la barrera2.
var lv3_wall2 = {
	left_x: 696,
	top_y: 200,
	width: 8,
	height: 50
	};


//Limite por la derecha.
var lv3_limiteD = {
	left_x: 0,
	top_y: 0,
	width: 24,
	height: 43
	};

//Limite por la izquierda.
var lv3_limiteI = {
	left_x: 0,
	top_y: 0,
	width: 24,
	height: 43
	};

//Setup.
function setup_lv3()
{
	canvas = document.getElementById('miCanvas');
	
	if (canvas.getContext)
	{
		ctx = canvas.getContext('2d');
		agregarEventosTeclado();
		
		//Inicializamos el juego.
		initialize_lv3();
		
		//Cargo las imagenes.
		cargarImagenes();
		
		imgFondo.onload = function()
		{
			loop_lv3();
		};			
	}
}

//Initialize.
function initialize_lv3()
{
	//Inicializo las vidas del jugador.
	vidas = 5;
	
	jugandoNivel=3;
	//Posicionamos la barrera en el centro.
	lv3_wall.left_x = 450;
	lv3_wall1.left_x = 296;
	lv3_wall2.left_x = 696;
	lv3_wall.top_y = 346;
	lv3_wall1.top_y = 200;
	lv3_wall2.top_y = 200;
	
	dir = -1;
	dir1 = -1;
	dir2 = -1;
	
	//Quitamos el pause.
	PAUSA = false;
	
	//Ponemos a false el menu
	MENU = false;
	
	//Los enemigos creados son 0.
	enemigosCount = 0;
	
	//Reseteamos la rotacion de los enemigos.
	rotation = 0.2;
	
	//Limpiamos el intervalo de creacion de enemigos y reseteamos su bool.
	clearInterval(refreshInterval);
	clearInterval(refreshInterval1);
	clearInterval(refreshInterval2);
	
	crearEnemigos1 = true;
	crearEnemigos2 = true;
	crearEnemigos3  = true;
	
	//Reseteamos la puntuacion.
	puntuacion = 0;
	 
	//Reseteamos las variables de los FPS.
	time=0;FPS=0;frames=0;acumDelta=0;	
	 
	//Limpiamos el array de enemigos.
	enemigos = enemigos.filter(function(enemigo)
	{
		return false; 
	});
	enemigos1 = enemigos1.filter(function(enemigo1)
	{
		return false; 
	});
	enemigos2 = enemigos2.filter(function(enemigo2)
	{
		return false; 
	});
}

//Accion.
function accion_lv3()
{
	if(!PAUSA)
	{
		//Comprobamos la dirección
		if(teclado[KEY_RIGHT] && (lv3_wall.left_x <= (display.width - lv3_wall.width - 306)))
		{
			dir = 0;
		}
		
		if(teclado[KEY_LEFT] && (lv3_wall.left_x >= 315))
		{
			dir = 1;
		}
		
		if(teclado[KEY_S] && (lv3_wall1.top_y <= (display.height - lv3_wall1.height - 356)))
		{
			dir1 = 0;
		}
		
		if(teclado[KEY_W] && (lv3_wall1.top_y >= 55))
		{
			dir1 = 1;
		}
		
		if(teclado[KEY_DOWN] && (lv3_wall2.top_y <= (display.height - lv3_wall2.height - 356)))
		{
			dir2 = 0;
		}
		
		if(teclado[KEY_UP] && (lv3_wall2.top_y >= 55))
		{
			dir2 = 1;
		}
		
		
		//Movemos la nave teniendo en cuenta los límites
		if(dir === 0)
		{
			lv3_wall.left_x += 13;
		}
		if(dir == 1)
		{
			lv3_wall.left_x -= 13;
		}
		
		if(dir1 === 0)
		{
			lv3_wall1.top_y += 13;
		}
		if(dir1 == 1)
		{
			lv3_wall1.top_y -= 13;
		}
		
		if(dir2 === 0)
		{
			lv3_wall2.top_y += 13;
		}
		if(dir2 == 1)
		{
			lv3_wall2.top_y -= 13;
		}
		
		//Para que no continue moviendose si no apretamos una tecla
		dir = -1;
		dir1 = -1;
		dir2 = -1;
	}
	
	//Variable para el pause.
	if(teclado[KEY_PAUSE])
	{
		PAUSA = !PAUSA;
		teclado[KEY_PAUSE] = false;
		//Paramos el intervalo crear enemigos.
		clearInterval(refreshInterval);
		clearInterval(refreshInterval1);
		clearInterval(refreshInterval2);
		
		//Permitimos que despues del pause se creen enemigos.
		crearEnemigos1 = true;
		crearEnemigos2 = true;
		crearEnemigos3 = true;
	}
}

//Loop.
function loop_lv3()
{	
	if(jugandoNivel==3)
	{
		//Llamamos a la funcion que mira los fps
		mirarFPS();
		
		//Llamo a la funcion Loop() cada frame
		requestAnimationFrame(loop_lv3);
	
	
		if(vidas > 0)
		{	
			//Funciones a llamar
			accion_lv3();
			if(!PAUSA)
			{
				actualizarEnemigos_lv3();
			}
			
			comprobarColision_lv3();
			
			dibujarFondo_lv3();
			dibujarBarrera_lv3();
			dibujarLimites_lv3();
			dibujarEnemigos_lv3();
			dibujarEnemigos1_lv3();
			dibujarEnemigos2_lv3();
			dibujarObjeto(); 
			pintarTextos();
		}
		else
		{
			//Si la tecla que se pulsa despues de morir es la R volvemos a iniciar el nivel
			if(teclado[KEY_RESET])
			{
				//setup();
				initialize_lv3();
				comprobarPunt();
			}
			
			//Si la tecla que se pulsa despues de morir es la M volvemos al menu
			if(teclado[KEY_MENU])
			{
				
				initialize();
				teclado[KEY_MENU]=false;
				
				jugandoNivel=0;
				//Indica si estamos jugando
				jugando=false;
				
				MostrarMenu();
				
				comprobarPunt();
			}
			
			
		}
	}
}

//Comprobamos la colision entre el enemigo y la barrera.
function comprobarColision_lv3()
{
	for(i in enemigos)
	{
		enemigo = enemigos[i];
		if(colision(enemigo, lv3_wall))
		{
			enemigo.estado = 'colision';
			enemigo.imagen = imgExplosion;
			//Con esta linea llamamos al sonido y lo reproducimos al colisionar.
			document.getElementById('sonido').play();
		}
	}
	
	for(j in enemigos1)
	{
		enemigo1 = enemigos1[j];
		if(colision(enemigo1, lv3_wall1))
		{
			enemigo1.estado = 'colision';
			enemigo1.imagen = imgExplosion1;
			//Con esta linea llamamos al sonido y lo reproducimos al colisionar.
			document.getElementById('sonido').play();
		}
	}
	
	for(k in enemigos2)
	{
		enemigo2 = enemigos2[k];
		if(colision(enemigo2, lv3_wall2))
		{
			enemigo2.estado = 'colision';
			enemigo2.imagen = imgExplosion2;
			//Con esta linea llamamos al sonido y lo reproducimos al colisionar.
			document.getElementById('sonido').play();
		}
	}
}


//Actualizar enemigos.
function actualizarEnemigos_lv3()
{
	//Creamos al enemigo.
	if(crearEnemigos3)
	{
		refreshInterval = setInterval('crearEnemigo_lv3();', 2000);
		crearEnemigos3 = false;
	}
	
	if(crearEnemigos1)
	{
		refreshInterval1 = setInterval('crearEnemigo1_lv3();', 3000);
		crearEnemigos1 = false;
	}
	
	if(crearEnemigos2)
	{
		refreshInterval2 = setInterval('crearEnemigo2_lv3();', 4000);
		crearEnemigos2 = false;
	}
	
	//Movemos al enemigo.
	for (i in enemigos)
	{
		//movemos enemigos.
		enemigo = enemigos[i];
		if(enemigo.estado == 'vivo')
		{
			enemigo.top_y -= 2;
		}
	}
	
	for (j in enemigos1)
	{
		//movemos enemigos.
		enemigo1 = enemigos1[j];
		if(enemigo1.estado == 'vivo')
		{
			enemigo1.left_x += 2;
		}
	}
	
	for (k in enemigos2)
	{
		//movemos enemigos.
		enemigo2 = enemigos2[k];
		if(enemigo2.estado == 'vivo')
		{
			enemigo2.left_x -= 2;
		}
	}
	
	//Dibujamos la explosion del enemigo.
	for(i in enemigos)
	{
		enemigo = enemigos[i];
		if(enemigo.estado == 'colision' && enemigo.imagen == imgExplosion)
		{
			enemigo.estado = 'muerto';
		}
	}
	for(j in enemigos1)
	{
		enemigo1 = enemigos1[j];
		if(enemigo1.estado == 'colision' && enemigo1.imagen == imgExplosion1)
		{
			enemigo1.estado = 'muerto';
		}
	}
	for(k in enemigos2)
	{
		enemigo2 = enemigos2[k];
		if(enemigo2.estado == 'colision' && enemigo2.imagen == imgExplosion2)
		{
			enemigo2.estado = 'muerto';
		}
	}
	
	//Eliminamos enemigos.
	enemigos = enemigos.filter(function(enemigo)
	{ 		
		if (enemigo && enemigo.estado == 'muerto') 
		{
			console.log("dead");
			puntuacion += 1;
			enemigosCount -= 1;
			return false;
		}
		return true; 
	});
	enemigos1 = enemigos1.filter(function(enemigo1)
	{ 		
		if (enemigo1 && enemigo1.estado == 'muerto') 
		{
			console.log("dead");
			puntuacion += 1;
			enemigosCount -= 1;
			return false;
		}
		return true; 
	});
	enemigos2 = enemigos2.filter(function(enemigo2)
	{ 		
		if (enemigo2 && enemigo2.estado == 'muerto') 
		{
			console.log("dead");
			puntuacion += 1;
			enemigosCount -= 1;
			return false;
		}
		return true; 
	});
	
	//El enemigo ha salido de la pantalla por la parte de arriba, lo eliminamos.
	enemigos= enemigos.filter(function(enemigo)
	{ 
		if (enemigo && enemigo.estado == 'vivo' && enemigo.top_y < 0) 
		{
			enemigosCount -= 1;
			vidas -= 1;
			return false;
		}
		return true; 
	});	
	enemigos1= enemigos1.filter(function(enemigo1)
	{ 
		if (enemigo1 && enemigo1.estado == 'vivo' && enemigo1.left_x > display.width/2) 
		{
			enemigosCount -= 1;
			vidas -= 1;
			return false;
		}
		return true; 
	});	
	enemigos2= enemigos2.filter(function(enemigo2)
	{ 
		if (enemigo2 && enemigo2.estado == 'vivo' && enemigo2.left_x < display.width/2) 
		{
			enemigosCount -= 1;
			vidas -= 1;
			return false;
		}
		return true; 
	});	
}

//dibujar enemigos.
function dibujarEnemigos_lv3()
{	
	for (var i in enemigos)
	{
		var enemigo = enemigos[i];
		
		ctx.save();
		ctx.translate(enemigo.left_x, enemigo.top_y);
		ctx.rotate(rotation);
		ctx.translate(-(enemigo.left_x + (enemigo.width/2)), -(enemigo.top_y +(enemigo.height/2)));
		ctx.drawImage(enemigo.imagen, enemigo.left_x, enemigo.top_y);
		ctx.restore();
	}
	rotation += 0.3;
}

function dibujarEnemigos1_lv3()
{	
	for (var i in enemigos1)
	{
		var enemigo1 = enemigos1[i];
		
		ctx.save();
		ctx.translate(enemigo1.left_x, enemigo1.top_y);
		ctx.rotate(rotation);
		ctx.translate(-(enemigo1.left_x + (enemigo1.width/2)), -(enemigo1.top_y +(enemigo1.height/2)));
		ctx.drawImage(enemigo1.imagen, enemigo1.left_x, enemigo1.top_y);
		ctx.restore();
	}
	rotation += 0.3;
}

function dibujarEnemigos2_lv3()
{	
	for (var i in enemigos2)
	{
		var enemigo2 = enemigos2[i];
		
		ctx.save();
		ctx.translate(enemigo2.left_x, enemigo2.top_y);
		ctx.rotate(rotation);
		ctx.translate(-(enemigo2.left_x + (enemigo2.width/2)), -(enemigo2.top_y +(enemigo2.height/2)));
		ctx.drawImage(enemigo2.imagen, enemigo2.left_x, enemigo2.top_y);
		ctx.restore();
	}
	rotation += 0.3;
}
//Crear enemigo.
function crearEnemigo_lv3()
{
	enemigo_x =Math.random(1000)*1000;
	
	//Controlo el limite por la izquierda.
	if(enemigo_x <=300)
	{
		enemigo_x += 300;
	}
	
	//Controlo el limite por la derecha.
	if(enemigo_x >=700)
	{
		enemigo_x -= 300;
	}
	
	enemigos.push(
	{
		left_x: enemigo_x,
		top_y: 650,
		width: 15,
		height: 15,
		estado: 'vivo',
		imagen: imgEnemy_1
	});
	enemigosCount += 1;
}

function crearEnemigo1_lv3()
{
	enemigo1_y =Math.random(500)*500;
	
	//Controlo el limite por la izquierda.
	if(enemigo1_y <=50)
	{
		enemigo1_y += 50;
	}
	
	//Controlo el limite por la derecha.
	if(enemigo1_y >=350)
	{
		enemigo1_y -= 150;
	}
	
	enemigos1.push(
	{
		left_x: -10,
		top_y: enemigo1_y,
		width: 15,
		height: 15,
		estado: 'vivo',
		imagen: imgEnemy_2
	});
	enemigosCount += 1;
}

function crearEnemigo2_lv3()
{
	enemigo2_y =Math.random(500)*500;
	
	//Controlo el limite por la izquierda.
	if(enemigo2_y <=50)
	{
		enemigo2_y += 50;
	}
	
	//Controlo el limite por la derecha.
	if(enemigo2_y >=350)
	{
		enemigo2_y -= 150;
	}
	
	enemigos2.push(
	{
		left_x: 1005,
		top_y: enemigo2_y,
		width: 15,
		height: 15,
		estado: 'vivo',
		imagen: imgEnemy_3
	});
	enemigosCount += 1;
}


//Aqui dibujo la barrera.
function dibujarBarrera_lv3()
{
	ctx.drawImage(imgWall, lv3_wall.left_x, lv3_wall.top_y, lv3_wall.width, lv3_wall.height);
	ctx.drawImage(imgWall1, lv3_wall1.left_x, lv3_wall1.top_y, lv3_wall1.width, lv3_wall1.height);
	ctx.drawImage(imgWall2, lv3_wall2.left_x, lv3_wall2.top_y, lv3_wall2.width, lv3_wall2.height);
}

//Aqui Dibujo los limites.
function dibujarLimites_lv3()
{
	ctx.drawImage(imgLimitD1, (lv3_linea1.left_x - (lv3_limiteD.width)), 0 );
	ctx.drawImage(imgLimitI1, (lv3_linea2.left_x - (lv3_limiteD.width)), 0 );
}

//Aqui dibujo el fondo
function dibujarFondo_lv3()
{	
	ctx.drawImage(imgFondo, 0, 0);
	ctx.drawImage(imgLine, lv3_linea.left_x, lv3_linea.top_y, lv3_linea.width, lv3_linea.height);
	ctx.drawImage(imgLine, lv3_linea1.left_x, 0, lv3_linea1.width, lv3_linea1.height);
	ctx.drawImage(imgLine, lv3_linea2.left_x, 0, lv3_linea2.width, lv3_linea2.height);
}
