function countUp() {
	var hrSpan = $('#hr');
	var minSpan = $('#min');
	var secSpan = $('#sec');

	var hr = parseFloat(hrSpan.html());
	var min = parseFloat(minSpan.html());
	var sec = parseFloat(secSpan.html());

	sec++;

	if(sec > 59) {
	  sec = 0;
	  min++;
	}

	if(min > 59) {
	  min = 0;
	  hour++;
	}

	hrSpan.html("0".substring(hr >= 10) + hr);
	minSpan.html("0".substring(min >= 10) + min);
	secSpan.html("0".substring(sec >= 10) + sec);
}

function startStopWatch() {
	return setInterval(countUp, 1000);
}

function stopStopWatch(timer) {
	clearInterval(timer);
}

function reset(timer) {
	stopStopWatch(timer);
	$('#hr').html("00");
	$('#min').html("00");
	$('#sec').html("00");
}

$(function () {
	var timer = null;
	var isStarted = false;

	$('#start_button').click(function() {
		if(!isStarted) {
			timer = startStopWatch();
			$("#start_button").prev('span').find('.ui-btn-text').text('Pause');
			isStarted = true;
		} else {
			stopStopWatch(timer);
			$("#start_button").prev('span').find('.ui-btn-text').text('Resume');
			isStarted = false;
		}		
	});

	$('#reset_button').click(function() {
		reset(timer);
		timer = null;
		$("#start_button").prev('span').find('.ui-btn-text').text('Start');
		isStarted = false;
	});

	$('#action_clear').click(function() {
		reset(timer);
		timer = null;
		$("#start_button").prev('span').find('.ui-btn-text').text('Start');
		isStarted = false;
	});
});