var s, e,
StreamMonitor ={

    settings: {
        userList: [],
        running: false,
        liveUsers: [],
        streamObjects: []
    },

    elements: {
        refreshButton: document.querySelector("#refresh"),
        loadingIcon: document.querySelector('.loadingIcon'),
        streamList: document.querySelector('#streamList'),
        btnAddStreamer: document.querySelector('#btnAddStreamer'),
        btnClearData: document.querySelector('#btnClearData'),
        lastUpdated: document.querySelector('.lastUpdated')
    },

    init: function() {
        if(localStorage.getItem('streamlist') != null){
            this.settings.userList = localStorage.getItem('streamlist').split(",");
        }
        s = this.settings;
        e = this.elements;
        this.reloadAll();
        this.bindUIActions();
    },

    bindUIActions: function() {
        e.refreshButton.onclick = function(){
            StreamMonitor.reloadAll();
        }
        e.btnAddStreamer.onclick = function(){
            var username = prompt("Twitch channel:", "");
            StreamMonitor.addNewStreamer(username);
        }
        e.btnClearData.onclick = function(){
            if(confirm("Are you sure you want to clear all data?")){
                localStorage.clear();
                location.reload();
            }
        }
    },

    /************************/
    /**** Main functions ****/
    /************************/

    reloadAll: function(){
        if(!s.running){

            s.running = true;
            s.streamObjects = [];
            s.liveUsers = [];

            $(e.refreshButton).attr('disabled','disabled');
            $(e.streamList).html("");
            $(e.loadingIcon).show();

            StreamMonitor.apiRequest(s.userList);

        }else{
            console.log("No duplicates");
        }
    },

    apiRequest: function(string){
        Twitch.api({method: 'streams/?channel=' + string + ", "}, function (error, data) {
            if(error){
                StreamMonitor.updateFailure(error);
            }else if(data.streams){
                for(var i = 0; i < data.streams.length; i++){
                    current = data.streams[i];
                    s.streamObjects.push({
                        username: current.channel.name,
                        display_name: current.channel.display_name,
                        game: current.channel.game,
                        status: current.channel.status,
                        viewers: current.viewers,
                        url: current.channel.url,
                        logo: current.channel.logo
                    });
                    s.liveUsers.push(current.channel.name);
                    StreamMonitor.lastUpdated();
                }

                StreamMonitor.printStreamList();
            }
        });
    },

    printStreamList: function(){
        var offlineUsers = [];

        $.grep(s.userList, function(el) {
            if (jQuery.inArray(el, s.liveUsers) == -1) offlineUsers.push(el);
        });

        for(var i = 0; i < s.streamObjects.length; i++){
            var channel = s.streamObjects[i];
            if(channel.viewers > 1000){channel.viewers = Math.floor(channel.viewers/1000) + "k"}
            $(e.streamList).append('<li class="online"><img src="' + channel.logo + '" height="48"/><h2>' + channel.display_name + '</h2><p class="game">' + channel.game + '</p><p class="status">' + channel.status + '</p><div class="viewers">' + channel.viewers + '<span class="live"></span></div></li>');
        }

        for(var i = 0; i < offlineUsers.length; i++){
            $(e.streamList).append('<li class="offline"><img src="images/application/offline.png" height="20" width="48"/><h2>' + offlineUsers[i] + '</h2><div class="viewers"><span class="live"></span></div></li>');
        }

        if(s.streamObjects.length == 0 && offlineUsers.length == 0){
           $(e.streamList).append('<li id="nodata"><p>Click here to start adding channels</li>')
        }

        s.running = false;
        $(e.loadingIcon).hide();
        $(e.refreshButton).removeAttr('disabled');
    },

    lastUpdated: function(){
        var d = new Date();
        var hours = d.getHours(),
            minutes = d.getMinutes(),
            seconds = d.getSeconds();
        if (hours   < 10) {hours   = "0"+hours;}
        if (minutes < 10) {minutes = "0"+minutes;}
        if (seconds < 10) {seconds = "0"+seconds;}

        var prettyDate = hours + ":" + minutes + ":" + seconds;
        $(e.lastUpdated).html("Last updated: " + prettyDate);
    },

    updateFailure: function(error){
        s.running = false;
        $(e.loadingIcon).hide();
        $(e.lastUpdated).html("Unable to fetch data");
        $(e.refreshButton).removeAttr('disabled');

        // alert(error + "- check network connection");
    },

    /******************************/
    /**** Management functions ****/
    /******************************/


    checkStringLength: function(element){
        var len = $(element).val().length;
        len ? $(e.btnAddStream).removeAttr('disabled')
        : $(e.btnAddStream).attr('disabled', 'disabled');
    },

    addNewStreamer: function(username){
        Twitch.api({method: 'channels/' + username}, function (error, data) {
            if(error){
                alert(error.message);
            }else if(data.name == username){
                $(e.txtAddStream).val("");
                $(e.btnAddStream).attr('disabled', 'disabled');

                if($.inArray(username, s.userList) == -1){
                    s.userList.push(username);
                    localStorage.setItem("streamlist", s.userList);
                    StreamMonitor.reloadAll();
                }else{
                    alert("Error: Streamer already exists");
                }

            }
        });
    }
}

Twitch.init({clientId: '5umdahxg39d3df4xvs0vbmlmurd9xoc'}, function(error, status) {
    if(error){
        console.log("Twitch error: " + error + " Status: " + status);
    }
});
StreamMonitor.init();

