var lookup, current, delayTimer, isClickBackspace;
var inputContext = null;

function init()
{
	var keyboardElement = document.getElementById("keyboard");

	window.navigator.mozInputMethod.oninputcontextchange = function()
	{
		inputContext = navigator.mozInputMethod.inputcontext;
		resizeWindow();
	};

	window.addEventListener("resize", resizeWindow);

	keyboardElement.addEventListener("mousedown", function(evt)
	{
		evt.preventDefault();
	});

	/********************/

	var stroke1Element = document.getElementById("stroke1");
	var stroke2Element = document.getElementById("stroke2");
	var stroke3Element = document.getElementById("stroke3");
	var stroke4Element = document.getElementById("stroke4");
	var stroke5Element = document.getElementById("stroke5");

	var backspaceElement = document.getElementById("backspace");
	var whitespaceElement = document.getElementById("whitespace");
	var newlineElement = document.getElementById("newline");

	var punctuationElement = document.getElementById("punctuation");
	var numbersElement = document.getElementById("numbers");

	var switchlangElement = document.getElementById("switchlang");

	/********************/

	stroke1Element.addEventListener("click", function() { input(1); });
	stroke2Element.addEventListener("click", function() { input(2); });
	stroke3Element.addEventListener("click", function() { input(3); });
	stroke4Element.addEventListener("click", function() { input(4); });
	stroke5Element.addEventListener("click", function() { input(5); });

	backspaceElement.addEventListener("touchstart", function()
	{
		isClickBackspace = true;
		delayTimer = setTimeout(backspaceEventHandler, 750);
	});

	backspaceElement.addEventListener("touchend", function()
	{
		clearTimeout(delayTimer);

		if (isClickBackspace)
		{
			performBackspace();
		}
	});

	whitespaceElement.addEventListener("click", function() { sendKey(" "); });
	newlineElement.addEventListener("click", function() { sendKey(String.fromCharCode(13)); });

	punctuationElement.addEventListener("click", showPunctuationMarks);
	numbersElement.addEventListener("click", showNumbers);

	/********************/

	var menuTimeout = 0;

	switchlangElement.addEventListener("click", function()
	{
		reset();
		var mgmt = navigator.mozInputMethod.mgmt;
		mgmt.next();
	});

	switchlangElement.addEventListener("touchstart", function()
	{
		menuTimeout = window.setTimeout(function()
		{
			reset();
			var mgmt = navigator.mozInputMethod.mgmt;
			mgmt.showAll();
		}, 700);
	});

	switchlangElement.addEventListener("touchend", function()
	{
		clearTimeout(menuTimeout);
	});

	/********************/

	parseLookup();
}

// -------------------------------------------------- //

function resizeWindow()
{
	var keyboardElement = document.getElementById("keyboard");
	window.resizeTo(window.innerWidth, keyboardElement.clientHeight);
}

function parseLookup()
{
	lookup = new Stroke("root", null);

	for (var i = 0; i < dictionary.length; i++)
	{
		lookup.parse(dictionary[i].strokes, dictionary[i].word);
	}

	current = lookup;
	
	document.getElementById("stroke1").disabled = false;
	document.getElementById("stroke2").disabled = false;
	document.getElementById("stroke3").disabled = false;
	document.getElementById("stroke4").disabled = false;
	document.getElementById("stroke5").disabled = false;
	document.getElementById("backspace").disabled = false;
	document.getElementById("whitespace").disabled = false;
	document.getElementById("newline").disabled = false;
	document.getElementById("punctuation").disabled = false;
	document.getElementById("numbers").disabled = false;
	document.getElementById("switchlang").disabled = false;
}

function displayWordList(words, isSymbol)
{
	var container, wordsElement;
	wordsElement = document.getElementById("words");
	wordsElement.innerHTML = "";

	for (var i = 0; i < words.length; i++)
	{
		container = document.createElement("div");
		container.id = "word" + i;
		container.innerHTML = words[i];

		if (!isSymbol)
		{
			container.className = "word";
			container.onclick = (function() {
				var word = words[i];
				return function() {
					sendKey(word);
					reset();
				}
			})();
		}
		else
		{
			container.className = "word thinword";
			container.onclick = (function() {
				var word = words[i];
				return function() {
					sendKey(word);
				}
			})();
		}

		wordsElement.appendChild(container);
	}

	wordsElement.scrollLeft = 0;
	document.getElementById("strokes").innerHTML = current.getStrokeList();
}

function input(stroke)
{
	current = current.getChild(stroke);
	displayWordList(current.getWordList(), false);
}

function backspaceEventHandler()
{
	isClickBackspace = false;
	performBackspace();
	delayTimer = setTimeout(backspaceEventHandler, 100);
}

function performBackspace()
{
	if (current.getStrokeList() == "")
	{
		sendKey(String.fromCharCode(8));
	}
	else
	{
		backstroke();
	}
}

function backstroke()
{
	current = current.getMyParent();
	displayWordList(current.getWordList(), false);
}

function reset()
{
	current = lookup;
	displayWordList(current.getWordList(), false);
}

function showNumbers()
{
	var displayList = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

	current = lookup;
	displayWordList(displayList, true);
}

function showPunctuationMarks()
{
	var displayList = [
		",", ".", "=", "-", "+", "*", "/", ":", ";", "'",
		"\"", "$", "#", "(", ")", "!", "?", "@", "~", "[",
		"]", "{", "}", "<", ">", "^", "%", "_", "•", "\\",
		"|", "&", "¥", "£", "♀", "♂", "♠", "♣", "♥", "♦",
		"♪", "☼", "☺", "☻", "←", "↑", "→", "↓", "©", "®"
	];

	current = lookup;
	displayWordList(displayList, true);
}

function sendKey(key)
{
	var keyCode = key.charCodeAt(0);

	switch (keyCode)
	{
		case KeyEvent.DOM_VK_BACK_SPACE:
		case KeyEvent.DOM_VK_RETURN:
			if (inputContext)
			{
				inputContext.sendKey(keyCode, 0, 0);
			}
			break;

		default:
			if (inputContext)
			{
				inputContext.sendKey(0, keyCode, 0);
			}
			break;
	}
}

window.addEventListener("load", init);