function Stroke(stroke, parent)
{
	const maxWords = 50;

	var myStroke = stroke;
	var myParent = parent;
	var children = [];
	var wordList = [];
	var translatedStroke = ["一", "丨", "丿", "丶", "亅"];

	// -------------------------------------------------- //

	this.getMyStroke = function()
	{
		var index = parseInt(myStroke);
		return translatedStroke[index - 1];
	}

	this.getMyParent = function()
	{
		if (myParent != null)
		{
			return myParent;
		}

		return this;
	}

	this.getChild = function(i)
	{
		var index = parseInt(i) - 1;

		if (children[index] != null)
		{
			return children[index];
		}

		return this;
	}

	// -------------------------------------------------- //

	this.parse = function(strokes, words)
	{
		var i, index, stroke;

		if (myParent != null && wordList.length < maxWords)
		{
			for (i = 0; i < words.length; i++)
			{
				wordList.push(words[i]);
			}
		}

		if (strokes != "")
		{
			stroke = parseInt(strokes.charAt(0));
			index = stroke - 1;

			if (children[index] == null)
			{
				children[index] = new Stroke(stroke, this);
			}

			children[index].parse(strokes.slice(1), words);
		}
	}

	this.getStrokeList = function()
	{
		if (myParent != null)
		{
			return myParent.getStrokeList() + this.getMyStroke();
		}
		else
		{
			return "";
		}
	}

	this.getWordList = function()
	{
		return wordList;
	}
}