public Player player;
public Ground gnd;
public Hill hillobj;
public PImage bee1, bee2, beedead, ground, hill, hill_dead;
public PImage bush, grass, cloud1, cloud2;
public boolean dead = false;
public boolean gameOver = false;
public boolean firstGame = true;
public Hill[] hills;
public Bush[] bushes;
public Cloud[] clouds;
public int speed = 5;
public int score = 0;
public int wings = 9;
public int factor = 4;
public int highScore = 0;
public int jumpGravity = -15;
public int hillDistance;
public int hillCount;
public float screenfactor = 1;

void setup()
{
  size(window.innerWidth, window.innerHeight);
  background(255);

  screenfactor = height/float(480);
  speed = int(5 * screenfactor);
  jumpGravity = - int(14*screenfactor);

  player = new Player();
  gnd = new Ground();
  hillDistance = player.sizeX * 4;
  hillCount = int(width/hillDistance)+1;
  hills = new Hill[hillCount];
  for (int i = 0;i<hillCount;i++)
  {
    hills[i] = new Hill(-(i*hillDistance));
  }

  bushes = new Bush[2];
  for (int i = 0;i<bushes.length;i++)
  {
    bushes[i] = new Bush(i%2);
  }

  clouds = new Cloud[4];
  for (int i = 0;i<clouds.length;i++)
  {
    clouds[i] = new Cloud(i%2);
  }

  frameRate(30);
  rectMode(CORNER);
  textAlign(CENTER);

  bee1 = loadImage("data/bee1.png");
  bee2 = loadImage("data/bee2.png");
  beedead = loadImage("data/bee_dead.png");
  ground = loadImage("data/ground.png");
  hill = loadImage("data/hill.png");
  hill_dead = loadImage("data/hill_dead.png");
  bush = loadImage("data/bush.png");
  grass = loadImage("data/grass.png");

  cloud1 = loadImage("data/cloud_1.png");
  cloud2 = loadImage("data/cloud_2.png");
}

void draw()
{
  background(144, 200, 255);
  if (!firstGame)
    player.calculateGravity();

  // move shit
  if (!dead && !firstGame)
  {
    player.checkBounds();
    gnd.move();

    for (int i = 0;i<hillCount;i++)
      hills[i].move();

    for (int i = 0;i<bushes.length;i++)
      bushes[i].move();
  }

  //draw hills for collision
  for (int i = 0;i<hillCount;i++)
  {
    hills[i].drawHill();
    if (!hills[i].counted && player.x*4 < hills[i].hmove-hills[i].sizeX)
    {
      hills[i].counted = true;
      score++;
    }
  }
  checkCollision();

  //draw and move clouds
  for (int i = 0;i<clouds.length;i++)
  {
    clouds[i].move();
    clouds[i].drawCloud();
  }

  //draw again hills and check score
  for (int i = 0;i<hillCount;i++)
  {
    hills[i].drawHill();
    if (!hills[i].counted && player.x*4 < hills[i].hmove-hills[i].sizeX)
    {
      hills[i].counted = true;
      score++;
    }
  }
  
  //draw bushes
  for (int i = 0;i<bushes.length;i++)
    bushes[i].drawBush();

  drawGround();

  //draw bee
  if (!dead)
  {
    player.drawBee();
  }
  else
  {
    image(beedead, player.x, player.y, player.sizeX, player.sizeY);
    if (gameOver)
    {
      if (score>highScore)
        highScore= score;

      fill(255);
      textSize(32);
      text("GAME OVER", width/2, height/2-50);
      textSize(22);
      text("Touch to restart", width/2, height/2);
      text("Highscore: "+highScore, width/2, height/2+50);
    }
    if (mousePressed)
    {
      newGame();
    }
  }

  //draw score
  fill(255);
  textSize(22);
  text(score, width/2, 50);

  if (firstGame)
  {

    fill(255);
    textSize(32);
    text("Stubborn Bee", width/2, height/2-50);
    textSize(22);
    text("Touch to start", width/2, height/2);

    if (mousePressed)
    {
      firstGame = false;
    }
  }
}


public void drawGround()
{
  for (int i =0;i<width+70;i+=70)
  {
    image(ground, i-gnd.gmove, height-40, 70, 70);
  }
}

public void newGame()
{
  if (dead && gameOver)
  {
    gameOver=false;
    dead=false;
    player = new Player();
    hills = new Hill[hillCount];
    for (int i = 0;i<hillCount;i++)
    {
      hills[i] = new Hill(-(i*hillDistance));
    }
    score = 0;
  }
}

public void checkCollision()
{
  color c1 = get(player.x, player.y);
  color c2 = get(player.x+player.sizeX, player.y);
  color c3 = get(player.x, player.y+player.sizeY);
  color c4 = get(player.x+player.sizeX, player.y+player.sizeY);

  if (c1!=-7288577 || c2!=-7288577 || c3!=-7288577 || c4!=-7288577)
    dead=true;
}

void mouseReleased()
{
  if (!dead)
    player.gravity = jumpGravity;
}

public class Player {
  public int x;
  public int y;
  public int sizeX;
  public int sizeY;
  public float gravity;
  public int maxGravity;

  public Player()
  {
    x = int(width/5);
    y = int(height/2);
    sizeX = int(60*screenfactor);
    sizeY = int(50*screenfactor);
    maxGravity= int(8*screenfactor);
    gravity = 0;
  }

  public void calculateGravity()
  {
    gravity += screenfactor;
    if (gravity > maxGravity && !dead)
      gravity = maxGravity;

    y = y + int(gravity);

    if (dead && player.y>height)
      gameOver=true;
  }

  public void drawBee()
  {
    wings = 9;
    factor = 4;
    if (gravity <0 )
    {
      wings = 5;
      factor = 2;
    }

    if (frameCount%wings>factor)
      image(bee1, player.x, player.y, player.sizeX, player.sizeY);
    else
      image(bee2, player.x, player.y, player.sizeX, player.sizeY);
  }

  public void checkBounds()
  {
    if (y+sizeY>height-gnd.gndheight)
    {
      y = height-sizeY-gnd.gndheight;
    }
    else if (y<0)
    {
      y = 0;
      gravity = -gravity;
    }
  }
}

public class Ground {
  public int gndheight = 40;
  public int gmove = 0;

  public Ground()
  {
    gndheight = 40;
    gmove = 0;
  }

  public void move()
  {
    gmove += speed;
    if (gmove>=70)
    {
      gmove=0;
    }
  }
}

public class Hill {
  public int hmove = 0;
  public int hy;
  public int sizeX;
  public int sizeY;
  public boolean counted = false;

  public Hill(int position)
  {
    hmove = position;
    randomY();
    sizeX = int(48*screenfactor);
    sizeY = int(850*screenfactor);
  }

  public void randomY()
  {
    hy = int(random(-int(300*screenfactor), -int(120*screenfactor)));
  }

  public void move() {
    hmove += speed;
    if (hmove>=width+sizeX)
    {
      hmove=-(hillCount*hillDistance-width-sizeX);
      randomY();
      counted=false;
    }
  }

  public void drawHill()
  {
    if (!dead)
      image(hill, width-hmove, hy, sizeX, sizeY);
    else
      image(hill_dead, width-hmove, hy, sizeX, sizeY);
  }
}

public class Bush {
  public int bmove = 0;
  public int sizeX;
  public int sizeY;
  public int nr;

  public Bush(int nr)
  {
    this.nr = nr;
    if (nr==0)
    {
      sizeX = int(100*screenfactor);
      sizeY = int(37*screenfactor);
    }
    else
    {
      sizeX = int(44*screenfactor);
      sizeY = int(50*screenfactor);
    }
    randomX();
  }

  public void randomX()
  {
    bmove = int(random(-width, 0));
  }

  public void move() {
    bmove += speed;
    if (bmove>=width+sizeX)
    {
      bmove=0;
      randomX();
    }
  }

  public void drawBush()
  {
    if (nr==0)
      image(bush, width-bmove, height-40-sizeY, sizeX, sizeY);
    else
      image(grass, width-bmove, height-40-sizeY, sizeX, sizeY);
  }
}

public class Cloud {
  public int y;
  public float cmove;
  public float cspeed;
  public float cfactor;
  public int sizeX;
  public int sizeY;
  public int nr;

  public Cloud(int nr)
  {
    create();
    this.nr = nr;
  }

  public void create()
  {
    randomY();
    randomX();
    randomSpeed();
    randomFactor();
    sizeX = int(129*cfactor*screenfactor);
    sizeY = int(63*cfactor*screenfactor);
  }

  public void randomY()
  {
    y = int(random(0, int(height/3)));
  }

  public void randomX()
  {
    cmove = int(random(-width, 0));
  }

  public void randomSpeed()
  {
    cspeed = random(1, 2)*screenfactor;
  }

  public void randomFactor()
  {
    cfactor = random(0.3, 0.8);
  }

  public void move() {
    cmove += cspeed;
    if (cmove>=width+sizeX)
    {
      cmove=0;
      create();
    }
  }

  public void drawCloud()
  {
    if (nr==0)
      image(cloud1, width-int(cmove), y, sizeX, sizeY);
    else
      image(cloud2, width-int(cmove), y, sizeX, sizeY);
  }
}
