(function($) {

	var solver = null;

	function newGame() {
		localStorage.setItem('difficulty', $('#difficulty').val());
		solver = new sudoku.Solver();
		solver.cull($('#difficulty').val());
		showGrid();
	}

	function showGrid() {
		var $table = $('<table>').attr({
			'class': 'sudoku-table',
			'cellspacing': 0,
			'cellpadding': 0
		});
		for(var r = 0; r < 3; r++) {
			var $r = $('<tr>');
			for(var c = 0; c < 3; c++) {
				var $cellgroup = $('<table>').attr({
					'class': ((r % 2 == 0) ^ (c % 2 == 0)) ? 'cellgroup cellgroup-1' : 'cellgroup cellgroup-2',
					'cellspacing': 2,
					'cellpadding': 0
				});
				for(var row = 0; row < 3; row++) {
					var $row = $('<tr>');
					for(var col = 0; col < 3; col++) {
						var value = solver.grid.rows[r * 3 + row][c * 3 + col];
						var $element;
						if(value === 0) {
							$element = $( '<span>' ).attr('class', 'value editvalue');
						}
						else {
							$element = $( '<span>' ).text(value).attr('class', 'value staticvalue');
						}
						$row.append(
							$('<td>')
							.append($element)
							.data({
								'row': r * 3 + row,
								'col': c * 3 + col
							})
						);
					}
					$cellgroup.append($row);
				}
				$r.append(
					$('<td>').append($cellgroup)
				);
			}
			$table.append($r);
		}
		$('#sudoku').html($table);
		$('.editvalue').click(function(e) {
			e.stopPropagation();
			$('.active').removeClass('active');
			$(this).addClass('active');
		});
		makeSize();
	}

	function makeSize() {
		var size;
		if(screen.width < screen.height) {
			$('.sudoku-table').width(screen.width).height('auto');
			size = screen.width / 9;
		}
		else {
			var height = screen.height - 45;
			$('.sudoku-table').height(height).width('auto');
			size = height / 9;
		}
		$('#sudoku td td').width(size).height(size);
	}
	
	function buildNumberpad() {
		var $table = $('<table>');
		for(var r = 0; r < 3; r++) {
			var $row = $('<tr>');
			for(var c = 1; c <= 3; c++) {
				$row.append(
					$('<td>').append(
						$('<button>')
						.text(r * 3 + c)
						.data('number', r * 3 + c)
						.click(function(e) {
							e.stopPropagation();
							$active = $('.active');
							$active.text($(this).data('number'));
							var data = $active.parent().data();
							solver.grid.setValue(data.col, data.row, $(this).data('number'));
						})
					)
				);
			}
			$table.append($row);
		}
		$('#numberpad').html($table);
	}
	
	function isCorrect() {
		var correct = true;
		$('.editvalue').each(function() {
			var data = $(this).parent().data();
			if(solver.grid.cellConflicts(data.col, data.row)) {
				return correct = false;
			}
		});
		return correct;
	}

	function init() {
		$('#newgame').click(function() {
			if(confirm(__('confirm_new_game'))) {
				newGame();
			}
		});
		$('#check').click(function() {
			if(isCorrect()) {
				alert(__('solved_game'));
				newGame();
			}
			else {
				alert(__('still_errors'));
			}
		});
		var difficulty = localStorage.getItem('difficulty');
		if(difficulty) {
			$('#difficulty').val(difficulty);
		}
		$(document).click(function() {
			$('.active').removeClass('active');
		});
		buildNumberpad();
		window.addEventListener('resize', makeSize);
		newGame();
	}

	$(document).ready(init);

})(jQuery);