﻿/*
 *
 */
function calcularRendaPerCapita(rendimento, qtdMembros) {
	
    var renda = rendimento / qtdMembros;
    return (Math.round(renda * 100) / 100).toFixed(2);
}

/*
 *
 */
function calcularTaxaMensal(taxaAnual) {

    var taxa = Math.pow((1 + (taxaAnual/100)), 1/12) - 1;
    return (taxa*100).toFixed(5) + " %";
}

/*
 *
 */
function calcularJurosSimples(capital, txJuros, meses) {

    montante = new Object();
    montante.juros = (capital * (txJuros / 100) * ((meses * 30) / 360)).toFixed(2);
    montante.valor = (parseFloat(montante.juros) + parseFloat(capital)).toFixed(2);
    return montante;
}

/*
 *
 */
function calcularJurosCompostos(capital, txJuros, meses) {

    var montanteAcumulado = capital;
    var i = 0;
    for (i; i < meses; i++) {
        montanteAcumulado = parseFloat(montanteAcumulado) + parseFloat(((txJuros / 100) * montanteAcumulado));
    }
    return montanteAcumulado.toFixed(2);
}

/*
 *
 */
function calcularPoupanca(taxaSelic, montante, taxaReferencial) {

    poupanca = new Object();
    poupanca.taxaJuros = parseFloat(recuperarTaxaJuros(taxaSelic)) + parseFloat(taxaReferencial);
    poupanca.rendimento = (montante * (poupanca.taxaJuros / 100)).toFixed(2);
    poupanca.total = (parseFloat(montante) + parseFloat(poupanca.rendimento)).toFixed(2);
    return poupanca;
}

/*
 *
 */
function recuperarTaxaJuros(taxaSelic) {

    var taxaJuros = 0;
    if (taxaSelic > 8.5) {
        taxaJuros = Math.pow((1 + (0.5 / 100)), 12) - 1;
        taxaJuros = (taxaJuros * 100).toFixed(2);
    } else {
        taxaJuros = (taxaSelic * (70 / 100)).toFixed(2);
    }
    return taxaJuros;
}