﻿/*
 *
 */
function calcularImposto(valorImovel, imposto) {

    var valorImposto = (valorImovel * imposto) / 100;
    return (Math.round(valorImposto * 100) / 100).toFixed(2);
}

/* 
 * PM (Prestação Mensal) = FC + TA + FR + Seguro.
 * FC (Fundo comun) = Valor total do crédito dividido pelo resultado do Percentual do crédito dividido pelo número dos meses.
 * TA (Taxa de Administração) = Percentual fixado no contrato de adesão.
 * FR (Fundo de Reserva) = Percentual fixodo no contrato de adesão. 
 */
function calcularConsorcio(credito, parcela, txAdm, fdReserva) {

    var fundoComun = parseFloat(Math.round(credito * (100 / parcela)) / 100).toFixed(2);
    var taxaAdministracao = parseFloat(Math.round(credito * (txAdm / parcela)) / 100).toFixed(2);
    var fundoReserva = parseFloat(Math.round(credito * (fdReserva / parcela)) / 100).toFixed(2);
    var prestacaoMensal = parseFloat(Math.round(parseFloat(fundoComun) + parseFloat(taxaAdministracao) + parseFloat(fundoReserva))).toFixed(2);
    return prestacaoMensal;
}

function converteNumeroPadraoPT(valor, prec) {
    if (prec == null) prec = 2;
    //var negativo = false;
    var valorPadraoPT = "ERRO";
    if (valor != null) {
        valor = valor + "";
        if (valor.indexOf("e+") != -1) return valor.replace(".", ",");
        if (valor.charAt(0) == "-") {
            valor = valor.replace("-", "");
            negativo = true;
        }
        if (isNaN(valor)) {
            valorPadraoPT = valor;
        } else {
            valor = aproximaParaZero(valor);
            valorPadraoPT = "";
            var toks = valor.split(".");
            var len = toks[0].length;
            for (var c = 0; c < len; c++) {
                var ci = len - 1 - c;
                if (c != 0 && c % 3 == 0) valorPadraoPT = "." + valorPadraoPT;
                valorPadraoPT = toks[0].charAt(ci) + valorPadraoPT;
            }
            if (toks.length == 2) {
                if (toks[1].length < prec) {
                    toks[1] = toks[1] + zeros(prec - toks[1].length);
                }
                valorPadraoPT += "," + toks[1].substring(0, prec);

            } else {
                if (prec > 0) valorPadraoPT += "," + zeros(prec);
            }
        }
    }
    //if (negativo) valorPadraoPT = "-"+valorPadraoPT;
    return valorPadraoPT;
}

function replaceAll(str, a, b) {
    if (str == null || a == b) return str;
    while (str.indexOf(a) >= 0) {
        str = str.replace(a, b);
    }
    return str;
}

function verificaSimbolos(formula) {
    var formulaVerificada = formula;
    formulaVerificada = replaceAll(formulaVerificada, ",", ".");
    formulaVerificada = replaceAll(formulaVerificada, "|", ",");
    formulaVerificada = replaceAll(formulaVerificada, ";", ",");
    formulaVerificada = replaceAll(formulaVerificada, "--", "+");
    formulaVerificada = replaceAll(formulaVerificada, "-+", "+");
    formulaVerificada = replaceAll(formulaVerificada, "%%", "%");
    return formulaVerificada;
}

function aproximaParaZero(valor) {
    if (valor.indexOf("e-") != -1) return "0";
    return valor;
}

function zeros(algs) {
    var k = 0;
    var retorno = "";
    for (; k < algs; k++) {
        retorno += "0";
    }
    return retorno;
}

function calculoSAC(vlTotal, entrada, txJuros, nuParcela) {

    var tabelaResultadoSac = "<table class='formatHTML5' border='1'>";

    if (entrada > 0) {
        saldoDevedor = parseFloat(vlTotal - entrada);
    } else {
        saldoDevedor = parseFloat(vlTotal);
    }

    nuParcela = parseFloat(verificaSimbolos(nuParcela + "")); //Número de Meses
    txJuros = parseFloat(verificaSimbolos(txJuros + "")) / 100; //Taxa de Juros
    saldoDevedor = parseFloat(verificaSimbolos(saldoDevedor + ""));     //Valor Financiado

    txJuros = transformaTxJuros(12, null, txJuros);

    var i = 0;
    var amortizacao = saldoDevedor / nuParcela;
    var totalJuros = 0;
    var totalAmort = 0;
    var totalParc = 0;
    var sifrao = "R$ ";

    for (i = 0; i < nuParcela; i++) {
        var parcela = amortizacao + saldoDevedor * txJuros;

        tabelaResultadoSac += "<tr>" +
                  "<td width='30'>" + (i + 1) + "</td>" +
                  "<td width='125'>" + sifrao + converteNumeroPadraoPT(parcela) + "</td>" +
                  "<td width='125'>" + sifrao + converteNumeroPadraoPT(amortizacao) + "</td>" +
                  "<td width='125'>" + sifrao + converteNumeroPadraoPT(saldoDevedor * txJuros) + "</td>" +
                  "<td width='125'>" + sifrao + converteNumeroPadraoPT(saldoDevedor - amortizacao) + "</td>" +
               "</tr>";


        totalJuros += saldoDevedor * txJuros;
        totalAmort += amortizacao;
        totalParc += parcela;
        saldoDevedor -= amortizacao;
    }

    tabelaResultadoSac += "<tr>" +
               "<td width='30' style='font-weight:bold;'> TOTAL </td>" +
               "<td width='125' style='font-weight:bold;'>" + sifrao + converteNumeroPadraoPT(totalParc) + "</td>" +
               "<td width='125' style='font-weight:bold;'>" + sifrao + converteNumeroPadraoPT(totalAmort) + "</td>" +
               "<td width='125' style='font-weight:bold;'>" + sifrao + converteNumeroPadraoPT(totalJuros) + "</td>" +
               "<td width='125' style='font-weight:bold;'></td>" +
           "</tr>";
    tabelaResultadoSac += "</table>";

    document.getElementById('resultadoSAC').innerHTML = tabelaResultadoSac;

}

function calculoSAC2(vlTotal, entrada, txJuros, nuParcela) {
	
	if (entrada > 0) {
		saldoDevedor = parseFloat(vlTotal - entrada);
	} else {
		saldoDevedor = parseFloat(vlTotal);
	}
	
	nuParcela = parseFloat(verificaSimbolos(nuParcela + "")); //Número de Meses
	txJuros = parseFloat(verificaSimbolos(txJuros + "")) / 100; //Taxa de Juros
	saldoDevedor = parseFloat(verificaSimbolos(saldoDevedor + ""));     //Valor Financiado
	
	txJuros = transformaTxJuros(12, null, txJuros);
	
	var i = 0;
	var amortizacao = saldoDevedor / nuParcela;
	var totalJuros = 0;
	var totalAmort = 0;
	var totalParc = 0;
	
	var result = new Object();
	result.itens = new Array();
	for (i = 0; i < nuParcela; i++) {
		var parcela = amortizacao + saldoDevedor * txJuros;
		
		var item = new Object();
		item.nuPrestacao = (i + 1);
		item.prestacao = converteNumeroPadraoPT(parcela);
		item.vlJuros = converteNumeroPadraoPT(saldoDevedor * txJuros);
		item.amortizacao = converteNumeroPadraoPT(amortizacao);
		item.saldoDevedor = converteNumeroPadraoPT(saldoDevedor - amortizacao);

		result.itens[i] = item;
		
		totalJuros += saldoDevedor * txJuros;
		totalAmort += amortizacao;
		totalParc += parcela;
		saldoDevedor -= amortizacao;
	}
	
	var total = new Object();
	total.totalParcelas = converteNumeroPadraoPT(totalParc);
	total.totalJuros = converteNumeroPadraoPT(totalJuros);
	total.totalArmotizacao = converteNumeroPadraoPT(totalAmort);
	result.total = total;
	
	return result;
}

function transformaTxJuros(dozeMeses, retorno, txJuros) {
    var a = Math.pow(1 + txJuros, 1.0 / dozeMeses);
    retorno = a - 1;
    return retorno;
}

/*
 *
 */
function calcularPrice(vlTotal, entrada, txJuros, nuParcela) {

    var amortizacao = 0;
    var juros = 0;
    var vlJuros = 0;
    var nuPrestacao = 0;
    var prestacao = 0;
    var saldoDevedor = 0;
    var total = 0;
    var divHtml = "";
    if (nuParcela != 0) {

        divHtml +=
			"<br /><table width='40%' border='1' align='center' class='formatHTML5'>" +
				"<thead><tr>" +
					"<td width='10%'>" +
						"N" +
					"</td>" +
					"<td width='20%'>" +
						"Prestacao" +
					"</td>" +
					"<td width='20%'>" +
						"Juros" +
					"</td>" +
					"<td width='25%'>" +
						"Amortizacao" +
					"</td>" +
					"<td width='25%'>" +
						"Saldo Devedor" +
					"</td>" +
				"</tr></thead><tbody>";

        if (entrada > 0) {
            saldoDevedor = parseFloat(vlTotal - entrada);
        } else {
            saldoDevedor = parseFloat(vlTotal);
        }

        //Juros convertido
        juros = (txJuros / 100);

        //Valor da Presatação fixa
        prestacao = saldoDevedor * [juros * (Math.pow(1 + juros, nuParcela))] / [Math.pow(1 + juros, nuParcela) - 1];

        var i;
        for (i = 0; i <= nuParcela; i++) {

            if (i == 0) {
                saldoDevedor;
                vlJuros = parseFloat(saldoDevedor * juros);
                amortizacao = prestacao - vlJuros;
            } else {
                saldoDevedor = saldoDevedor - (prestacao - vlJuros);
                vlJuros = parseFloat(saldoDevedor * juros);
                amortizacao = prestacao - vlJuros;
            }

            //Valores impressos na tela
            prestacao = parseFloat(prestacao).toFixed(2);
            saldoDevedor = parseFloat(saldoDevedor).toFixed(2);
            amortizacao = parseFloat(amortizacao).toFixed(2);
            vlJuros = parseFloat(vlJuros).toFixed(2);

            var sifrao = "R$ ";

            divHtml +=
					"<tr>" +
						"<td width='10%'>" +
							nuPrestacao +
						"</td>" +
						"<td width='20%'>"
							+ sifrao + prestacao +
						"</td>" +
						"<td width='20%'>"
							+ sifrao + vlJuros +
						"</td>" +
						"<td width='25%'>"
							+ sifrao + amortizacao +
						"</td>" +
						"<td width='25%'>"
							+ sifrao + saldoDevedor +
						"</td>" +
					"</tr>";

            nuPrestacao++;
        }
        divHtml += "</tbody></table>";
        document.getElementById('valorPrice').innerHTML = divHtml;
    }
}

function calcularConsumoEnergia(qtdAparelhos, potencia, horasPorDia, uf) {
	
	var consumo = (qtdAparelhos * potencia * horasPorDia * 30) / 1000;
	var result = new Object();
	result.consumo = consumo + " KWh/mês";
	var valorKWh = recuperaValorKWhPorUf(uf); 
	result.valorKWh = "R$ " + valorKWh.toString().replace('.', ',') + ". Fonte: ANEEL.";
	result.valorTotal = formatarRealDouble(parseFloat(parseFloat(valorKWh) * parseFloat(consumo)).toFixed(2));
	return result;
}

function recuperaValorKWhPorUf(uf) {
	
	var valorKWhPorUf = '';
	if (uf == 'AC') {
		valorKWhPorUf = 0.37060;
	} else if (uf == 'AL') {
		valorKWhPorUf = 0.30293;
	} else if (uf == 'AP') {
		valorKWhPorUf = 0.19729;
	} else if (uf == 'AM') {
		valorKWhPorUf = 0.27139;
	} else if (uf == 'BA') {
		valorKWhPorUf = 0.32740;
	} else if (uf == 'CE') {
		valorKWhPorUf = 0.29815;
	} else if (uf == 'DF') {
		valorKWhPorUf = 0.24253;
	} else if (uf == 'ES') {
		valorKWhPorUf = 0.31509;
	} else if (uf == 'GO') {
		valorKWhPorUf = 0.29662;
	} else if (uf == 'MA') {
		valorKWhPorUf = 0.36610;
	} else if (uf == 'MT') {
		valorKWhPorUf = 0.412570;
	} else if (uf == 'MS') {
		valorKWhPorUf = 0.36346;
	} else if (uf == 'MG') {
		valorKWhPorUf = 0.36448;
	} else if (uf == 'PA') {
		valorKWhPorUf = 0.32076;
	} else if (uf == 'PB') {
		valorKWhPorUf = 0.31782;
	} else if (uf == 'PR') {
		valorKWhPorUf = 0.24258;
	} else if (uf == 'PE') {
		valorKWhPorUf = 0.29615;
	} else if (uf == 'PI') {
		valorKWhPorUf = 0.36292;
	} else if (uf == 'RJ') {
		valorKWhPorUf = 0.31416;
	} else if (uf == 'RN') {
		valorKWhPorUf = 0.29825;
	} else if (uf == 'RS') {
		valorKWhPorUf = 0.25307;
	} else if (uf == 'RO') {
		valorKWhPorUf = 0.33862;
	} else if (uf == 'RR') {
		valorKWhPorUf = 0.31346;
	} else if (uf == 'SC') {
		valorKWhPorUf = 0.25580;
	} else if (uf == 'SP') {
		valorKWhPorUf = 0.23801;
	} else if (uf == 'SE') {
		valorKWhPorUf = 0.33702;
	} else if (uf == 'TO') {
		valorKWhPorUf = 0.34423;
	}
	return valorKWhPorUf;
}