﻿/*
 *
 */
function calcularRegrade3(valor1, valor2, valor3) {
	
    var x = (valor1*valor2) / valor3;
	return parseFloat(Math.round(x * 100) / 100).toFixed(2);
}

/*
 *
 */
function calcularHipotenusa(cateto1, cateto2) {
    var a = Math.sqrt((cateto1 * cateto1) + (cateto2 * cateto2));
    return parseFloat(Math.round(a * 100) / 100).toFixed(2);
}

/*
 *
 */
function calcularMediaAritmetica(valores) {

    var arrayValores = valores.split("#");
    var total = arrayValores.length;
    var somatorio = 0;
    for (var i = 0; i < total - 1; i++) {
        somatorio = parseFloat(somatorio) + parseFloat(arrayValores[i]);
    }
    return parseFloat(Math.round((somatorio / (total - 1)) * 100) / 100).toFixed(2) + "";
}

/*
 *
 */
function calcularVariancia(valores) {

    var arrayValores = valores.split("#");
    var total = arrayValores.length;
    var media = calcularMediaAritmetica(valores);
    var somatorioVariancia = 0;
    for (var i = 0; i < arrayValores.length - 1; i++) {
        somatorioVariancia = parseFloat(somatorioVariancia) + ((parseFloat(arrayValores[i]) - parseFloat(media)) * (parseFloat(arrayValores[i]) - parseFloat(media)));
    }
    return parseFloat(Math.round((somatorioVariancia / (total - 1)) * 100) / 100).toFixed(2) + "";
}

/*
 *
 */
function calcularDesvioPadrao(valores) {

    var arrayValores = valores.split("#");
    arrayValores.pop();
    var arrayNum = new Array();
    for (i = 0; i < arrayValores.length; i++) {
        arrayNum[i] = new Number(arrayValores[i]);
    }
    return getStandardDeviation(arrayNum, 4) + "";
}

// Programmer: Larry Battle 
// Date: Mar 06, 2011
// Purpose: Calculate standard deviation, variance, and average among an array of numbers.
var isArray = function (obj) {
    return Object.prototype.toString.call(obj) === "[object Array]";
},
getNumWithSetDec = function (num, numOfDec) {
    var pow10s = Math.pow(10, numOfDec || 0);
    return (numOfDec) ? Math.round(pow10s * num) / pow10s : num;
},
getAverageFromNumArr = function (numArr, numOfDec) {
    if (!isArray(numArr)) { return false; }
    var i = numArr.length,
		sum = 0;
    while (i--) {
        sum += numArr[i];
    }
    return getNumWithSetDec((sum / numArr.length), numOfDec);
},
getVariance = function (numArr, numOfDec) {
    if (!isArray(numArr)) { return false; }
    var avg = getAverageFromNumArr(numArr, numOfDec),
		i = numArr.length,
		v = 0;

    while (i--) {
        v += Math.pow((numArr[i] - avg), 2);
    }
    v /= numArr.length;
    return getNumWithSetDec(v, numOfDec);
},
getStandardDeviation = function (numArr, numOfDec) {
    if (!isArray(numArr)) { return false; }
    var stdDev = Math.sqrt(getVariance(numArr, numOfDec));
    return getNumWithSetDec(stdDev, numOfDec);
};

/*
 *
 */
function calcularProbabilidade(casosFavoraveis, casosPossiveis) {

    var probabilidade = casosFavoraveis / casosPossiveis;
    return parseFloat(Math.round(probabilidade * 100) / 100).toFixed(2);
}

/*
 *
 */
function calcularDistancia(x1, x2, y1, y3) {

    var distancia = Math.sqrt(((x2 - x1) * (x2 - x1)) + ((y3 - y1) * (y3 - y1)));
    return parseFloat(Math.round(distancia * 100) / 100).toFixed(2);
}

/*
 *
 */
function calcularAceleracao(vi, vf, ti, tf) {

    var aceleracao = (vf - vi) / (tf - ti);
    return parseFloat(Math.round(aceleracao * 100) / 100).toFixed(2) + " m/s\u00B2";
}

/*
 *
 */
function calcularAngulo(angulo) {

    resultado = new Object();
    resultado.sen = "Seno: " + parseFloat(Math.round(Math.sin(angulo) * 100) / 100).toFixed(2);
    resultado.cos = "Co-seno: " + parseFloat(Math.round(Math.cos(angulo) * 100) / 100).toFixed(2);
    resultado.tan = "Tagente: " + parseFloat(Math.round(Math.tan(angulo) * 100) / 100).toFixed(2);
    resultado.asen = "Arco Seno: " + parseFloat(Math.round((Math.asin(angulo) * 180/Math.PI) * 100) / 100).toFixed(2);
    resultado.acos = "Arco Co-Seno: " + parseFloat(Math.round((Math.acos(angulo) * 180/Math.PI) * 100) / 100).toFixed(2);
    resultado.atan = "Arco Tangente: " + parseFloat(Math.round((Math.atan(angulo) * 180/Math.PI) * 100) / 100).toFixed(2);
    return resultado;
}

/*
 *
 */
function calcularRaiz(valor, potencia) {

    var pow = parseFloat(1 / potencia).toFixed(3);
    var valorRaiz = Math.pow(valor, pow);
    return parseFloat(Math.round(valorRaiz * 100) / 100).toFixed(2);
}

/*
 *
 */
function calcularAreaQuadrado(baseQuadrado, alturaQuadrado) {
    return parseFloat(Math.round((baseQuadrado * alturaQuadrado) * 100) / 100).toFixed(2) + " un\u00B2";
}

/*
 *
 */
function calcularAreaTriangulo(baseTriangulo, alturaTriangulo) {
    return parseFloat(Math.round((parseFloat(baseTriangulo) * parseFloat(alturaTriangulo))) / 2).toFixed(2) + " un\u00B2";
}

/*
 *
 */
function calcularAreaEsfera(raio) {
    return parseFloat(Math.round((Math.PI * (raio * raio)) * 100) / 100).toFixed(2) + " un\u00B2";
}

/*
 *
 */
function calcularVolumeQuadrado(baseQuadrado, alturaQuadrado, profundidadeQuadrado) {
    return parseFloat(Math.round((baseQuadrado * alturaQuadrado * profundidadeQuadrado) * 100) / 100).toFixed(2) + " un\u00B3";
}

/*
 *
 */
function calcularVolumeTriangulo(baseTriangulo, alturaTriangulo, profundidadeTriangulo) {
    return parseFloat(Math.round((parseFloat(calcularAreaTriangulo(baseTriangulo,alturaTriangulo)) * parseFloat(profundidadeTriangulo)) * 100) / 100).toFixed(2) + " un\u00B3";
}

/*
 *
 */
function calcularVolumeEsfera(raio) {
    return parseFloat(Math.round(((4 / 3) * Math.PI * (raio * raio * raio)) * 100) / 100).toFixed(2) + " un\u00B3";
}

function calcularPotencia(valor, potencia) {
    return parseFloat(Math.pow(valor, potencia)).toFixed(2);
}

function calcularPorcentagem(valor, porcentagem) {
	return parseFloat(valor * parseFloat(porcentagem/100)).toFixed(2);
}