﻿/*
 * Variáveis globais.
 */
var imc = 0;
var pesoIdeal = "";
var periodoFertil = "";

/*
 * Método responsável por o IMC (Índice de Massa Corpórea).
 * @param peso o peso da pessoa em kilos (Ex.: 80)
 * @param altura a altura da pesoa em metros (Ex.: 1.80)
 * 
 * @ComoTestar: Compare o resultado com o site: http://www.calculador.com.br/calculo/imc
 */
function calcularIMC(peso, altura) {
	
	imc = peso / (altura * altura);
	return parseFloat(Math.round(imc * 100) / 100).toFixed(2);
}

/*
 * Método responsável por calcular o peso ideal.
 * @param peso o peso da pessoa em kilos (Ex.: 80)
 * @param altura a altura da pesoa em metros (Ex.: 1.80)
 * 
 * @ComoTestar: Compare o resultado com o site: http://www.calculador.com.br/calculo/peso-ideal
 */
function calcularPesoIdeal(peso, altura) {
	
	imc = peso / (altura * altura);
	
	if (imc <= 17) {
		pesoIdeal = "Muito abaixo do peso (IMC abaixo de 17).";
	} else if (imc > 17 && imc <= 18.49) {
		pesoIdeal = "Abaixo do peso (IMC entre 17 e 18.50).";
	} else if (imc > 18.49 && imc <= 24.99) {
		pesoIdeal = "Peso normal (IMC entre 18.50 e 25).";
	} else if (imc > 24.99 && imc <= 29.99) {
		pesoIdeal = "Acima do peso (IMC entre 25 e 30).";
	} else if (imc > 29.99 && imc <= 34.99) {
		pesoIdeal = "Obesidade I (IMC entre 30 e 35).";
	} else if (imc > 34.99 && imc <= 39.99) {
		pesoIdeal = "Obesidade II (IMC entre 35 e 40).";
	} else if (imc > 39.99) {
		pesoIdeal = "Obesidade III (IMC acima de 40).";
	}
	return pesoIdeal;
}

/*
 * Método responsável por calcular o período fértil da mulher.
 * @param dataUltimaMenstruacao a data da última mensturação (Ex.: 15/12/2012)
 * @param quantidadeDiasCiclo a quantidade de dias, média, do ciclo menstural (Ex.: 22)
 * 
 * @ComoTestar: Compare o resultado com o site: http://guiadobebe.uol.com.br/calculadora-do-periodo-fertil/
 */
function calcularPeriodoFertil(dataUltimaMenstruacao, quantidadeDiasCiclo) {
	
	var proximoPeriodoMenos2 = null;
	var proximoPeriodoMenos1 = null;
	var proximoPeriodoMais2 = null;
	var proximoPeriodoMais1 = null;
	var proximoInicio = null;
	var data = new Date(dataUltimaMenstruacao);
	data.setDate((data.getDate() + (quantidadeDiasCiclo/2)));
	proximoInicio = new Date(data);
	proximoPeriodoMenos2 = proximoInicio.setDate(proximoInicio.getDate() - 2);
	proximoPeriodoMenos1 = proximoInicio.setDate(proximoInicio.getDate() + 1);
	proximoPeriodoMais1 =  proximoInicio.setDate(proximoInicio.getDate() + 2);
	proximoPeriodoMais2 =  proximoInicio.setDate(proximoInicio.getDate() + 1);
	proximoInicio = proximoInicio.setDate(proximoInicio.getDate() - 2);
	periodoFertil = formatarData(proximoPeriodoMenos2) + " à " + formatarData(proximoPeriodoMais2);
	return periodoFertil;
}

function formatarData(data) {

	var dataOrigem = new Date(data);
	var dataFormatada = dataOrigem.getDate() + "/" + (dataOrigem.getMonth()+1) + "/" + dataOrigem.getFullYear();
	return dataFormatada;
}

/*
 *
 */
function calcularIdadeGestacional(dataUltimaMenstruacao) {

    var dataHoje = new Date();
    var data = new Date(dataUltimaMenstruacao);
    data.setDate(data.getDate() + 14);
    var diferenca = dataHoje.getTime() - data.getTime();
    idadeGestacional = new Object();
    idadeGestacional.dia = parseInt(diferenca / (1000 * 60 * 60 * 24)) + " dias.";
    idadeGestacional.semana = parseInt(diferenca / (1000 * 60 * 60 * 24 * 4)) + " semanas.";
    return idadeGestacional
}

/*
 *
 */
function calcularDataParto(dataUltimaMenstruacao) {

    var data = new Date(dataUltimaMenstruacao);
    data.setDate(data.getDate() + (40 * 7));
    return data.getDate() + "/" + (data.getMonth() + 1) + "/" + data.getFullYear();;
}


