﻿/*
 * Variáveis globais.
 */
var ferias = 0;
var valorFgts = 0;
var valorDependenteLegal = 171.97;
var valorTetoInss = 457.27;
var inss = 0;
var descInss = "";
var iprf = 0;
var descAliquota = "";
var salarioLiquido = 0;
var porcentagemFgts = 0.08;
var descFgts = "";
var decimoTerceiro = 0;

/*
 * Método responsável por o IMC (Índice de Massa Corpórea).
 * @param salarioBruto o salário bruto (Ex.: 1980.50)
 * @param quantidadeMeses a quantidade de meses trabalhados sendo o máximo 12 (Ex.: 10)
 * 
 * @ComoTestar: Compare o resultado com o site: http://www.calculador.com.br/calculo/imc
 */
function calcularFerias(salarioBruto, quantidadeDiasFerias, numeroDependentes) {
	
	var sal = salarioBruto/30 * quantidadeDiasFerias + (salarioBruto/30 * quantidadeDiasFerias)/3;
	var baseCalculo = sal - verificaFaixaINSS(sal) - (numeroDependentes ? (numeroDependentes * valorDependenteLegal) : 0);
	ferias = baseCalculo - verificaFaixaImpostoRenda(baseCalculo);
	ferias = (Math.round(ferias * 100) / 100).toFixed(2);
	return ferias;
}

/*
 * Método responsável por calcular o FGTS.
 * @param salarioBruto o salário bruto (Ex.: 1980.50)
 * @param quantidadeMeses a quantidade de meses trabalhados
 * 
 * @ComoTestar: Compare o resultado com o site: http://www.calculador.com.br/calculo/fgts
 */
function calcularFgts(salarioBruto, quantidadeMeses) {
	
	valorFgts = salarioBruto * porcentagemFgts * quantidadeMeses;
	descFgts = parseFloat(Math.round((salarioBruto * porcentagemFgts) * 100) / 100).toFixed(2);
	result = new Object();
	result.valorTotal = parseFloat(Math.round(valorFgts * 100) / 100).toFixed(2);
	result.valorMes = descFgts;
	return result;
}

/*
 * Método responsável por calcular o Décimo Terceiro.
 * @param salarioBruto o salário bruto (Ex.: 1980.50)
 * @param quantidadeMeses a quantidade de meses trabalhados
 * @param numeroDependentes o número de dependentes
 * 
 * @ComoTestar: Compare o resultado com o site: http://www.calculador.com.br/calculo/decimo-terceiro
 */
function calcularDecimoTerceiro(salarioBruto, quantidadeMeses, numeroDependentes) {
	
    var baseCalculo = (salarioBruto / 12 * quantidadeMeses) - verificaFaixaINSS(salarioBruto) - (salarioBruto > 1710.79 ? (numeroDependentes * valorDependenteLegal) : 0);
	decimoTerceiro = baseCalculo - verificaFaixaImpostoRenda(baseCalculo);
	decimoTerceiro = (Math.round(decimoTerceiro * 100) / 100).toFixed(2);
	return decimoTerceiro;
}

/*
 * Método responsável por consultar o salário líquido.
 * @param salarioBruto
 * @param outrosDescontos
 * @param numeroDependentes
 * @OndeTestar Compare o resultado com o site: http://www.calculador.com.br/calculo/salario-liquido
 */
function calculaSalarioLiquido(salarioBruto, outrosDescontos, numeroDependentes) {
	
    var baseCalculo = salarioBruto - verificaFaixaINSS(salarioBruto) - (salarioBruto > 1710.79 ? (numeroDependentes * valorDependenteLegal) : 0);
	salarioLiquido = baseCalculo - verificaFaixaImpostoRenda(baseCalculo) - (outrosDescontos == null ? 0 : outrosDescontos);
	salarioLiquido = (Math.round(salarioLiquido * 100) / 100).toFixed(2);

	var result = new Object();
	result.salarioLiquido = salarioLiquido;
	result.descAliquota = descAliquota;
	result.descInss = descInss;
	result.valorIPRF = iprf.toFixed(2);
	result.valorINSS = inss.toFixed(2);
	return result;
}

/*
 * Método responsável por verificar a faixa e o imposto a ser cobrado de acordo com o salário
 * @param salario
 */
function verificaFaixaImpostoRenda(salario) {

    if (salario <= 1710.78) {
        iprf = 0;
        descAliquota = "0%";

    } else if (salario >= 1710.79 && salario <= 2563.91) {
        iprf = salario * 0.075 - 128.31;
        descAliquota = "7,5%";

    } else if (salario >= 2563.92 && salario <= 3418.59) {
        iprf = salario * 0.15 - 320.60;
        descAliquota = "15%";

    } else if (salario >= 3418.60 && salario <= 4271.59) {
        iprf = salario * 0.225 - 577.00;
        descAliquota = "22,5%";

    } else if (salario >= 4271.59) {
        iprf = (salario * 0.275) - 790.58;
        descAliquota = "27,5%";
    }
    return iprf;
}

/*
 * Método responsável por verificar o valor a ser cobrado do INSS de acordo com o salário bruto
 * @param salarioBruto
 */
function verificaFaixaINSS(salarioBruto) {
	
	if (salarioBruto <= 1247.11) {
		inss = (salarioBruto * 0.08) > valorTetoInss ? valorTetoInss : salarioBruto * 0.08;
		descInss = "8%";
	} else if (salarioBruto >= 1247.12 &&  salarioBruto <= 2078.52) {
		inss = (salarioBruto * 0.09) > valorTetoInss ? valorTetoInss : salarioBruto * 0.09;
		descInss = "9%";
	} else if (salarioBruto >= 2078.53) {
		inss = (salarioBruto * 0.11) > valorTetoInss ? valorTetoInss : salarioBruto * 0.11;
		descInss = "11%";
	}
	return inss;
}

/*
 *
 */
function calcularHoraTrabalhada(salario) {

    return parseFloat(Math.round((salario/220) * 100) / 100).toFixed(2);
}

/*
 *
 */
function calcularAdicionalNoturno(salario) {

    var valorHora = calcularHoraTrabalhada(salario);
    hora = new Object();
    hora.valorNormal = valorHora;
    hora.valorAdicional = parseFloat(Math.round(((valorHora * 20) / 100) * 100) / 100).toFixed(2);
    hora.valorNoturno = parseFloat(parseFloat(hora.valorNormal) + parseFloat(hora.valorAdicional)).toFixed(2);
    return hora;
}

/*
 *
 */
function calcularAdicionalInsalubridade(salario, insalubridade, salarioMinimo) {

    var valorMinimo = salarioMinimo * (parseFloat(insalubridade) / 100);
    var total = parseFloat(salario) + parseFloat(valorMinimo);
    var valorHora = total / 220;
    return valorHora.toFixed(2);
}

/*
 * Método responsável por verificar a Referencia do valor a ser cobrado do INSS de acordo com o salário bruto
 * @param salarioBruto
 */
function verificaReferenciaFaixaINSS(salarioBruto) {

    if (salarioBruto <= 1247.11) {
        descInss = "8%";
    } else if (salarioBruto >= 1247.12 && salarioBruto <= 2078.52) {
        descInss = "9%";
    } else if (salarioBruto >= 2078.53) {
        descInss = "11%";
    }
    return descInss;
}

/*
 * Método responsável por verificar a referência da faixa e o imposto a ser cobrado de acordo com o salário
 * @param salario
 */
function verificaReferenciaFaixaImpostoRenda(salario) {

    if (salario <= 1710.78) {
        descAliquota = "0%";

    } else if (salario >= 1710.79 && salario <= 2563.91) {
        descAliquota = "7,5%";

    } else if (salario >= 2563.92 && salario <= 3418.59) {
        descAliquota = "15%";

    } else if (salario >= 3418.60 && salario <= 4271.59) {
        descAliquota = "22,5%";

    } else if (salario >= 4271.59) {
        descAliquota = "27,5%";
    }
    return descAliquota;
}

function calcHoraExtra(salarioBruto, qtdHoras) {
	
	var horaTrabalhada = calcularHoraTrabalhada(salarioBruto);
	var horaExtra = parseFloat(parseFloat(horaTrabalhada) + parseFloat(horaTrabalhada/2)).toFixed(2);
	var result = new Object();
	result.horaExtra = horaExtra;
	result.totalHoraExtra = parseFloat(parseFloat(horaExtra) * parseFloat(qtdHoras)).toFixed(2);
	return result;
}

/*
 * Função do Cálculo Trabalhista de Rescisão de Contrato CLT
 */
function calcRescisaoCLT(salarioBruto, dataInicio, dataFim, aviso, rescisao, feriasVencidas) {
	 //Testar --> http://www.calculador.com.br/calculo/rescisao-clt
    //13º sal proporc --> salario base ÷ 12 × numero de meses).
    //FÉRIAS + 1/3 --> salario ÷ 12 x numero de meses x 1,3333.
    //saldo salarial --> ultimos dias trabalhados no mes / 12 * seu salario;

    var numeroMeses = setaPeriodo(dataInicio, dataFim);
    console.log('numeroMeses -- > ' + numeroMeses);
    console.log('dataInicio -- > ' + dataInicio);
    console.log('dataFim -- > ' + dataFim);

    //Modulo Saldo Salarial ----------------------------------------------------------------------------------------------------------
    var saldoSalarial = ((Dia(dataFim) / 30) * salarioBruto).toFixed(2);
    var descontoINSSSaldoSalarial = verificaFaixaINSS(saldoSalarial);
    var descontoIRRFSaldoSalarial = verificaFaixaImpostoRenda(saldoSalarial);

    //Modulo Decimo Terceiro ----------------------------------------------------------------------------------------------------------
    var decimoTerceiroProporcional = verifica13Proporcional(salarioBruto, numeroMeses); //Somar
    var descontoINSSdecimoTerceiroProporcional = verificaFaixaINSS(decimoTerceiroProporcional); //Subtrair
    var descontoIRRFdecimoTerceiroProporcional = verificaFaixaImpostoRenda(decimoTerceiroProporcional); //Subtrair


    //Módulo Férias --------------------------------------------------------------------------------------------------------------------
    var feriasVencidasOuNao = verificaFeriasVencidas(feriasVencidas, salarioBruto, numeroMeses); //Somar
    var feriasVencidasUmTerco = 0;
    if (feriasVencidasOuNao != 0) {
        feriasVencidasUmTerco = (feriasVencidasOuNao / 3).toFixed(2); //Somar
    }
    var feriasProporcionais = verificaFeriasProporcionais(numeroMeses, salarioBruto); //Somar
    var feriasUmTercoProporcionais = (feriasProporcionais / 3).toFixed(2); //Somar

    var vlTotalFerias = (parseFloat(feriasVencidasOuNao) + parseFloat(feriasVencidasUmTerco)
			+ parseFloat(feriasProporcionais)
			+ parseFloat(feriasUmTercoProporcionais)).toFixed(2);

    var descontoIRRFFerias = verificaFaixaImpostoRenda(vlTotalFerias); //Subtrair

    //Módulo Aviso Prévio -------------------------------------------------------------------------------------------------------------
    var avisoPrevioRecebe = verificaMotivoRescisaoRecebe(rescisao, aviso, salarioBruto); // Soma ou Subtrai
    var avisoPrevioDesconta = verificaMotivoRescisaoDesconta(rescisao, aviso, salarioBruto); // Soma ou Subtrai

    if (rescisao == 2) {
        aviso40porcento = "Importante: Além do valor informado acima, o empregado terá direito a 40% do valor do FGTS depositado.";
    } else {
        aviso40porcento = "";
    }

    //Valores Totais a Receber e a Descontar e Liquidez
    var vlTotalReceber = (
			parseFloat(feriasVencidasOuNao) + parseFloat(feriasVencidasUmTerco) + parseFloat(feriasProporcionais) +
			parseFloat(feriasUmTercoProporcionais) + parseFloat(saldoSalarial) + parseFloat(decimoTerceiroProporcional) +
			parseFloat(avisoPrevioRecebe)
			).toFixed(2);

    var vlTotalDescontar = (
			parseFloat(descontoIRRFFerias) + parseFloat(descontoINSSSaldoSalarial) + parseFloat(descontoIRRFSaldoSalarial) +
			parseFloat(descontoINSSdecimoTerceiroProporcional) + parseFloat(descontoIRRFdecimoTerceiroProporcional) + parseFloat(avisoPrevioDesconta)
	).toFixed(2);

    var vlLiquidoReceber = parseFloat(vlTotalReceber - vlTotalDescontar).toFixed(2);

    //Colocando variáveis com duas casas decimais.
    feriasVencidasOuNao = parseFloat(feriasVencidasOuNao).toFixed(2);
    feriasVencidasUmTerco = parseFloat(feriasVencidasUmTerco).toFixed(2);
    feriasProporcionais = parseFloat(feriasProporcionais).toFixed(2);
    feriasUmTercoProporcionais = parseFloat(feriasUmTercoProporcionais).toFixed(2);
    descontoIRRFFerias = parseFloat(descontoIRRFFerias).toFixed(2);
    saldoSalarial = parseFloat(saldoSalarial).toFixed(2);
    descontoINSSSaldoSalarial = parseFloat(descontoINSSSaldoSalarial).toFixed(2);
    descontoIRRFSaldoSalarial = parseFloat(descontoIRRFSaldoSalarial).toFixed(2);
    descontoINSSdecimoTerceiroProporcional = parseFloat(descontoINSSdecimoTerceiroProporcional).toFixed(2);
    descontoIRRFdecimoTerceiroProporcional = parseFloat(descontoIRRFdecimoTerceiroProporcional).toFixed(2);
    avisoPrevioRecebe = parseFloat(avisoPrevioRecebe).toFixed(2);
    avisoPrevioDesconta = parseFloat(avisoPrevioDesconta).toFixed(2);
    decimoTerceiroProporcional = parseFloat(decimoTerceiroProporcional).toFixed(2);

    //Coluna Referência da tabela de resulado
    referenciaSaldoSalario = dataFim.toString().substring(0, 2);
    referenciaIRRFSaldoSalario = verificaReferenciaFaixaImpostoRenda(saldoSalarial);
    referenciaINSSSaldoSalario = verificaReferenciaFaixaINSS(saldoSalarial);

    referenciaFeriasProporcionais = verificaReferenciaFeriasProporcionais(numeroMeses);
    referenciaIRRFFerias = verificaReferenciaFaixaImpostoRenda(vlTotalFerias);

    referencia13Proporcial = setaPeriodo(dataInicio, dataFim);
    referenciaINSS13Proporcional = verificaReferenciaFaixaINSS(decimoTerceiroProporcional);
    referenciaIRRF13Proporcional = verificaReferenciaFaixaImpostoRenda(decimoTerceiroProporcional); 
    
    result = new Object();
	result.feriasVencidas = formatarRealDouble(feriasVencidasOuNao);
	result.tercoFerias = formatarRealDouble(feriasVencidasUmTerco);
	result.referenciaFeriasProporcionais = referenciaFeriasProporcionais;
	result.feriasProporcionais = formatarRealDouble(feriasProporcionais);
	result.feriasTercoProporcionais = formatarRealDouble(feriasUmTercoProporcionais);
	result.referenciaIRRFFerias = referenciaIRRFFerias;
	result.descontoIRRFFerias = formatarRealDouble(descontoIRRFFerias);
	result.referenciaSaldoSalarial = referenciaSaldoSalario;
	result.saldoSalarial = formatarRealDouble(saldoSalarial);
	result.referenciaINSSSalario = referenciaINSSSaldoSalario;
	result.descontoINSSSaldoSalarial = formatarRealDouble(descontoINSSSaldoSalarial);
	result.referenciaIRRFSaldoSalario = referenciaIRRFSaldoSalario;
	result.descontoIRRFSaldoSalarial = formatarRealDouble(descontoIRRFSaldoSalarial);
	result.referencia13Proporcional = referencia13Proporcial;
	result.decimoTerceiroProporcional = formatarRealDouble(decimoTerceiroProporcional);
	result.referenciaINSS13Proporcional = referenciaINSS13Proporcional;
	result.descontoINSS13Proporcional = formatarRealDouble(descontoINSSdecimoTerceiroProporcional);
	result.referenciaIRRF13Proporcional = referenciaIRRF13Proporcional;
	result.descontoIRRF13Proporcional = formatarRealDouble(descontoIRRFdecimoTerceiroProporcional);
	result.avisoPrevioRecebe = formatarRealDouble(avisoPrevioRecebe);
	result.avisoPrevioDesconta = formatarRealDouble(avisoPrevioDesconta);
	result.vlTotalReceber = formatarRealDouble(vlTotalReceber);
	result.vlTotalDescontar = formatarRealDouble(vlTotalDescontar);
	result.vlLiquidoReceber = formatarRealDouble(vlLiquidoReceber);
	result.aviso40PorCento = aviso40porcento;
	return result;
}

/*
 * Cálculo que faz a verificação do número de meses de férias proporcionais a serem beneficiados.
 */
function verificaFeriasProporcionais(numeroMeses, salarioBruto) {
    if (numeroMeses > 12) {
        retorno = (salarioBruto * ((numeroMeses - 12) / 12)).toFixed(2);
    } else if (numeroMeses > 24) {
        retorno = (salarioBruto * ((numeroMeses - 24) / 12)).toFixed(2);
    } else if (numeroMeses > 36) {
        retorno = (salarioBruto * ((numeroMeses - 36) / 12)).toFixed(2);
    } else if (numeroMeses > 48) {
        retorno = (salarioBruto * ((numeroMeses - 48) / 12)).toFixed(2);
    } else if (numeroMeses > 60) {
        retorno = (salarioBruto * ((numeroMeses - 60) / 12)).toFixed(2);
    } else if (numeroMeses > 72) {
        retorno = (salarioBruto * ((numeroMeses - 72) / 12)).toFixed(2);
    } else if (numeroMeses > 84) {
        retorno = (salarioBruto * ((numeroMeses - 84) / 12)).toFixed(2);
    } else if (numeroMeses > 96) {
        retorno = (salarioBruto * ((numeroMeses - 96) / 12)).toFixed(2);
    } else if (numeroMeses > 108) {
        retorno = (salarioBruto * ((numeroMeses - 108) / 12)).toFixed(2);
    } else if (numeroMeses > 120) {
        retorno = (salarioBruto * ((numeroMeses - 120) / 12)).toFixed(2);
    } else {
        retorno = 0;
    }
    return retorno;
}

/*
 * Cálculo que faz a verificação da referencia das férias proporcionais
 */
function verificaReferenciaFeriasProporcionais(numeroMeses) {
    if (numeroMeses > 12) {
        retorno = (numeroMeses - 12);
    } else if (numeroMeses > 24) {
        retorno = (numeroMeses - 24);
    } else if (numeroMeses > 36) {
        retorno = (numeroMeses - 36);
    } else if (numeroMeses > 48) {
        retorno = (numeroMeses - 48);
    } else if (numeroMeses > 60) {
        retorno = (numeroMeses - 60);
    } else if (numeroMeses > 72) {
        retorno = (numeroMeses - 72);
    } else if (numeroMeses > 84) {
        retorno = (numeroMeses - 84);
    } else if (numeroMeses > 96) {
        retorno = (numeroMeses - 96);
    } else if (numeroMeses > 108) {
        retorno = (numeroMeses - 108);
    } else if (numeroMeses > 120) {
        retorno = (numeroMeses - 120);
    } else {
        retorno = 0;
    }
    return retorno;
}

/*
 * Cálculo que retornar o valor a ser beneficiado pelo motivo da Rescisão
 */
function verificaMotivoRescisaoRecebe(rescisao, aviso, salarioBruto) {
    //Rescisão --> 1 = Pedido de Demissão, 2 = Dispensa sem justa causa, 3 = Dispensa com justa causa
    //Aviso --> 1 = Trabalhado, 2 = Indenizado
    retorno = 0;
    if (rescisao == 1 && aviso == 1) {
        retorno = 0;
    } else if (rescisao == 2 && aviso == 1) {
        retorno = 0;
    } else if (rescisao == 2 && aviso == 2) {
        retorno = salarioBruto;
    } else if (rescisao == 3 && aviso == 1) {
        retorno = 0;
    }
    return retorno;
}

/*
 * Cálculo que retornar o valor a ser descontado pelo motivo da Rescisão
 */
function verificaMotivoRescisaoDesconta(rescisao, aviso, salarioBruto) {
    //Rescisão --> 1 = Pedido de Demissão, 2 = Dispensa sem justa causa, 3 = Dispensa com justa causa
    //Aviso --> 1 = Trabalhado, 2 = Indenizado
    retorno = 0;
    if (rescisao == 1 && aviso == 2) {
        retorno = salarioBruto;
    } else if (rescisao == 3 && aviso == 2) {
        retorno = salarioBruto;
    }
    return retorno;
}

/*
 * Cálculo que retornar o valor a ser beneficiado pelas férias vencidas
 */
function verificaFeriasVencidas(feriasVencidas, salarioBruto, numeroMeses) {
    proporcaoSalarial = salarioBruto / 12;
    //Férias Vencidas --> 1 = Sim, 2 = Não
    if (feriasVencidas == 1) {
        retorno = (proporcaoSalarial * numeroMeses);
    } else if (feriasVencidas == 2) {
        retorno = 0;
    }
    return retorno;
}

/*
 * Cálculo que retornar o valor proporcional do 13º a receber
 */
function verifica13Proporcional(salarioBruto, numeroMeses) {
    proporcaoSalarial = salarioBruto / 12;
    if (numeroMeses > 1) {
        retorno = (proporcaoSalarial * numeroMeses);
    } else {
        retorno = 0;
    }
    return retorno;
}

/*
 * Função que retorna o dia da data
 */
function Dia(Data_DDMMYYYY) {
    string_data = Data_DDMMYYYY.toString();
    posicao_barra = string_data.indexOf("/");
    if (posicao_barra != -1) {
        dia = string_data.substring(0, posicao_barra);
        return dia;
    }
}

/*
 * Função que retorna o mês da data
 */
function Mes(Data_DDMMYYYY) {
    string_data = Data_DDMMYYYY.toString();
    posicao_barra = string_data.indexOf("/");

    if (posicao_barra != -1) {
        dia = string_data.substring(0, posicao_barra);
        string_mes = string_data.substring(posicao_barra + 1, string_data.length);
        posicao_barra = string_mes.indexOf("/");

        if (posicao_barra != -1) {
            mes = string_mes.substring(0, posicao_barra);
            return mes;
        }
    }
}

/*
 * Função que retorna o ano da data
 */
function Ano(Data_DDMMYYYY) {
    string_data = Data_DDMMYYYY.toString();

    posicao_barra = string_data.indexOf("/");

    if (posicao_barra != -1) {
        dia = string_data.substring(0, posicao_barra);
        string_mes = string_data.substring(posicao_barra + 1, string_data.length);
        posicao_barra = string_mes.indexOf("/");

        if (posicao_barra != -1) {
            mes = string_mes.substring(0, posicao_barra);
            mes = Math.floor(mes);
            ano = string_mes.substring(posicao_barra + 1, string_mes.length);
            return ano;
        }
    }
}

/*
 * Função que retorna a diferença das datas em dias
 */
function setaPeriodo(dataInicio, dataFim) {

    var data1_DDMMYYYY = dataInicio;
    var data2_DDMMYYYY = dataFim;

    Var_Dia1 = Dia(data1_DDMMYYYY);
    Var_Mes1 = Mes(data1_DDMMYYYY);
    Var_Ano1 = Ano(data1_DDMMYYYY);
    Var_Dia2 = Dia(data2_DDMMYYYY);
    Var_Mes2 = Mes(data2_DDMMYYYY);
    Var_Ano2 = Ano(data2_DDMMYYYY);

    var data1 = new Date(Var_Ano1, (Var_Mes1) - (1), Var_Dia1);
    var data2 = new Date(Var_Ano2, (Var_Mes2) - (1), Var_Dia2);
    var diferenca = data2.getTime() - data1.getTime();
    var resultado = (diferenca / (1000 * 60 * 60 * 24 * 30)).toFixed(0);
    return resultado;
}