﻿/*
 *
 */
function calcularAlcoolGasolina(alcool, gasolina) {
	
    var preferencia = "";
    var porc = (gasolina.replace(",", ".") * 70) / 100;
    if (alcool.replace(",", ".") > porc) {
        preferencia = "Gasolina."
    } else {
        preferencia = "\u00c1lcool."
    }
	return preferencia;
}

/*
 *
 */
function calcularConsumo(quilometros, litros) {

    var kml = quilometros/litros;
    return (Math.round(kml * 100) / 100).toFixed(2) + " Km/l";
}

/*
 *
 */
function calcularVelocidadeMedia(distancia, tempo, tipoMedida) {

    velocidade = new Object();
    velocidade.metro = 0;
    velocidade.quilometro = 0;
    if (tipoMedida == "1") {
        velocidade.metro = (distancia / tempo).toFixed(3) + " m/s";
        var hora = tempo * 3600;
        var km = distancia * 100;
        velocidade.quilometro = (hora / km).toFixed(3) + " km/h";
    } else if (tipoMedida == "2") {
        velocidade.quilometro = (distancia / tempo).toFixed(3) + " km/h";
        var minuto = tempo / 3600;
        var metro = distancia / 10;
        velocidade.metro = (minuto / metro).toFixed(3) + " m/s";
    }
    return velocidade;
}

/* 
 * PM (Prestação Mensal) = FC + TA + FR + Seguro.
 * FC (Fundo comun) = Valor total do crédito dividido pelo resultado do Percentual do crédito dividido pelo número dos meses.
 * TA (Taxa de Administração) = Percentual fixado no contrato de adesão.
 * FR (Fundo de Reserva) = Percentual fixodo no contrato de adesão. 
 */
function calcularConsorcio(credito, parcela, txAdm, fdReserva) {

    var fundoComun = parseFloat(Math.round(credito * (100 / parcela)) / 100).toFixed(2);
    var taxaAdministracao = parseFloat(Math.round(credito * (txAdm / parcela)) / 100).toFixed(2);
    var fundoReserva = parseFloat(Math.round(credito * (fdReserva / parcela)) / 100).toFixed(2);
    var prestacaoMensal = parseFloat(Math.round(parseFloat(fundoComun) + parseFloat(taxaAdministracao) + parseFloat(fundoReserva))).toFixed(2);
    return prestacaoMensal;
}

/*
 *
 */
function calcularPrice(vlTotal, entrada, txJuros, nuParcela) {

    var amortizacao = 0;
    var juros = 0;
    var vlJuros = 0;
    var nuPrestacao = 0;
    var prestacao = 0;
    var saldoDevedor = 0;
    var total = 0;
    //var entrada = 0;
    var divHtml = "";
    if (nuParcela != 0) {

        divHtml +=
			"<br /><table width='350px' border='1' align='center' class='formatHTML5'>" +
				"<thead><tr>" +
					"<td width='10%'>" +
						"N" +
					"</td>" +
					"<td width='20%'>" +
						"Prestacao" +
					"</td>" +
					"<td width='20%'>" +
						"Juros" +
					"</td>" +
					"<td width='25%'>" +
						"Amortizacao" +
					"</td>" +
					"<td width='25%'>" +
						"Saldo Devedor" +
					"</td>" +
				"</tr></thead><tbody>";

        
        if (entrada > 0) {
            saldoDevedor = parseFloat(vlTotal - entrada);
        } else {
            saldoDevedor = parseFloat(vlTotal);
        }

        //Juros convertido
        juros = (txJuros / 100);

        //Valor da Presatação fixa
        prestacao = saldoDevedor * [juros * (Math.pow(1 + juros, nuParcela))] / [Math.pow(1 + juros, nuParcela) - 1];

        var i;
        for (i = 0; i <= nuParcela; i++) {

            if (i == 0) {
                saldoDevedor;
                vlJuros = parseFloat(saldoDevedor * juros);
                amortizacao = prestacao - vlJuros;
            } else {
                saldoDevedor = saldoDevedor - (prestacao - vlJuros);
                vlJuros = parseFloat(saldoDevedor * juros);
                amortizacao = prestacao - vlJuros;
            }

            //Valores impressos na tela
            prestacao = parseFloat(prestacao).toFixed(2);
            saldoDevedor = parseFloat(saldoDevedor).toFixed(2);
            amortizacao = parseFloat(amortizacao).toFixed(2);
            vlJuros = parseFloat(vlJuros).toFixed(2);

            var sifrao = "R$ ";

            divHtml +=
					"<tr>" +
						"<td width='10%'>" +
							nuPrestacao +
						"</td>" +
						"<td width='20%'>"
							+ sifrao + prestacao +
						"</td>" +
						"<td width='20%'>"
							+ sifrao + vlJuros +
						"</td>" +
						"<td width='25%'>"
							+ sifrao + amortizacao +
						"</td>" +
						"<td width='25%'>"
							+ sifrao + saldoDevedor +
						"</td>" +
					"</tr>";

            nuPrestacao++;
        }
        divHtml += "</tbody></table>";
        document.getElementById('result-financiamento-price').innerHTML = divHtml;
    }
}

function calcularPrice2(vlTotal, entrada, txJuros, nuParcela) {
	
	var amortizacao = 0;
	var juros = 0;
	var vlJuros = 0;
	var nuPrestacao = 0;
	var prestacao = 0;
	var saldoDevedor = 0;
	var total = 0;
	//var entrada = 0;
	if (nuParcela != 0) {
		
		
		if (entrada > 0) {
			saldoDevedor = parseFloat(vlTotal - entrada);
		} else {
			saldoDevedor = parseFloat(vlTotal);
		}
		
		//Juros convertido
		juros = (txJuros / 100);
		
		//Valor da Presatação fixa
		prestacao = saldoDevedor * [juros * (Math.pow(1 + juros, nuParcela))] / [Math.pow(1 + juros, nuParcela) - 1];

		var result = new Array();
		
		var i;
		for (i = 0; i <= nuParcela; i++) {
			
			if (i == 0) {
				saldoDevedor;
				vlJuros = parseFloat(saldoDevedor * juros);
				amortizacao = prestacao - vlJuros;
			} else {
				saldoDevedor = saldoDevedor - (prestacao - vlJuros);
				vlJuros = parseFloat(saldoDevedor * juros);
				amortizacao = prestacao - vlJuros;
			}
			
			var item = new Object();
			item.nuPrestacao = nuPrestacao;
			item.prestacao = parseFloat(prestacao).toFixed(2);
			item.vlJuros = parseFloat(vlJuros).toFixed(2);
			item.amortizacao = parseFloat(amortizacao).toFixed(2);
			item.saldoDevedor = parseFloat(saldoDevedor).toFixed(2);
			
			result[i] = item;
			nuPrestacao++;
		}
		return result;
	}
	return null;
}