var keyboard = new Object();
keyboard.currentInput = null;
keyboard.currentseparator = '';
keyboard.type = '';
keyboard.TYPE_MONETARIO = 'M';
keyboard.TYPE_INTEIRO = 'I';
keyboard.TYPE_DECIMAL = 'D';
keyboard.TYPE_PORCENTAGEM = 'P';
keyboard.SEP_MONETARIO = ',';
keyboard.SEP_DECIMAL = '.';
keyboard.SEP_INTEIRO = '';
keyboard.DECIMAL_LENGTH = 2;
keyboard.DECIMAL_COUNT = 0;
keyboard.EXISTS_SEPARATOR = false;

keyboard.finalizar = function() {
	if(keyboard.currentInput == null) return; 
	switch (keyboard.type) {
		case keyboard.TYPE_MONETARIO:
			if(keyboard.currentInput.value.length > 0
					&& keyboard.currentInput.value != keyboard.currentseparator){
				keyboard.currentInput.value = formatReal(Number(removerMascara(keyboard.currentInput.value)));
			}else{
				keyboard.currentInput.value = formatReal(Number(0));
			}
			break;
		case keyboard.TYPE_INTEIRO:
	
			break;
		case keyboard.TYPE_DECIMAL:
			
			break;
		case keyboard.TYPE_PORCENTAGEM:
			if(keyboard.currentInput.value.length > 0
					&& keyboard.currentInput.value != keyboard.currentseparator){
				keyboard.currentInput.value = formatPercent(keyboard.currentInput.value);
			}else{
				keyboard.currentInput.value = formatPercent(Number(0));
			}
			break;
	}
	keyboard.currentInput = null;
	$("#keyboard").hide();
},
keyboard.vMaxLength = function() {
	return keyboard.currentInput.value.length < keyboard.currentInput.maxLength;
},
keyboard.reset = function() {
	keyboard.DECIMAL_COUNT = 0;
	keyboard.EXISTS_SEPARATOR = keyboard.currentInput.value.split(keyboard.currentseparator).length > 1;
	if(keyboard.EXISTS_SEPARATOR){
		keyboard.DECIMAL_COUNT = keyboard.currentInput.value.split(keyboard.currentseparator)[1].length;
	}
},
keyboard.setup = function(event, type, separator) {
	if(keyboard.currentInput != event.currentTarget){
		if(keyboard.currentInput != null){
			keyboard.finalizar();
		}
		
		keyboard.currentInput = event.currentTarget;
		keyboard.type = type;
		keyboard.currentseparator = separator;
		keyboard.reset();
		$("#keyboard-seperator").html(separator);
		$("#keyboard").show();
		//$.mobile.silentScroll($(keyboard.currentInput).offset().top-80);
	}
	$('.ui-page-active').on("tap", function(event) {
		if($('#keyboard').find(event.target).length < 1 && event.target != keyboard.currentInput){
			keyboard.finalizar();
		}
	});
	
},
keyboard.create = function() {
	$(".keyboard-numero").on("tap", function(event) {
		if (keyboard.vMaxLength() && keyboard.DECIMAL_COUNT < keyboard.DECIMAL_LENGTH) {
			keyboard.currentInput.value = keyboard.currentInput.value + $(this).html();
			if(keyboard.EXISTS_SEPARATOR){
				keyboard.DECIMAL_COUNT++;
			}
		}
	});
	$("#keyboard-seperator").on("tap", function(event){
		if(keyboard.currentInput.value.indexOf(keyboard.currentseparator) == -1
				&& keyboard.vMaxLength()){
			keyboard.EXISTS_SEPARATOR = true;
			keyboard.currentInput.value = keyboard.currentInput.value + keyboard.currentseparator;
		}	
	});
	$("#keyboard-backspace").on("tap", function(event){
		keyboard.currentInput.value = keyboard.currentInput.value.slice(0,-1);
		keyboard.reset();
	});
	$("#keyboard-limpar").on("tap", function(event){
		keyboard.currentInput.value = '';
		keyboard.reset();
	});
	$("#keyboard-prox").on("tap", function(event){
		var next = false;
		var prox = null;
		$('.ui-page-active').find('[data-keyboard]').each(function(){
		    if(next && prox == null){
		    	prox = this;
	    	};
		    if(this.id == keyboard.currentInput.id){
		    	next = true;
	    	};
		});
		keyboard.finalizar();
		if(prox != null){
			prox.focus();
			$(prox).trigger('tap');
		}
	});

},
keyboard.init = function(type) {
	$("#keyboard").hide();
	$("[data-keyboard='monetario']").on("tap", function(event){
		keyboard.setup(event, keyboard.TYPE_MONETARIO, keyboard.SEP_MONETARIO);
		keyboard.currentInput.value = removerMascaraVirgula(keyboard.currentInput.value);
	});
	$("[data-keyboard='inteiro']").on("tap", function(event){
		keyboard.setup(event, keyboard.TYPE_INTEIRO, keyboard.SEP_INTEIRO);
		keyboard.currentInput.value = removerMascaraVirgula(keyboard.currentInput.value);
	});
	$("[data-keyboard='decimal']").on("tap", function(event){
		keyboard.setup(event, keyboard.TYPE_DECIMAL, keyboard.SEP_DECIMAL);
		keyboard.currentInput.value = removerMascaraVirgula(keyboard.currentInput.value);
	});
	$("[data-keyboard='percentual']").on("tap", function(event){
		keyboard.setup(event, keyboard.TYPE_PORCENTAGEM, keyboard.SEP_MONETARIO);
		keyboard.currentInput.value = removerMascPorcentagemKeyboard(keyboard.currentInput.value);
	});
	$("#keyboard-ok").on("tap", function(event){
		keyboard.finalizar();
	});
};