﻿/*
 * Remove mascara monetária.
 * @param value o valor (Ex.: R$ 1.980,50)
 * @return O valor retorno para o exemplo acima será 1980.50
 */
function removerMascara(value) {
    return value.replace('.', '').replace(',', '.').replace(/[^0-9\.]+/g, '');
}
function removerMascaraVirgula(value) {
	return value.replace('.', '').replace(/[^0-9\,]+/g, '');
}

/*
 * Remove mascara de porcentagem.
 * @param value o valor (Ex.: 4.50%)
 * @return O valor retorno para o exemplo acima será 4.50
 */
function removerMascPorcentagemKeyboard(value) {
    return value.replace('.', ',').replace('%', '');
}

/*
 * Remove mascara de porcentagem.
 * @param value o valor (Ex.: 4.50%)
 * @return O valor retorno para o exemplo acima será 4.50
 */
function removerMascPorcentagem(value) {
    return value.replace(',', '.').replace(/[^0-9\.]+/g,'').replace('%', '');
}

/*
 * Remove mascara de porcentagem.
 * @param value o valor (Ex.: 4.50%)
 * @return O valor retorno para o exemplo acima será 4.50
 */
function removerMasc(value) {
    return value.replace(/[^0-9\.]+/g, '');
}

/*
 * Remove mascara de porcentagem usado como Listen Handler.
 * Para usar basta registrar o mesmo no ready do page control 
 * com o seletor a seguir WinJS.Utilities.query("input").listen('blur', removerMascHandler, false);
 * @param eventInfo fornecido pelo listen
 */
function removerMascHandler(eventInfo) {
    eventInfo.preventDefault();
    eventInfo.currentTarget.value = eventInfo.currentTarget.value.replace(/[^0-9\.]+/g, '');
}

/*
 * Retorna o valor informado no padrão monetário do Real
 * @param int o valor (Ex.: 198050)
 * @return O valor retorno para o exemplo acima será R$ 1.980,50
 * @referencia: http://wbruno.com.br/2012/06/20/formatar-em-moeda-reais-expressao-regular-em-javascript/
 */
function formatarRealInt(int) {
    var tmp = int + '';
    tmp = tmp.replace(/([0-9]{2})$/g, ",$1");
    if (tmp.length > 6)
        tmp = tmp.replace(/([0-9]{3}),([0-9]{2}$)/g, ".$1,$2");
    return 'R$ ' + tmp;
}

/*
 * Retorna o valor informado no padrão monetário do Real
 * @param double o valor (Ex.: 1980.50)
 * @return O valor retorno para o exemplo acima será R$ 1.980,50
 */
function formatarRealDouble(double) {
    var tmp = double + "";
    return formatarRealInt(tmp.replace('.', ''));
}

function formatReal(n) {
    return n == 0 ? "" : "R$ " + n.toFixed(2).replace('.',',').replace(/(\d)(?=(\d{3})+\,)/g, "$1.");
}

function formatPercent(e) {
	if (e != null && e != '') {
		e = e.replace(",", ".");
	}
	return e == 0 || e == null || e == '' ? "" : (e > 100 ? "100,00%" : Number(e).toFixed(2).replace(".",",") + "%");
}

function removeMascPorcentagem(e) {
	return e.indexOf("100") == -1 ? e.replace(",", ".").replace("%", "") : "100.0";
}

function addMascPorcentagem(e) {
	return e.indexOf("100") == -1 ? e.replace(".", ",") + '%' : "100,00%";
}